/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.apps;

import java.awt.Color;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eso.ohs.core.gui.utilities.SystemFonts;
import org.eso.ohs.core.gui.widgets.AuthenticationDialog;
import org.eso.ohs.core.gui.widgets.ErrorMessages;
import org.eso.ohs.core.utilities.FileIOUtils;
import org.eso.ohs.core.utilities.OHSConfig;
import org.eso.ohs.core.utilities.ObjectIOException;
import org.eso.ohs.dfs.Target;
import org.eso.ohs.instruments.Instrument;
import org.eso.ohs.instruments.InstrumentList;
import org.eso.ohs.persistence.AppConfig;
import org.eso.ohs.persistence.Config;
import org.eso.ohs.persistence.Media;
import org.eso.ohs.persistence.OHSPersistence;
import org.eso.ohs.persistence.ObjectAuthorisationException;

public class OHSApplication {
    private static final String rcsid = "$Id: OHSApplication.java,v 1.52 2005/02/11 11:00:26 tcanavan Exp $";
    protected static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$apps$OHSApplication == null ? (class$org$eso$ohs$apps$OHSApplication = OHSApplication.class$("org.eso.ohs.apps.OHSApplication")) : class$org$eso$ohs$apps$OHSApplication));
    protected static OHSApplication instance_ = null;
    private static String appFullName_ = "OHS application";
    private static String ohsPropertyFile_ = "ohs.properties";
    private static String ohsCommonConfigDir_ = "config";
    private static String ohsUserConfigDir_ = ".ohs";
    private static String appShortName_ = "OHSapp";
    private static String appVersion_ = "0.0";
    protected static final String ERROR_MSG = "Operation aborted: no authentication\n\nPlease check your username and password,\nor contact the ESO User Support Group.";
    private static OHSPersistence persistence_;
    private static int fontOffset_;
    private final int MAXOFFSET = 5;
    private int fontStyle_ = 0;
    private String fontFace_ = "Monospaced";
    static /* synthetic */ Class class$org$eso$ohs$apps$OHSApplication;

    public void init(String string, String string2, String string3) {
        appFullName_ = string;
        appShortName_ = string2;
        appVersion_ = string3;
        TimeZone timeZone = TimeZone.getTimeZone("UT");
        TimeZone.setDefault(timeZone);
        stdlog_.info((Object)("TimeZone is: " + TimeZone.getDefault().getID()));
        String string4 = System.getProperty("log.level");
        Level level = null;
        if (string4 == null || string4.length() == 0) {
            level = Level.WARN;
            stdlog_.warn((Object)("log.level property not found. current log level = <" + level.toString() + ">"));
        } else {
            level = Level.toLevel((String)string4);
            stdlog_.info((Object)("log.level property = <" + level.toString() + ">"));
        }
        Logger.getRootLogger().setLevel(level);
    }

    protected OHSApplication() {
    }

    public static OHSApplication getApplication() {
        if (instance_ == null) {
            instance_ = new OHSApplication();
        }
        instance_.loadEnv();
        return instance_;
    }

    public void loadEnv() {
        this.loadSystemProperties(OHSApplication.getOhsCommonConfigDir(), OHSApplication.getOhsUserConfigDir(), OHSApplication.getOhsPropertyFile());
    }

    protected void loadSystemProperties(String string, String string2, String string3) {
        File file = new File(string + File.separator + string3);
        Object var5_5 = null;
        Properties properties = new Properties();
        stdlog_.info((Object)" loading system properties ");
        this.loadPropFromClassLoader(file, properties);
        file = this.getConfigFile(file);
        this.loadPropFromDir(file, properties);
        File file2 = new File(OHSApplication.getOhsUserConfigDirPath());
        File file3 = this.getPrivateFile(file2.getAbsolutePath(), string3);
        if (!file2.exists()) {
            file2.mkdir();
        }
        this.loadPropFromDir(file3, properties);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            if (System.getProperty(string4) != null) continue;
            System.setProperty(string4, properties.getProperty(string4).trim());
        }
    }

    protected File getPrivateFile(String string, String string2) {
        File file = new File(string + File.separator + string2);
        return file;
    }

    private void loadPropFromDir(File file, Properties properties) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
            stdlog_.info((Object)("loading property file " + file.getAbsolutePath()));
        }
        catch (IOException iOException) {
            stdlog_.info((Object)("property file " + file.getAbsolutePath() + " in current working directory: \n" + iOException.getMessage()));
        }
    }

    protected File getConfigFile(File file) {
        return file;
    }

    private void loadPropFromClassLoader(File file, Properties properties) {
        InputStream inputStream = null;
        try {
            inputStream = this.loadFileFromResource(file);
            properties.load(inputStream);
            stdlog_.info((Object)("loading property file " + file.getAbsolutePath() + " in classloader "));
        }
        catch (IOException iOException) {
            stdlog_.info((Object)("property file " + file.getAbsolutePath() + " in classloader not found: \n" + iOException.getMessage()));
        }
    }

    protected InputStream loadFileFromResource(File file) throws IOException {
        InputStream inputStream = FileIOUtils.getResourceStream(file.getAbsolutePath());
        return inputStream;
    }

    public static Logger getStdlog() {
        return stdlog_;
    }

    public void setInstance(OHSPersistence oHSPersistence) {
        persistence_ = oHSPersistence;
    }

    public static String getFullName() {
        return appFullName_;
    }

    public static String getShortName() {
        return appShortName_;
    }

    public static String getVersion() {
        return appVersion_;
    }

    public static void checkDbFileExists() {
        AppConfig appConfig = AppConfig.getAppConfig();
        String string = new String(OHSApplication.getShortName() + "-db.cf").toLowerCase();
        if (!appConfig.hasDbCfg()) {
            JOptionPane.showMessageDialog(null, string + "file does not exist" + "\n" + OHSApplication.getShortName() + " cannot continue", "File does not exist : " + string, 0);
            System.exit(0);
        }
    }

    public static void setShortName(String string) {
        appShortName_ = string;
    }

    public static String getShortDesc() {
        if (OHSApplication.getVersion() != null && !appVersion_.equals("0.0")) {
            return OHSApplication.getShortName() + " V." + OHSApplication.getVersion();
        }
        return OHSApplication.getShortName();
    }

    public void setDefaultGUIResources() {
        UIManager.put("List.background", Color.white);
        UIManager.put("List.selectionBackground", Color.blue.darker());
        UIManager.put("List.focusCellHighlightBorder", BorderFactory.createLineBorder(Color.yellow));
        UIManager.put("ComboBox.background", Color.white);
        UIManager.put("TextField.background", Color.white);
        UIManager.put("TextArea.background", Color.white);
        UIManager.put("PasswordField.background", Color.white);
        UIManager.put("Table.background", Color.white);
        UIManager.put("Table.textBackground", Color.white);
        UIManager.put("Table.selectionBackground", Color.blue.darker());
        UIManager.put("Table.selectionForeground", Color.white);
        UIManager.put("Table.focusCellHighlightBorder", BorderFactory.createLineBorder(Color.yellow));
        UIManager.put("Tree.background", Color.white);
        UIManager.put("Tree.textBackground", Color.white);
        UIManager.put("Tree.selectionBackground", Color.blue.darker());
        UIManager.put("Tree.selectionForeground", Color.white);
        UIManager.put("Tree.selectionBorderColor", Color.yellow);
        ToolTipManager.sharedInstance().setDismissDelay(5000);
        ToolTipManager.sharedInstance().setInitialDelay(0);
        Font font = new Font(this.getFontFace(), this.getFontStyle(), 12 + fontOffset_);
        UIManager.put("TextField.font", font);
        UIManager.put("TextArea.font", font);
        UIManager.put("List.font", font);
        UIManager.put("ComboBox.font", font);
        UIManager.put("PasswordField.font", font);
        UIManager.put("Table.font", font);
        UIManager.put("Tree.font", font);
    }

    private String getFontFace() {
        return this.fontFace_;
    }

    private int getFontStyle() {
        return this.fontStyle_;
    }

    public void offsetFontSize(OHSConfig oHSConfig) {
        fontOffset_ = oHSConfig.getInteger("FONT.SIZE.OFFSET", 0);
        if (fontOffset_ > 0 && fontOffset_ < 5) {
            SystemFonts.increaseUIManagerFontSize(fontOffset_);
        } else if (fontOffset_ < 0 && fontOffset_ > -5) {
            SystemFonts.decreaseUIManagerFontSize(fontOffset_ * -1);
        }
    }

    public void setFontStyle(OHSConfig oHSConfig) {
        String string = oHSConfig.getValue("FONT.STYLE");
        this.fontStyle_ = string.equals("BOLD") ? 1 : (string.equals("ITALIC") ? 2 : 0);
    }

    public void setFontFace(OHSConfig oHSConfig) {
        this.fontFace_ = oHSConfig.getValue("FONT.FACE");
    }

    public static int getFontSize() {
        return 12 + fontOffset_;
    }

    public void setLookAndFeel() {
        try {
            String string = UIManager.getSystemLookAndFeelClassName();
            if (System.getProperty("os.name").equals("HP-UX")) {
                string = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
            }
            if (System.getProperty("os.name").equals("Linux")) {
                string = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
            }
            UIManager.setLookAndFeel(string);
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            stdlog_.error((Object)("Exception: " + unsupportedLookAndFeelException));
        }
        catch (ClassNotFoundException classNotFoundException) {
            stdlog_.error((Object)("Exception: " + classNotFoundException));
        }
        catch (InstantiationException instantiationException) {
            stdlog_.error((Object)("Exception: " + instantiationException));
        }
        catch (IllegalAccessException illegalAccessException) {
            stdlog_.error((Object)("Exception: " + illegalAccessException));
        }
    }

    public static void initialiseTargetObjectClass() throws IOException {
        File file = new File(AppConfig.getAppConfig().getConfigDir(), "objClass.dat");
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        BufferedReader bufferedReader = null;
        String string = null;
        String string2 = null;
        try {
            String string3;
            bufferedReader = new BufferedReader(new FileReader(file));
            while ((string3 = bufferedReader.readLine()) != null) {
                int n = string3.indexOf(58);
                if (n < 0 || (string3 = string3.substring(n + 1)).trim().length() == 0 || string3.length() <= 20) continue;
                int n2 = string3.indexOf(34);
                int n3 = string3.lastIndexOf(34);
                if (n2 < 0 || n3 < 0) continue;
                string = string3.substring(0, 20);
                string2 = string3.substring(n2 + 1, n3);
                vector.addElement(string);
                vector2.addElement(string2);
            }
        }
        catch (IOException iOException) {
            stdlog_.error((Object)"", (Throwable)iOException);
        }
        if (bufferedReader != null) {
            bufferedReader.close();
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        Target.setObjectClassValues((String[])objectArray);
        Object[] objectArray2 = new String[vector2.size()];
        vector2.copyInto(objectArray2);
        Target.setObjectClassTooltips((String[])objectArray2);
    }

    public static void askForAuthentication(Media media) throws ObjectIOException {
        int n = Config.getCfg().getUserName();
        String string = Config.getCfg().getPassword();
        persistence_.setUserId(n);
        if (string != null && !string.equals("") && persistence_.authenticateUser(media, string)) {
            return;
        }
        AuthenticationDialog authenticationDialog = new AuthenticationDialog(null, "Enter your password", "Please enter your password:", String.valueOf(n));
        authenticationDialog.show();
        int n2 = authenticationDialog.getUserChoice();
        if (n2 == -1 || n2 == 2) {
            throw new ObjectIOException("Operation aborted: no authentication");
        }
        string = authenticationDialog.getPassword();
        if (string == null || string.equals("")) {
            throw new ObjectIOException(ERROR_MSG);
        }
        Config.getCfg().setPassword(string);
        if (!persistence_.authenticateUser(media, string)) {
            throw new ObjectIOException(ERROR_MSG);
        }
    }

    public static boolean ensureAuthenticated() {
        try {
            OHSApplication.askForAuthentication(Media.DBASE);
            return true;
        }
        catch (ObjectAuthorisationException objectAuthorisationException) {
            JOptionPane.showMessageDialog(null, new Object[]{"Your objects in the ESO database could not be displayed", "because you have not successfully authenticated"}, "Authentication Error", 0);
            return false;
        }
        catch (ObjectIOException objectIOException) {
            ErrorMessages.announceIOError(null, objectIOException);
            return false;
        }
    }

    public void checkInstrumentDirectories(AppConfig appConfig) {
        File file = new File(appConfig.getInstrumDir());
        this.checkDirectory(file, false, false);
    }

    public void checkDirectory(File file, boolean bl, boolean bl2) {
        if (!file.exists()) {
            if (bl2) {
                if (!file.mkdirs()) {
                    JOptionPane.showMessageDialog(null, new Object[]{"Directory could not be created", "Directory: " + file.getAbsolutePath(), " ", "Cannot continue!"}, "Required directory could not be created", 0);
                    System.exit(0);
                } else {
                    JOptionPane.showMessageDialog(null, new Object[]{"Required directory was created: ", "Directory: " + file.getAbsolutePath(), ""}, "Directory Created", 2);
                }
            } else {
                JOptionPane.showMessageDialog(null, new Object[]{"Directory does not exist", "Directory: " + file.getAbsolutePath(), " ", "Cannot continue!"}, "Required directory does not exist", 0);
                System.exit(0);
            }
        }
        if (!file.canRead()) {
            JOptionPane.showMessageDialog(null, new Object[]{"No read permissions for directory", "Directory: " + file.getAbsolutePath(), " ", "Cannot continue!"}, "No read permissions", 0);
            System.exit(0);
        }
        if (bl && !file.canWrite()) {
            JOptionPane.showMessageDialog(null, new Object[]{"No write permissions for directory", "Directory: " + file.getAbsolutePath(), " ", "Cannot continue!"}, "No write permissions", 0);
            System.exit(0);
        }
    }

    public void displayInstrumentErrorInfo() {
        Instrument[] instrumentArray = InstrumentList.getInstance().getInstrumentList();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < instrumentArray.length) {
            if (instrumentArray[n].hasInvalidTemplates()) {
                stringBuffer.append("    " + instrumentArray[n].getInstrumentName() + ", v" + instrumentArray[n].getVersion() + ", location: " + instrumentArray[n].getTSFDirectory() + "\n");
                if (n < instrumentArray.length - 1) {
                    stringBuffer.append(" ");
                }
            }
            ++n;
        }
        if (stringBuffer.length() > 0) {
            JOptionPane.showMessageDialog(null, new Object[]{"The following instrument package(s) \n" + stringBuffer.toString() + "have invalid template signatures.\n Please use engineering mode to get detailed error report", " ", ""}, "Invalid templates in instrument package(s)", 2);
        }
    }

    protected static void setOhsCommonConfigDir(String string) {
        ohsCommonConfigDir_ = string;
    }

    public static String getOhsCommonConfigDir() {
        return ohsCommonConfigDir_;
    }

    protected static void setOhsUserConfigDir(String string) {
        ohsUserConfigDir_ = string;
    }

    public static String getOhsUserConfigDir() {
        return ohsUserConfigDir_;
    }

    public static String getOhsUserConfigDirPath() {
        String string = System.getProperty("user.home") + File.separator + OHSApplication.getOhsUserConfigDir();
        return string;
    }

    protected static void setOhsPropertyFile(String string) {
        ohsPropertyFile_ = string;
    }

    public static String getOhsPropertyFile() {
        return ohsPropertyFile_;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        fontOffset_ = 0;
    }
}

