/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.core.gui.widgets;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.sql.SQLWarning;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import org.eso.ohs.core.utilities.ObjectIOException;
import org.eso.ohs.core.utilities.TextUtils;

public class ErrorMessages {
    public static void announceIOError(Component component, Exception exception) {
        ErrorMessages.announceError(component, new String[]{"An error occurred while reading/writing data", " ", exception.getMessage()}, exception);
    }

    public static void announceNoObject(Component component, Exception exception) {
        ErrorMessages.announceError(component, new String[]{"An internal consistency check has failed", "The selected object failed to be loaded.", " ", exception.getMessage()}, exception);
    }

    public static void announceError(Component component, String[] stringArray, Exception exception) {
        final JTextArea jTextArea = new JTextArea();
        JButton jButton = new JButton("OK");
        Object[] objectArray = new Object[]{jButton};
        if (exception instanceof ObjectIOException) {
            ObjectIOException objectIOException = (ObjectIOException)exception;
            ObjectIOException.NestedInfo nestedInfo = objectIOException.getExceptionInfo();
            StringBuffer stringBuffer = new StringBuffer();
            while (nestedInfo != null) {
                stringBuffer.append(nestedInfo.message);
                if (nestedInfo.sqlState != null) {
                    stringBuffer.append("error code = ");
                    stringBuffer.append(nestedInfo.errorCode);
                    stringBuffer.append("\n");
                    stringBuffer.append("sql state  = ");
                    stringBuffer.append(nestedInfo.sqlState);
                }
                stringBuffer.append("\n\n");
                nestedInfo = nestedInfo.next;
            }
            if (stringBuffer.length() > 0) {
                JButton jButton2 = new JButton("Details");
                jTextArea.setText(stringBuffer.toString());
                jTextArea.setEditable(false);
                jTextArea.setOpaque(false);
                objectArray = new Object[]{jButton, jButton2};
                jButton2.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        JComponent jComponent = (JComponent)actionEvent.getSource();
                        Container container = jComponent.getTopLevelAncestor();
                        JOptionPane.showMessageDialog(container, jTextArea, "Error details", 0);
                    }
                });
            }
        }
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JComponent jComponent = (JComponent)actionEvent.getSource();
                Window window = (Window)jComponent.getTopLevelAncestor();
                window.setVisible(false);
                window.dispose();
            }
        });
        JOptionPane.showOptionDialog(component, stringArray, "Error", -1, 0, null, objectArray, jButton);
    }

    public static void sqlError(SQLException sQLException, Component component) {
        JOptionPane.showMessageDialog(component, TextUtils.breakString(sQLException.getMessage(), 40), "SQL error " + sQLException.getErrorCode(), 0);
    }

    public static void sqlWarning(SQLWarning sQLWarning, Component component) {
        JOptionPane.showMessageDialog(component, TextUtils.breakString(sQLWarning.getMessage(), 40), "SQL warning " + sQLWarning.getErrorCode(), 2);
    }
}

