/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.core.utilities;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ConnectionPool {
    private static final String rcsid = "$Id: ConnectionPool.java,v 1.7 2005/03/02 14:00:57 amchavan Exp $";
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$core$utilities$ConnectionPool == null ? (class$org$eso$ohs$core$utilities$ConnectionPool = ConnectionPool.class$("org.eso.ohs.core.utilities.ConnectionPool")) : class$org$eso$ohs$core$utilities$ConnectionPool));
    public static final String PoolSize = "conn.pool.size";
    public static final String Timeout = "conn.pool.timeout";
    public static final String ReopenAllowed = "conn.pool.reopen";
    protected static int MAX_CONNECTIONS = 20;
    protected static long REAPER_SLEEPTIME = 5000L;
    protected static long MAX_IDLE_LIFETIME = 60000L;
    protected static int MAX_LIFETIME = 600000;
    protected static boolean reopenAllowed_ = true;
    protected Vector pool_ = new Vector();
    private static ConnectionPool conPool_;
    private int maxPoolSize_;
    private Reaper reaper_;
    private String userName_;
    private String password_;
    static /* synthetic */ Class class$org$eso$ohs$core$utilities$ConnectionPool;

    public static long getMaxIdleLifetime() {
        return MAX_IDLE_LIFETIME;
    }

    public static long getReaperSleepTime() {
        return REAPER_SLEEPTIME;
    }

    public static synchronized boolean setInitProperties(Properties properties) {
        String string = properties.getProperty(PoolSize);
        if (string != null) {
            try {
                MAX_CONNECTIONS = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
            stdlog_.info((Object)("MAX_CONNECTIONS set to: " + MAX_CONNECTIONS));
        }
        if ((string = properties.getProperty(Timeout)) != null) {
            try {
                MAX_IDLE_LIFETIME = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
            stdlog_.info((Object)("MAX_IDLE_LIFETIME set to: " + MAX_IDLE_LIFETIME));
        }
        if ((string = properties.getProperty(ReopenAllowed)) != null) {
            reopenAllowed_ = string.equalsIgnoreCase("T");
            stdlog_.info((Object)("reopenAllowed_ set to: " + reopenAllowed_));
        }
        return conPool_ == null;
    }

    protected ConnectionPool(int n) {
        this.maxPoolSize_ = n;
        if (MAX_IDLE_LIFETIME > 0L) {
            this.reaper_ = new Reaper(this, this.pool_);
            this.reaper_.start();
        } else {
            this.reaper_ = null;
        }
        stdlog_.debug((Object)("MAX_IDLE_LIFETIME: " + MAX_IDLE_LIFETIME));
        stdlog_.debug((Object)("MAX_CONNECTIONS: " + MAX_CONNECTIONS));
        stdlog_.debug((Object)("reopenAllowed_: " + reopenAllowed_));
    }

    public void setUserName(String string) {
        this.userName_ = string;
    }

    public void setPassword(String string) {
        this.password_ = string;
    }

    public synchronized Connection acquireConnection(String string, String string2, String string3) throws SQLException {
        Element element = null;
        this.userName_ = string2;
        this.setPassword(string3);
        String string4 = string.substring(string.lastIndexOf(47) + 1, string.length());
        while (true) {
            int n = this.pool_.size();
            int n2 = 0;
            while (n2 < n) {
                element = (Element)this.pool_.elementAt(n2);
                if (element.available && (!reopenAllowed_ || string4.equals(element.dbaseName))) {
                    element.available = false;
                    stdlog_.debug((Object)("@@ acquireConnection: found " + n2));
                    return element.connection;
                }
                ++n2;
            }
            if (reopenAllowed_) {
                int n3 = 0;
                while (n3 < n) {
                    element = (Element)this.pool_.elementAt(n3);
                    if (element.available) {
                        element.available = false;
                        stdlog_.debug((Object)("@@ acquireConnection: found " + n3));
                        this.reuseConnection(element, string, string4);
                        return element.connection;
                    }
                    ++n3;
                }
            }
            if (this.pool_.size() < this.maxPoolSize_) break;
            try {
                stdlog_.debug((Object)"@@ acquireConnection: waiting");
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        stdlog_.debug((Object)("@@ acquireConnection: adding conn " + this.pool_.size()));
        element = new Element();
        element.available = false;
        element.creationTime = System.currentTimeMillis();
        element.connection = this.openConnection(string);
        element.dbaseName = string4;
        this.pool_.addElement(element);
        return element.connection;
    }

    public synchronized void releaseConnection(Connection connection) {
        if (connection == null) {
            return;
        }
        int n = this.pool_.size();
        int n2 = 0;
        while (n2 < n) {
            Element element = (Element)this.pool_.elementAt(n2);
            if (element.connection == connection) {
                boolean bl = false;
                try {
                    if (element.connection.isClosed()) {
                        bl = true;
                    }
                }
                catch (SQLException sQLException) {
                    bl = true;
                }
                if (bl) {
                    this.pool_.removeElementAt(n2);
                } else {
                    element.available = true;
                    element.last_released = System.currentTimeMillis();
                }
                stdlog_.debug((Object)("@@ releaseConnection: releasing " + n2));
                this.notify();
                return;
            }
            ++n2;
        }
        stdlog_.warn((Object)"@@ releaseConnection: NOT FOUND");
        throw new IllegalArgumentException("internal error: unknown connection");
    }

    public synchronized void releaseAllConnections() throws SQLException {
        Iterator iterator = this.pool_.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            this.closeConnection(element.connection);
        }
        this.pool_.removeAllElements();
    }

    protected void reuseConnection(Element element, String string, String string2) throws SQLException {
        if (reopenAllowed_) {
            this.closeConnection(element.connection);
            element.connection = this.openConnection(string);
            element.dbaseName = string2;
        }
    }

    protected Connection openConnection(String string) throws SQLException {
        return this.openConnection(string, null, null);
    }

    protected Connection openConnection(String string, String string2, String string3) throws SQLException {
        Connection connection;
        if (string2 == null) {
            string2 = this.userName_;
        }
        if (string3 == null) {
            string3 = this.getPassword();
        }
        try {
            connection = DriverManager.getConnection(string, string2, string3);
        }
        catch (SQLException sQLException) {
            stdlog_.error((Object)("url: " + string + " user: " + string2));
            throw sQLException;
        }
        return connection;
    }

    public Connection openExtraPoolConnection(String string, String string2, String string3) throws SQLException {
        return this.openConnection(string, string2, string3);
    }

    protected void closeConnection(Connection connection) throws SQLException {
        connection.close();
    }

    public static synchronized ConnectionPool getPool() {
        if (conPool_ == null) {
            conPool_ = new ConnectionPool(MAX_CONNECTIONS);
        }
        return conPool_;
    }

    public static synchronized void shutdown() {
        if (conPool_ != null) {
            if (ConnectionPool.conPool_.reaper_ != null) {
                ConnectionPool.conPool_.reaper_.shutdown();
            }
            conPool_ = null;
        }
    }

    private String getPassword() {
        return this.password_;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Properties properties = System.getProperties();
        StringBuffer stringBuffer = new StringBuffer("com.sybase.jdbc2.jdbc.SybDriver");
        String string = properties.getProperty("jdbc.drivers");
        if (string != null) {
            stringBuffer.append(":" + string);
        }
        properties.put("jdbc.drivers", stringBuffer.toString());
    }

    private class Reaper
    extends Thread {
        private ConnectionPool pool_;
        private Vector poolVec_;
        private boolean finished_ = false;

        public Reaper(ConnectionPool connectionPool2, Vector vector) {
            super("ConnectionPool - Dead Connection Reaper");
            this.pool_ = connectionPool2;
            this.poolVec_ = vector;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.finished_ = true;
            Reaper reaper = this;
            synchronized (reaper) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Element element = null;
            while (!this.finished_) {
                long l = System.currentTimeMillis();
                ConnectionPool connectionPool = this.pool_;
                synchronized (connectionPool) {
                    int n = this.poolVec_.size() - 1;
                    while (n >= 0) {
                        element = (Element)this.poolVec_.elementAt(n);
                        if (element.available && (element.last_released + MAX_IDLE_LIFETIME < l || element.creationTime + (long)MAX_LIFETIME < l)) {
                            stdlog_.debug((Object)("@@ reaper: last release " + element.last_released));
                            this.poolVec_.removeElementAt(n);
                            this.forciblyCloseConnection(element);
                        }
                        --n;
                    }
                }
                try {
                    Thread.sleep(REAPER_SLEEPTIME);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Reaper reaper = this;
            synchronized (reaper) {
                this.notifyAll();
            }
        }

        public void forciblyCloseConnection(Element element) {
            stdlog_.debug((Object)("@@ reaper: closing " + element));
            try {
                ConnectionPool.this.closeConnection(element.connection);
                element.connection = null;
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }

    protected static class Element {
        public String dbaseName;
        public boolean available;
        public Connection connection;
        public long last_released;
        public long creationTime;

        protected Element() {
        }

        public String toString() {
            return "Element[dbaseName=" + this.dbaseName + ",available=" + this.available + ",last_released=" + this.last_released + ",creationTime=" + this.creationTime + "]";
        }
    }
}

