/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.core.utilities;

import java.util.Enumeration;
import java.util.Vector;
import org.eso.ohs.core.utilities.GTreeModel;
import org.eso.ohs.core.utilities.GTreeNode;
import org.eso.ohs.core.utilities.GTreePath;

public class DefaultGTreeModel
implements GTreeModel {
    protected GTreeNode root_;

    public DefaultGTreeModel(GTreeNode gTreeNode) {
        this.root_ = gTreeNode;
    }

    public GTreeNode getRoot() {
        return this.root_;
    }

    public boolean isLeaf(GTreeNode gTreeNode) {
        return gTreeNode.isLeaf();
    }

    public GTreeNode getChild(GTreeNode gTreeNode, String string) {
        return gTreeNode.getChild(string);
    }

    public GTreeNode getChild(GTreeNode gTreeNode, GTreeNode gTreeNode2) {
        return gTreeNode.getChild(gTreeNode2);
    }

    public int getChildCount(GTreeNode gTreeNode) {
        return gTreeNode.getChildCount();
    }

    public Enumeration getChildren(GTreeNode gTreeNode) {
        return gTreeNode.getChildren();
    }

    public GTreeNode[] getPathToRoot(GTreeNode gTreeNode) {
        Vector<GTreeNode> vector = new Vector<GTreeNode>();
        while (gTreeNode != null) {
            vector.addElement(gTreeNode);
            if (gTreeNode.equals(this.getRoot())) break;
            gTreeNode = gTreeNode.getParent();
        }
        GTreeNode[] gTreeNodeArray = new GTreeNode[vector.size()];
        int n = 0;
        while (n < gTreeNodeArray.length) {
            gTreeNodeArray[n] = (GTreeNode)vector.elementAt(gTreeNodeArray.length - (n + 1));
            ++n;
        }
        return gTreeNodeArray;
    }

    public void addChild(GTreeNode gTreeNode, GTreeNode gTreeNode2) {
        gTreeNode.addChild(gTreeNode2);
    }

    public boolean addPath(GTreePath gTreePath) {
        return this.addPath(this.getRoot(), gTreePath);
    }

    public boolean addPath(GTreeNode gTreeNode, GTreePath gTreePath) {
        boolean bl;
        GTreeNode[] gTreeNodeArray = gTreePath.getPath();
        if (!gTreeNode.getName().equals(gTreeNodeArray[0].getName())) {
            bl = false;
        } else {
            int n = 1;
            while (n < gTreeNodeArray.length) {
                GTreeNode gTreeNode2 = gTreeNode.getChild(gTreeNodeArray[n]);
                if (gTreeNode2 == null) break;
                gTreeNode = gTreeNode2;
                ++n;
            }
            int n2 = n;
            while (n2 < gTreeNodeArray.length) {
                gTreeNode.addChild(gTreeNodeArray[n2]);
                gTreeNode = gTreeNodeArray[n2];
                ++n2;
            }
            bl = true;
        }
        return bl;
    }

    public GTreeNode removeChild(GTreeNode gTreeNode, GTreeNode gTreeNode2) {
        return gTreeNode.removeChild(gTreeNode2);
    }

    public GTreeNode removeChild(GTreeNode gTreeNode, String string) {
        return gTreeNode.removeChild(string);
    }

    public GTreeNode getNode(GTreeNode[] gTreeNodeArray) {
        GTreeNode gTreeNode = null;
        if (gTreeNodeArray != null) {
            GTreeNode gTreeNode2 = this.getRoot();
            if (gTreeNode2.equals(gTreeNodeArray[0])) {
                int n = 1;
                while (gTreeNode2 != null && n < gTreeNodeArray.length) {
                    gTreeNode2 = gTreeNode2.getChild(gTreeNodeArray[n]);
                    ++n;
                }
                gTreeNode = gTreeNode2;
            } else {
                gTreeNode = null;
            }
        }
        return gTreeNode;
    }

    public GTreeNode getNode(GTreePath gTreePath) {
        return this.getNode(gTreePath.getPath());
    }

    public String getValue(GTreePath gTreePath) {
        GTreeNode gTreeNode = this.getNode(gTreePath);
        String string = null;
        if (gTreeNode != null) {
            string = gTreeNode.getValue();
        }
        return string;
    }

    public Object get(GTreePath gTreePath) {
        GTreeNode gTreeNode = this.getNode(gTreePath);
        Object object = null;
        if (gTreeNode != null) {
            object = gTreeNode.get();
        }
        return object;
    }

    public GTreeNode findNode(String string) {
        return this.findNode(this.getRoot(), string);
    }

    public GTreeNode findNode(GTreeNode gTreeNode) {
        return this.findNode(this.getRoot(), gTreeNode.getName());
    }

    protected GTreeNode findNode(GTreeNode gTreeNode, String string) {
        GTreeNode gTreeNode2 = null;
        if (gTreeNode.getName().equals(string)) {
            gTreeNode2 = gTreeNode;
        } else {
            Enumeration enumeration = gTreeNode.getChildren();
            while (enumeration.hasMoreElements()) {
                gTreeNode2 = this.findNode((GTreeNode)enumeration.nextElement(), string);
                if (gTreeNode2 != null) break;
            }
        }
        return gTreeNode2;
    }

    public String toString() {
        return this.toString(this.getRoot());
    }

    public String toString(GTreeNode gTreeNode) {
        StringBuffer stringBuffer = new StringBuffer();
        this.printTree(gTreeNode, 0, stringBuffer);
        return stringBuffer.toString();
    }

    protected void printTree(GTreeNode gTreeNode, int n, StringBuffer stringBuffer) {
        this.pad(stringBuffer, n);
        stringBuffer.append(gTreeNode.getName() + "(" + gTreeNode.getValue() + ")\n");
        Enumeration enumeration = gTreeNode.getChildren();
        while (enumeration.hasMoreElements()) {
            this.printTree((GTreeNode)enumeration.nextElement(), n + 1, stringBuffer);
        }
    }

    protected void pad(StringBuffer stringBuffer, int n) {
        while (n-- > 0) {
            stringBuffer.append("  ");
        }
    }
}

