/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.core.utilities;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eso.ohs.core.utilities.GTreeNode;

public class DefaultGTreeNode
implements GTreeNode {
    protected Hashtable children_ = new Hashtable();
    protected GTreeNode parent_ = null;
    protected String name_ = null;
    protected Object value_ = null;

    public DefaultGTreeNode(String string) {
        this.name_ = string;
        this.value_ = string;
    }

    public DefaultGTreeNode(String string, Object object) {
        this.name_ = string;
        this.value_ = object;
    }

    public String getPathName() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.parent_.isRoot()) {
            stringBuffer.append(this.getPathParentName());
        }
        stringBuffer.append(this.getName());
        return stringBuffer.toString();
    }

    public String getPathParentName() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.parent_.isRoot()) {
            stringBuffer.append(this.parent_.getPathParentName());
            stringBuffer.append(this.parent_.getName());
            stringBuffer.append(".");
        }
        return stringBuffer.toString();
    }

    public String getName() {
        return this.name_;
    }

    public void setName(String string) {
        this.name_ = string;
    }

    public Object get() {
        return this.value_;
    }

    public void set(Object object) {
        this.value_ = object;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object instanceof GTreeNode) {
            GTreeNode gTreeNode = (GTreeNode)object;
            bl = this.getName().equals(gTreeNode.getName());
        }
        return bl;
    }

    public String getValue() {
        String string = null;
        if (this.value_ != null) {
            string = this.value_.toString();
        }
        return string;
    }

    public void setValue(String string) {
        this.value_ = string;
    }

    public void setParent(GTreeNode gTreeNode) {
        this.parent_ = gTreeNode;
    }

    public GTreeNode getParent() {
        return this.parent_;
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public boolean isRoot() {
        return this.parent_ == null;
    }

    public GTreeNode getChild(String string) {
        return (GTreeNode)this.children_.get(string);
    }

    public GTreeNode getChild(GTreeNode gTreeNode) {
        return (GTreeNode)this.children_.get(gTreeNode.getName());
    }

    public int getChildCount() {
        return this.children_.size();
    }

    public Enumeration getChildren() {
        return this.children_.elements();
    }

    public void addChild(GTreeNode gTreeNode) {
        gTreeNode.setParent(this);
        this.children_.put(gTreeNode.getName(), gTreeNode);
    }

    public GTreeNode removeChild(GTreeNode gTreeNode) {
        return this.removeChild(gTreeNode.getName());
    }

    public GTreeNode removeChild(String string) {
        GTreeNode gTreeNode = (GTreeNode)this.children_.remove(string);
        if (gTreeNode != null) {
            gTreeNode.setParent(null);
        }
        return gTreeNode;
    }
}

