/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.dbase.phase2;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eso.ohs.core.utilities.ConnectionPool;
import org.eso.ohs.core.utilities.SqlUtils;
import org.eso.ohs.dbase.phase2.AffectedObsRun;
import org.eso.ohs.dfs.ObservationBlock;
import org.eso.ohs.dfs.ObservingRun;
import org.eso.ohs.instruments.InstrumentPackage;
import org.eso.ohs.instruments.ZipUtils;
import org.eso.ohs.persistence.AppConfig;
import org.eso.ohs.persistence.Config;

public class InstrumentPackageDBIO {
    public static final String cvsID_ = "$Id: InstrumentPackageDBIO.java,v 1.40 2005/02/11 11:00:26 tcanavan Exp $";
    private static final int SaveAsFile = 0;
    private static final int SaveAndExtract = 1;
    private static final int GetIPobject = 2;
    public static final float anyVersion = -1.0f;
    public static final float unassignedVersion = -2.0f;
    private static final Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$dbase$phase2$InstrumentPackageDBIO == null ? (class$org$eso$ohs$dbase$phase2$InstrumentPackageDBIO = InstrumentPackageDBIO.class$("org.eso.ohs.dbase.phase2.InstrumentPackageDBIO")) : class$org$eso$ohs$dbase$phase2$InstrumentPackageDBIO));
    private static final String obrepDbName = Config.getCfg().getDbName(ObservationBlock.getSuffix());
    private static final String opc70DbName = Config.getCfg().getDbName(ObservingRun.getSuffix());
    private static final String IP = obrepDbName + "..instrument_packages";
    private static final String IPP = obrepDbName + "..ip_periods";
    private static final String SR = opc70DbName + "..sched_rep";
    private static final String OR = opc70DbName + "..obs_runs";
    private static final String OP = opc70DbName + "..obs_programmes";
    private static final String PR = opc70DbName + "..proposed";
    private static final String EU = opc70DbName + "..eso_users";
    private static final String RS = obrepDbName + "..run_states";
    static /* synthetic */ Class class$org$eso$ohs$dbase$phase2$InstrumentPackageDBIO;

    public static String[] getInstruments() throws SQLException {
        Connection connection = null;
        Statement statement = null;
        try {
            Object[] objectArray;
            Config config = Config.getCfg();
            connection = ConnectionPool.getPool().acquireConnection(config.getUrl(ObservationBlock.getSuffix()), config.getDbUserName(), config.getDbPassword());
            statement = connection.createStatement();
            String string = "select distinct inst_name from " + IP;
            stdlog_.debug((Object)string);
            ResultSet resultSet = statement.executeQuery(string);
            Vector<Object[]> vector = new Vector<Object[]>();
            while (resultSet.next()) {
                objectArray = (resultSet.getString("inst_name") + "").trim();
                vector.addElement(objectArray);
                stdlog_.debug((Object)("found: " + (String)objectArray));
            }
            resultSet.close();
            statement.close();
            ConnectionPool.getPool().releaseConnection(connection);
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        catch (SQLException sQLException) {
            stdlog_.error((Object)("getInstruments(): " + sQLException.getMessage()));
            if (connection != null) {
                statement.close();
                ConnectionPool.getPool().releaseConnection(connection);
            }
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean insertRow(String string, String string2, String string3) {
        boolean bl = true;
        Connection connection = null;
        try {
            try {
                Config config = Config.getCfg();
                connection = ConnectionPool.getPool().acquireConnection(config.getUrl(ObservationBlock.getSuffix()), config.getDbUserName(), config.getDbPassword());
                String string4 = "insert into " + obrepDbName + ".." + string + " (" + string2 + ") values (" + string3 + ")";
                stdlog_.debug((Object)string4);
                Statement statement = connection.createStatement();
                statement.executeUpdate(string4);
                statement.close();
            }
            catch (SQLException sQLException) {
                bl = false;
                stdlog_.error((Object)("Failed to insert: " + sQLException.getMessage()));
                Object var9_10 = null;
                if (connection != null) {
                    ConnectionPool.getPool().releaseConnection(connection);
                }
            }
            Object var9_9 = null;
            if (connection != null) {
                ConnectionPool.getPool().releaseConnection(connection);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (connection != null) {
                ConnectionPool.getPool().releaseConnection(connection);
            }
            throw throwable;
        }
        return bl;
    }

    public static void executeCmds(Vector vector) throws SQLException {
        Connection connection = null;
        try {
            Config config = Config.getCfg();
            connection = ConnectionPool.getPool().acquireConnection(config.getUrl(ObservationBlock.getSuffix()), config.getDbUserName(), config.getDbPassword());
            connection.setAutoCommit(false);
            int n = 0;
            while (n < vector.size()) {
                String string = (String)vector.elementAt(n);
                stdlog_.debug((Object)string);
                Statement statement = connection.createStatement();
                statement.executeUpdate(string);
                statement.close();
                ++n;
            }
            connection.commit();
            stdlog_.debug((Object)"all SQL commands executed");
        }
        catch (SQLException sQLException) {
            InstrumentPackageDBIO.tryRollback(connection, sQLException);
            throw sQLException;
        }
        finally {
            if (connection != null) {
                try {
                    connection.setAutoCommit(true);
                    stdlog_.debug((Object)"setAutoCommit: true");
                }
                catch (SQLException sQLException) {
                    stdlog_.error((Object)("Error setAutoCommit(true):" + sQLException.getMessage()));
                }
                ConnectionPool.getPool().releaseConnection(connection);
            }
        }
    }

    public static void insertIP(String string, float f, String string2, int n, String string3, File file, int[] nArray) throws SQLException, FileNotFoundException {
        Connection connection = null;
        try {
            Config config = Config.getCfg();
            connection = ConnectionPool.getPool().acquireConnection(config.getUrl(ObservationBlock.getSuffix()), config.getDbUserName(), config.getDbPassword());
            connection.setAutoCommit(false);
            String string4 = "insert into " + IP + " (inst_name, version, added_by, added_date, comment, " + "inst_package) values ('" + string + "', " + f + ", " + SqlUtils.sqlEscapedString(string2) + ", " + n + ", " + SqlUtils.sqlEscapedString(string3) + ", ?)";
            stdlog_.debug((Object)string4);
            PreparedStatement preparedStatement = connection.prepareStatement(string4);
            FileInputStream fileInputStream = new FileInputStream(file);
            preparedStatement.setBinaryStream(1, (InputStream)fileInputStream, (int)file.length());
            int n2 = preparedStatement.executeUpdate();
            preparedStatement.close();
            int n3 = 0;
            while (n3 < nArray.length) {
                string4 = "insert into " + IPP + " (inst_name, version, period) values ('" + string + "', " + f + ", " + nArray[n3] + ")";
                stdlog_.debug((Object)string4);
                Statement statement = connection.createStatement();
                statement.executeUpdate(string4);
                statement.close();
                ++n3;
            }
            connection.commit();
            stdlog_.debug((Object)"insertIP: success");
        }
        catch (SQLException sQLException) {
            InstrumentPackageDBIO.tryRollback(connection, sQLException);
            throw sQLException;
        }
        catch (FileNotFoundException fileNotFoundException) {
            InstrumentPackageDBIO.tryRollback(connection, fileNotFoundException);
            throw fileNotFoundException;
        }
        finally {
            if (connection != null) {
                try {
                    connection.setAutoCommit(true);
                    stdlog_.debug((Object)"setAutoCommit: true");
                }
                catch (SQLException sQLException) {
                    stdlog_.error((Object)("Error setAutoCommit(true):" + sQLException.getMessage()));
                }
                ConnectionPool.getPool().releaseConnection(connection);
            }
        }
    }

    public static void updateIP(String string, float f, String string2, String string3, int[] nArray) throws SQLException {
        Connection connection = null;
        try {
            Config config = Config.getCfg();
            connection = ConnectionPool.getPool().acquireConnection(config.getUrl(ObservationBlock.getSuffix()), config.getDbUserName(), config.getDbPassword());
            connection.setAutoCommit(false);
            String string4 = "update " + IP + " set added_by=" + SqlUtils.sqlEscapedString(string2) + ", comment=" + SqlUtils.sqlEscapedString(string3) + " where inst_name='" + string + "' and version=" + f;
            stdlog_.debug((Object)string4);
            Statement statement = connection.createStatement();
            statement.executeUpdate(string4);
            statement.close();
            if (nArray != null) {
                string4 = "delete from " + IPP + " where inst_name='" + string + "' and version=" + f;
                stdlog_.debug((Object)string4);
                statement = connection.createStatement();
                statement.executeUpdate(string4);
                statement.close();
                String string5 = "'" + string + "', " + f + ", ";
                int n = 0;
                while (n < nArray.length) {
                    string4 = "insert into " + IPP + " (inst_name, version, period) values (" + string5 + nArray[n] + ")";
                    stdlog_.debug((Object)string4);
                    statement = connection.createStatement();
                    statement.executeUpdate(string4);
                    statement.close();
                    ++n;
                }
            }
            connection.commit();
            stdlog_.debug((Object)"updateIP: success");
        }
        catch (SQLException sQLException) {
            InstrumentPackageDBIO.tryRollback(connection, sQLException);
            throw sQLException;
        }
        finally {
            if (connection != null) {
                try {
                    connection.setAutoCommit(true);
                    stdlog_.debug((Object)"setAutoCommit: true");
                }
                catch (SQLException sQLException) {
                    stdlog_.error((Object)("Error setAutoCommit(true):" + sQLException.getMessage()));
                }
                ConnectionPool.getPool().releaseConnection(connection);
            }
        }
    }

    private static void tryRollback(Connection connection, Exception exception) {
        stdlog_.error((Object)("caught exception: " + exception.getMessage()));
        try {
            connection.rollback();
            stdlog_.debug((Object)"rollback done");
        }
        catch (SQLException sQLException) {
            stdlog_.error((Object)("Error rolling back: " + sQLException.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteIP(String string, float f) {
        boolean bl = true;
        stdlog_.debug((Object)("delete IP: " + string + " v" + f));
        Connection connection = null;
        try {
            try {
                Config config = Config.getCfg();
                connection = ConnectionPool.getPool().acquireConnection(config.getUrl(ObservationBlock.getSuffix()), config.getDbUserName(), config.getDbPassword());
                Statement statement = connection.createStatement();
                String string2 = "delete from " + IPP + " where inst_name = '" + string + "' and version = " + f;
                stdlog_.debug((Object)string2);
                int n = statement.executeUpdate(string2);
                string2 = "delete from " + IP + " where inst_name ='" + string + "' and version = " + f;
                stdlog_.debug((Object)string2);
                int n2 = statement.executeUpdate(string2);
                stdlog_.debug((Object)("del1=" + n + ", del2=" + n2));
                statement.close();
            }
            catch (SQLException sQLException) {
                bl = false;
                stdlog_.error((Object)("Failed to delete IP: " + sQLException.getMessage()));
                Object var10_11 = null;
                if (connection != null) {
                    ConnectionPool.getPool().releaseConnection(connection);
                }
            }
            Object var10_10 = null;
            if (connection != null) {
                ConnectionPool.getPool().releaseConnection(connection);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (connection != null) {
                ConnectionPool.getPool().releaseConnection(connection);
            }
            throw throwable;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkDuplicateIP(String string, float f) throws SQLException {
        boolean bl;
        block2: {
            Connection connection = null;
            Statement statement = null;
            try {
                Config config = Config.getCfg();
                connection = ConnectionPool.getPool().acquireConnection(config.getUrl(ObservationBlock.getSuffix()), config.getDbUserName(), config.getDbPassword());
                statement = connection.createStatement();
                String string2 = "select * from " + IP + " where inst_name = '" + string + "'" + " and version = " + f;
                stdlog_.debug((Object)string2);
                ResultSet resultSet = statement.executeQuery(string2);
                bl = resultSet.next();
                Object var9_8 = null;
                if (connection == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var9_9 = null;
                    if (connection == null) break block3;
                    statement.close();
                    ConnectionPool.getPool().releaseConnection(connection);
                }
                throw throwable;
            }
            statement.close();
            ConnectionPool.getPool().releaseConnection(connection);
        }
        return bl;
    }

    public static InstrumentPackage getIP(String string, float f) throws SQLException, IOException {
        return InstrumentPackageDBIO.getIPInternal(string, f, null, 2, null);
    }

    public static String getIP(String string, float f, String string2, boolean bl) throws SQLException, IOException {
        return InstrumentPackageDBIO.getIP(string, f, string2, bl, null);
    }

    public static String getIP(String string, float f, String string2, boolean bl, Connection connection) throws SQLException, IOException {
        int n = bl ? 1 : 0;
        InstrumentPackage instrumentPackage = InstrumentPackageDBIO.getIPInternal(string, f, string2, n, connection);
        String string3 = instrumentPackage.getComment();
        return string3;
    }

    public static byte[] getIPData(String string, float f) throws SQLException, IOException {
        InstrumentPackage instrumentPackage = InstrumentPackageDBIO.getIPInternal(string, f, null, 2, null);
        return instrumentPackage.getInstPackageFile();
    }

    protected static InstrumentPackage getIPInternal(String string, float f, String string2, int n, Connection connection) throws SQLException, IOException {
        InstrumentPackage instrumentPackage = new InstrumentPackage(string, f);
        Connection connection2 = connection;
        Statement statement = null;
        try {
            ResultSet resultSet;
            block13: {
                block14: {
                    Config config = Config.getCfg();
                    if (connection2 == null) {
                        connection2 = ConnectionPool.getPool().acquireConnection(config.getUrl(ObservationBlock.getSuffix()), config.getDbUserName(), config.getDbPassword());
                    }
                    statement = connection2.createStatement();
                    String string3 = "select max(datalength(inst_package)) from " + IP + " where inst_name = '" + string + "'" + " and version = " + f;
                    stdlog_.debug((Object)string3);
                    resultSet = statement.executeQuery(string3);
                    int n2 = 0;
                    while (resultSet.next()) {
                        n2 = resultSet.getInt(1);
                    }
                    resultSet.close();
                    string3 = "set textsize " + n2;
                    stdlog_.debug((Object)string3);
                    statement.execute(string3);
                    string3 = "select added_by, added_date, comment, inst_package from " + IP + " where inst_name = '" + string + "' and version = " + f;
                    stdlog_.debug((Object)string3);
                    resultSet = statement.executeQuery(string3);
                    if (!resultSet.next()) break block14;
                    switch (n) {
                        case 0: 
                        case 1: {
                            int n3 = resultSet.getInt("added_date");
                            InputStream inputStream = resultSet.getBinaryStream("inst_package");
                            String string4 = f + "000.000";
                            String string5 = string4.substring(0, string4.indexOf(46) + 3);
                            String string6 = string + "-" + string5 + "-" + InstrumentPackageDBIO.dateString(n3) + ".zip";
                            stdlog_.debug((Object)("zipFile=" + string6));
                            instrumentPackage.setComment(string6);
                            try {
                                boolean bl = n == 1;
                                ZipUtils.extract(inputStream, string2, string6, bl);
                                break block13;
                            }
                            catch (IOException iOException) {
                                stdlog_.error((Object)("zip-extract error: " + iOException.getMessage()));
                                throw iOException;
                            }
                        }
                        case 2: {
                            instrumentPackage.setAddedBy((resultSet.getString("added_by") + "").trim());
                            instrumentPackage.setDateAdded(resultSet.getLong("added_date"));
                            instrumentPackage.setComment((resultSet.getString("comment") + "").trim());
                            instrumentPackage.setInstPackageFile(resultSet.getBytes("inst_package"));
                            break block13;
                        }
                        default: {
                            throw new IOException("Unknown processing code: " + n);
                        }
                    }
                }
                throw new SQLException("Instrument Package for " + string + " v" + f + " not found in the database");
            }
            resultSet.close();
            statement.close();
            if (connection == null) {
                ConnectionPool.getPool().releaseConnection(connection2);
            }
        }
        catch (SQLException sQLException) {
            stdlog_.error((Object)("getIP(): " + sQLException.getMessage()));
            if (connection2 != null) {
                statement.close();
                if (connection == null) {
                    ConnectionPool.getPool().releaseConnection(connection2);
                }
            }
            throw sQLException;
        }
        return instrumentPackage;
    }

    public static String getInstFromOd(Statement statement, long l) throws SQLException {
        String string = "SELECT instrument,ipversion from " + obrepDbName + "..obs_descriptions" + " WHERE od_id = " + l;
        ResultSet resultSet = statement.executeQuery(string);
        String string2 = null;
        while (resultSet.next()) {
            string2 = resultSet.getString("instrument");
        }
        return string2;
    }

    public static float getIPVFromOd(Statement statement, long l) throws SQLException {
        String string = "SELECT instrument,ipversion from " + obrepDbName + "..obs_descriptions" + " WHERE od_id = " + l;
        ResultSet resultSet = statement.executeQuery(string);
        float f = 0.0f;
        while (resultSet.next()) {
            f = resultSet.getFloat("ipversion");
        }
        return f;
    }

    public static float getIPVFromObsRun(Statement statement, long l) throws SQLException {
        String string = "SELECT ipversion from " + opc70DbName + "..sched_rep" + " WHERE run_id = " + l;
        ResultSet resultSet = statement.executeQuery(string);
        float f = 0.0f;
        while (resultSet.next()) {
            f = resultSet.getFloat("ipversion");
        }
        resultSet.close();
        return f;
    }

    public static Vector getPeriods(String string, float f) throws SQLException {
        Connection connection = null;
        Statement statement = null;
        Vector<Integer> vector = new Vector<Integer>();
        try {
            Config config = Config.getCfg();
            connection = ConnectionPool.getPool().acquireConnection(config.getUrl(ObservationBlock.getSuffix()), config.getDbUserName(), config.getDbPassword());
            statement = connection.createStatement();
            String string2 = "select period from " + IPP + " where inst_name = '" + string + "' and version = " + f;
            stdlog_.debug((Object)string2);
            ResultSet resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                Integer n = new Integer(resultSet.getInt(1));
                vector.addElement(n);
            }
            resultSet.close();
            statement.close();
            ConnectionPool.getPool().releaseConnection(connection);
        }
        catch (SQLException sQLException) {
            stdlog_.error((Object)("getIP(): " + sQLException.getMessage()));
            if (connection != null) {
                statement.close();
                ConnectionPool.getPool().releaseConnection(connection);
            }
            throw sQLException;
        }
        return vector;
    }

    public static Vector getIPversions(String string, int n) throws SQLException {
        Connection connection = null;
        Statement statement = null;
        Vector<Float> vector = new Vector<Float>();
        try {
            Config config = Config.getCfg();
            connection = ConnectionPool.getPool().acquireConnection(config.getUrl(ObservationBlock.getSuffix()), config.getDbUserName(), config.getDbPassword());
            statement = connection.createStatement();
            String string2 = "select distinct version from " + IPP + " where inst_name = '" + string + "' and period = " + n;
            stdlog_.debug((Object)string2);
            ResultSet resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                Float f = new Float(resultSet.getFloat(1));
                vector.addElement(f);
            }
            resultSet.close();
            statement.close();
            ConnectionPool.getPool().releaseConnection(connection);
        }
        catch (SQLException sQLException) {
            stdlog_.error((Object)("getIP(): " + sQLException.getMessage()));
            if (connection != null) {
                statement.close();
                ConnectionPool.getPool().releaseConnection(connection);
            }
            throw sQLException;
        }
        return vector;
    }

    public static Vector getAllIPversions(String string) throws SQLException {
        Connection connection = null;
        Statement statement = null;
        Vector<Float> vector = new Vector<Float>();
        try {
            Config config = Config.getCfg();
            connection = ConnectionPool.getPool().acquireConnection(config.getUrl(ObservationBlock.getSuffix()), config.getDbUserName(), config.getDbPassword());
            statement = connection.createStatement();
            String string2 = "select distinct version from " + IP + " where inst_name = '" + string + "'";
            stdlog_.debug((Object)string2);
            ResultSet resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                Float f = new Float(resultSet.getFloat(1));
                vector.addElement(f);
            }
            resultSet.close();
            statement.close();
            ConnectionPool.getPool().releaseConnection(connection);
        }
        catch (SQLException sQLException) {
            stdlog_.error((Object)("getIP(): " + sQLException.getMessage()));
            if (connection != null) {
                statement.close();
                ConnectionPool.getPool().releaseConnection(connection);
            }
            throw sQLException;
        }
        return vector;
    }

    private static String dateString(int n) {
        Calendar calendar = Calendar.getInstance();
        Date date = new Date((long)n * 1000L);
        calendar.setTime(date);
        int n2 = calendar.get(5);
        int n3 = calendar.get(2);
        int n4 = calendar.get(1);
        String string = ++n3 < 10 ? "0" : "";
        String string2 = n2 < 10 ? "0" : "";
        String string3 = n4 + string + n3 + string2 + n2;
        stdlog_.debug((Object)("dateStr=" + string3));
        return string3;
    }

    public static float getDefaultIP(String string, int n) throws SQLException {
        Config config = Config.getCfg();
        String string2 = config.getUrl(ObservationBlock.getSuffix());
        String string3 = config.getDbUserName();
        String string4 = config.getDbPassword();
        return InstrumentPackageDBIO.getDefaultIP(string, n, string2, string3, string4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static float getDefaultIP(String string, int n, String string2, String string3, String string4) throws SQLException {
        float f = -1.0f;
        Connection connection = null;
        Statement statement = null;
        try {
            connection = ConnectionPool.getPool().acquireConnection(string2, string3, string4);
            String string5 = "select MAX(version) from " + IPP + " where (inst_name = ? and period = ?)";
            stdlog_.debug((Object)string5);
            statement = connection.prepareStatement(string5);
            statement.setString(1, string);
            statement.setInt(2, n);
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next() && (f = resultSet.getFloat(1)) == 0.0f) {
                f = -1.0f;
            }
            Object var11_10 = null;
            if (connection == null) return f;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (connection == null) throw throwable;
            statement.close();
            ConnectionPool.getPool().releaseConnection(connection);
            throw throwable;
        }
        statement.close();
        ConnectionPool.getPool().releaseConnection(connection);
        return f;
    }

    public static Vector getObsRuns(String string, float f, int[] nArray) throws SQLException {
        stdlog_.debug((Object)("IPdbio.getObsRuns: " + string + " v" + f));
        Connection connection = null;
        Statement statement = null;
        try {
            Config config = Config.getCfg();
            connection = ConnectionPool.getPool().acquireConnection(config.getUrl(ObservationBlock.getSuffix()), config.getDbUserName(), config.getDbPassword());
            statement = connection.createStatement();
            StringBuffer stringBuffer = new StringBuffer(1000);
            stringBuffer.append("select distinct " + SR + ".id, inst, ipversion, " + SR + ".period, " + SR + ".progid, " + "email_address, " + "item_name, surname_dl, email, run_state from " + SR + ", " + OR + ", " + OP + ", " + PR + ", " + EU + ", " + RS + " where " + OR + ".id = " + SR + ".run_id and " + OP + ".id = " + OR + ".programme_id and " + OP + ".id = " + PR + ".programme_id and " + EU + ".id = " + PR + ".user_id and " + OR + ".id *=" + RS + ".run_id and " + "pi_flag=0 and " + "published=1 and " + "inst = '" + string + "'");
            if (f >= 0.0f) {
                stringBuffer.append(" and ipversion = " + f);
            } else if (f == -2.0f) {
                stringBuffer.append(" and ipversion is Null");
            }
            if (nArray != null && nArray.length > 0) {
                stringBuffer.append(" and " + SR + ".period in (" + nArray[0]);
                int n = 1;
                while (n < nArray.length) {
                    stringBuffer.append(", " + nArray[n]);
                    ++n;
                }
                stringBuffer.append(")");
            }
            stringBuffer.append(" order by " + SR + ".progid, " + SR + ".id");
            stdlog_.debug((Object)stringBuffer);
            ResultSet resultSet = statement.executeQuery(stringBuffer.toString());
            Vector<AffectedObsRun> vector = new Vector<AffectedObsRun>();
            while (resultSet.next()) {
                AffectedObsRun affectedObsRun = new AffectedObsRun();
                affectedObsRun.id_ = resultSet.getInt("id");
                affectedObsRun.period_ = resultSet.getInt("period");
                affectedObsRun.obsRunName_ = resultSet.getString("progid");
                affectedObsRun.piInitial_ = resultSet.getString("item_name");
                affectedObsRun.piName_ = resultSet.getString("surname_dl");
                affectedObsRun.emailEU_ = resultSet.getString("email");
                affectedObsRun.emailOP_ = resultSet.getString("email_address");
                affectedObsRun.runState_ = resultSet.getString("run_state");
                affectedObsRun.instrument_ = resultSet.getString("inst");
                affectedObsRun.ipVersion_ = resultSet.getFloat("ipversion");
                if (resultSet.wasNull()) {
                    affectedObsRun.ipVersion_ = -1.0f;
                }
                vector.addElement(affectedObsRun);
            }
            resultSet.close();
            statement.close();
            ConnectionPool.getPool().releaseConnection(connection);
            return vector;
        }
        catch (SQLException sQLException) {
            stdlog_.error((Object)("getObsRuns(): " + sQLException.getMessage()));
            if (connection != null) {
                statement.close();
                ConnectionPool.getPool().releaseConnection(connection);
            }
            throw sQLException;
        }
    }

    public static void updateObsRunsIpVersions(int[] nArray, float[] fArray) throws SQLException {
        Connection connection = null;
        try {
            Config config = Config.getCfg();
            connection = ConnectionPool.getPool().acquireConnection(config.getUrl(ObservationBlock.getSuffix()), config.getDbUserName(), config.getDbPassword());
            connection.setAutoCommit(false);
            int n = 0;
            while (n < nArray.length) {
                String string = fArray[n] < 0.0f ? "null" : fArray[n] + "";
                String string2 = "update " + SR + " set ipversion=" + string + " where id=" + nArray[n];
                stdlog_.debug((Object)string2);
                Statement statement = connection.createStatement();
                statement.executeUpdate(string2);
                statement.close();
                ++n;
            }
            connection.commit();
            stdlog_.debug((Object)"updateObsRunsIpVersions: success");
        }
        catch (SQLException sQLException) {
            InstrumentPackageDBIO.tryRollback(connection, sQLException);
            throw sQLException;
        }
        finally {
            if (connection != null) {
                try {
                    connection.setAutoCommit(true);
                    stdlog_.debug((Object)"setAutoCommit: true");
                }
                catch (SQLException sQLException) {
                    stdlog_.error((Object)("Error setAutoCommit(true):" + sQLException.getMessage()));
                }
                ConnectionPool.getPool().releaseConnection(connection);
            }
        }
    }

    public static Vector getMissingIPs(boolean bl) throws SQLException {
        return InstrumentPackageDBIO.getMissingIPs(bl, null);
    }

    public static Vector getMissingIPs(boolean bl, Vector vector) throws SQLException {
        String string;
        Object object;
        stdlog_.debug((Object)"IPdbio.getMissingIPs");
        Connection connection = null;
        Statement statement = null;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        if (vector != null) {
            object = vector.elements();
            while (object.hasMoreElements()) {
                string = (String)object.nextElement();
                if (string == null || string.length() <= 0) continue;
                if (bl2) {
                    stringBuffer.append(", ");
                } else {
                    bl2 = true;
                }
                stringBuffer.append(SqlUtils.sqlEscapedString(string));
            }
        }
        try {
            object = Config.getCfg();
            connection = ConnectionPool.getPool().acquireConnection(((Config)object).getUrl(ObservationBlock.getSuffix()), ((Config)object).getDbUserName(), ((Config)object).getDbPassword());
            statement = connection.createStatement();
            string = "select distinct inst, ipversion " + (bl ? "" : ", progid, period ") + "from " + SR + " where published=1 " + (bl2 ? "and inst not in (" + stringBuffer.toString() + ") " : "") + "and (" + "(ipversion<>null and " + SR + ".ipversion not in " + "(select version from " + IP + " where " + IP + ".inst_name = " + SR + ".inst)" + ") or (" + "(ipversion=null and period<" + AppConfig.getAppConfig().getIPVersionStartPeriod() + " and 0.0 not in " + "(select version from " + IP + " where " + IP + ".inst_name = " + SR + ".inst)" + "))) order by " + (bl ? "inst, ipversion" : "progid, inst, period, ipversion");
            stdlog_.debug((Object)string);
            ResultSet resultSet = statement.executeQuery(string);
            Vector<AffectedObsRun> vector2 = new Vector<AffectedObsRun>();
            while (resultSet.next()) {
                AffectedObsRun affectedObsRun = new AffectedObsRun();
                if (!bl) {
                    affectedObsRun.obsRunName_ = resultSet.getString("progid");
                    affectedObsRun.period_ = resultSet.getInt("period");
                }
                affectedObsRun.instrument_ = resultSet.getString("inst");
                affectedObsRun.ipVersion_ = resultSet.getFloat("ipversion");
                if (resultSet.wasNull()) {
                    affectedObsRun.ipVersion_ = -1.0f;
                }
                vector2.addElement(affectedObsRun);
            }
            resultSet.close();
            statement.close();
            ConnectionPool.getPool().releaseConnection(connection);
            return vector2;
        }
        catch (SQLException sQLException) {
            stdlog_.error((Object)("getMissingIPs(): " + sQLException.getMessage()));
            if (connection != null) {
                statement.close();
                ConnectionPool.getPool().releaseConnection(connection);
            }
            throw sQLException;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

