/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.dfs;

import java.io.Serializable;
import org.eso.ohs.core.utilities.AssocList;
import org.eso.ohs.dfs.CommentDetails;
import org.eso.ohs.dfs.ReadmeHistory;
import org.eso.ohs.dfs.USDReadmeDatails;
import org.eso.ohs.instruments.Instrument;
import org.eso.ohs.instruments.ReadmeAttribute;
import org.eso.ohs.instruments.ReadmeAttributesFactory;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class Readme
implements Serializable {
    private static final long serialVersionUID = -4378250031958131400L;
    public static final String DEFINED_STATUS = "D";
    public static final String CHECKEDOUT_STATUS = "P";
    public static final String ACCEPTED_STATUS = "+";
    public static final String REJECTED_STATUS = "-";
    private String status;
    public static final AssocList statusValues_ = new AssocList().add("(-)Rejected", "-").add("(+)Accepted", "+");
    private int version;
    private boolean checkedIn = false;
    private float ipVersion_;
    private ReadmeHistory[] readmeHistoryItems;
    private transient USDReadmeDatails usdReadmeFileDetails;
    private transient CommentDetails[] commentArray;
    private ReadmeAttribute[] readmeAttributes_;

    public Readme(float f) {
        this.ipVersion_ = f;
    }

    public ReadmeAttribute[] getRedmeAttributes() {
        if (this.readmeAttributes_ == null) {
            return new ReadmeAttribute[0];
        }
        return this.readmeAttributes_;
    }

    public void setRedmeAttributes(ReadmeAttribute[] readmeAttributeArray) {
        this.readmeAttributes_ = readmeAttributeArray;
    }

    public String toAttributesXMLString() {
        Format format;
        XMLOutputter xMLOutputter;
        Element element = new Element("Readme");
        Document document = new Document(element);
        document.setRootElement(element);
        int n = 0;
        while (n < this.readmeAttributes_.length) {
            xMLOutputter = new Element(this.readmeAttributes_[n].getName());
            format = new Element("Label");
            format.setText(this.readmeAttributes_[n].getReadmeConfig().getLabel());
            Element element2 = new Element("Data");
            element2.setText(this.readmeAttributes_[n].getValue());
            xMLOutputter.addContent(0, (Content)format);
            xMLOutputter.addContent(1, (Content)element2);
            element.addContent((Content)xMLOutputter);
            ++n;
        }
        xMLOutputter = new XMLOutputter();
        format = Format.getPrettyFormat();
        xMLOutputter.setFormat(format);
        return xMLOutputter.outputString(document);
    }

    public String verifyReport() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.readmeAttributes_.length) {
            String string = this.readmeAttributes_[n].verify();
            if (string.equals("Not Defined")) {
                stringBuffer.append("ERROR Not Defined:- " + this.readmeAttributes_[n].getReadmeConfig().getLabel() + "\n");
            }
            if (string.equals("INVALID")) {
                stringBuffer.append("ERROR Invalid Data:- " + this.readmeAttributes_[n].getReadmeConfig().getLabel() + "\n");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean isCheckedIn() {
        return this.checkedIn;
    }

    public void setCheckedIn(boolean bl) {
        this.checkedIn = bl;
    }

    public float getIpVersion() {
        return this.ipVersion_;
    }

    public void setIpVersion(float f) {
        this.ipVersion_ = f;
    }

    public ReadmeHistory[] getReadmeHistoryItems() {
        if (this.readmeHistoryItems == null) {
            return new ReadmeHistory[0];
        }
        return this.readmeHistoryItems;
    }

    public void setReadmeHistoryItems(ReadmeHistory[] readmeHistoryArray) {
        this.readmeHistoryItems = readmeHistoryArray;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String string) {
        this.status = string;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    public USDReadmeDatails getUsdReadmeFileDetails() {
        return this.usdReadmeFileDetails;
    }

    public void setUsdReadmeFileDetails(USDReadmeDatails uSDReadmeDatails) {
        this.usdReadmeFileDetails = uSDReadmeDatails;
    }

    public CommentDetails[] getCommentArray() {
        return this.commentArray;
    }

    public void setCommentArray(CommentDetails[] commentDetailsArray) {
        this.commentArray = commentDetailsArray;
    }

    public static Readme createReadme(Instrument instrument) {
        Readme readme = new Readme(instrument.getVersionNumber());
        readme.setRedmeAttributes(ReadmeAttributesFactory.createReadmeAttributes(instrument));
        return readme;
    }
}

