/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.instruments;

import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eso.ohs.instruments.ParamMetaData;
import org.eso.ohs.instruments.Parameter;

public class NumberParameter
extends Parameter {
    static final long serialVersionUID = 1652945642248714865L;
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$instruments$NumberParameter == null ? (class$org$eso$ohs$instruments$NumberParameter = NumberParameter.class$("org.eso.ohs.instruments.NumberParameter")) : class$org$eso$ohs$instruments$NumberParameter));
    private Float minValue_;
    private Float maxValue_;
    private Float[] validValues_;
    static /* synthetic */ Class class$org$eso$ohs$instruments$NumberParameter;

    public Float getMinValue() {
        return this.minValue_;
    }

    public Float getMaxValue() {
        return this.maxValue_;
    }

    public Float[] getValidValues() {
        return this.validValues_;
    }

    public String getToolTipText() {
        String string = "Enter valid value";
        boolean bl = false;
        if (this.getMinValue() != null && this.getMaxValue() != null) {
            bl = true;
        }
        Float[] floatArray = this.getValidValues();
        StringBuffer stringBuffer = new StringBuffer(20);
        if (floatArray != null) {
            int n = 0;
            while (n < floatArray.length) {
                stringBuffer.append(floatArray[n].floatValue() + " ");
                ++n;
            }
        }
        StringBuffer stringBuffer2 = null;
        if (bl) {
            stringBuffer2 = new StringBuffer();
            stringBuffer2.append(this.getMinValue());
            stringBuffer2.append("..");
            stringBuffer2.append(this.getMaxValue());
        }
        if (bl && floatArray == null) {
            string = "Floating point within range " + stringBuffer2.toString();
        }
        if (!bl && floatArray != null) {
            string = "Floating point value from the list " + stringBuffer.toString();
        }
        if (bl && floatArray != null) {
            string = "Floating point value within " + stringBuffer2.toString() + " or in list " + stringBuffer.toString();
        }
        if (!bl && floatArray == null) {
            string = "Enter Floating point value";
        }
        return string;
    }

    public NumberParameter(ParamMetaData paramMetaData) {
        super(paramMetaData);
        this.initValidValues();
    }

    public char getDBTypeCode() {
        return 'N';
    }

    public boolean verifyValue(String string) {
        Float f = null;
        String string2 = this.getRange();
        if (string == null || string.length() <= 0) {
            return false;
        }
        if (string.compareTo("NODEFAULT") == 0) {
            return false;
        }
        try {
            f = new Float(string);
            if (f.isNaN()) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return string2 == null || string2.length() <= 0 || this.valueInRange(f);
    }

    private boolean valueInRange(Float f) {
        if (this.minValue_ != null && this.maxValue_ != null && f.floatValue() >= this.minValue_.floatValue() && f.floatValue() <= this.maxValue_.floatValue()) {
            return true;
        }
        if (this.validValues_ != null) {
            int n = 0;
            while (n < this.validValues_.length) {
                if (f.floatValue() == this.validValues_[n].floatValue()) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public void initValidValues() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.getRange());
        StringBuffer stringBuffer = new StringBuffer(20);
        StringBuffer stringBuffer2 = new StringBuffer(20);
        Vector<Float> vector = new Vector<Float>();
        while (stringTokenizer.hasMoreElements()) {
            String string = stringTokenizer.nextToken();
            int n = string.indexOf("..");
            if (n != -1) {
                int n2 = n - 1;
                while (n2 >= 0 && string.charAt(n2) != ' ') {
                    stringBuffer.insert(0, string.charAt(n2));
                    --n2;
                }
                n2 = n + 2;
                while (n2 < string.length() && string.charAt(n2) != ' ') {
                    stringBuffer2.append(string.charAt(n2));
                    ++n2;
                }
                try {
                    this.minValue_ = new Float(stringBuffer.toString());
                    this.maxValue_ = new Float(stringBuffer2.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    stdlog_.error((Object)("Invalid range : " + numberFormatException.getMessage()));
                }
                continue;
            }
            try {
                Float f = new Float(string);
                vector.addElement(f);
            }
            catch (NumberFormatException numberFormatException) {
                stdlog_.error((Object)("Invalid range in paramater : " + this.getParameterName()));
            }
        }
        if (vector.size() > 0) {
            this.validValues_ = new Float[vector.size()];
            vector.copyInto(this.validValues_);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

