/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.instruments;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.Logger;
import org.eso.ohs.core.utilities.Paramfile;
import org.eso.ohs.instruments.FileParameter;
import org.eso.ohs.instruments.ParamMetaData;

public class ParamFileParameter
extends FileParameter {
    static final long serialVersionUID = -1919846079097974958L;
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$instruments$ParamFileParameter == null ? (class$org$eso$ohs$instruments$ParamFileParameter = ParamFileParameter.class$("org.eso.ohs.instruments.ParamFileParameter")) : class$org$eso$ohs$instruments$ParamFileParameter));
    private String fileName_;
    private byte[] compressedValue_ = new byte[0];
    private int uncompressedLength_;
    static /* synthetic */ Class class$org$eso$ohs$instruments$ParamFileParameter;

    public ParamFileParameter(ParamMetaData paramMetaData) {
        super(paramMetaData);
        this.setValue(super.getValue());
    }

    public boolean displayValueDifferent() {
        return true;
    }

    public char getDBTypeCode() {
        return 'p';
    }

    public void setValue(String string) {
        if (string == null || string.equals("NODEFAULT")) {
            return;
        }
        stdlog_.debug((Object)("@@@@ Actual value length " + string.length()));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            byte[] byArray = string.getBytes();
            gZIPOutputStream.write(byArray, 0, byArray.length);
            gZIPOutputStream.close();
            this.uncompressedLength_ = byArray.length;
            this.compressedValue_ = byteArrayOutputStream.toByteArray();
            this.fileName_ = ParamFileParameter.getFilenameValue(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String getValue() {
        if (this.fileName_ == null || this.fileName_.equals("NODEFAULT")) {
            return "NODEFAULT";
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.compressedValue_);
            GZIPInputStream gZIPInputStream = new GZIPInputStream((InputStream)byteArrayInputStream, this.uncompressedLength_);
            byte[] byArray = new byte[this.uncompressedLength_];
            int n = gZIPInputStream.read(byArray, 0, byArray.length);
            gZIPInputStream.close();
            return new String(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public String getFilenameFromValue() {
        String string;
        int n;
        String string2 = this.getValue();
        stdlog_.debug((Object)("Value = " + string2));
        String string3 = "NODEFAULT";
        if (string2 == null || string2.length() <= 0) {
            return string3;
        }
        int n2 = string2.indexOf("PAF.NAME");
        if (n2 >= 0 && (n = (string = string2.substring(n2)).indexOf(34)) >= 0) {
            int n3 = string.indexOf(34, n + 1);
            string3 = string.substring(n + 1, n3);
        }
        return string3;
    }

    public static String getFilenameValue(String string) {
        String string2;
        int n;
        String string3 = null;
        if (string == null || string.length() <= 0) {
            return string3;
        }
        int n2 = string.indexOf("PAF.NAME");
        if (n2 >= 0 && (n = (string2 = string.substring(n2)).indexOf(34)) >= 0) {
            int n3 = string2.indexOf(34, n + 1);
            string3 = string2.substring(n + 1, n3);
        }
        return string3;
    }

    public boolean verifyValue(String string) {
        return string != null && !string.equals("NODEFAULT") && string.length() > 0;
    }

    public boolean verify() {
        return this.verifyValue(this.getFilename());
    }

    public String getDisplayValue() {
        if (this.fileName_ == null) {
            return "NODEFAULT";
        }
        return this.fileName_;
    }

    public void setFilename(String string) {
        this.fileName_ = string;
    }

    public String getFilename() {
        return this.fileName_;
    }

    public byte[] getCompressedValue() {
        return this.compressedValue_;
    }

    public void setCompressedValue(byte[] byArray) {
        this.compressedValue_ = byArray;
    }

    public void setUncompressedLength(int n) {
        this.uncompressedLength_ = n;
    }

    public int getUncompressedLength() {
        return this.uncompressedLength_;
    }

    public Paramfile getParamfile() {
        String string = this.getValue();
        if (string.equals("NODEFAULT")) {
            return null;
        }
        Paramfile paramfile = null;
        try {
            paramfile = new Paramfile(new StringReader(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return paramfile;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

