/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.instruments;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.eso.ohs.core.utilities.AssocList;
import org.eso.ohs.core.utilities.TextUtils;
import org.eso.ohs.instruments.ParamMetaData;

public abstract class Parameter
implements Serializable {
    static final long serialVersionUID = -4378250031958131854L;
    private final String rcsid = "$Id: Parameter.java,v 1.31 2005/02/07 09:06:36 pnunes Exp $";
    public static final String FILTER_NAME = "Filter";
    public static final int FILTER_VALUE = 1;
    public static final String GRISM_NAME = "Grism";
    public static final int GRISM_VALUE = 2;
    public static final AssocList filters = new AssocList().add("Filter", new Integer(1)).add("Grism", new Integer(2));
    public static final int PARAM_DISPLAY_VALUE_MAXLEN = 300;
    private String value_;
    private String parameterName_;
    private String parameterType_;
    private ParamMetaData pMeta_;
    private transient ParamMetaData newPMeta_;

    public Parameter(ParamMetaData paramMetaData) {
        this.newPMeta_ = paramMetaData;
        this.parameterName_ = this.newPMeta_.getParameterName();
        this.parameterType_ = this.newPMeta_.getType();
        this.value_ = this.newPMeta_.getValue();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.pMeta_ != null) {
            this.parameterType_ = this.pMeta_.getType();
            this.parameterName_ = this.pMeta_.getParameterName();
            if (this.value_ == null) {
                this.value_ = this.pMeta_.getValue();
            }
            this.pMeta_ = null;
        }
    }

    public static boolean validParamKeyword(String string) {
        return ParamMetaData.validParamKeyword(string);
    }

    public boolean displayValueDifferent() {
        return false;
    }

    public boolean isDisplay() {
        return this.newPMeta_.isDisplay();
    }

    public boolean isHidden() {
        return this.newPMeta_.isHidden();
    }

    public String getParameterName() {
        return this.parameterName_;
    }

    public String getName() {
        return this.getParameterName();
    }

    public abstract char getDBTypeCode();

    public String getType() {
        return this.parameterType_;
    }

    public String getRange() {
        return this.newPMeta_.getRange();
    }

    public String getDefaultValue() {
        return this.newPMeta_.getDefaultValue();
    }

    public String getValue() {
        return this.value_;
    }

    public void setMetaData(ParamMetaData paramMetaData) {
        this.newPMeta_ = paramMetaData;
        this.parameterType_ = this.newPMeta_.getType();
        this.parameterName_ = this.newPMeta_.getParameterName();
    }

    public String getLabel() {
        return this.newPMeta_.getLabel();
    }

    public String getMiniHelp() {
        return this.newPMeta_.getMiniHelp();
    }

    public boolean isFixed() {
        return this.newPMeta_.isFixed();
    }

    public boolean hasHiddenKeyword() {
        return this.newPMeta_.hasHiddenKeyword();
    }

    public void setValue(String string) {
        this.value_ = string == null ? this.newPMeta_.getDefaultValue() : string;
    }

    public boolean samePrefix(String string) {
        return this.newPMeta_.samePrefix(string);
    }

    public abstract boolean verifyValue(String var1);

    public boolean verify() {
        return this.verifyValue(this.getValue());
    }

    private String valueToOBD(String string) {
        String string2 = this.getParameterName();
        if (string == null) {
            string = "";
        }
        if (string2.indexOf(".FILT") >= 0) {
            string = string.replace(' ', '#');
        } else if (string2.endsWith(".ALPHA") || string2.endsWith(".DELTA")) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = string.length();
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                if (Character.isDigit(c) || c == '.' || c == '-') {
                    stringBuffer.append(c);
                }
                ++n2;
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public String toOBDParameterString() {
        return this.toOBDParameterString(this.getValue());
    }

    public String toOBDParameterString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.parameterName_ + "\t\t\"" + TextUtils.escapedString(this.valueToOBD(string)) + "\"");
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public String toDisplayOBDParameterString() {
        return this.toDisplayOBDParameterString(this.getValue());
    }

    public String toDisplayOBDParameterString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.length() > 300) {
            String string2 = string.substring(0, 300);
            stringBuffer.append(this.parameterName_ + "\t\t\"" + TextUtils.escapedString(string2) + " ...." + "\"");
        } else {
            stringBuffer.append(this.parameterName_ + "\t\t\"" + TextUtils.escapedString(this.valueToOBD(string)) + "\"");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public String getDisplayValue() {
        if (this.getValue() != null) {
            return this.getValue();
        }
        if (this.getDefaultValue() != null) {
            return this.getDefaultValue();
        }
        return "NODEFAULT";
    }

    public String getToolTipText() {
        return "Enter Value";
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass());
        stringBuffer.append(", Name=");
        stringBuffer.append(this.getName());
        stringBuffer.append(", Type=");
        stringBuffer.append(this.getType());
        stringBuffer.append(", Range=");
        stringBuffer.append(this.getRange());
        stringBuffer.append(", Default=");
        stringBuffer.append(this.getDefaultValue());
        stringBuffer.append(", DispValue=");
        stringBuffer.append(this.getDisplayValue());
        stringBuffer.append(", Hidden=");
        stringBuffer.append(this.isHidden());
        stringBuffer.append(", Display=");
        stringBuffer.append(this.isDisplay());
        stringBuffer.append(", Fixed=");
        stringBuffer.append(this.isFixed());
        stringBuffer.append(", Label=");
        stringBuffer.append(this.getLabel());
        stringBuffer.append(", Minihelp=");
        stringBuffer.append(this.getMiniHelp());
        return stringBuffer.toString();
    }

    public boolean equals(Parameter parameter) {
        return this.parameterName_.compareTo(parameter.getParameterName()) == 0 && this.value_.compareTo(parameter.getValue()) == 0;
    }
}

