/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.instruments;

import org.eso.ohs.instruments.InstrumentConstraintConfig;
import org.eso.ohs.instruments.InstrumentConstraintMetaData;
import org.eso.ohs.instruments.ReadmeAttribute;

public class ReadmeTextAttribute
extends ReadmeAttribute {
    private static final long serialVersionUID = -4378250031958121801L;
    public static final String DB_TYPE = "T";

    public ReadmeTextAttribute(InstrumentConstraintConfig instrumentConstraintConfig) {
        super(instrumentConstraintConfig);
    }

    public Object getRawValue() {
        return this.getValue();
    }

    public boolean isCompulsory() {
        InstrumentConstraintConfig instrumentConstraintConfig = this.getReadmeConfig();
        String string = this.getValue();
        return !instrumentConstraintConfig.isCompulsory() || this.hasValue();
    }

    public String verify() {
        InstrumentConstraintConfig instrumentConstraintConfig = this.getReadmeConfig();
        InstrumentConstraintMetaData instrumentConstraintMetaData = instrumentConstraintConfig.getMetaData();
        if (!this.isCompulsory()) {
            return "Not Defined";
        }
        if (this.getValue().length() > instrumentConstraintMetaData.getMaxLength()) {
            return "DATA TRUNCATED";
        }
        return "OK";
    }

    public static String getDBType() {
        return DB_TYPE;
    }

    public String getToolTipText() {
        InstrumentConstraintConfig instrumentConstraintConfig = this.getReadmeConfig();
        InstrumentConstraintMetaData instrumentConstraintMetaData = instrumentConstraintConfig.getMetaData();
        return "Enter Text Not greater than " + instrumentConstraintMetaData.getMaxLength() + " (characters)";
    }
}

