/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.persistence;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.eso.ohs.core.utilities.ObjectIOException;
import org.eso.ohs.persistence.Media;

public abstract class Config {
    protected static final int MAX_OBJECT_TYPES = 100;
    protected static Config config_ = null;
    private String password_ = null;
    private int userId_ = -1;
    private boolean debugMode_ = false;
    public static final int MAX_NAME_LENGTH = 32;
    public static final int MAX_TEXT_LENGTH = 240;
    protected Hashtable objCfgPersistence = new Hashtable();
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$persistence$Config == null ? (class$org$eso$ohs$persistence$Config = Config.class$("org.eso.ohs.persistence.Config")) : class$org$eso$ohs$persistence$Config));
    static /* synthetic */ Class class$org$eso$ohs$persistence$Config;

    protected Config() {
        this.debugMode_ = new Boolean(System.getProperty("debug.mode"));
        this.initPersistenceObjInfo();
    }

    public static Config getCfg() {
        return config_;
    }

    public static void setCfg(Config config) {
        config_ = config;
    }

    public static void reset() {
        config_ = null;
    }

    private ObjConfigPersistence getObjCfgPersistence(Class clazz) {
        ObjConfigPersistence objConfigPersistence = (ObjConfigPersistence)this.objCfgPersistence.get(clazz);
        if (objConfigPersistence != null) {
            return objConfigPersistence;
        }
        Enumeration enumeration = this.objCfgPersistence.keys();
        throw new IllegalArgumentException("getObjCfg: " + clazz);
    }

    public void setUserName(int n) {
        this.userId_ = n;
    }

    public int getUserName() {
        return this.userId_;
    }

    public void setPassword(String string) {
        this.password_ = string;
    }

    public String getPassword() {
        return this.password_;
    }

    public Class getClassForFileSuffix(String string) {
        Enumeration enumeration = this.objCfgPersistence.keys();
        while (enumeration.hasMoreElements()) {
            ObjConfigPersistence objConfigPersistence = (ObjConfigPersistence)this.objCfgPersistence.get(enumeration.nextElement());
            if (!objConfigPersistence.suffix.equals(string)) continue;
            return objConfigPersistence.key;
        }
        return null;
    }

    public Media getMediaFromId(long l) {
        if (l < 0L) {
            return Media.LOCAL;
        }
        return Media.DBASE;
    }

    public Class getClassFromQueueId(long l) {
        Enumeration enumeration = this.objCfgPersistence.keys();
        Object var5_3 = null;
        long l2 = this.uniqueToTableId(l);
        if (l2 != 0L) {
            if (l2 < 10L && l2 > 0L) {
                l2 *= 100L;
            }
            int n = Math.abs((int)(l % l2));
            while (enumeration.hasMoreElements()) {
                ObjConfigPersistence objConfigPersistence = (ObjConfigPersistence)this.objCfgPersistence.get(enumeration.nextElement());
                if (objConfigPersistence.index != n) continue;
                return objConfigPersistence.key;
            }
        }
        return null;
    }

    public Class getClassFromId(long l) {
        Enumeration enumeration = this.objCfgPersistence.keys();
        Object var5_3 = null;
        long l2 = this.uniqueToTableId(l);
        if (l2 != 0L) {
            int n = Math.abs((int)(l % l2));
            while (enumeration.hasMoreElements()) {
                ObjConfigPersistence objConfigPersistence = (ObjConfigPersistence)this.objCfgPersistence.get(enumeration.nextElement());
                if (objConfigPersistence.index != n) continue;
                return objConfigPersistence.key;
            }
        }
        return null;
    }

    public long tableToUniqueId(long l, Class clazz) {
        if (l == 0L || l == -1L) {
            return 0L;
        }
        return l > 0L ? this.transformId(l, clazz) : -this.transformId(-l, clazz);
    }

    private long transformId(long l, Class clazz) {
        return 100L * l + (long)this.getObjCfgPersistence((Class)clazz).index;
    }

    public long uniqueToTableId(long l) {
        long l2 = l == 0L || l == -1L ? 0L : l / 100L;
        return l2;
    }

    public boolean isDebugMode() {
        return this.debugMode_;
    }

    public boolean isInOperationsMode() {
        return this.isOperationsModeId(this.userId_);
    }

    public boolean isInEngineeringMode() {
        return this.isEngineeringModeId(this.userId_);
    }

    public boolean isSuperUser() {
        return false;
    }

    public boolean isInVisitorMode() {
        return this.isVisitorModeId(this.userId_);
    }

    public boolean isInCloneMode() {
        return this.isCloneModeId();
    }

    public boolean isInStandardMode() {
        return this.isStandardModeId(this.userId_);
    }

    public abstract String[] folderColumnProperties(Class var1);

    public abstract String getDbUserName();

    public abstract String getDbPassword();

    public abstract String getUrl(String var1);

    public abstract String getDbName(String var1);

    public abstract boolean isOperationsModeId(int var1);

    public abstract boolean isEngineeringModeId(int var1);

    public abstract boolean isVisitorModeId(int var1);

    public abstract boolean isCloneModeId();

    public abstract boolean isStandardModeId(int var1);

    public abstract int getStartPeriodForIPVersioning();

    public abstract void askForAuthentication(Media var1) throws ObjectIOException;

    public abstract boolean isUserLevel(Class var1);

    public abstract void initPersistenceObjInfo();

    public int getMaxNameLength() {
        return 32;
    }

    public int getMaxTextLength() {
        return 240;
    }

    public String summaryDbaseTables(Class clazz) {
        return this.getObjCfgPersistence((Class)clazz).dbaseTables;
    }

    public String[] summaryDbaseColumns(Class clazz) {
        return this.getObjCfgPersistence((Class)clazz).dbaseColumns;
    }

    public boolean isVMOBCheckinAllowed(String string) {
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class ObjConfigPersistence {
        public Class key;
        public String dbaseTables;
        public String[] dbaseColumns;
        public String suffix;
        public int index;

        public ObjConfigPersistence(Class clazz, String[] stringArray, String string, String string2, int n) {
            this.key = clazz;
            this.dbaseTables = string;
            this.dbaseColumns = stringArray;
            this.suffix = string2;
            this.index = n;
        }
    }
}

