/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.phrs.common;

import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Vector;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eso.ohs.core.utilities.OHSConfig;
import org.eso.ohs.core.utilities.ObjectIOException;
import org.eso.ohs.core.utilities.RunCommand;
import org.eso.ohs.core.utilities.TextUtils;
import org.eso.ohs.dbase.phase1.DbaseHandlerObsRun;
import org.eso.ohs.dbase.phase1.WriterStmt;
import org.eso.ohs.dfs.Affiliation;
import org.eso.ohs.dfs.BusinessObject;
import org.eso.ohs.dfs.EsoUser;
import org.eso.ohs.dfs.ObsRun;
import org.eso.ohs.dfs.Phase1Target;
import org.eso.ohs.dfs.VltiTarget;
import org.eso.ohs.persistence.Config;
import org.eso.ohs.persistence.DBdataHelper;
import org.eso.ohs.phrs.common.ProposalType;
import org.eso.ohs.phrs.writer.CriticalTime;
import org.eso.ohs.phrs.writer.InstrumentConf;
import org.eso.ohs.phrs.writer.MovingTargetsRun;
import org.eso.ohs.phrs.writer.ProposalSummaryDBFields;
import org.eso.ohs.phrs.writer.RunsLink;
import org.eso.ohs.phrs.writer.SpecialReqRun;
import org.eso.ohs.phrs.writer.SplitRun;
import org.eso.ohs.phrs.writer.UnsuitableTime;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class XmlProposalSummaryReader {
    public static final String CYCLE_ID = "cycleid";
    public static final String EMPTY_ELEMENT_TEXT = "";
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$phrs$common$XmlProposalSummaryReader == null ? (class$org$eso$ohs$phrs$common$XmlProposalSummaryReader = XmlProposalSummaryReader.class$("org.eso.ohs.phrs.common.XmlProposalSummaryReader")) : class$org$eso$ohs$phrs$common$XmlProposalSummaryReader));
    private Element domNode_ = null;
    public static final String WHY_PHASE = "whyphase";
    public static final String WHY_NIGHTS = "whynights";
    private int gto_ = -1;
    private String cycleLabel_ = "";
    private int cycleId_ = -1;
    private int currentPeriod_ = -1;
    private String title_ = "";
    private String panel_;
    private String subpanel_;
    private String whyNights_;
    private String whyPhase_;
    private String abstractText_;
    private EsoUser currentPi_ = null;
    private int propTime_;
    static /* synthetic */ Class class$org$eso$ohs$phrs$common$XmlProposalSummaryReader;
    static /* synthetic */ Class class$org$eso$ohs$dfs$ObsRun;

    public XmlProposalSummaryReader(Document document) throws ObjectIOException {
        this.setRootElem(document);
        this.init();
    }

    public XmlProposalSummaryReader() throws ObjectIOException {
    }

    public void setRootElem(Document document) {
        this.domNode_ = document.getRootElement();
    }

    public void init() throws ObjectIOException {
        this.initAbstract();
        this.initCycleInfo();
        String string = this.domNode_.getChildText("currentperiod");
        String string2 = this.domNode_.getChildText("proprietarytime");
        if (string2 != null && string2.trim().length() > 0) {
            this.setPropTime(Integer.parseInt(string2.trim()));
        }
        this.currentPeriod_ = Integer.parseInt(string.trim());
        this.gto_ = this.extractGto();
        this.panel_ = this.getChildElementText("category").substring(0, 1);
        this.subpanel_ = this.getChildElementText("category").substring(1, 2);
        this.initTitle();
        this.whyNights_ = this.getChildElementText(WHY_NIGHTS);
        this.whyPhase_ = this.getChildElementText(WHY_PHASE);
    }

    public void initAbstract() {
        this.abstractText_ = this.domNode_.getChildText("abstract").trim();
    }

    public void initTitle() {
        this.title_ = this.domNode_.getChildText("title").trim();
    }

    public void initCycleInfo() throws ObjectIOException {
        this.cycleLabel_ = this.domNode_.getChildText("cycle").trim();
        String string = this.domNode_.getChildText(CYCLE_ID);
        this.cycleId_ = Integer.parseInt(string.trim());
    }

    private int getChildInt(String string, String string2) throws ObjectIOException {
        Element element = this.domNode_.getChild(string);
        String string3 = EMPTY_ELEMENT_TEXT;
        int n = 0;
        if (element != null && (string3 = element.getAttributeValue(string2)) == null && (string3 = element.getChildText(string2)) == null) {
            string3 = EMPTY_ELEMENT_TEXT;
        }
        try {
            n = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            throw new ObjectIOException("invalid integer value: '" + string3 + "'. Element: " + string + " child:" + string2);
        }
        return n;
    }

    private String getChildText(String string, String string2) {
        Element element = this.domNode_.getChild(string);
        String string3 = EMPTY_ELEMENT_TEXT;
        if (element != null && (string3 = element.getAttributeValue(string2)) == null && (string3 = element.getChildText(string2)) == null) {
            string3 = EMPTY_ELEMENT_TEXT;
        }
        return string3;
    }

    private int getChildElementInt(String string) throws ObjectIOException {
        int n = 0;
        String string2 = null;
        try {
            string2 = this.getTextValue(this.domNode_, string);
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            throw new ObjectIOException("invalid integer value: '" + string2 + "' for tag " + string);
        }
        return n;
    }

    private int extractGto() {
        int n = -1;
        String string = this.getChildElementText("programme");
        stdlog_.debug((Object)("Proposal Type is: " + string));
        if (string.equals("large")) {
            n = ProposalType.LARGE_INT;
        } else {
            String string2 = this.getChildElementText("obstype");
            n = string2.equals("gto") ? ProposalType.GTO_INT : (string2.equals("ddt") ? ProposalType.DDT_INT : (string2.equals("too") ? ProposalType.TOO_INT.intValue() : ProposalType.NORMAL_INT.intValue()));
            stdlog_.debug((Object)("GTO string is: " + string2));
        }
        stdlog_.debug((Object)("GTO flag is: " + n));
        return n;
    }

    public int getGto() {
        return this.gto_;
    }

    public String getCycleLabel() {
        return this.cycleLabel_;
    }

    public int getCycleId() {
        return this.cycleId_;
    }

    public int getCurrentPeriod() {
        return this.currentPeriod_;
    }

    public String getTitle() {
        return this.title_;
    }

    public String getPanel() {
        return this.panel_;
    }

    public String getSubpanel() {
        return this.subpanel_;
    }

    public String getWhyNights() {
        return this.whyNights_;
    }

    public String getWhyPhase() {
        return this.whyPhase_;
    }

    public String getAbstractText() {
        return this.abstractText_;
    }

    public EsoUser[] getPiCoi() throws ObjectIOException {
        EsoUser[] esoUserArray;
        Element element = this.domNode_.getChild("pi");
        List list = this.domNode_.getChildren("coi");
        Vector<Object> vector = new Vector<Object>();
        EsoUser esoUser = new EsoUser();
        Affiliation affiliation = new Affiliation();
        affiliation.setCycleLabel(this.getCycleLabel());
        affiliation.setCycleId(this.getCycleId());
        affiliation.setPeriod(this.getCurrentPeriod());
        this.setBOStringMandatoryProperty(affiliation, "institution", element, "institute");
        this.setBOStringMandatoryProperty(affiliation, "countryCode", element, "country");
        esoUser.setAffiliation(affiliation);
        this.setBOStringMandatoryProperty(esoUser, "itemName", element, "initial");
        this.setBOStringMandatoryProperty(esoUser, "surname", element, "name");
        String string = this.filterLatexSurname(esoUser.getSurname());
        esoUser.setSurnameDL(string);
        this.setBOStringMandatoryProperty(esoUser, "email", element, "email");
        vector.addElement(esoUser);
        this.currentPi_ = esoUser;
        int n = 0;
        while (n < list.size()) {
            esoUserArray = new EsoUser();
            affiliation = new Affiliation();
            affiliation.setCycleLabel(this.getCycleLabel());
            affiliation.setCycleId(this.getCycleId());
            affiliation.setPeriod(this.getCurrentPeriod());
            this.setBOStringMandatoryProperty(affiliation, "institution", (Element)list.get(n), "institute");
            this.setBOStringMandatoryProperty(affiliation, "countryCode", (Element)list.get(n), "country");
            esoUserArray.setAffiliation(affiliation);
            this.setBOStringMandatoryProperty((BusinessObject)esoUserArray, "itemName", (Element)list.get(n), "initial");
            this.setBOStringMandatoryProperty((BusinessObject)esoUserArray, "surname", (Element)list.get(n), "name");
            this.setBOStringMandatoryProperty((BusinessObject)esoUserArray, "surnameDL", (Element)list.get(n), "name");
            vector.addElement(esoUserArray);
            ++n;
        }
        esoUserArray = vector.toArray(new EsoUser[vector.size()]);
        return esoUserArray;
    }

    public String getPi() throws ObjectIOException {
        if (this.currentPi_ == null) {
            this.getPiCoi();
        }
        String string = this.currentPi_.getItemName() + " " + this.currentPi_.getSurname();
        return string;
    }

    private String filterLatexSurname(String string) {
        String string2 = string;
        try {
            OHSConfig oHSConfig = OHSConfig.getInstance();
            String string3 = oHSConfig.getValue("phrs.writer.detex.cmd");
            String string4 = StringUtils.replace((String)string3, (String)"%surname%", (String)string);
            String[] stringArray = TextUtils.stringToStringArray(string4, ",", true);
            RunCommand runCommand = new RunCommand(stringArray);
            runCommand.executeCmd();
            string2 = runCommand.getOutput();
            String string5 = oHSConfig.getValue("phrs.writer.detex.removePattern");
            if (!string5.equals(EMPTY_ELEMENT_TEXT)) {
                string2 = XmlProposalSummaryReader.removeChars(string2, string5);
            }
        }
        catch (Exception exception) {
            stdlog_.error((Object)("Error in filtering latex: " + exception.getMessage()), (Throwable)exception);
            string2 = string;
        }
        return string2;
    }

    public static String removeChars(String string, String string2) {
        stdlog_.debug((Object)("Starting string: " + string));
        String string3 = string.replaceAll(string2, EMPTY_ELEMENT_TEXT);
        stdlog_.debug((Object)("Result   string: " + string3));
        return string3;
    }

    public Phase1Target[] getTargetList(long l) throws ObjectIOException {
        List list = this.domNode_.getChildren("target");
        Phase1Target[] phase1TargetArray = new Phase1Target[list.size()];
        int n = 0;
        while (n < list.size()) {
            Element element = (Element)list.get(n);
            Phase1Target phase1Target = new Phase1Target();
            phase1Target.setTargetId(n);
            phase1Target.setProgId(l);
            this.setBOStringMandatoryProperty(phase1Target, "runReferences", element, "runid");
            this.setBOStringMandatoryProperty(phase1Target, "itemName", element, "name");
            this.setBOLongMandatoryProperty(phase1Target, "ra", element, "ra");
            this.setBOLongMandatoryProperty(phase1Target, "declination", element, "dec");
            this.setBONumericOptionalProperty(phase1Target, "equinox", element, "equinox");
            this.setBONumericOptionalProperty(phase1Target, "timeOnTarget", element, "timetarget");
            this.setBOStringOptionalProperty(phase1Target, "magnitude", element, "magnitude");
            this.setBOStringOptionalProperty(phase1Target, "diameter", element, "diameter");
            this.setBOStringOptionalProperty(phase1Target, "userComment", element, "addinfo");
            this.setBOStringOptionalProperty(phase1Target, "referenceStar", element, "nacoid");
            phase1TargetArray[n] = phase1Target;
            ++n;
        }
        return phase1TargetArray;
    }

    public VltiTarget[] getVltiTargetList(Phase1Target[] phase1TargetArray, ObsRun[] obsRunArray, long l) throws ObjectIOException {
        List list = this.domNode_.getChildren("vltitarget");
        VltiTarget[] vltiTargetArray = new VltiTarget[list.size()];
        int n = 0;
        while (n < list.size()) {
            Element element = (Element)list.get(n);
            VltiTarget vltiTarget = new VltiTarget();
            vltiTarget.setProgrammeId(l);
            int n2 = this.getIdFromTargets(phase1TargetArray, XmlProposalSummaryReader.getChildElementNonEmptyText(element, "name"), XmlProposalSummaryReader.getChildElementNonEmptyText(element, "runid"));
            vltiTarget.setTargetId(n2);
            this.setBOStringOptionalProperty(vltiTarget, "magVisual", element, "vmag");
            this.setBOStringOptionalProperty(vltiTarget, "magWave", element, "maglambda");
            this.setBOStringMandatoryProperty(vltiTarget, "obsWave", element, "lambdaobs");
            this.setBOStringOptionalProperty(vltiTarget, "sizeWave", element, "size");
            this.setBOStringMandatoryProperty(vltiTarget, "baseline", element, "baseline");
            this.setBOStringOptionalProperty(vltiTarget, "visibility", element, "vis");
            long l2 = this.getRunIdFromRuns(obsRunArray, XmlProposalSummaryReader.getChildElementNonEmptyText(element, "runid"));
            vltiTarget.setRunId(l2);
            this.setBOStringOptionalProperty(vltiTarget, "timeTarget", element, "timeontarget");
            this.setBOStringOptionalProperty(vltiTarget, "mag", element, "magc");
            vltiTargetArray[n] = vltiTarget;
            ++n;
        }
        return vltiTargetArray;
    }

    private long getRunIdFromRuns(ObsRun[] obsRunArray, String string) {
        long l = -1L;
        int n = 0;
        while (n < obsRunArray.length) {
            if (obsRunArray[n].getRunDesc().equals(string)) {
                l = obsRunArray[n].getTableId();
                break;
            }
            ++n;
        }
        return l;
    }

    private int getIdFromTargets(Phase1Target[] phase1TargetArray, String string, String string2) {
        int n = -1;
        int n2 = 0;
        while (n2 < phase1TargetArray.length) {
            if (phase1TargetArray[n2].getItemName().equals(string) && phase1TargetArray[n2].getRunReferences().equals(string2)) {
                n = phase1TargetArray[n2].getTargetId();
                break;
            }
            ++n2;
        }
        return n;
    }

    public SplitRun[] getSplitList(long l) throws ObjectIOException {
        List list = this.domNode_.getChildren("split");
        SplitRun[] splitRunArray = new SplitRun[list.size()];
        int n = 0;
        while (n < splitRunArray.length) {
            Element element = (Element)list.get(n);
            SplitRun splitRun = new SplitRun();
            splitRun.setProgId(l);
            this.setBOStringMandatoryProperty(splitRun, "runDesc", element, "runid");
            this.setBOStringMandatoryProperty(splitRun, "text", element, "formula");
            splitRunArray[n] = splitRun;
            ++n;
        }
        return splitRunArray;
    }

    public CriticalTime[] getCriticalTimeList(long l) throws ObjectIOException {
        List list = this.domNode_.getChildren("criticaltime");
        CriticalTime[] criticalTimeArray = new CriticalTime[list.size()];
        int n = 0;
        while (n < criticalTimeArray.length) {
            Element element = (Element)list.get(n);
            CriticalTime criticalTime = new CriticalTime();
            criticalTime.setProgId(l);
            this.setBOStringMandatoryProperty(criticalTime, "runDesc", element, "runid");
            this.setBOLongMandatoryProperty(criticalTime, "fromDate", element, "fromdate");
            this.setBOLongMandatoryProperty(criticalTime, "toDate", element, "todate");
            this.setBOStringOptionalProperty(criticalTime, "comments", element, "comment");
            criticalTime.setTcIndex(n);
            criticalTimeArray[n] = criticalTime;
            ++n;
        }
        return criticalTimeArray;
    }

    public UnsuitableTime[] getUnsuitableTimeList(long l) throws ObjectIOException {
        List list = this.domNode_.getChildren("unsuitabletime");
        UnsuitableTime[] unsuitableTimeArray = new UnsuitableTime[list.size()];
        int n = 0;
        while (n < unsuitableTimeArray.length) {
            Element element = (Element)list.get(n);
            UnsuitableTime unsuitableTime = new UnsuitableTime();
            unsuitableTime.setProgId(l);
            this.setBOStringMandatoryProperty(unsuitableTime, "runDesc", element, "runid");
            this.setBOLongMandatoryProperty(unsuitableTime, "fromDate", element, "fromdate");
            this.setBOLongMandatoryProperty(unsuitableTime, "toDate", element, "todate");
            this.setBOStringOptionalProperty(unsuitableTime, "comments", element, "comment");
            unsuitableTime.setTcIndex(n);
            unsuitableTimeArray[n] = unsuitableTime;
            ++n;
        }
        return unsuitableTimeArray;
    }

    public RunsLink[] getRunsLinkList(long l) throws ObjectIOException {
        List list = this.domNode_.getChildren("link");
        RunsLink[] runsLinkArray = new RunsLink[list.size()];
        int n = 0;
        while (n < runsLinkArray.length) {
            Element element = (Element)list.get(n);
            RunsLink runsLink = new RunsLink();
            runsLink.setProgId(l);
            this.setBOStringMandatoryProperty(runsLink, "firstRunDesc", element, "firstrun");
            this.setBOStringMandatoryProperty(runsLink, "flag", element, "timetag");
            this.setBOStringMandatoryProperty(runsLink, "secondRunDesc", element, "secondrun");
            this.setBOStringMandatoryProperty(runsLink, "delay", element, "days");
            runsLinkArray[n] = runsLink;
            ++n;
        }
        return runsLinkArray;
    }

    public InstrumentConf[] getInstConfigList(long l) throws ObjectIOException {
        List list = this.domNode_.getChildren("insconf");
        InstrumentConf[] instrumentConfArray = new InstrumentConf[list.size()];
        int n = 0;
        while (n < list.size()) {
            Element element = (Element)list.get(n);
            InstrumentConf instrumentConf = new InstrumentConf();
            instrumentConf.setProgId(l);
            this.setBOStringMandatoryProperty(instrumentConf, "runDesc", element, "runid");
            this.setBOStringMandatoryProperty(instrumentConf, "instrument", element, "instrument");
            this.setBOStringOptionalProperty(instrumentConf, "filterName", element, "mode");
            this.setBOStringOptionalProperty(instrumentConf, "filterValue", element, "filter");
            instrumentConfArray[n] = instrumentConf;
            ++n;
        }
        return instrumentConfArray;
    }

    public MovingTargetsRun[] getMovTargetList(long l) throws ObjectIOException {
        MovingTargetsRun[] movingTargetsRunArray;
        List list = this.domNode_.getChildren("movingtargets");
        Vector<MovingTargetsRun> vector = new Vector<MovingTargetsRun>();
        int n = 0;
        while (n < list.size()) {
            movingTargetsRunArray = (MovingTargetsRun[])list.get(n);
            MovingTargetsRun movingTargetsRun = new MovingTargetsRun();
            movingTargetsRun.setProgId(l);
            boolean bl = false;
            try {
                this.setBOStringMandatoryProperty(movingTargetsRun, "runDesc", (Element)movingTargetsRunArray, "runid");
            }
            catch (ObjectIOException objectIOException) {
                stdlog_.warn((Object)"run desc  not found ", (Throwable)objectIOException);
                bl = true;
            }
            if (!bl) {
                this.setBOStringMandatoryProperty(movingTargetsRun, "text", (Element)movingTargetsRunArray, "requirement");
                vector.addElement(movingTargetsRun);
            }
            ++n;
        }
        movingTargetsRunArray = vector.toArray(new MovingTargetsRun[vector.size()]);
        return movingTargetsRunArray;
    }

    public SpecialReqRun[] getSpecialReqList(long l) throws ObjectIOException {
        SpecialReqRun[] specialReqRunArray;
        List list = this.domNode_.getChildren("specialrequirements");
        Vector<SpecialReqRun> vector = new Vector<SpecialReqRun>();
        int n = 0;
        while (n < list.size()) {
            specialReqRunArray = (SpecialReqRun[])list.get(n);
            SpecialReqRun specialReqRun = new SpecialReqRun();
            specialReqRun.setProgId(l);
            boolean bl = false;
            try {
                this.setBOStringMandatoryProperty(specialReqRun, "runDesc", (Element)specialReqRunArray, "runid");
            }
            catch (ObjectIOException objectIOException) {
                stdlog_.warn((Object)"run desc  not found ", (Throwable)objectIOException);
                bl = true;
            }
            if (!bl) {
                this.setBOStringOptionalProperty(specialReqRun, "text", (Element)specialReqRunArray, "requirement");
                vector.addElement(specialReqRun);
            }
            ++n;
        }
        specialReqRunArray = vector.toArray(new SpecialReqRun[vector.size()]);
        return specialReqRunArray;
    }

    public void updateFigures(ProposalSummaryDBFields proposalSummaryDBFields, Statement statement) throws SQLException, ObjectIOException {
        List list = this.domNode_.getChildren("picture");
        int n = 0;
        while (n < list.size()) {
            int n2;
            Element element = (Element)list.get(n);
            String string = element.getText().trim();
            if (string.length() > 0 && (n2 = DBdataHelper.getInstance().readIntValue(WriterStmt.countPicture(proposalSummaryDBFields.getProposalId(), string), statement)) == 0) {
                DBdataHelper.getInstance().execUpdate(WriterStmt.insertRowPicture(proposalSummaryDBFields.getProposalId(), string), statement);
            }
            ++n;
        }
    }

    public ObsRun[] getRunList(long l, String string) throws SQLException, ObjectIOException {
        List list = this.domNode_.getChildren("observingrun");
        ObsRun[] obsRunArray = new ObsRun[list.size()];
        int n = 0;
        while (n < list.size()) {
            Element element = (Element)list.get(n);
            ObsRun obsRun = new ObsRun();
            obsRun.setProgrammeId(l);
            String string2 = this.getRunDesc(element);
            obsRun.setTableId(DbaseHandlerObsRun.buildRunId(l, string2));
            obsRun.setRunDesc(string2);
            obsRun.setRunCode(string + "(" + string2 + ")");
            obsRun.setId(Config.getCfg().tableToUniqueId(obsRun.getTableId(), class$org$eso$ohs$dfs$ObsRun == null ? XmlProposalSummaryReader.class$("org.eso.ohs.dfs.ObsRun") : class$org$eso$ohs$dfs$ObsRun));
            this.setBOStringOptionalProperty(obsRun, "telescope", element, "telescope");
            this.setBONumericOptionalProperty(obsRun, "period", element, "period");
            this.setBOStringMandatoryProperty(obsRun, "instrument", element, "instrument");
            this.setBOStringMandatoryProperty(obsRun, "reqTime", element, "time");
            String string3 = this.getTextValue(element, "assignedtime");
            if (!string3.equals(EMPTY_ELEMENT_TEXT)) {
                obsRun.setAssignedTime(Float.parseFloat(string3) / 10.0f);
            }
            this.setBOStringMandatoryProperty(obsRun, "month", element, "month");
            this.setBOStringMandatoryProperty(obsRun, "moon", element, "moon");
            this.setBOStringMandatoryProperty(obsRun, "seeing", element, "seeing");
            this.setBOStringMandatoryProperty(obsRun, "skyTransparency", element, "transp");
            this.setBOStringMandatoryProperty(obsRun, "obsMode", element, "mode");
            obsRun.setScheduled("N");
            obsRunArray[n] = obsRun;
            ++n;
        }
        return obsRunArray;
    }

    public String getInstruments(long l, String string) throws SQLException, ObjectIOException {
        ObsRun[] obsRunArray = this.getRunList(l, string);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < obsRunArray.length) {
            String string2 = obsRunArray[n].getInstrument();
            stringBuffer.append(string2).append(" ");
            ++n;
        }
        return stringBuffer.toString();
    }

    private void setBOStringMandatoryProperty(BusinessObject businessObject, String string, Element element, String string2) throws ObjectIOException {
        String string3 = this.getTextValue(element, string2);
        if (string3.equals(EMPTY_ELEMENT_TEXT)) {
            throw new ObjectIOException(element.getValue() + " \nThe element <" + string2 + "> doesn't contain data");
        }
        this.assignProperty(businessObject, string, string2, string3);
    }

    private void setBOStringOptionalProperty(BusinessObject businessObject, String string, Element element, String string2) throws ObjectIOException {
        String string3 = this.getTextValue(element, string2);
        this.assignProperty(businessObject, string, string2, string3);
    }

    private void setBOIntMandatoryProperty(BusinessObject businessObject, String string, Element element, String string2) throws ObjectIOException {
        String string3 = this.getTextValue(element, string2);
        if (string3.equals(EMPTY_ELEMENT_TEXT)) {
            throw new ObjectIOException(element.getValue() + " \nThe element <" + string2 + "> doesn't contain data");
        }
        Integer n = Integer.decode(string3.trim());
        this.assignProperty(businessObject, string, string2, n);
    }

    private void setBOLongMandatoryProperty(BusinessObject businessObject, String string, Element element, String string2) throws ObjectIOException {
        String string3 = this.getTextValue(element, string2);
        if (string3.equals(EMPTY_ELEMENT_TEXT)) {
            throw new ObjectIOException(element.getValue() + " \nThe element <" + string2 + "> doesn't contain data");
        }
        Long l = Long.decode(string3.trim());
        this.assignProperty(businessObject, string, string2, l);
    }

    private void setBODoubleMandatoryProperty(BusinessObject businessObject, String string, Element element, String string2) throws ObjectIOException {
        String string3 = this.getTextValue(element, string2);
        if (string3.equals(EMPTY_ELEMENT_TEXT)) {
            throw new ObjectIOException(element.getValue() + " \nThe element <" + string2 + "> doesn't contain data");
        }
        Double d = Double.valueOf(string3.trim());
        this.assignProperty(businessObject, string, string2, d);
    }

    private void setBONumericOptionalProperty(BusinessObject businessObject, String string, Element element, String string2) throws ObjectIOException {
        String string3 = this.getTextValue(element, string2);
        if (!string3.equals(EMPTY_ELEMENT_TEXT)) {
            this.assignProperty(businessObject, string, string2, string3.trim());
        }
    }

    private String getTextValue(Element element, String string) {
        Element element2 = null;
        try {
            element2 = element.getChild(string);
        }
        catch (Exception exception) {
            stdlog_.error((Object)("No child " + string), (Throwable)exception);
        }
        String string2 = null;
        if (element2 != null) {
            string2 = element2.getText();
        }
        if (string2 == null) {
            string2 = EMPTY_ELEMENT_TEXT;
        }
        return string2.trim();
    }

    public boolean isOpticon() {
        boolean bl = false;
        Element element = this.domNode_.getChild("opticon");
        if (element != null) {
            bl = true;
        }
        return bl;
    }

    public boolean isXmm() {
        boolean bl = false;
        Element element = this.domNode_.getChild("xmm");
        if (element != null) {
            bl = true;
        }
        return bl;
    }

    public boolean isRrm() {
        boolean bl = false;
        Element element = this.domNode_.getChild("rrm");
        if (element != null) {
            bl = true;
        }
        return bl;
    }

    private String getRunDesc(Element element) throws ObjectIOException {
        String string = element.getChildText("id").trim();
        if (string.length() != 1) {
            throw new ObjectIOException("run description must be set properly: <" + string + ">");
        }
        return string;
    }

    private void assignProperty(BusinessObject businessObject, String string, String string2, Object object) throws ObjectIOException {
        try {
            if (!PropertyUtils.isWriteable((Object)businessObject, (String)string)) {
                throw new ObjectIOException("Not writable property: " + string);
            }
            BeanUtils.setProperty((Object)businessObject, (String)string, (Object)object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ObjectIOException("Illegal Access property : " + string);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ObjectIOException("Illegal Invocation property : " + string);
        }
    }

    public String getChildElementText(String string) {
        String string2 = this.domNode_.getChildText(string);
        if (string2 == null) {
            string2 = EMPTY_ELEMENT_TEXT;
        }
        return string2.trim();
    }

    public String getChildElementAttrText(String string, String string2) {
        Element element = this.domNode_.getChild(string);
        String string3 = null;
        if (element != null && (string3 = element.getAttributeValue(string2)) == null) {
            string2 = EMPTY_ELEMENT_TEXT;
        }
        return string3.trim();
    }

    public static String getChildElementNonEmptyText(Element element, String string) throws ObjectIOException {
        String string2 = element.getChildText(string);
        if (string2 == null || string2.equals(EMPTY_ELEMENT_TEXT)) {
            List list = element.getChildren();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Current node: <").append(element.getName()).append("> ").append(" \nThe child element <").append(string).append("> doesn't contain data\n-------\n");
            stringBuffer.append(list.size() + " children nodes:\n");
            int n = 0;
            while (n < list.size()) {
                Element element2 = (Element)list.get(n);
                stringBuffer.append("<").append(element2.getName()).append(">");
                stringBuffer.append(element2.getText());
                stringBuffer.append("</").append(element2.getName()).append(">\n");
                ++n;
            }
            throw new ObjectIOException(stringBuffer.toString());
        }
        return string2.trim();
    }

    public static String getAttrNonEmptyText(Element element, String string) throws ObjectIOException {
        String string2 = element.getAttributeValue(string);
        if (string2 == null || string2.equals(EMPTY_ELEMENT_TEXT)) {
            List list = element.getAttributes();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Current node: <").append(element.getName()).append("> ").append(" \nThe attr  '").append(string).append("' doesn't contain data\n-------\n");
            stringBuffer.append(list.size() + " attributes:\n");
            int n = 0;
            while (n < list.size()) {
                Attribute attribute = (Attribute)list.get(n);
                stringBuffer.append("'").append(attribute.getName()).append("'=\"");
                stringBuffer.append(attribute.getValue());
                stringBuffer.append("\"");
                ++n;
            }
            throw new ObjectIOException(stringBuffer.toString());
        }
        return string2.trim();
    }

    public String toString() {
        XMLOutputter xMLOutputter = new XMLOutputter();
        return xMLOutputter.outputString(this.domNode_);
    }

    public void setPropTime(int n) {
        this.propTime_ = n;
    }

    public int getPropTime() {
        return this.propTime_;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

