/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.phrs.writer;

import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import org.eso.ohs.apps.OHSApplication;
import org.eso.ohs.core.dbb.client.StarcatDate;
import org.eso.ohs.core.utilities.ConnectionPool;
import org.eso.ohs.core.utilities.FileIOUtils;
import org.eso.ohs.core.utilities.Logger;
import org.eso.ohs.core.utilities.OHSConfig;
import org.eso.ohs.core.utilities.ObjectIOException;
import org.eso.ohs.core.utilities.RandomStringGenerator;
import org.eso.ohs.core.utilities.TextUtils;
import org.eso.ohs.core.utilities.javamail.MailManagement;
import org.eso.ohs.core.utilities.rmi.OHSServer;
import org.eso.ohs.dbase.phase1.DbaseHandlerCycle;
import org.eso.ohs.dbase.phase1.DbaseHandlerEsoUser;
import org.eso.ohs.dbase.phase1.DbaseHandlerObsRun;
import org.eso.ohs.dbase.phase1.DbaseHandlerPhase1Target;
import org.eso.ohs.dbase.phase1.DbaseHandlerVltiTarget;
import org.eso.ohs.dbase.phase1.Phase1SelectStmt;
import org.eso.ohs.dbase.phase1.WriterStmt;
import org.eso.ohs.dfs.Cycle;
import org.eso.ohs.dfs.EsoUser;
import org.eso.ohs.dfs.ObsRun;
import org.eso.ohs.dfs.Phase1Target;
import org.eso.ohs.dfs.VltiTarget;
import org.eso.ohs.persistence.Config;
import org.eso.ohs.persistence.DBdataHelper;
import org.eso.ohs.persistence.ObjectNotFoundException;
import org.eso.ohs.persistence.StorageManager;
import org.eso.ohs.phrs.common.OpticonType;
import org.eso.ohs.phrs.common.PhrsPersistCfg;
import org.eso.ohs.phrs.common.RrmType;
import org.eso.ohs.phrs.common.XmlProposalSummaryReader;
import org.eso.ohs.phrs.common.XmmType;
import org.eso.ohs.phrs.writer.CriticalTime;
import org.eso.ohs.phrs.writer.FigureInfo;
import org.eso.ohs.phrs.writer.InstrumentConf;
import org.eso.ohs.phrs.writer.MovingTargetsRun;
import org.eso.ohs.phrs.writer.ProposalSummaryDBFields;
import org.eso.ohs.phrs.writer.RunSchedReq;
import org.eso.ohs.phrs.writer.RunTimingConstraints;
import org.eso.ohs.phrs.writer.RunsLink;
import org.eso.ohs.phrs.writer.SpecialReqRun;
import org.eso.ohs.phrs.writer.SplitRun;
import org.eso.ohs.phrs.writer.UnsuitableTime;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;

public class PhrsWriter
extends OHSServer {
    public static final String WHY_PHASE = "whyphase";
    public static final String WHY_NIGHTS = "whynights";
    private static final String WRITER_CONFIG_FILE = "config/writer.cf";
    private String tmpPath_ = OHSConfig.getInstance().getValue("phrs.writer.workdir");
    private String currentProposalInProcess_ = "";
    private int gto;
    private static org.apache.log4j.Logger stdlog_ = org.apache.log4j.Logger.getLogger((Class)(class$org$eso$ohs$phrs$writer$PhrsWriter == null ? (class$org$eso$ohs$phrs$writer$PhrsWriter = PhrsWriter.class$("org.eso.ohs.phrs.writer.PhrsWriter")) : class$org$eso$ohs$phrs$writer$PhrsWriter));
    static /* synthetic */ Class class$org$eso$ohs$phrs$writer$PhrsWriter;

    public static void main(String[] stringArray) {
        OHSApplication oHSApplication = OHSApplication.getApplication();
        oHSApplication.init("writer", "writer", " writer ");
        PhrsWriter phrsWriter = null;
        PhrsWriter.initConfig();
        int n = OHSConfig.getInstance().getInteger("phrs.writer.port");
        try {
            phrsWriter = new PhrsWriter("writer", n, null);
        }
        catch (Exception exception) {
            PhrsWriter.sendWarningMail(exception.getMessage(), "Error Starting writer");
            exception.printStackTrace();
            stdlog_.error((Object)"", (Throwable)exception);
        }
        try {
            phrsWriter.startLoop();
        }
        catch (ObjectIOException objectIOException) {
            stdlog_.error((Object)"", (Throwable)objectIOException);
        }
    }

    public PhrsWriter(String string, int n, Logger logger) throws IOException, AlreadyBoundException, NotBoundException {
        super(string, n, logger);
    }

    private void startLoop() throws ObjectIOException {
        block8: while (true) {
            this.sleep();
            this.checkFile();
            ProposalSummaryDBFields[] proposalSummaryDBFieldsArray = new ProposalSummaryDBFields[]{};
            try {
                proposalSummaryDBFieldsArray = this.loadProposalList();
            }
            catch (Exception exception) {
                this.waitDbRestart(exception.getMessage());
                stdlog_.error((Object)"", (Throwable)exception);
            }
            int n = 0;
            while (n < proposalSummaryDBFieldsArray.length) {
                try {
                    this.log(1, "insert proposal in the database...", proposalSummaryDBFieldsArray[n].getMessageId());
                    this.processProposalSummary(proposalSummaryDBFieldsArray[n]);
                    this.log(1, "proposal inserted in the database.", proposalSummaryDBFieldsArray[n].getMessageId());
                }
                catch (Exception exception) {
                    String string = "Writer: Proposal :" + proposalSummaryDBFieldsArray[n].getProposalCode() + " Id :" + proposalSummaryDBFieldsArray[n].getMessageId() + " not inserted";
                    stdlog_.error((Object)string, (Throwable)exception);
                    PhrsWriter.sendWarningMail(exception.getMessage(), string);
                }
                ++n;
            }
            FigureInfo[] figureInfoArray = new FigureInfo[]{};
            try {
                figureInfoArray = this.getFigureList();
            }
            catch (Exception exception) {
                this.waitDbRestart(exception.getMessage());
                stdlog_.error((Object)"", (Throwable)exception);
            }
            int n2 = 0;
            while (true) {
                if (n2 >= figureInfoArray.length) continue block8;
                try {
                    this.insertFigureList(figureInfoArray[n2]);
                }
                catch (Exception exception) {
                    String string = "Writer: Figure " + figureInfoArray[n2].getProposalId() + " Name: " + figureInfoArray[n2].getName() + " not inserted";
                    stdlog_.error((Object)string, (Throwable)exception);
                    PhrsWriter.sendWarningMail(exception.getMessage(), string);
                }
                ++n2;
            }
            break;
        }
    }

    private void checkFile() {
        String string = OHSConfig.getInstance().getValue("phrs.writer.startFile");
        File file = new File(string);
        if (!file.exists()) {
            stdlog_.warn((Object)("The file " + file.getAbsolutePath() + " not found. EXIT!!!"));
            System.exit(0);
        }
    }

    private FigureInfo[] getFigureList() throws ObjectIOException {
        ResultSet resultSet = null;
        Vector<FigureInfo> vector = new Vector<FigureInfo>();
        FigureInfo[] figureInfoArray = new FigureInfo[]{};
        Connection connection = null;
        Statement statement = null;
        try {
            try {
                connection = this.getDBdataHelper().acquireConnection();
                connection.setAutoCommit(false);
                stdlog_.debug((Object)"BEGIN TRANSACTION");
                statement = connection.createStatement();
                String string = WriterStmt.selFigureList();
                stdlog_.info((Object)string);
                resultSet = statement.executeQuery(string);
                while (resultSet.next()) {
                    stdlog_.info((Object)"New figure ");
                    FigureInfo figureInfo = new FigureInfo();
                    figureInfo.setId(resultSet.getLong(1));
                    stdlog_.info((Object)("Message Id: " + figureInfo.getId()));
                    figureInfo.setProposalId(resultSet.getLong(2));
                    figureInfo.setName(resultSet.getString(3));
                    vector.addElement(figureInfo);
                    long l = figureInfo.getId();
                }
                resultSet.close();
                int n = 0;
                while (n < vector.size()) {
                    FigureInfo figureInfo = (FigureInfo)vector.get(n);
                    String string2 = WriterStmt.updateStatusFigure(2, figureInfo.getId(), figureInfo.getName());
                    this.getDBdataHelper().execUpdate(string2, statement);
                    ++n;
                }
                stdlog_.debug((Object)"COMMIT");
                connection.commit();
            }
            catch (SQLException sQLException) {
                stdlog_.error((Object)"Sql error: ", (Throwable)sQLException);
                this.getDBdataHelper().rollbackConnection(connection);
                throw new ObjectIOException(sQLException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                stdlog_.error((Object)"IllegalArgumentException error Sql  ", (Throwable)illegalArgumentException);
                this.getDBdataHelper().rollbackConnection(connection);
                throw new ObjectIOException(illegalArgumentException);
            }
            catch (ObjectIOException objectIOException) {
                this.getDBdataHelper().rollbackConnection(connection);
                throw objectIOException;
            }
            Object var11_15 = null;
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            this.getDBdataHelper().setAutoCommitAndFreeConnection(connection, statement);
            throw throwable;
        }
        this.getDBdataHelper().setAutoCommitAndFreeConnection(connection, statement);
        figureInfoArray = vector.toArray(new FigureInfo[vector.size()]);
        return figureInfoArray;
    }

    private void insertFigureList(FigureInfo figureInfo) throws ObjectIOException {
        boolean bl = false;
        Connection connection = null;
        Statement statement = null;
        try {
            try {
                String string = Phase1SelectStmt.getFigureBinaryInCache(figureInfo.getId(), figureInfo.getName());
                File file = new File(this.tmpPath_ + File.separator + figureInfo.getName() + ".zip");
                file = this.getDBdataHelper().getFile(file, string);
                connection = this.getDBdataHelper().acquireConnection();
                connection.setAutoCommit(false);
                stdlog_.debug((Object)"BEGIN TRANSACTION");
                statement = connection.createStatement();
                this.getDBdataHelper().execUpdate(Phase1SelectStmt.updateReceivedFiguresFlag(figureInfo.getProposalId(), figureInfo.getName()), statement);
                String string2 = Phase1SelectStmt.countReceivedFigures(figureInfo.getProposalId(), figureInfo.getName());
                int n = this.getDBdataHelper().readIntValue(string2, statement);
                if (n != 1) {
                    String[] stringArray = this.getDBdataHelper().readStringArray(Phase1SelectStmt.selFigures(figureInfo.getProposalId()), statement);
                    String string3 = "There must be only one Figure row\n********* \n" + string2 + "\n******\n the figure list is:\"" + TextUtils.arrayToString(stringArray, "\"", false) + "\"";
                    throw new ObjectIOException(string3);
                }
                String string4 = WriterStmt.insertFigureSource(figureInfo.getProposalId(), figureInfo.getName());
                DBdataHelper.getInstance().insertBinaryFile(file, string4, connection);
                statement = connection.createStatement();
                String string5 = WriterStmt.updateStatusFigure(3, figureInfo.getId(), figureInfo.getName());
                this.getDBdataHelper().execUpdate(string5, statement);
                statement = null;
                connection.commit();
                stdlog_.debug((Object)"COMMIT");
                if (OHSConfig.getInstance().getBoolean("phrs.writer.deleteTempFile")) {
                    file.delete();
                }
                connection.setAutoCommit(true);
            }
            catch (Exception exception) {
                this.getDBdataHelper().rollbackConnection(connection);
                DBdataHelper.getInstance().setAutoCommitAndFreeConnection(connection, statement);
                stdlog_.error((Object)"", (Throwable)exception);
                exception.printStackTrace();
                throw new ObjectIOException(exception);
            }
            Object var12_14 = null;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            DBdataHelper.getInstance().setAutoCommitAndFreeConnection(connection, statement);
            throw throwable;
        }
        DBdataHelper.getInstance().setAutoCommitAndFreeConnection(connection, statement);
    }

    public ProposalSummaryDBFields[] loadProposalList() throws ObjectIOException {
        ResultSet resultSet = null;
        Vector<ProposalSummaryDBFields> vector = new Vector<ProposalSummaryDBFields>();
        ProposalSummaryDBFields[] proposalSummaryDBFieldsArray = new ProposalSummaryDBFields[]{};
        Connection connection = null;
        Statement statement = null;
        try {
            try {
                connection = this.getDBdataHelper().acquireConnection();
                connection.setAutoCommit(false);
                stdlog_.debug((Object)"BEGIN TRANSACTION");
                statement = connection.createStatement();
                String string = WriterStmt.selProposalSummaryList();
                stdlog_.info((Object)string);
                resultSet = statement.executeQuery(string);
                while (resultSet.next()) {
                    stdlog_.info((Object)"New programme ");
                    ProposalSummaryDBFields proposalSummaryDBFields = new ProposalSummaryDBFields();
                    proposalSummaryDBFields.setMessageId(resultSet.getLong(1));
                    stdlog_.info((Object)("Message Id: " + proposalSummaryDBFields.getMessageId()));
                    proposalSummaryDBFields.setCycleLabel(resultSet.getString(2));
                    proposalSummaryDBFields.setEmail(resultSet.getString(3));
                    proposalSummaryDBFields.setPiEmail(resultSet.getString(4));
                    proposalSummaryDBFields.setProposalId(resultSet.getLong(5));
                    proposalSummaryDBFields.setDateReceived(resultSet.getLong(6));
                    proposalSummaryDBFields.setProposalCode(resultSet.getString(7));
                    vector.addElement(proposalSummaryDBFields);
                    stdlog_.info((Object)"end of programme----------------");
                }
                resultSet.close();
                int n = 0;
                while (n < vector.size()) {
                    DbaseHandlerCycle dbaseHandlerCycle = new DbaseHandlerCycle();
                    ProposalSummaryDBFields proposalSummaryDBFields = (ProposalSummaryDBFields)vector.elementAt(n);
                    StorageManager.UnpackedStorableObject[] unpackedStorableObjectArray = dbaseHandlerCycle.read(statement, WriterStmt.wcCycleFromLabel(proposalSummaryDBFields.getCycleLabel(), DbaseHandlerCycle.PROPOSAL_SUBMISSION_PHASE), "");
                    if (unpackedStorableObjectArray.length != 1) {
                        throw new ObjectIOException("cycle or step_id wrong. Label: " + proposalSummaryDBFields.getCycleLabel());
                    }
                    Cycle cycle = (Cycle)unpackedStorableObjectArray[0].getObject();
                    proposalSummaryDBFields.setCycle(cycle);
                    proposalSummaryDBFields.getProposalId();
                    long l = proposalSummaryDBFields.getMessageId();
                    String string2 = WriterStmt.updateStatusProposalSummaryList(4, l);
                    this.getDBdataHelper().execUpdate(string2, statement);
                    ++n;
                }
                stdlog_.debug((Object)"COMMIT");
                connection.commit();
            }
            catch (SQLException sQLException) {
                stdlog_.error((Object)"Sql error: ", (Throwable)sQLException);
                this.getDBdataHelper().rollbackConnection(connection);
                throw new ObjectIOException(sQLException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                stdlog_.error((Object)"IllegalArgumentException error Sql  ", (Throwable)illegalArgumentException);
                this.getDBdataHelper().rollbackConnection(connection);
                throw new ObjectIOException(illegalArgumentException);
            }
            catch (ObjectIOException objectIOException) {
                this.getDBdataHelper().rollbackConnection(connection);
                throw objectIOException;
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                this.getDBdataHelper().rollbackConnection(connection);
                throw new ObjectIOException(objectNotFoundException);
            }
            Object var15_19 = null;
        }
        catch (Throwable throwable) {
            Object var15_20 = null;
            this.getDBdataHelper().setAutoCommitAndFreeConnection(connection, statement);
            throw throwable;
        }
        this.getDBdataHelper().setAutoCommitAndFreeConnection(connection, statement);
        proposalSummaryDBFieldsArray = vector.toArray(new ProposalSummaryDBFields[vector.size()]);
        return proposalSummaryDBFieldsArray;
    }

    private void log(int n, String string, long l) throws SQLException, ObjectIOException {
        stdlog_.info((Object)("logged to DB: " + string));
        String string2 = WriterStmt.insertWriterProposalLogEntry(l, n, string, "writer");
        DBdataHelper.getInstance().execUpdate(string2);
    }

    public void processProposalSummary(ProposalSummaryDBFields proposalSummaryDBFields) throws IOException, ObjectIOException, SQLException, ObjectNotFoundException {
        Document document = this.getXmlDocument(proposalSummaryDBFields.getMessageId());
        XmlProposalSummaryReader xmlProposalSummaryReader = new XmlProposalSummaryReader(document);
        File file = this.getLatex(proposalSummaryDBFields.getMessageId());
        this.insertProposalInDb(file, proposalSummaryDBFields, xmlProposalSummaryReader);
        if (OHSConfig.getInstance().getBoolean("phrs.writer.deleteTempFile")) {
            file.delete();
        }
    }

    private File getLatex(long l) throws ObjectIOException, IOException {
        String string = Phase1SelectStmt.getLatexSourceCache(l);
        File file = new File(this.tmpPath_ + File.separator + l);
        File file2 = this.getDBdataHelper().getBinaryFile(file, string);
        return file2;
    }

    public Document getXmlDocument(long l) throws ObjectIOException {
        String string = WriterStmt.getXmlSummary(l);
        Document document = null;
        String string2 = this.getDBdataHelper().readString(string);
        SAXBuilder sAXBuilder = new SAXBuilder();
        try {
            document = sAXBuilder.build((Reader)new StringReader(string2));
        }
        catch (Exception exception) {
            throw new ObjectIOException(exception);
        }
        return document;
    }

    private boolean insertProposalInDb(File file, ProposalSummaryDBFields proposalSummaryDBFields, XmlProposalSummaryReader xmlProposalSummaryReader) throws ObjectNotFoundException, IOException, ObjectIOException {
        boolean bl = false;
        Connection connection = null;
        Statement statement = null;
        int n = 6;
        try {
            try {
                connection = this.getDBdataHelper().acquireConnection();
                connection.setAutoCommit(false);
                stdlog_.debug((Object)"BEGIN TRANSACTION");
                statement = connection.createStatement();
                this.insertProposalRows(proposalSummaryDBFields, xmlProposalSummaryReader, statement);
                String string = WriterStmt.insertLatexSource(proposalSummaryDBFields.getProposalId());
                this.insertProposalCodeInLatex(file, proposalSummaryDBFields.getProposalCode());
                DBdataHelper.getInstance().insertBinaryZippedFile(file, string, connection);
                statement = connection.createStatement();
                n = 5;
                String string2 = WriterStmt.updateStatusProposalSummaryList(n, proposalSummaryDBFields.getMessageId());
                this.getDBdataHelper().execUpdate(string2, statement);
                statement = null;
                connection.commit();
                stdlog_.debug((Object)"COMMIT");
                bl = true;
                connection.setAutoCommit(true);
            }
            catch (Exception exception) {
                stdlog_.error((Object)"", (Throwable)exception);
                this.getDBdataHelper().rollbackConnection(connection);
                throw new ObjectIOException(exception);
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            DBdataHelper.getInstance().setAutoCommitAndFreeConnection(connection, statement);
            throw throwable;
        }
        DBdataHelper.getInstance().setAutoCommitAndFreeConnection(connection, statement);
        return bl;
    }

    public void insertProposalCodeInLatex(File file, String string) {
        String string2 = "\\\\documentclass{esoform}";
        String string3 = "\\\\documentstyle{esoform}";
        String string4 = "\\\\documentclass{esoformlarge}";
        String string5 = "\\\\documentstyle{esoformlarge}";
        String string6 = "\\\\ProposalID{" + string + "}";
        Pattern pattern = Pattern.compile("^\\\\documentclass\\{esoform\\}$");
        Pattern pattern2 = Pattern.compile("^\\\\documentclass\\{esoformlarge\\}$");
        Pattern pattern3 = Pattern.compile("^\\\\documentstyle\\{esoform\\}$");
        Pattern pattern4 = Pattern.compile("^\\\\documentstyle\\{esoformlarge\\}$");
        try {
            String string7 = FileIOUtils.fileToString(file.getAbsolutePath());
            LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(string7));
            String string8 = null;
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer().append(string2).append("\n").append(string6).append("\n");
            StringBuffer stringBuffer3 = new StringBuffer().append(string4).append("\n").append(string6).append("\n");
            StringBuffer stringBuffer4 = new StringBuffer().append(string3).append("\n").append(string6).append("\n");
            StringBuffer stringBuffer5 = new StringBuffer().append(string5).append("\n").append(string6).append("\n");
            while ((string8 = lineNumberReader.readLine()) != null) {
                Matcher matcher = pattern.matcher(string8.trim());
                string8 = matcher.replaceAll(stringBuffer2.toString());
                matcher.reset();
                matcher = pattern2.matcher(string8.trim());
                string8 = matcher.replaceAll(stringBuffer3.toString());
                matcher.reset();
                matcher = pattern3.matcher(string8.trim());
                string8 = matcher.replaceAll(stringBuffer4.toString());
                matcher.reset();
                matcher = pattern4.matcher(string8.trim());
                string8 = matcher.replaceAll(stringBuffer5.toString());
                matcher.reset();
                stringBuffer.append(string8).append("\n");
            }
            FileIOUtils.stringToFile(stringBuffer.toString(), file.getAbsolutePath());
        }
        catch (IOException iOException) {
            stdlog_.error((Object)("cannot create the proposalId " + iOException.getMessage()));
            iOException.printStackTrace();
        }
    }

    private void insertProposalRows(ProposalSummaryDBFields proposalSummaryDBFields, XmlProposalSummaryReader xmlProposalSummaryReader, Statement statement) throws ObjectIOException, ObjectNotFoundException, SQLException, IOException {
        String string;
        String string2;
        StringBuffer stringBuffer = new StringBuffer("00000000000000000");
        boolean bl = false;
        String string3 = null;
        Object var7_7 = null;
        long l = 0L;
        boolean bl2 = false;
        String string4 = null;
        String string5 = null;
        String string6 = xmlProposalSummaryReader.getCycleLabel();
        if (!string6.equals(proposalSummaryDBFields.getCycleLabel())) {
            throw new ObjectIOException("cycle wrong. Label: " + string6 + " summary table label: " + proposalSummaryDBFields.getCycleLabel());
        }
        string3 = xmlProposalSummaryReader.getTitle();
        string4 = xmlProposalSummaryReader.getPanel();
        string5 = xmlProposalSummaryReader.getSubpanel();
        l = proposalSummaryDBFields.getMessageId();
        ObsRun[] obsRunArray = xmlProposalSummaryReader.getRunList(proposalSummaryDBFields.getProposalId(), proposalSummaryDBFields.getProposalCode());
        this.gto = xmlProposalSummaryReader.getGto();
        if (xmlProposalSummaryReader.isOpticon()) {
            stringBuffer.setCharAt(1, OpticonType.OPTICON_FLAG);
        }
        if (xmlProposalSummaryReader.isXmm()) {
            stringBuffer.setCharAt(0, XmmType.XMM_FLAG);
        }
        if (xmlProposalSummaryReader.isRrm()) {
            stringBuffer.setCharAt(2, RrmType.RRM_FLAG);
        }
        if ((string2 = proposalSummaryDBFields.getProposalCode()).length() <= 4) {
            throw new ObjectIOException("The proposalCode is wrong : " + string2);
        }
        String string7 = string2.substring(4, string2.length());
        long l2 = proposalSummaryDBFields.getDateReceived();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l2);
        Date date = calendar.getTime();
        long l3 = StarcatDate.convertDateToStarCatLong(date);
        this.getDBdataHelper().execUpdate(WriterStmt.insertProgramme(proposalSummaryDBFields.getCycle().getPeriod(), string4, string5, proposalSummaryDBFields.getProposalId(), proposalSummaryDBFields.getProposalId(), string3, string7, proposalSummaryDBFields.getPiEmail(), l3, obsRunArray.length, this.gto, stringBuffer.toString(), proposalSummaryDBFields.getCycle().getCycleId(), string2, string4), statement);
        String string8 = xmlProposalSummaryReader.getAbstractText();
        this.getDBdataHelper().execUpdate(Phase1SelectStmt.insertLatexSourceRow(proposalSummaryDBFields.getProposalId(), string8), statement);
        int n = 0;
        while (n < obsRunArray.length) {
            string = this.getDBdataHelper().readString(Phase1SelectStmt.getTelescope(proposalSummaryDBFields.getCycle().getCycleId(), obsRunArray[n].getInstrument()), statement);
            obsRunArray[n].setTelescope(string);
            obsRunArray[n].setProprietaryTime(xmlProposalSummaryReader.getPropTime());
            this.getDBdataHelper().execUpdate(DbaseHandlerObsRun.buildWriteStmt(obsRunArray[n]), statement);
            ++n;
        }
        this.insertPiCoi(proposalSummaryDBFields, xmlProposalSummaryReader, statement);
        xmlProposalSummaryReader.updateFigures(proposalSummaryDBFields, statement);
        string = xmlProposalSummaryReader.getWhyPhase();
        DBdataHelper.getInstance().execUpdate(WriterStmt.insertWhyPhase(proposalSummaryDBFields.getProposalId(), string), statement);
        String string9 = xmlProposalSummaryReader.getWhyNights();
        DBdataHelper.getInstance().execUpdate(WriterStmt.insertWhyNights(proposalSummaryDBFields.getProposalId(), string9), statement);
        Phase1Target[] phase1TargetArray = xmlProposalSummaryReader.getTargetList(proposalSummaryDBFields.getProposalId());
        int n2 = 0;
        while (n2 < phase1TargetArray.length) {
            this.addTargetsInDB(phase1TargetArray[n2], statement);
            ++n2;
        }
        VltiTarget[] vltiTargetArray = xmlProposalSummaryReader.getVltiTargetList(phase1TargetArray, obsRunArray, proposalSummaryDBFields.getProposalId());
        int n3 = 0;
        while (n3 < vltiTargetArray.length) {
            this.addVltiTargetsInDB(vltiTargetArray[n3], statement);
            ++n3;
        }
        SplitRun[] splitRunArray = xmlProposalSummaryReader.getSplitList(proposalSummaryDBFields.getProposalId());
        int n4 = 0;
        while (n4 < splitRunArray.length) {
            this.addRunSchedInDB(splitRunArray[n4], statement);
            ++n4;
        }
        CriticalTime[] criticalTimeArray = xmlProposalSummaryReader.getCriticalTimeList(proposalSummaryDBFields.getProposalId());
        int n5 = 0;
        while (n5 < criticalTimeArray.length) {
            this.addRunTimingInDB(criticalTimeArray[n5], statement);
            ++n5;
        }
        UnsuitableTime[] unsuitableTimeArray = xmlProposalSummaryReader.getUnsuitableTimeList(proposalSummaryDBFields.getProposalId());
        int n6 = 0;
        while (n6 < unsuitableTimeArray.length) {
            this.addRunTimingInDB(unsuitableTimeArray[n6], statement);
            ++n6;
        }
        RunsLink[] runsLinkArray = xmlProposalSummaryReader.getRunsLinkList(proposalSummaryDBFields.getProposalId());
        int n7 = 0;
        while (n7 < runsLinkArray.length) {
            this.addRunsLinkInDB(runsLinkArray[n7], statement);
            ++n7;
        }
        SpecialReqRun[] specialReqRunArray = xmlProposalSummaryReader.getSpecialReqList(proposalSummaryDBFields.getProposalId());
        int n8 = 0;
        while (n8 < specialReqRunArray.length) {
            this.addRunSchedInDB(specialReqRunArray[n8], statement);
            ++n8;
        }
        MovingTargetsRun[] movingTargetsRunArray = xmlProposalSummaryReader.getMovTargetList(proposalSummaryDBFields.getProposalId());
        int n9 = 0;
        while (n9 < movingTargetsRunArray.length) {
            this.addRunSchedInDB(movingTargetsRunArray[n9], statement);
            ++n9;
        }
        InstrumentConf[] instrumentConfArray = xmlProposalSummaryReader.getInstConfigList(proposalSummaryDBFields.getProposalId());
        int n10 = 0;
        while (n10 < instrumentConfArray.length) {
            this.addInstConfigInDB(instrumentConfArray[n10], statement);
            ++n10;
        }
    }

    private void addVltiTargetsInDB(VltiTarget vltiTarget, Statement statement) throws SQLException {
        String string = DbaseHandlerVltiTarget.buildInsertStmt(vltiTarget);
        DBdataHelper.getInstance().execUpdate(string, statement);
    }

    private void insertPiCoi(ProposalSummaryDBFields proposalSummaryDBFields, XmlProposalSummaryReader xmlProposalSummaryReader, Statement statement) throws ObjectIOException, ObjectNotFoundException, SQLException {
        EsoUser[] esoUserArray = xmlProposalSummaryReader.getPiCoi();
        HashSet<Object> hashSet = new HashSet<Object>();
        int n = 0;
        int n2 = 0;
        while (n2 < esoUserArray.length) {
            String string;
            Object object;
            EsoUser esoUser = esoUserArray[n2];
            String string2 = esoUser.getItemName();
            String string3 = esoUser.getSurnameDL();
            EsoUser[] esoUserArray2 = this.loadOrderedUsersFromDB(statement, string2, string3);
            long l = 0L;
            if (esoUserArray2.length == 0) {
                l = DBdataHelper.getInstance().readIntValue(Phase1SelectStmt.getNewUserId(), statement);
                object = new RandomStringGenerator();
                esoUser.setPassword(((RandomStringGenerator)object).getPass());
                string = DbaseHandlerEsoUser.buildInsertStmt(l, esoUser);
                DBdataHelper.getInstance().execUpdate(string, statement);
                DBdataHelper.getInstance().execUpdate(WriterStmt.insertUserRoles(l), statement);
            } else {
                object = esoUserArray2[0];
                ((EsoUser)object).replaceAffiliation(esoUser.getLastAffiliation());
                string = DbaseHandlerEsoUser.buildUpdateStmt((EsoUser)object);
                DBdataHelper.getInstance().execUpdate(string, statement);
                l = ((EsoUser)object).getTableId();
            }
            object = new Long(l);
            if (!hashSet.contains(object)) {
                hashSet.add(object);
                DBdataHelper.getInstance().execUpdate(WriterStmt.insertProposedEntry(l, n, proposalSummaryDBFields.getProposalId()), statement);
                ++n;
            }
            ++n2;
        }
    }

    public void addInstConfigInDB(InstrumentConf instrumentConf, Statement statement) throws ObjectIOException, SQLException {
        if (instrumentConf == null) {
            throw new ObjectIOException(" the instrument conf object is null");
        }
        String string = WriterStmt.insertInstConfRow(instrumentConf.getRunId(), instrumentConf.getFilterName(), instrumentConf.getFilterValue());
        DBdataHelper.getInstance().execUpdate(string, statement);
    }

    private void addRunsLinkInDB(RunsLink runsLink, Statement statement) throws SQLException, ObjectIOException {
        String string = WriterStmt.countRunLinkRows(runsLink.getFirstRunId(), runsLink.getSecondRunId());
        int n = DBdataHelper.getInstance().readIntValue(string, statement);
        String string2 = "";
        if (n == 0) {
            string2 = WriterStmt.insertRunLinkRow(runsLink.getFirstRunId(), runsLink.getSecondRunId(), runsLink.getFlag(), runsLink.getDelay());
        } else if (n == 1) {
            string2 = WriterStmt.updateRunLinkRow(runsLink.getFirstRunId(), runsLink.getSecondRunId(), runsLink.getFlag(), runsLink.getDelay());
        } else {
            throw new ObjectIOException(n + "  rows in run_links for run " + runsLink.getFirstRunId() + " and run  " + runsLink.getSecondRunId());
        }
        DBdataHelper.getInstance().execUpdate(string2, statement);
    }

    public void addRunTimingInDB(RunTimingConstraints runTimingConstraints, Statement statement) throws SQLException, ObjectIOException {
        String string = WriterStmt.countRunTimingRows(runTimingConstraints.getRunId(), runTimingConstraints.getType());
        int n = DBdataHelper.getInstance().readIntValue(string, statement);
        String string2 = WriterStmt.insertRunTimingRow(runTimingConstraints.getRunId(), runTimingConstraints.getType(), runTimingConstraints.getFromDate(), runTimingConstraints.getToDate(), runTimingConstraints.getComments(), runTimingConstraints.getTcIndex() + n);
        DBdataHelper.getInstance().execUpdate(string2, statement);
    }

    public void addRunSchedInDB(RunSchedReq runSchedReq, Statement statement) throws SQLException, ObjectIOException {
        String string = WriterStmt.countRunSchedRows(runSchedReq.getRunId(), runSchedReq.getType());
        int n = DBdataHelper.getInstance().readIntValue(string, statement);
        String string2 = "";
        if (n == 0) {
            string2 = WriterStmt.insertRunSchedRow(runSchedReq.getRunId(), runSchedReq.getType(), runSchedReq.getText());
        } else if (n == 1) {
            string2 = WriterStmt.updateRunSchedRow(runSchedReq.getRunId(), runSchedReq.getType(), runSchedReq.getText());
        } else {
            throw new ObjectIOException(n + "  rows in run_sched_requirements for run " + runSchedReq.getRunId() + " and type " + runSchedReq.getType());
        }
        DBdataHelper.getInstance().execUpdate(string2, statement);
    }

    private void addTargetsInDB(Phase1Target phase1Target, Statement statement) throws ObjectIOException, ObjectNotFoundException, SQLException {
        String string = DbaseHandlerPhase1Target.buildInsertStmt(phase1Target);
        DBdataHelper.getInstance().execUpdate(string, statement);
    }

    private EsoUser[] loadOrderedUsersFromDB(Statement statement, String string, String string2) throws ObjectIOException, ObjectNotFoundException, SQLException {
        DbaseHandlerEsoUser dbaseHandlerEsoUser = new DbaseHandlerEsoUser();
        StorageManager.UnpackedStorableObject[] unpackedStorableObjectArray = dbaseHandlerEsoUser.read(statement, WriterStmt.wcUsersFromName(string, string2), WriterStmt.wcUserFromNameTables());
        EsoUser[] esoUserArray = new EsoUser[unpackedStorableObjectArray.length];
        int n = 0;
        while (n < unpackedStorableObjectArray.length) {
            esoUserArray[n] = (EsoUser)unpackedStorableObjectArray[n].getObject();
            ++n;
        }
        return esoUserArray;
    }

    public DBdataHelper getDBdataHelper() {
        return new DBdataHelper();
    }

    private void sleep() {
        try {
            Thread.sleep(OHSConfig.getInstance().getInteger("phrs.writer.sleep", 1000));
        }
        catch (InterruptedException interruptedException) {
            stdlog_.error((Object)"awakened prematurely", (Throwable)interruptedException);
        }
    }

    private void waitDbRestart(String string) {
        int n = OHSConfig.getInstance().getInteger("phrs.writer.waitDbRestart", 1000);
        String string2 = "Writer problems connecting: " + Config.getCfg().getUrl("") + " wait " + n + " milliseconds.";
        try {
            PhrsWriter.sendWarningMail(string, string2);
            Thread.sleep(OHSConfig.getInstance().getInteger("phrs.writer.waitDbRestart", 1000));
        }
        catch (InterruptedException interruptedException) {
            stdlog_.error((Object)"awakened prematurely", (Throwable)interruptedException);
        }
    }

    private static void sendWarningMail(String string, String string2) {
        MailManagement mailManagement = null;
        try {
            mailManagement = new MailManagement(OHSConfig.getInstance().getSubConfig("phrs.mailConfig"));
        }
        catch (Exception exception) {
            stdlog_.error((Object)"Error: ", (Throwable)exception);
        }
        String string3 = OHSConfig.getInstance().getValue("phrs.mailConfig.mail.recipientTO");
        String string4 = OHSConfig.getInstance().getValue("phrs.mailConfig.mail.recipientCC");
        try {
            mailManagement.postTextPlainMail(string3, string4, string2, string);
        }
        catch (MessagingException messagingException) {
            stdlog_.error((Object)"", (Throwable)messagingException);
        }
    }

    public static void initConfig() {
        try {
            Config.setCfg(new PhrsPersistCfg());
            OHSConfig oHSConfig = OHSConfig.getInstance();
            try {
                oHSConfig.addParamfile(WRITER_CONFIG_FILE);
            }
            catch (Exception exception) {
                stdlog_.error((Object)"Error in config file:config/writer.cf", (Throwable)exception);
                System.exit(0);
            }
            stdlog_.info((Object)("PhrsWriter DB CONNECTION: " + Config.getCfg().getUrl("")));
            Properties properties = new Properties();
            properties.put("conn.pool.size", "1");
            properties.put("conn.pool.timeout", "60");
            properties.put("conn.pool.reopen", "F");
            if (!ConnectionPool.setInitProperties(properties)) {
                stdlog_.error((Object)"Warning: init properties ignored, connection pool already in use.");
            }
            Phase1SelectStmt.definePhase1TableDb(oHSConfig.getValue("phrs.phase1.database"), oHSConfig.getValue("phrs.phase1.owner"));
        }
        catch (Exception exception) {
            stdlog_.error((Object)"Error in config file", (Throwable)exception);
            System.exit(0);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

