/*
 * Decompiled with CFR 0.152.
 */
package com.oroinc.net.telnet;

import com.oroinc.net.telnet.TelnetClient;
import com.oroinc.net.telnet.TelnetOption;
import java.io.IOException;
import java.io.OutputStream;

final class TelnetOutputStream
extends OutputStream {
    private TelnetClient __client;
    private boolean __convertCRtoCRLF = true;
    private boolean __lastWasCR = false;

    TelnetOutputStream(TelnetClient telnetClient) {
        this.__client = telnetClient;
    }

    public void write(int n) throws IOException {
        TelnetClient telnetClient = this.__client;
        synchronized (telnetClient) {
            n &= 0xFF;
            if (this.__client._requestedWont(TelnetOption.BINARY)) {
                if (this.__lastWasCR) {
                    if (this.__convertCRtoCRLF) {
                        this.__client._sendByte(10);
                        if (n == 10) {
                            this.__lastWasCR = false;
                            Object var3_3 = null;
                            return;
                        }
                    } else if (n != 10) {
                        this.__client._sendByte(0);
                    }
                }
                this.__lastWasCR = false;
                switch (n) {
                    case 13: {
                        this.__client._sendByte(13);
                        this.__lastWasCR = true;
                        break;
                    }
                    case 255: {
                        this.__client._sendByte(255);
                        this.__client._sendByte(255);
                        break;
                    }
                    default: {
                        this.__client._sendByte(n);
                        break;
                    }
                }
            } else if (n == 255) {
                this.__client._sendByte(n);
                this.__client._sendByte(255);
            } else {
                this.__client._sendByte(n);
            }
            return;
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        TelnetClient telnetClient = this.__client;
        synchronized (telnetClient) {
            while (n2-- > 0) {
                this.write(byArray[n++]);
            }
            return;
        }
    }

    public void flush() throws IOException {
        this.__client._flushOutputStream();
    }

    public void close() throws IOException {
        this.__client._closeOutputStream();
    }
}

