/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.tds.Dumpable;
import com.sybase.jdbc2.tds.TdsInputStream;
import com.sybase.jdbc2.tds.Token;
import com.sybase.jdbc2.utils.DumpFilter;
import com.sybase.jdbc2.utils.DumpInfo;
import com.sybase.jdbc2.utils.HexConverts;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class SrvAltNameToken
extends Token
implements Dumpable {
    protected int _totalLen;
    protected int _id;
    protected Vector _names;

    public SrvAltNameToken(TdsInputStream tdsInputStream) throws IOException {
        this._totalLen = tdsInputStream.readShort();
        this._id = tdsInputStream.readShort();
        this._names = new Vector();
        int n = this._totalLen - 2;
        while (n > 0) {
            NameInfo nameInfo = new NameInfo(tdsInputStream);
            this._names.addElement(nameInfo);
            n -= nameInfo.getLength();
        }
        if (n < 0) {
            throw new IOException("Malformed AltName token lengths");
        }
    }

    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        DumpInfo dumpInfo = null;
        if (dumpFilter.includesToken(167)) {
            dumpInfo = dumpFilter.getDumpInfo();
            if (dumpFilter.includesDetail(0)) {
                dumpInfo.addInfo("Token", 1, "ALTNAME Token (0x" + HexConverts.hexConvert(167, 1) + "); variable length.");
            } else {
                dumpInfo.addInfo("Token", 1, "ALTNAME Token");
            }
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Length", 2, this._totalLen);
            }
            if (dumpFilter.includesDetail(3)) {
                dumpInfo.addInt("ID", 2, this._id);
                Enumeration enumeration = this._names.elements();
                while (enumeration.hasMoreElements()) {
                    NameInfo nameInfo = (NameInfo)enumeration.nextElement();
                    dumpInfo.addInfo(nameInfo.dump(dumpFilter));
                }
            }
        }
        return dumpInfo;
    }

    public int getId() {
        return this._id;
    }

    public int getTokenType() {
        return 167;
    }

    private class NameInfo
    implements Dumpable {
        private int _length;
        private String _name;

        protected NameInfo(TdsInputStream tdsInputStream) throws IOException {
            this._length = tdsInputStream.readUnsignedByte();
            if (this._length != 0) {
                this._name = tdsInputStream.readString(this._length);
            }
        }

        public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
            DumpInfo dumpInfo = dumpFilter.getDumpInfo();
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Name Length", 1, this._length);
            }
            if (this._length != 0) {
                dumpInfo.addText("Name", this._length, this._name);
            }
            return dumpInfo;
        }

        protected int getLength() {
            return this._length + 1;
        }

        public int getTokenType() {
            return -1;
        }
    }
}

