/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.tds.SrvBulkException;
import com.sybase.jdbc2.tds.SrvPdu;
import com.sybase.jdbc2.tds.TdsInputStream;
import com.sybase.jdbc2.utils.Debug;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import sun.io.ByteToCharConverter;

public class SrvDataInputStream
extends TdsInputStream {
    private SrvPdu _pdu = new SrvPdu();
    private byte[] _packet = null;
    private ByteToCharConverter _btcc = null;

    public SrvDataInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
        this._btcc = ByteToCharConverter.getConverter((String)this._pdu._charset);
        this.setPacketSize(this._pdu._packetSize);
    }

    protected void bulkDone() {
        this._pdu._inBulk = false;
    }

    private void fill() throws IOException {
        int n = 0;
        while (this._last <= this._next) {
            n = this.in.read(this._packet, 0, SrvPdu.size());
            if (n < 0) {
                throw new EOFException("TDS data input stream lost connection");
            }
            this._pdu.setpdu(this._packet);
            int n2 = 0;
            while (n2 < this._pdu.dataLength()) {
                n = this.in.read(this._packet, SrvPdu.size() + n2, this._pdu.dataLength() - n2);
                if (n < 0) {
                    throw new EOFException("TDS data input stream lost connection");
                }
                n2 += n;
            }
            this._next = SrvPdu.size();
            this._last = n2 + this._next;
            if (!this._pdu.bulkOccurred()) continue;
            throw new SrvBulkException();
        }
    }

    public String getCharset() {
        return this._pdu._charset;
    }

    public int read() throws IOException {
        if (this._next >= this._last) {
            if (this._pdu._inBulk && (this._pdu._msgStatus & 1) != 0) {
                return -1;
            }
            this.fill();
        }
        return this._packet[this._next++] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.read();
            if (n4 == -1) break;
            byArray[n + n3] = (byte)n4;
            ++n3;
        }
        return n3 == 0 ? -1 : n3;
    }

    public final String readString(int n) throws IOException {
        if (n <= 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        while (n > 0) {
            int n2 = this.read(byArray, byArray.length - n, n);
            if (n2 == -1) {
                throw new IOException("Unexpected end of data from client");
            }
            n -= n2;
        }
        return new String(this._btcc.convertAll(byArray));
    }

    public void setEncoding(String string) throws IOException {
        this._pdu._charset = string;
        this._btcc = ByteToCharConverter.getConverter((String)this._pdu._charset);
    }

    public void setPacketSize(int n) {
        Debug.assert(this._last < 0 || this._last == this._next, "TDS input buffer in use, cannot reset packetsize");
        this._pdu._packetSize = n;
        this._packet = new byte[this._pdu._packetSize];
    }

    public long skip(long l) throws IOException {
        int n = 0;
        while ((long)n < l) {
            if (this.read() == -1) {
                throw new EOFException("TDS data input stream lost connection");
            }
            ++n;
        }
        return n;
    }

    public int skipBytes(int n) throws IOException {
        return (int)this.skip(n);
    }
}

