/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.Convert;
import com.sybase.jdbc2.jdbc.DateObject;
import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.tds.BlobOutputStream;
import com.sybase.jdbc2.tds.DataFormat;
import com.sybase.jdbc2.tds.SrvBlobInputStream;
import com.sybase.jdbc2.tds.SrvCapabilityToken;
import com.sybase.jdbc2.tds.SrvDataFormat;
import com.sybase.jdbc2.tds.SrvDataToken;
import com.sybase.jdbc2.tds.SrvFormatToken;
import com.sybase.jdbc2.tds.SrvParamDataFormat2;
import com.sybase.jdbc2.tds.SrvParamFormat2Token;
import com.sybase.jdbc2.tds.SrvRowDataFormat2;
import com.sybase.jdbc2.tds.SrvRowFormat2Token;
import com.sybase.jdbc2.tds.SrvTextImageData;
import com.sybase.jdbc2.tds.SrvTypeException;
import com.sybase.jdbc2.tds.SrvTypeFormatter;
import com.sybase.jdbc2.tds.SrvVarCharData;
import com.sybase.jdbc2.tds.TdsDateTime;
import com.sybase.jdbc2.tds.TdsInputStream;
import com.sybase.jdbc2.tds.TdsNumeric;
import com.sybase.jdbc2.tds.TdsOutputStream;
import com.sybase.jdbc2.tds.Token;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;

public class SrvJavaTypeFormatter
extends SrvTypeFormatter {
    private static final int BUF_SIZE = 2048;
    protected Object[] _data = null;
    private int[] _dataLengths = null;
    private int _columnNo = 0;
    private int _lastColumnIndex = 0;
    private boolean _mustConvertChars = true;

    public SrvJavaTypeFormatter(SrvFormatToken srvFormatToken, SrvCapabilityToken srvCapabilityToken) {
        this(srvFormatToken, srvCapabilityToken, true);
    }

    public SrvJavaTypeFormatter(SrvFormatToken srvFormatToken, SrvCapabilityToken srvCapabilityToken, boolean bl) {
        super(srvFormatToken, srvCapabilityToken);
        this._mustConvertChars = bl;
    }

    public void addFormat(DataFormat dataFormat) throws IOException, SrvTypeException {
        this._format.addFormat(dataFormat);
    }

    public void addFormat(Object object, String string, int n, int n2) throws IOException, SrvTypeException {
        this.addFormat(object, string, n, n2, null);
    }

    public void addFormat(Object object, String string, int n, int n2, String string2) throws IOException, SrvTypeException {
        this.addFormat(object, null, null, null, null, string, n, n2);
    }

    public void addFormat(Object object, String string, String string2, String string3, String string4, String string5, int n, int n2) throws IOException, SrvTypeException {
        int n3 = 0;
        if (object == null) {
            object = new Object();
        }
        if (object instanceof String) {
            n3 = n2 > 0 && n2 <= 255 ? 47 : (n2 > 255 ? 175 : 39);
        } else if (object instanceof Boolean) {
            n3 = 50;
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (byArray.length > 255) {
                n2 = Integer.MAX_VALUE;
                n3 = 225;
            } else {
                n3 = 37;
                n2 = 255;
            }
        } else if (object instanceof Byte) {
            n3 = 38;
            n2 = 1;
        } else if (object instanceof Short) {
            n3 = 38;
            n2 = 2;
        } else if (object instanceof Integer) {
            n3 = 38;
            n2 = 4;
        } else if (object instanceof Long) {
            n3 = 38;
            n2 = 8;
        } else if (object instanceof Float) {
            n3 = 59;
        } else if (object instanceof Double) {
            n3 = 62;
        } else if (object instanceof Date || object instanceof Calendar) {
            n3 = 111;
            n2 = 8;
        } else if (object instanceof InputStream) {
            n3 = 9220;
            n2 = -1;
        } else if (object instanceof Reader) {
            n3 = 9219;
            n2 = -1;
        } else if (object instanceof SrvTextImageData) {
            n3 = 34;
            n2 = Integer.MAX_VALUE;
        } else {
            n3 = 9217;
            n2 = -1;
        }
        if (this._format instanceof SrvParamFormat2Token) {
            ((SrvParamFormat2Token)this._format).addFormat(new SrvParamDataFormat2(string5, n3, n, n2, object));
        } else if (this._format instanceof SrvRowFormat2Token) {
            ((SrvRowFormat2Token)this._format).addFormat(new SrvRowDataFormat2(string, string2, string3, string4, string5, n3, n, n2, 0, 0, object));
        } else {
            this._format.addFormat(new SrvDataFormat(string5, n3, n, n2, object));
        }
    }

    private InputStream cacheBlob(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        while ((n = inputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    public Object[] convertData(Token token) throws IOException {
        Object[] objectArray = new Object[this._format.getFormatCount()];
        this._dataLengths = new int[this._format.getFormatCount()];
        TdsInputStream tdsInputStream = null;
        this._lastColumnIndex = objectArray.length - 1;
        int n = 0;
        while (n < objectArray.length) {
            if (token instanceof SrvDataToken) {
                tdsInputStream = ((SrvDataToken)((Object)token)).getStream();
            }
            objectArray[n] = this.receiveData(tdsInputStream, this._format.formatAt(n));
            ++n;
            ++this._columnNo;
        }
        return objectArray;
    }

    public void convertData(Token token, Object[] objectArray) throws IOException {
        this.setFormatter(token, this);
        this._data = objectArray;
    }

    public int[] getDataLengths() {
        return this._dataLengths;
    }

    public int[] getLengthSizes() {
        int n = this._format.getFormatCount();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            DataFormat dataFormat = this._format.formatAt(n2);
            nArray[n2] = DataFormat.lengthSize(dataFormat._datatype);
            ++n2;
        }
        return nArray;
    }

    private Object readBLOB(TdsInputStream tdsInputStream, int n) throws IOException, SrvTypeException {
        Object object = null;
        int n2 = tdsInputStream.readUnsignedByte();
        short s = tdsInputStream.readShort();
        this._dataLengths[this._columnNo] = 0;
        switch (n) {
            case 1: {
                Object object2;
                if (s > 0) {
                    object2 = tdsInputStream.readString(s);
                }
                object2 = new SrvBlobInputStream(tdsInputStream);
                try {
                    try {
                        ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)object2);
                        try {
                            try {
                                object = objectInputStream.readObject();
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new SrvTypeException("Error Deserializing: " + classNotFoundException.getMessage());
                            }
                            Object var11_10 = null;
                        }
                        catch (Throwable throwable) {
                            Object var11_11 = null;
                            objectInputStream.close();
                            throw throwable;
                        }
                        objectInputStream.close();
                        this._dataLengths[this._columnNo] = object == null ? 0 : object.toString().length();
                    }
                    catch (EOFException eOFException) {
                    }
                    Object var8_13 = null;
                }
                catch (Throwable throwable) {
                    Object var8_14 = null;
                    ((SrvBlobInputStream)object2).close();
                    throw throwable;
                }
                ((SrvBlobInputStream)object2).close();
                break;
            }
            case 3: {
                if (s > 0) {
                    tdsInputStream.skip(s);
                }
                SrvBlobInputStream srvBlobInputStream = new SrvBlobInputStream(tdsInputStream);
                InputStreamReader inputStreamReader = null;
                inputStreamReader = this._columnNo < this._lastColumnIndex ? new InputStreamReader(this.cacheBlob(srvBlobInputStream), tdsInputStream.getCharset()) : new InputStreamReader((InputStream)srvBlobInputStream, tdsInputStream.getCharset());
                object = inputStreamReader;
                break;
            }
            case 4: {
                if (s > 0) {
                    tdsInputStream.skip(s);
                }
                if (this._columnNo < this._lastColumnIndex) {
                    object = this.cacheBlob(new SrvBlobInputStream(tdsInputStream));
                    break;
                }
                object = new SrvBlobInputStream(tdsInputStream);
                break;
            }
        }
        return object;
    }

    private TdsDateTime readDATETIMN(TdsInputStream tdsInputStream, int n) throws IOException {
        switch (n) {
            case 0: {
                return null;
            }
            case 4: {
                int n2 = tdsInputStream.readUnsignedShort();
                int n3 = tdsInputStream.readUnsignedShort();
                return new TdsDateTime(n2, n3, 0);
            }
            case 8: {
                int n4 = tdsInputStream.readInt();
                int n5 = tdsInputStream.readInt();
                return new TdsDateTime(n4, n5);
            }
        }
        ErrorMessage.raiseIOException("JZ0P4");
        return null;
    }

    private Number readFLTN(TdsInputStream tdsInputStream, int n) throws IOException {
        switch (n) {
            case 0: {
                return null;
            }
            case 4: {
                return new Float(tdsInputStream.readFloat());
            }
            case 8: {
                return new Double(tdsInputStream.readDouble());
            }
        }
        ErrorMessage.raiseIOException("JZ0P4");
        return null;
    }

    private BigDecimal readMONEYN(TdsInputStream tdsInputStream, int n) throws IOException {
        switch (n) {
            case 0: {
                return null;
            }
            case 4: {
                int n2 = tdsInputStream.readInt();
                return new BigDecimal(BigInteger.valueOf(n2), 4);
            }
            case 8: {
                long l = tdsInputStream.readLong();
                return new BigDecimal(BigInteger.valueOf(l), 4);
            }
        }
        ErrorMessage.raiseIOException("JZ0P4");
        return null;
    }

    protected Object receiveData(TdsInputStream tdsInputStream, DataFormat dataFormat) throws IOException, SrvTypeException {
        switch (dataFormat._datatype) {
            case 50: {
                this._dataLengths[this._columnNo] = 1;
                return new Boolean(tdsInputStream.readByte() == 0);
            }
            case 37: 
            case 45: 
            case 225: {
                int n = dataFormat._datatype == 225 ? tdsInputStream.readInt() : tdsInputStream.readUnsignedByte();
                this._dataLengths[this._columnNo] = n;
                if (n == 0) {
                    return null;
                }
                byte[] byArray = new byte[n];
                while (n > 0) {
                    int n2 = tdsInputStream.read(byArray, byArray.length - n, n);
                    if (n2 == -1) {
                        throw new IOException("Unexpected end of data from client");
                    }
                    n -= n2;
                }
                return byArray;
            }
            case 39: 
            case 47: 
            case 103: 
            case 104: {
                int n;
                this._dataLengths[this._columnNo] = n = tdsInputStream.readUnsignedByte();
                if (n == 0) {
                    return "";
                }
                if (this._mustConvertChars) {
                    return tdsInputStream.readString(n);
                }
                byte[] byArray = new byte[n];
                tdsInputStream.read(byArray);
                return new SrvVarCharData(byArray, tdsInputStream.getCharset());
            }
            case 175: {
                int n;
                this._dataLengths[this._columnNo] = n = tdsInputStream.readInt();
                return tdsInputStream.readString(n);
            }
            case 48: {
                this._dataLengths[this._columnNo] = 1;
                return new Byte(tdsInputStream.readByte());
            }
            case 52: {
                this._dataLengths[this._columnNo] = 2;
                return new Short(tdsInputStream.readShort());
            }
            case 56: {
                this._dataLengths[this._columnNo] = 4;
                return new Integer(tdsInputStream.readInt());
            }
            case 38: {
                int n;
                this._dataLengths[this._columnNo] = n = tdsInputStream.readUnsignedByte();
                if (n == 0) {
                    return null;
                }
                switch (n) {
                    case 1: {
                        return new Byte(tdsInputStream.readByte());
                    }
                    case 2: {
                        return new Short(tdsInputStream.readShort());
                    }
                    case 4: {
                        return new Integer(tdsInputStream.readInt());
                    }
                    case 8: {
                        return new Long(tdsInputStream.readLong());
                    }
                }
                throw new SrvTypeException("Unmappable TDS data INTN type received:  length " + dataFormat._length);
            }
            case 59: {
                this._dataLengths[this._columnNo] = 4;
                return this.readFLTN(tdsInputStream, 4);
            }
            case 62: {
                this._dataLengths[this._columnNo] = 8;
                return this.readFLTN(tdsInputStream, 8);
            }
            case 109: {
                int n;
                this._dataLengths[this._columnNo] = n = tdsInputStream.readUnsignedByte();
                return this.readFLTN(tdsInputStream, n);
            }
            case 106: 
            case 108: {
                int n;
                this._dataLengths[this._columnNo] = n = tdsInputStream.readUnsignedByte();
                if (n == 0) {
                    return null;
                }
                byte[] byArray = new byte[n];
                tdsInputStream.read(byArray);
                return TdsNumeric.numericValue(byArray, dataFormat._precision, dataFormat._scale);
            }
            case 58: 
            case 61: {
                this._dataLengths[this._columnNo] = dataFormat._length;
                return this.readDATETIMN(tdsInputStream, dataFormat._length);
            }
            case 111: {
                int n;
                this._dataLengths[this._columnNo] = n = tdsInputStream.readUnsignedByte();
                return this.readDATETIMN(tdsInputStream, n);
            }
            case 36: {
                return this.readBLOB(tdsInputStream, dataFormat._blobType);
            }
            case 35: {
                int n = tdsInputStream.readUnsignedByte();
                if (n == 0) {
                    return null;
                }
                byte[] byArray = new byte[n + 8];
                tdsInputStream.read(byArray, 0, n + 8);
                int n3 = tdsInputStream.readInt();
                if (n3 == 0) {
                    return null;
                }
                this._dataLengths[this._columnNo] = n3;
                return tdsInputStream.readString(n3);
            }
            case 34: {
                int n = tdsInputStream.readUnsignedByte();
                if (n == 0) {
                    return null;
                }
                byte[] byArray = new byte[n + 8];
                tdsInputStream.read(byArray, 0, n + 8);
                int n4 = tdsInputStream.readInt();
                if (n4 == 0) {
                    return null;
                }
                this._dataLengths[this._columnNo] = n4;
                byte[] byArray2 = new byte[n4];
                while (n4 > 0) {
                    int n5 = tdsInputStream.read(byArray2, byArray2.length - n4, n4);
                    if (n5 == -1) {
                        throw new IOException("Unexpected end of data from client");
                    }
                    n4 -= n5;
                }
                return byArray2;
            }
            case 60: 
            case 122: {
                this._dataLengths[this._columnNo] = dataFormat._length;
                return this.readMONEYN(tdsInputStream, dataFormat._length);
            }
            case 110: {
                int n;
                this._dataLengths[this._columnNo] = n = tdsInputStream.readUnsignedByte();
                return this.readMONEYN(tdsInputStream, n);
            }
        }
        throw new SrvTypeException("Unmappable TDS data type received: 0x" + Integer.toHexString(dataFormat._datatype));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void sendData(TdsOutputStream tdsOutputStream, Object object, DataFormat dataFormat) throws IOException, SrvTypeException {
        switch (dataFormat._datatype) {
            case 50: {
                if (((Boolean)object).booleanValue()) {
                    tdsOutputStream.writeByte(1);
                    return;
                } else {
                    tdsOutputStream.writeByte(0);
                }
                return;
            }
            case 37: 
            case 45: 
            case 225: {
                if (object == null) {
                    if (dataFormat._datatype == 225) {
                        tdsOutputStream.writeInt(0);
                        return;
                    } else {
                        tdsOutputStream.writeByte(0);
                    }
                    return;
                } else if (object instanceof byte[]) {
                    byte[] byArray = (byte[])object;
                    if (dataFormat._datatype == 225) {
                        tdsOutputStream.writeInt(byArray.length);
                    } else {
                        tdsOutputStream.writeByte(byArray.length);
                    }
                    tdsOutputStream.write(byArray);
                    return;
                } else {
                    if (!(object instanceof Byte)) throw new SrvTypeException("Expected Byte or Byte[], got " + object.getClass().getName());
                    tdsOutputStream.writeByte(1);
                    tdsOutputStream.writeByte(((Byte)object).byteValue());
                }
                return;
            }
            case 39: 
            case 47: {
                byte[] byArray = tdsOutputStream.stringToByte((String)object);
                tdsOutputStream.writeByte(byArray.length);
                tdsOutputStream.write(byArray);
                return;
            }
            case 175: {
                byte[] byArray = tdsOutputStream.stringToByte((String)object);
                tdsOutputStream.writeInt(byArray.length);
                tdsOutputStream.write(byArray);
                return;
            }
            case 48: {
                tdsOutputStream.writeByte(((Byte)object).intValue());
                return;
            }
            case 52: {
                tdsOutputStream.writeShort(((Short)object).intValue());
                return;
            }
            case 56: {
                tdsOutputStream.writeInt((Integer)object);
                return;
            }
            case 59: {
                tdsOutputStream.writeFloat(((Float)object).floatValue());
                return;
            }
            case 62: {
                tdsOutputStream.writeDouble((Double)object);
                return;
            }
            case 38: {
                if (object == null) {
                    tdsOutputStream.writeByte(0);
                    return;
                }
                tdsOutputStream.writeByte(dataFormat._length);
                try {
                    switch (dataFormat._length) {
                        case 1: {
                            tdsOutputStream.writeByte(((Byte)object).byteValue());
                            return;
                        }
                        case 2: {
                            tdsOutputStream.writeShort(((Short)object).intValue());
                            return;
                        }
                        case 4: {
                            tdsOutputStream.writeInt((Integer)object);
                            return;
                        }
                        case 8: {
                            tdsOutputStream.writeLong((Long)object);
                            return;
                        }
                        default: {
                            return;
                        }
                    }
                }
                catch (ClassCastException classCastException) {
                    throw new SrvTypeException("Object does not match data format requested");
                }
            }
            case 111: {
                if (object == null) {
                    tdsOutputStream.writeByte(0);
                    return;
                }
                DateObject dateObject = null;
                try {
                    dateObject = Convert.objectToDateObject(object, null);
                }
                catch (SQLException sQLException) {
                    throw new SrvTypeException("Cannot cast " + object.getClass().getName() + " to a TDS_DATIMN: " + sQLException);
                }
                int[] nArray = TdsDateTime.tdsDateTime(dateObject);
                tdsOutputStream.writeByte(8);
                tdsOutputStream.writeInt(nArray[0]);
                tdsOutputStream.writeInt(nArray[1]);
                return;
            }
            case 36: {
                switch (dataFormat._blobType) {
                    case 1: {
                        tdsOutputStream.writeByte(1);
                        tdsOutputStream.writeShort(0);
                        if (object == null) {
                            tdsOutputStream.writeInt(0);
                            return;
                        }
                        BlobOutputStream blobOutputStream = new BlobOutputStream(tdsOutputStream);
                        ObjectOutputStream objectOutputStream = new ObjectOutputStream(blobOutputStream);
                        objectOutputStream.writeObject(object);
                        objectOutputStream.close();
                        return;
                    }
                    case 4: {
                        int n;
                        tdsOutputStream.writeByte(0);
                        tdsOutputStream.writeShort(0);
                        if (object == null) {
                            tdsOutputStream.writeInt(0);
                            return;
                        }
                        BlobOutputStream blobOutputStream = new BlobOutputStream(tdsOutputStream);
                        InputStream inputStream = (InputStream)object;
                        byte[] byArray = new byte[2048];
                        while ((n = inputStream.read(byArray)) >= 0) {
                            blobOutputStream.write(byArray, 0, n);
                        }
                        blobOutputStream.close();
                        return;
                    }
                    case 3: {
                        int n;
                        tdsOutputStream.writeByte(0);
                        tdsOutputStream.writeShort(0);
                        if (object == null) {
                            tdsOutputStream.writeInt(0);
                            return;
                        }
                        BlobOutputStream blobOutputStream = new BlobOutputStream(tdsOutputStream);
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)blobOutputStream, tdsOutputStream.getCharset());
                        char[] cArray = new char[2048];
                        Reader reader = (Reader)object;
                        while ((n = reader.read(cArray)) >= 0) {
                            outputStreamWriter.write(cArray, 0, n);
                        }
                        outputStreamWriter.flush();
                        blobOutputStream.close();
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            case 34: 
            case 35: {
                if (object == null || object instanceof SrvTextImageData && ((SrvTextImageData)object).isNull()) {
                    tdsOutputStream.writeByte(0);
                    return;
                }
                if (!(object instanceof SrvTextImageData)) {
                    throw new SrvTypeException("Unmappable IMAGE or TEXT data type: " + object.getClass().getName());
                }
                SrvTextImageData srvTextImageData = (SrvTextImageData)object;
                tdsOutputStream.writeByte(srvTextImageData.getTextPtrLength());
                tdsOutputStream.write(srvTextImageData.getTextPtr());
                tdsOutputStream.writeLong(srvTextImageData.getTimeStamp());
                if (srvTextImageData._bytes != null) {
                    tdsOutputStream.writeInt(srvTextImageData.getLength());
                    tdsOutputStream.write(srvTextImageData._bytes);
                    return;
                }
                if (srvTextImageData._byteStream == null) throw new SrvTypeException("Invalid construction of SrvTextImageData: no data!!!");
                tdsOutputStream.writeInt(srvTextImageData.getLength());
                try {
                    int n = srvTextImageData._byteStream.read();
                    while (n != -1) {
                        tdsOutputStream.write(n);
                        n = srvTextImageData._byteStream.read();
                    }
                    return;
                }
                catch (IOException iOException) {
                    throw new SrvTypeException("Problem reading SrvTextImageData InputStream:" + iOException);
                }
            }
            default: {
                throw new SrvTypeException("Unmappable java data type: " + object.getClass().getName());
            }
        }
    }

    public void sendDataStream(TdsOutputStream tdsOutputStream) throws IOException {
        if (this._data.length != this._format.getFormatCount()) {
            throw new SrvTypeException("Format to data item count is off, " + this._data.length + " data items" + " and " + this._format.getFormatCount() + " formats");
        }
        int n = 0;
        while (n < this._data.length) {
            this.sendData(tdsOutputStream, this._data[n], this._format.formatAt(n));
            ++n;
        }
    }
}

