/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.tds.Dumpable;
import com.sybase.jdbc2.tds.LoginAckToken;
import com.sybase.jdbc2.tds.LoginToken;
import com.sybase.jdbc2.tds.TdsInputStream;
import com.sybase.jdbc2.tds.TdsOutputStream;
import com.sybase.jdbc2.utils.DumpFilter;
import com.sybase.jdbc2.utils.DumpInfo;
import com.sybase.jdbc2.utils.HexConverts;
import java.io.IOException;

public class SrvLoginAckToken
extends LoginAckToken
implements Dumpable {
    private static final int PROGNAME_MAXLEN = 255;
    protected int _totalLen;
    protected int _progNameLen;
    private static final byte[] PROGVERSION;

    static {
        byte[] byArray = new byte[4];
        byArray[0] = 1;
        byArray[1] = 1;
        PROGVERSION = byArray;
    }

    public SrvLoginAckToken(int n, String string, byte[] byArray) {
        this._status = n;
        int n2 = string.length();
        if (n2 > 255) {
            n2 = 255;
        }
        this._progName = string.substring(0, n2);
        this._progNameLen = n2;
        this._progVers = byArray;
        this._totalLen = 6 + this._progNameLen + 4;
    }

    public SrvLoginAckToken(TdsInputStream tdsInputStream) throws IOException {
        this._totalLen = tdsInputStream.readShort();
        this._status = tdsInputStream.readUnsignedByte();
        this._tdsVers = new byte[4];
        tdsInputStream.read(this._tdsVers);
        this._progNameLen = tdsInputStream.readUnsignedByte();
        this._progName = tdsInputStream.readString(this._progNameLen);
        this._progVers = new byte[4];
        tdsInputStream.read(this._progVers);
    }

    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        DumpInfo dumpInfo = null;
        if (dumpFilter.includesToken(173)) {
            dumpInfo = dumpFilter.getDumpInfo();
            if (dumpFilter.includesDetail(0)) {
                dumpInfo.addInfo("Token", 1, "LOGINACK Token (0x" + HexConverts.hexConvert(173, 1) + "); variable length.");
            } else {
                dumpInfo.addInfo("Token", 1, "LOGINACK Token");
            }
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Length", 2, this._totalLen);
            }
            if (dumpFilter.includesDetail(3)) {
                String[] stringArray = new String[]{"<unrecognized>", "<unrecognized>", "<unrecognized>", "<unrecognized>", "<unrecognized>", "LOG_SUCCEED", "LOG_FAIL", "LOG_NEGOTIATE"};
                dumpInfo.addField("Status", 1, this._status, stringArray);
                dumpInfo.addInfo("TDS Version", 4, LoginAckToken.makeVersionString(this._tdsVers));
                if (dumpFilter.includesDetail(1)) {
                    dumpInfo.addInt("Program Name Length", 1, this._progNameLen);
                }
                dumpInfo.addText("Program Name", this._progName.length(), this._progName);
                dumpInfo.addInfo("Program Version", 4, LoginAckToken.makeVersionString(this._progVers));
            }
        }
        return dumpInfo;
    }

    public int getTokenType() {
        return 173;
    }

    public void send(TdsOutputStream tdsOutputStream) throws IOException {
        tdsOutputStream.writeByte(173);
        byte[] byArray = tdsOutputStream.stringToByte(this._progName);
        int n = byArray.length;
        if (byArray.length > 255) {
            n = 255;
        }
        tdsOutputStream.writeShort(1 + LoginToken.TDSVERSION.length + 1 + n + PROGVERSION.length);
        tdsOutputStream.writeByte(this._status);
        tdsOutputStream.write(LoginToken.TDSVERSION);
        tdsOutputStream.writeByte(n);
        tdsOutputStream.write(byArray);
        tdsOutputStream.write(PROGVERSION);
    }
}

