/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.core.utilities;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eso.ohs.core.utilities.DefaultGTreeModel;
import org.eso.ohs.core.utilities.DefaultGTreeNode;
import org.eso.ohs.core.utilities.DefaultGTreePath;
import org.eso.ohs.core.utilities.FileIOUtils;
import org.eso.ohs.core.utilities.GTreeModel;
import org.eso.ohs.core.utilities.GTreeNode;
import org.eso.ohs.core.utilities.GTreePath;
import org.eso.ohs.core.utilities.NotASCIIException;
import org.eso.ohs.core.utilities.PafData;
import org.eso.ohs.core.utilities.PafFile;
import org.eso.ohs.core.utilities.Paramfile;
import org.eso.ohs.core.utilities.ParamfileTreePath;
import org.eso.ohs.core.utilities.TextUtils;

public class OHSConfig {
    private static final String rcsid = "$Id: OHSConfig.java,v 1.17 2005/02/16 08:31:48 ddorigo Exp $";
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$core$utilities$OHSConfig == null ? (class$org$eso$ohs$core$utilities$OHSConfig = OHSConfig.class$("org.eso.ohs.core.utilities.OHSConfig")) : class$org$eso$ohs$core$utilities$OHSConfig));
    protected static OHSConfig instance_ = null;
    protected DefaultGTreeModel tree_ = null;
    protected static int maxParamFileLines_ = 10000;
    protected static String FILE_HDR = "#!--- USER SELECTION OPTION FILE\n#!--- This is an automatically generated file.\n#!--- It will be read and overwritten.\n#!--- Do not edit this file.\n";
    static /* synthetic */ Class class$org$eso$ohs$core$utilities$OHSConfig;

    public static OHSConfig getInstance() {
        if (instance_ == null) {
            instance_ = new OHSConfig();
        }
        return instance_;
    }

    public static void setInstance(OHSConfig oHSConfig) {
        instance_ = oHSConfig;
    }

    public static boolean isSingletonSet() {
        return instance_ != null;
    }

    public OHSConfig() {
        DefaultGTreeNode defaultGTreeNode = new DefaultGTreeNode("config");
        this.tree_ = new DefaultGTreeModel(defaultGTreeNode);
        stdlog_.info((Object)("*******\nPLATFORM: " + this.getSystemProperty("os.name") + "\n*******"));
    }

    public OHSConfig(GTreeNode gTreeNode) {
        this.tree_ = new DefaultGTreeModel(gTreeNode);
    }

    public OHSConfig(DefaultGTreeModel defaultGTreeModel) {
        this.tree_ = defaultGTreeModel;
    }

    public void addParamfile(String string, String string2) throws IOException, NotASCIIException {
        this.addParamData(new Paramfile(string, maxParamFileLines_), new ParamfileTreePath(string2));
    }

    public void addParamfile(String string) throws IOException, NotASCIIException {
        stdlog_.info((Object)("loading param file: " + string));
        this.addParamData(new Paramfile(string, maxParamFileLines_), (GTreePath)null);
    }

    public void retrievePrivateConfResource(String string) throws IOException, NotASCIIException {
        File file = new File(string);
        String string2 = file.getName();
        File file2 = new File(System.getProperty("user.home") + File.separator + string2);
        stdlog_.debug((Object)("Retrieving private config file " + file2.getAbsolutePath()));
        if (file2.exists()) {
            this.addParamfile(file2.getAbsolutePath());
        } else {
            stdlog_.warn((Object)("No private config file " + file2.getAbsolutePath()));
        }
    }

    public void loadConfigFile(String string, String string2) {
        File file = new File(string);
        String string3 = file.getName();
        File file2 = new File(string2 + File.separator + string3);
        try {
            this.addParamfileAsResourceStream(string);
            stdlog_.info((Object)("load param file: " + string));
        }
        catch (Exception exception) {
            stdlog_.debug((Object)("Cannot load param file: " + string + ": \n " + exception.getMessage()));
        }
        try {
            this.addParamfile(string);
            stdlog_.info((Object)("load param file: " + string));
        }
        catch (Exception exception) {
            stdlog_.debug((Object)("Cannot load param file: " + string + ": \n " + exception.getMessage()));
        }
        try {
            this.addParamfile(file2.getAbsolutePath());
            stdlog_.info((Object)("load param file: " + file2.getAbsolutePath()));
        }
        catch (Exception exception) {
            stdlog_.debug((Object)("Cannot load param file: " + file2.getAbsolutePath() + ": \n " + exception.getMessage()));
        }
    }

    public String getFileContent(String string, String string2) {
        File file = this.getFileLocal(string, string2);
        String string3 = this.getValue(string);
        File file2 = new File(string3);
        String string4 = file2.getName();
        String string5 = null;
        try {
            InputStream inputStream = FileIOUtils.getResourceStream(string3);
            string5 = FileIOUtils.fileToString(inputStream);
            inputStream.close();
            stdlog_.info((Object)("load file as ResourceStream: " + string3));
        }
        catch (Exception exception) {
            stdlog_.debug((Object)("Cannot load  file: " + string3 + ": \n " + exception.getMessage()));
        }
        try {
            if (file2.canRead()) {
                string5 = FileIOUtils.fileToString(file2);
                stdlog_.info((Object)("load file from file system: " + string3));
            }
        }
        catch (Exception exception) {
            stdlog_.debug((Object)("Cannot load  file: " + string3 + ": \n " + exception.getMessage()));
        }
        try {
            if (file.canRead()) {
                string5 = FileIOUtils.fileToString(file.getAbsolutePath());
                stdlog_.info((Object)("load file: " + file.getAbsolutePath()));
            }
        }
        catch (Exception exception) {
            stdlog_.debug((Object)("Cannot load file: " + file.getAbsolutePath() + ": \n " + exception.getMessage()));
        }
        return string5;
    }

    public File getFileLocal(String string, String string2) {
        String string3 = this.getValue(string);
        File file = new File(string2 + File.separator + string3);
        return file;
    }

    public void addParamfileAsResourceStream(String string) throws IOException, NotASCIIException {
        InputStream inputStream = FileIOUtils.getResourceStream(string);
        this.addParamfile(inputStream);
    }

    public void addParamfile(InputStream inputStream) throws IOException, NotASCIIException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        this.addParamData(new Paramfile(inputStreamReader, maxParamFileLines_), (GTreePath)null);
    }

    public void saveParamDataToPAF(String string, Paramfile paramfile) throws IOException, NotASCIIException {
        this.saveParamDataToPAF(string, paramfile, (GTreePath)null);
    }

    public void saveParamDataToPAF(String string, Paramfile paramfile, String string2) throws IOException, NotASCIIException {
        this.saveParamDataToPAF(string, paramfile, new ParamfileTreePath(string2));
    }

    protected void saveParamDataToPAF(String string, Paramfile paramfile, GTreePath gTreePath) throws IOException, NotASCIIException {
        Paramfile paramfile2 = new Paramfile();
        String string2 = "CONFIGURATION " + TextUtils.currentISODateTime() + "(UT)\n";
        Object var6_6 = null;
        String[] stringArray = paramfile.getKeywords();
        int n = 0;
        while (n < stringArray.length) {
            String string3 = stringArray[n];
            String string4 = paramfile.getValue(string3);
            paramfile2.put(string3, string4);
            ++n;
        }
        try {
            if (string != null) {
                paramfile2.writeTo(new FileWriter(string), string2);
            }
        }
        catch (IOException iOException) {
            stdlog_.error((Object)("Error writing to file: \n" + iOException.getMessage()));
        }
    }

    public void addParamData(Paramfile paramfile) {
        this.addParamData(paramfile, (GTreePath)null);
    }

    public void addParamData(Paramfile paramfile, String string) {
        this.addParamData(paramfile, new ParamfileTreePath(string));
    }

    protected void addParamData(Paramfile paramfile, GTreePath gTreePath) {
        Object object;
        DefaultGTreeModel defaultGTreeModel = null;
        if (gTreePath != null && gTreePath.getPath().length > 0) {
            object = OHSConfig.prependNode(this.tree_.getRoot(), gTreePath);
            this.tree_.addPath((GTreePath)object);
            GTreeNode gTreeNode = this.tree_.getNode((GTreePath)object);
            defaultGTreeModel = new DefaultGTreeModel(gTreeNode);
        } else {
            defaultGTreeModel = this.tree_;
        }
        object = paramfile.getKeywords();
        int n = 0;
        while (n < ((String[])object).length) {
            String string = object[n];
            String string2 = paramfile.getValue(string);
            this.setValue(defaultGTreeModel, string, (Object)string2);
            ++n;
        }
    }

    public void addPafData(PafFile pafFile) {
        this.addPafData(pafFile, (GTreePath)null);
    }

    protected void addPafData(PafFile pafFile, String string) {
        this.addPafData(pafFile, new ParamfileTreePath(string));
    }

    protected void addPafData(PafFile pafFile, GTreePath gTreePath) {
        Object object;
        DefaultGTreeModel defaultGTreeModel = null;
        if (gTreePath != null && gTreePath.getPath().length > 0) {
            object = OHSConfig.prependNode(this.tree_.getRoot(), gTreePath);
            this.tree_.addPath((GTreePath)object);
            GTreeNode gTreeNode = this.tree_.getNode((GTreePath)object);
            defaultGTreeModel = new DefaultGTreeModel(gTreeNode);
        } else {
            defaultGTreeModel = this.tree_;
        }
        object = pafFile.getIdentifierList();
        int n = 0;
        while (n < ((PafData[])object).length) {
            String string = object[n].getIdentifier();
            String string2 = object[n].getValue();
            this.setValue(defaultGTreeModel, string, (Object)string2);
            ++n;
        }
    }

    protected static GTreePath prependNode(GTreeNode gTreeNode, GTreePath gTreePath) {
        GTreeNode[] gTreeNodeArray = new GTreeNode[gTreePath.getPath().length + 1];
        gTreeNodeArray[0] = gTreeNode;
        System.arraycopy(gTreePath.getPath(), 0, gTreeNodeArray, 1, gTreePath.getPath().length);
        DefaultGTreePath defaultGTreePath = new DefaultGTreePath(gTreeNodeArray);
        return defaultGTreePath;
    }

    public boolean setValue(String string, String string2) {
        return this.setValue(this.tree_, string, (Object)string2);
    }

    public boolean setValue(DefaultGTreeModel defaultGTreeModel, String string, Object object) {
        boolean bl = true;
        ParamfileTreePath paramfileTreePath = new ParamfileTreePath(string);
        StringBuffer stringBuffer = new StringBuffer();
        if (!paramfileTreePath.isValidPath()) {
            bl = false;
        } else {
            GTreeNode[] gTreeNodeArray = paramfileTreePath.getPath();
            int n = gTreeNodeArray.length;
            int n2 = 0;
            if (gTreeNodeArray[n2].getValue().equalsIgnoreCase("PLATFORM")) {
                if (++n2 < n) {
                    if (gTreeNodeArray[n2].getValue().equals(this.getSystemProperty("os.name"))) {
                        if (++n2 < n) {
                            while (n2 < n) {
                                paramfileTreePath = new ParamfileTreePath(gTreeNodeArray[n2].getValue());
                                stringBuffer.append("." + gTreeNodeArray[n2].getValue());
                                ++n2;
                            }
                            paramfileTreePath = new ParamfileTreePath(stringBuffer.toString());
                            this.setValue(defaultGTreeModel, paramfileTreePath, object);
                            bl = true;
                        }
                    } else {
                        bl = false;
                    }
                }
            } else {
                this.setValue(defaultGTreeModel, paramfileTreePath, object);
                bl = true;
            }
        }
        return bl;
    }

    public String getSystemProperty(String string) {
        return System.getProperty(string).replaceAll(" ", "");
    }

    public boolean setValue(String string, int n) {
        return this.setValue(string, "" + n);
    }

    public boolean setValue(String string, boolean bl) {
        String string2 = bl ? "true" : "false";
        return this.setValue(string, string2);
    }

    public boolean set(String string, Object object) {
        return this.setValue(this.tree_, string, object);
    }

    public void setValue(DefaultGTreeModel defaultGTreeModel, GTreePath gTreePath, Object object) {
        GTreePath gTreePath2 = OHSConfig.prependNode(defaultGTreeModel.getRoot(), gTreePath);
        defaultGTreeModel.addPath(gTreePath2);
        GTreeNode gTreeNode = defaultGTreeModel.getNode(gTreePath2);
        gTreeNode.set(object);
    }

    public void removeKeyword(String string) {
        ParamfileTreePath paramfileTreePath = new ParamfileTreePath(string);
        GTreeNode gTreeNode = this.getNode(paramfileTreePath);
        if (gTreeNode != null) {
            gTreeNode.set(null);
            GTreeNode gTreeNode2 = gTreeNode.getParent();
            if (gTreeNode2 != null) {
                gTreeNode2.removeChild(gTreeNode);
            }
        }
    }

    public Map subTreeToMap(String string) {
        Object object;
        GTreeNode gTreeNode = null;
        if (string == null) {
            gTreeNode = this.tree_.getRoot();
        } else {
            object = new ParamfileTreePath(string);
            gTreeNode = this.getNode((GTreePath)object);
        }
        object = new HashMap();
        if (gTreeNode != null) {
            object = this.saveSubTreeToMap((Map)object, gTreeNode);
        }
        return object;
    }

    public GTreeNode saveSubTreeToPafFile(String string, String string2) {
        Object object;
        GTreeNode gTreeNode = null;
        if (string2 == null) {
            gTreeNode = this.tree_.getRoot();
        } else {
            object = new ParamfileTreePath(string2);
            gTreeNode = this.getNode((GTreePath)object);
        }
        object = new StringBuffer();
        if (gTreeNode != null) {
            object = this.saveSubTreeToString((StringBuffer)object, gTreeNode);
        }
        this.writeConfigFile(string, (StringBuffer)object);
        return gTreeNode;
    }

    private void writeConfigFile(String string, StringBuffer stringBuffer) {
        if (string == null) {
            stdlog_.error((Object)"Config file name is null");
        } else {
            try {
                if (stringBuffer != null) {
                    PrintWriter printWriter = new PrintWriter(new FileWriter(string));
                    String string2 = FILE_HDR + "#!--- " + TextUtils.currentISODateTime() + " (UT)\n\n" + stringBuffer.toString();
                    printWriter.println(string2);
                    printWriter.close();
                }
            }
            catch (IOException iOException) {
                stdlog_.error((Object)("File \"" + string + "\" not writed"), (Throwable)iOException);
            }
        }
    }

    protected Map saveSubTreeToMap(Map map, GTreeNode gTreeNode) {
        if (gTreeNode != null) {
            Object object;
            String string = gTreeNode.getValue();
            if (string != null && gTreeNode.isLeaf()) {
                object = gTreeNode.getPathName();
                map.put(object, string);
            }
            object = gTreeNode.getChildren();
            while (object.hasMoreElements()) {
                GTreeNode gTreeNode2 = (GTreeNode)object.nextElement();
                map = this.saveSubTreeToMap(map, gTreeNode2);
            }
        }
        return map;
    }

    public StringBuffer saveSubTreeToString(StringBuffer stringBuffer, GTreeNode gTreeNode) {
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer();
        }
        if (gTreeNode != null) {
            Object object;
            String string = gTreeNode.getValue();
            if (string != null && gTreeNode.isLeaf()) {
                object = gTreeNode.getPathName();
                stringBuffer.append((String)object);
                stringBuffer.append("  \"");
                stringBuffer.append((Object)string);
                stringBuffer.append("\"\n");
            }
            object = gTreeNode.getChildren();
            while (object.hasMoreElements()) {
                GTreeNode gTreeNode2 = (GTreeNode)object.nextElement();
                stringBuffer = this.saveSubTreeToString(stringBuffer, gTreeNode2);
            }
        }
        return stringBuffer;
    }

    public void removeSubTree(String string) {
        ParamfileTreePath paramfileTreePath = new ParamfileTreePath(string);
        GTreeNode gTreeNode = this.getNode(paramfileTreePath);
        if (gTreeNode != null) {
            this.removeNodeChildren(gTreeNode);
        }
    }

    public void removeNodeChildren(GTreeNode gTreeNode) {
        if (gTreeNode != null) {
            GTreeNode gTreeNode2;
            Enumeration enumeration = gTreeNode.getChildren();
            while (enumeration.hasMoreElements()) {
                gTreeNode2 = (GTreeNode)enumeration.nextElement();
                this.removeNodeChildren(gTreeNode2);
            }
            gTreeNode.set(null);
            gTreeNode2 = gTreeNode.getParent();
            gTreeNode2.removeChild(gTreeNode);
        }
    }

    public GTreeNode getNode(String string) {
        ParamfileTreePath paramfileTreePath = new ParamfileTreePath(string);
        GTreeNode gTreeNode = null;
        gTreeNode = paramfileTreePath.isValidPath() ? this.getNode(paramfileTreePath) : null;
        return gTreeNode;
    }

    public GTreeNode getNode(GTreePath gTreePath) {
        gTreePath = OHSConfig.prependNode(this.tree_.getRoot(), gTreePath);
        return this.tree_.getNode(gTreePath);
    }

    public String getValue(String string) {
        String string2 = "";
        GTreeNode gTreeNode = this.getNode(string);
        if (gTreeNode != null && gTreeNode.getValue() != null) {
            string2 = gTreeNode.getValue();
        }
        return string2;
    }

    public int getInteger(String string) throws NumberFormatException {
        String string2 = this.getValue(string);
        return Integer.parseInt(string2);
    }

    public int getInteger(String string, int n) {
        int n2 = n;
        try {
            n2 = this.getInteger(string);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = n;
        }
        return n2;
    }

    public boolean getBoolean(String string) {
        String string2 = this.getValue(string);
        return string2.equalsIgnoreCase("T") || string2.equalsIgnoreCase("Y") || string2.equalsIgnoreCase("TRUE") || string2.equals("1");
    }

    public Object get(String string) {
        Object object = null;
        GTreeNode gTreeNode = this.getNode(string);
        if (gTreeNode != null) {
            object = gTreeNode.get();
        }
        return object;
    }

    public OHSConfig getSubConfig(String string) {
        OHSConfig oHSConfig = null;
        GTreeNode gTreeNode = this.getNode(string);
        if (gTreeNode != null) {
            oHSConfig = new OHSConfig(gTreeNode);
        }
        return oHSConfig;
    }

    public OHSConfig getSuperConfig() {
        OHSConfig oHSConfig = null;
        GTreeNode gTreeNode = this.tree_.getRoot().getParent();
        if (gTreeNode != null) {
            oHSConfig = new OHSConfig(gTreeNode);
        }
        return oHSConfig;
    }

    public GTreeModel getTree() {
        return this.tree_;
    }

    public String toString() {
        return this.tree_.toString();
    }

    public String getBaseDir() {
        return this.getValue("DIR.BASE");
    }

    public String getHomeDir() {
        return this.getValue("DIR.HOME");
    }

    public String getConfigDir() {
        return this.getValue("DIR.CONFIG");
    }

    protected String prependBase(String string) {
        boolean bl;
        String string2 = this.getValue(string);
        String string3 = this.getValue("USER.OVERRIDE." + string);
        boolean bl2 = bl = string3.length() > 0;
        if (bl) {
            string2 = string3;
        }
        String string4 = null;
        if (string2 != null && string2.length() > 0) {
            File file;
            if (string2.indexOf("~/") == 0) {
                string2 = string2.substring(1);
                string2 = this.getHomeDir() + string2;
            }
            if (!(file = new File(string2)).isAbsolute()) {
                String string5 = null;
                string5 = bl ? this.getHomeDir() : this.getBaseDir();
                file = new File(string5 + File.separator + string2);
            }
            string4 = file.getAbsolutePath();
        }
        return string4;
    }

    public String evalPropertyFromParamfile(String string, Paramfile paramfile) {
        String string2 = "";
        String string3 = this.getValue(string);
        if (string3.length() > 0) {
            string2 = paramfile.getValue(string3);
        }
        if (string2.length() == 0) {
            int n = 1;
            do {
                string3 = this.getValue(string + "." + n);
                ++n;
                if (string3.length() <= 0) continue;
                string2 = paramfile.getValue(string3);
            } while (string2.length() == 0 && string3.length() > 0);
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

