/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.dfs;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.eso.ohs.core.utilities.OHSConfig;
import org.eso.ohs.core.utilities.Paramfile;
import org.eso.ohs.core.utilities.ReflectionException;
import org.eso.ohs.core.utilities.TextUtils;
import org.eso.ohs.dfs.BusinessObject;
import org.eso.ohs.dfs.BusinessVisitor;
import org.eso.ohs.instruments.Instrument;
import org.eso.ohs.instruments.InstrumentConstraintConfig;
import org.eso.ohs.instruments.InstrumentList;
import org.eso.ohs.instruments.ParamFileParameter;

public class ConstraintSet
extends BusinessObject {
    static final long serialVersionUID = -7526074509242804567L;
    private float airmass_ = 5.0f;
    private float fractionalLunarIllumination_ = 1.0f;
    private int moonAngularDistance_ = 30;
    private float seeing_ = 2.0f;
    private String skyTransparency_ = validSkyTransparency_[0];
    private int telTemp_ = 0;
    private String waterVapour_ = validWaterVapour_[0];
    private String description_;
    private float strehlRatio_ = 0.0f;
    private String baseLine;
    private static final String[] validSkyTransparency_ = new String[]{"Photometric", "Clear", "Variable, thin cirrus", "Variable, thick cirrus"};
    private static final String[] skyTransparencyDbRange = new String[]{"1PHO", "2CLR", "3THN", "4THK"};
    private static String[] validWaterVapour_ = new String[]{"Low", "Median", "Any"};
    private static String strehlRatioParam = null;
    public static final String strehlRatioParamKeyword = "CONSTRAINTSET.STREHLRATIO.PARAM";

    ConstraintSet() {
    }

    public static String[] getValidSkyTransparency() {
        String[] stringArray = new String[validSkyTransparency_.length];
        System.arraycopy(validSkyTransparency_, 0, stringArray, 0, stringArray.length);
        return stringArray;
    }

    public static String[] getDbSkyTransparency() {
        String[] stringArray = new String[skyTransparencyDbRange.length];
        System.arraycopy(skyTransparencyDbRange, 0, stringArray, 0, stringArray.length);
        return stringArray;
    }

    public static String fromDbSkyTransparency(String string) {
        int n = 0;
        while (n < skyTransparencyDbRange.length) {
            if (skyTransparencyDbRange[n].equals(string)) {
                return validSkyTransparency_[n];
            }
            ++n;
        }
        return null;
    }

    public String toDbSkyTransparency(String string) {
        int n = 0;
        while (n < validSkyTransparency_.length) {
            if (validSkyTransparency_[n].equals(string)) {
                return skyTransparencyDbRange[n];
            }
            ++n;
        }
        return null;
    }

    public float getAirmass() {
        return this.airmass_;
    }

    public float getFractionalLunarIllumination() {
        return this.fractionalLunarIllumination_;
    }

    public String getSkyTransparency() {
        if (this.skyTransparency_ == null) {
            return "";
        }
        return this.skyTransparency_;
    }

    public int getMoonAngularDistance() {
        return this.moonAngularDistance_;
    }

    public float getSeeing() {
        return this.seeing_;
    }

    public int getTelTemp() {
        return this.telTemp_;
    }

    public String getWaterVapour() {
        if (this.waterVapour_ == null) {
            return "";
        }
        return this.waterVapour_;
    }

    public String getDescription() {
        if (this.description_ == null) {
            return "";
        }
        return this.description_;
    }

    public float getStrehlRatio() {
        return this.strehlRatio_;
    }

    public void setStrehlRatio(float f) {
        if ((double)f >= 100.0) {
            throw new IllegalArgumentException("strehl ratio not in range 0.0 <= sr < 100.0");
        }
        this.strehlRatio_ = f;
        this.firePropertyChangeEvent();
    }

    public void setAirmass(float f) {
        if (f < 1.0f || f > 5.0f) {
            throw new IllegalArgumentException("airmass not in range 1 to 5");
        }
        this.airmass_ = f;
        this.firePropertyChangeEvent();
    }

    public void setDescription(String string) {
        this.description_ = string;
        this.firePropertyChangeEvent();
    }

    public void setFractionalLunarIllumination(float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("fractional lunar illumination not in range 0 to 1");
        }
        this.fractionalLunarIllumination_ = f;
        this.firePropertyChangeEvent();
    }

    public void setMoonAngularDistance(int n) {
        if (n < 0 || n > 180) {
            throw new IllegalArgumentException("moon angular distance not in range 0 to 180");
        }
        this.moonAngularDistance_ = n;
        this.firePropertyChangeEvent();
    }

    public void setSeeing(float f) {
        if ((double)f < 0.2 || (double)f > 2.0) {
            throw new IllegalArgumentException("seeing/image quality not in range 0.2 to 2.0");
        }
        this.seeing_ = f;
        this.firePropertyChangeEvent();
    }

    public void setTelTemp(int n) {
        this.telTemp_ = n;
        this.firePropertyChangeEvent();
    }

    public void setWaterVapour(String string) {
        int n = 0;
        while (n < validWaterVapour_.length) {
            if (validWaterVapour_[n].equals(string)) {
                this.waterVapour_ = string;
                this.firePropertyChangeEvent();
                return;
            }
            ++n;
        }
        throw new IllegalArgumentException("water vapour unrecognised: " + string);
    }

    public void setSkyTransparency(String string) {
        int n = 0;
        while (n < validSkyTransparency_.length) {
            if (validSkyTransparency_[n].equals(string)) {
                this.skyTransparency_ = string;
                this.firePropertyChangeEvent();
                return;
            }
            ++n;
        }
        throw new IllegalArgumentException("sky transparency not recognised: " + string);
    }

    public static String getDisplayName() {
        return "ConSet";
    }

    public static String getSuffix() {
        return "cs";
    }

    public String paramString() {
        return super.paramString() + ",airmass=" + this.airmass_ + ",lunarIllumin=" + this.fractionalLunarIllumination_ + ",moonDist=" + this.moonAngularDistance_ + ",seeing=" + this.seeing_ + ",skyTransp=" + this.skyTransparency_ + ",telescopeTemp=" + this.telTemp_ + ",strehlRatio=" + this.strehlRatio_ + ",waterVapour=" + this.waterVapour_ + ",description=<" + this.description_ + ">";
    }

    public String toReportString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ConSet: " + this.getName() + "\n");
        stringBuffer.append("Seeing                        : " + this.getSeeing() + "\n");
        stringBuffer.append("Sky transparency              : " + this.getSkyTransparency() + "\n");
        stringBuffer.append("Air mass                      : " + this.getAirmass() + "\n");
        stringBuffer.append("Strehl Ratio                  : " + this.getStrehlRatio() + "\n");
        stringBuffer.append("Fractional lunar illumination : " + this.getFractionalLunarIllumination() + "\n");
        stringBuffer.append("Moon angular distance         : " + this.getMoonAngularDistance() + "\n");
        if (this.description_ != null && this.description_.length() > 0) {
            stringBuffer.append("User Com. : ");
            String[] stringArray = TextUtils.splitString(this.description_, 60);
            int n = 0;
            while (n < stringArray.length) {
                if (n != 0) {
                    stringBuffer.append("            ");
                }
                stringBuffer.append(stringArray[n] + "\n");
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public String toReportString(String string, float f) {
        Instrument instrument = InstrumentList.getInstance().getInstrument(string, f);
        InstrumentConstraintConfig[] instrumentConstraintConfigArray = instrument.getCsConfList();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = 0;
        while (n < instrumentConstraintConfigArray.length) {
            hashMap.put(instrumentConstraintConfigArray[n].getName(), instrumentConstraintConfigArray[n].getName());
            ++n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ConSet: " + this.getName() + "\n");
        if (hashMap.containsKey("Seeing")) {
            stringBuffer.append("Seeing                        : " + this.getSeeing() + "\n");
        }
        if (hashMap.containsKey("SkyTransparency")) {
            stringBuffer.append("Sky transparency              : " + this.getSkyTransparency() + "\n");
        }
        if (hashMap.containsKey("Airmass")) {
            stringBuffer.append("Air mass                      : " + this.getAirmass() + "\n");
        }
        if (hashMap.containsKey("StrehlRatio")) {
            stringBuffer.append("Strehl Ratio                  : " + this.getStrehlRatio() + "\n");
        }
        if (hashMap.containsKey("FractionalLunarIllumination")) {
            stringBuffer.append("Fractional lunar illumination : " + this.getFractionalLunarIllumination() + "\n");
        }
        if (hashMap.containsKey("MoonAngularDistance")) {
            stringBuffer.append("Moon angular distance         : " + this.getMoonAngularDistance() + "\n");
        }
        String string2 = null;
        if (hashMap.containsKey("Baseline")) {
            string2 = this.getBaseline();
            if (string2 == null || string2.length() <= 0) {
                string2 = "NONE";
            }
            stringBuffer.append("Baseline                      : " + string2 + "\n");
        }
        if (this.description_ != null && this.description_.length() > 0) {
            stringBuffer.append("User Com. : ");
            String[] stringArray = TextUtils.splitString(this.description_, 60);
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (n2 != 0) {
                    stringBuffer.append("            ");
                }
                stringBuffer.append(stringArray[n2] + "\n");
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    public String verify() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.airmass_ < 1.0f || this.airmass_ > 5.0f) {
            stringBuffer.append("airmass not in range 1 to 5\n");
        }
        if (this.fractionalLunarIllumination_ < 0.0f || this.fractionalLunarIllumination_ > 1.0f) {
            stringBuffer.append("fractional lunar illumination not in range 0 to 1\n");
        }
        if (this.moonAngularDistance_ < 0 || this.moonAngularDistance_ > 180) {
            stringBuffer.append("moon angular distance not in range 0 to 180\n");
        }
        if ((double)this.seeing_ < 0.2 || (double)this.seeing_ > 2.0) {
            stringBuffer.append("seeing/image quality not in range 0.2 to 2.0\n");
        }
        return stringBuffer.toString();
    }

    public String verifyBO() {
        return this.verify();
    }

    public Object accept(BusinessVisitor businessVisitor, Object object) {
        return businessVisitor.visit(this, object);
    }

    public void updateFromParamFileParameter(ParamFileParameter paramFileParameter) throws IllegalArgumentException {
        if (!paramFileParameter.getValue().equals("NODEFAULT")) {
            Paramfile paramfile = paramFileParameter.getParamfile();
            this.updateFromParamfile(paramfile);
        }
    }

    public void updateFromParamfile(Paramfile paramfile) throws IllegalArgumentException {
        float f;
        IllegalArgumentException illegalArgumentException = null;
        this.suspendPropertyChangeEvents();
        String string = OHSConfig.getInstance().evalPropertyFromParamfile(strehlRatioParamKeyword, paramfile).trim();
        string = string.trim();
        if (string.length() > 0) {
            try {
                f = Float.valueOf(string).floatValue();
                this.setStrehlRatio(f);
            }
            catch (NumberFormatException numberFormatException) {
                illegalArgumentException = new IllegalArgumentException("Invalid Strehl Ratio value: " + string);
            }
        }
        if ((string = OHSConfig.getInstance().evalPropertyFromParamfile("CONSTRAINTSET.AIRMASS.PARAM", paramfile).trim()).length() > 0) {
            try {
                f = Float.valueOf(string).floatValue();
                this.setAirmass(f);
            }
            catch (NumberFormatException numberFormatException) {
                illegalArgumentException = new IllegalArgumentException("Invalid Air Mass value: " + string);
            }
        }
        if ((string = OHSConfig.getInstance().evalPropertyFromParamfile("CONSTRAINTSET.FLI.PARAM", paramfile).trim()).length() > 0) {
            try {
                float f2 = Float.valueOf(string).floatValue();
                this.setFractionalLunarIllumination(f2);
            }
            catch (NumberFormatException numberFormatException) {
                illegalArgumentException = new IllegalArgumentException("Invalid FLI value: " + string);
            }
        }
        if ((string = OHSConfig.getInstance().evalPropertyFromParamfile("CONSTRAINTSET.MOON.PARAM", paramfile).trim()).length() > 0) {
            try {
                int n = Integer.valueOf(string);
                this.setMoonAngularDistance(n);
            }
            catch (NumberFormatException numberFormatException) {
                illegalArgumentException = new IllegalArgumentException("Invalid Moon Distance value: " + string);
            }
        }
        if ((string = OHSConfig.getInstance().evalPropertyFromParamfile("CONSTRAINTSET.SEEING.PARAM", paramfile).trim()).length() > 0) {
            try {
                float f3 = Float.valueOf(string).floatValue();
                this.setSeeing(f3);
            }
            catch (NumberFormatException numberFormatException) {
                illegalArgumentException = new IllegalArgumentException("Invalid Seeing value: " + string);
            }
        }
        if ((string = OHSConfig.getInstance().evalPropertyFromParamfile("CONSTRAINTSET.SKY.PARAM", paramfile).trim()).length() > 0) {
            this.setSkyTransparency(string);
        }
        if ((string = OHSConfig.getInstance().evalPropertyFromParamfile("CONSTRAINTSET.TELTEMP.PARAM", paramfile).trim()).length() > 0) {
            try {
                int n = Integer.valueOf(string);
                this.setTelTemp(n);
            }
            catch (NumberFormatException numberFormatException) {
                illegalArgumentException = new IllegalArgumentException("Invalid Telescope Tempurature value: " + string);
            }
        }
        if ((string = OHSConfig.getInstance().evalPropertyFromParamfile("CONSTRAINTSET.VAPOUR.PARAM", paramfile).trim()).length() > 0) {
            this.setWaterVapour(string);
        }
        this.resumePropertyChangeEvents();
        this.firePropertyChangeEvent();
        if (illegalArgumentException != null) {
            throw illegalArgumentException;
        }
    }

    public void postProecess() {
    }

    public String getBaseline() {
        return this.baseLine;
    }

    public void setBaseline(String string) {
        this.baseLine = string;
        this.firePropertyChangeEvent();
    }

    public boolean equals(ConstraintSet constraintSet, String[] stringArray) throws ReflectionException {
        boolean bl = true;
        Class<?> clazz = this.getClass();
        int n = 0;
        if (n < stringArray.length) {
            String string = stringArray[n];
            try {
                Method method = clazz.getMethod("get" + string, new Class[0]);
                Object object = method.invoke((Object)this, new Object[0]);
                Object object2 = method.invoke((Object)constraintSet, new Object[0]);
                if (!object.equals(object2)) {
                    bl = false;
                }
                return bl;
            }
            catch (SecurityException securityException) {
                throw new ReflectionException(securityException.toString());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new ReflectionException(noSuchMethodException.toString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ReflectionException(illegalArgumentException.toString());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ReflectionException(illegalAccessException.toString());
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new ReflectionException(invocationTargetException.toString());
            }
        }
        return bl;
    }
}

