/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.dfs;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.eso.ohs.core.utilities.ObjectIOException;
import org.eso.ohs.dfs.BusinessObject;
import org.eso.ohs.dfs.BusinessVisitor;
import org.eso.ohs.persistence.Config;
import org.eso.ohs.phrs.common.CycleSteps;

public class Cycle
extends BusinessObject
implements Comparable {
    private String cycleLabel_ = "";
    private int period_ = -1;
    private String description_ = "";
    private int step_id_ = -1;
    private Hashtable telInstTable_ = new Hashtable();
    private String[] countries_ = new String[0];
    private String[] interferometricInstruments_ = new String[0];
    private Hashtable baselines_ = new Hashtable();
    private Hashtable lambdacouples_ = new Hashtable();
    private String[] specialInstruments_ = new String[0];
    private String[] validMonths_ = new String[0];
    private String[] runcodeValues_ = new String[0];
    private String[] altcodeValues_ = new String[0];
    private String[] obsModeValues_ = new String[0];
    private String[] moonList_ = new String[0];
    private Integer[] periodList_ = new Integer[0];
    private String[] seeingValues_ = new String[0];
    private String[] skyTransparencyValues_ = new String[0];
    private String[] subCategoryCodes_ = new String[0];
    private String[] equinox_ = new String[0];
    private int cycleId_ = -1;
    private String stepLabel_ = "";
    private CycleSteps steps_ = new CycleSteps();
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$dfs$Cycle == null ? (class$org$eso$ohs$dfs$Cycle = Cycle.class$("org.eso.ohs.dfs.Cycle")) : class$org$eso$ohs$dfs$Cycle));
    private Hashtable telescopesInstruments_;
    static /* synthetic */ Class class$org$eso$ohs$dfs$Cycle;

    public int getCycleId() {
        long l = Config.getCfg().uniqueToTableId(this.getId());
        return (int)l;
    }

    public void setLabel(String string) {
        this.cycleLabel_ = string;
    }

    public String getLabel() {
        return this.cycleLabel_;
    }

    public void setPeriod(int n) {
        this.period_ = n;
    }

    public int getPeriod() {
        return this.period_;
    }

    public void setDescription(String string) {
        this.description_ = string;
    }

    public String getDescription() {
        return this.description_;
    }

    public void setStepId(int n) {
        this.step_id_ = n;
        this.initializeStepLabel(this.step_id_);
    }

    public int getStepId() {
        return this.step_id_;
    }

    public String toString() {
        return this.cycleLabel_;
    }

    public Object accept(BusinessVisitor businessVisitor, Object object) {
        return null;
    }

    public int compareTo(Object object) {
        if (!(object instanceof Cycle)) {
            throw new ClassCastException("Not a cycle obj");
        }
        Cycle cycle = (Cycle)object;
        int n = (int)(this.getId() - cycle.getId());
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof Cycle) {
            Cycle cycle = (Cycle)object;
            return cycle.getId() == this.getId();
        }
        return false;
    }

    public void postProecess() {
    }

    public String getStepLabel() {
        return this.stepLabel_;
    }

    public void setStepLabel(String string) {
        this.stepLabel_ = string;
        this.initializeStepId(this.stepLabel_);
    }

    private void initializeStepLabel(int n) {
        Integer n2 = new Integer(n);
        this.stepLabel_ = this.steps_.fromDatabaseData(n2);
    }

    private void initializeStepId(String string) {
        Integer n = (Integer)this.steps_.toDatabaseData(string);
        this.step_id_ = n;
    }

    public String[] getBaselines(String string) {
        String[] stringArray = (String[])this.baselines_.get(string);
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public void setBaselines(String string, String[] stringArray) {
        this.baselines_.put(string, stringArray);
    }

    public String[] getAllBaselines() {
        Collection collection = this.baselines_.values();
        return this.getArrayFromCollection(collection);
    }

    public void setBaselinesTable(Hashtable hashtable) {
        this.baselines_ = hashtable;
    }

    public Hashtable getTelescopesInstrumentsTable() {
        return this.telInstTable_;
    }

    public void setTelescopesInstrumentsTable(Hashtable hashtable) {
        this.telInstTable_ = hashtable;
    }

    public Hashtable getBaselinesTable() {
        return this.baselines_;
    }

    public String[] getEquinox() {
        return this.equinox_;
    }

    public void setEquinox(String[] stringArray) {
        this.equinox_ = stringArray;
    }

    public String[] getAllInstruments() {
        Collection collection = this.telInstTable_.values();
        return this.getArrayFromCollection(collection);
    }

    private String[] getArrayFromCollection(Collection collection) {
        String[] stringArray;
        Vector<String> vector = new Vector<String>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                vector.add(string);
                ++n;
            }
        }
        stringArray = vector.toArray(new String[vector.size()]);
        return stringArray;
    }

    public String[] getInstruments(String string) {
        String[] stringArray = (String[])this.telInstTable_.get(string);
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public void setInstruments(String string, String[] stringArray) throws ObjectIOException {
        String[] stringArray2 = this.getAllTelescopes();
        Vector vector = new Vector();
        CollectionUtils.addAll(vector, (Object[])stringArray);
        int n = 0;
        while (n < stringArray2.length) {
            String string2 = stringArray2[n];
            if (string2.equals(string)) break;
            Vector vector2 = new Vector();
            String[] stringArray3 = this.getInstruments(string2);
            int n2 = 0;
            while (n2 < stringArray3.length) {
                if (vector.contains(stringArray3[n2])) {
                    String string3 = "Attempting to add instrument " + stringArray3[n2] + " in telescope " + string + "\n Instrument already present in telescope " + string2;
                    throw new ObjectIOException(string3);
                }
                ++n2;
            }
            ++n;
        }
        this.telInstTable_.put(string, stringArray);
    }

    public String[] getInterferometricInstruments() {
        return this.interferometricInstruments_;
    }

    public void setInterferometricInstruments(String[] stringArray) {
        this.interferometricInstruments_ = stringArray;
    }

    public String[] getLambdacouples(String string) {
        String[] stringArray = (String[])this.lambdacouples_.get(string);
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public void setLambdacouples(String string, String[] stringArray) {
        this.lambdacouples_.put(string, stringArray);
    }

    public String[] getAllLambdacouples() {
        Collection collection = this.lambdacouples_.values();
        return this.getArrayFromCollection(collection);
    }

    public void setLambdaCouplesTable(Hashtable hashtable) {
        this.lambdacouples_ = hashtable;
    }

    public Hashtable getLambdacouplesTable() {
        return this.lambdacouples_;
    }

    public String[] getMoonList() {
        return this.moonList_;
    }

    public void setMoonList(String[] stringArray) {
        this.moonList_ = stringArray;
    }

    public String[] getObsModeValues() {
        return this.obsModeValues_;
    }

    public void setObsModeValues(String[] stringArray) {
        this.obsModeValues_ = stringArray;
    }

    public Integer[] getPeriodList() {
        return this.periodList_;
    }

    public String[] getPeriodListString() {
        Integer[] integerArray = this.getPeriodList();
        int n = integerArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = integerArray[n2].toString();
            ++n2;
        }
        return stringArray;
    }

    public void setPeriodList(Integer[] integerArray) {
        this.periodList_ = integerArray;
    }

    public String[] getRuncodeValues() {
        return this.runcodeValues_;
    }

    public void setRuncodeValues(String[] stringArray) {
        this.runcodeValues_ = stringArray;
    }

    public String[] getSeeingValues() {
        return this.seeingValues_;
    }

    public void setSeeingValues(String[] stringArray) {
        this.seeingValues_ = stringArray;
    }

    public String[] getSkyTransparencyValues() {
        return this.skyTransparencyValues_;
    }

    public void setSkyTransparencyValues(String[] stringArray) {
        this.skyTransparencyValues_ = stringArray;
    }

    public String[] getSpecialInstruments() {
        return this.specialInstruments_;
    }

    public void setSpecialInstruments(String[] stringArray) {
        this.specialInstruments_ = stringArray;
    }

    public String[] getSubCategoryCodes() {
        return this.subCategoryCodes_;
    }

    public void setSubCategoryCodes(String[] stringArray) {
        this.subCategoryCodes_ = stringArray;
    }

    public String[] getAllTelescopes() {
        String[] stringArray;
        Vector<String[]> vector = new Vector<String[]>();
        Enumeration enumeration = this.telInstTable_.keys();
        while (enumeration.hasMoreElements()) {
            stringArray = (String[])enumeration.nextElement();
            if (vector.contains(stringArray)) continue;
            vector.add(stringArray);
        }
        stringArray = vector.toArray(new String[vector.size()]);
        return stringArray;
    }

    public void setTelescopes(String[] stringArray) {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            String[] stringArray2 = this.getInstruments(string);
            this.telInstTable_.put(string, stringArray2);
            ++n2;
        }
    }

    public String[] getValidMonths() {
        return this.validMonths_;
    }

    public void setValidMonths(String[] stringArray) {
        this.validMonths_ = stringArray;
    }

    public String[] getCountries() {
        return this.countries_;
    }

    public void setCountries(String[] stringArray) {
        this.countries_ = stringArray;
    }

    public String[] getAltcodeValues() {
        return this.altcodeValues_;
    }

    public void setAltcodeValues(String[] stringArray) {
        this.altcodeValues_ = stringArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

