/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.dfs;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.CRC32;
import org.apache.log4j.Logger;
import org.eso.ohs.dfs.FindingChartCache;
import org.eso.ohs.dfs.ObservingRun;
import org.eso.ohs.dfs.SimpleStorableObject;

public class FindingChart
extends SimpleStorableObject {
    static final long serialVersionUID = -4182388435966734083L;
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$dfs$FindingChart == null ? (class$org$eso$ohs$dfs$FindingChart = FindingChart.class$("org.eso.ohs.dfs.FindingChart")) : class$org$eso$ohs$dfs$FindingChart));
    private byte[] fcData;
    private String fcName;
    private String fcNotes;
    private String fcType = "jpg";
    private long checkSum;
    private transient ObservingRun obsRun;
    private transient String destDirectory;
    static /* synthetic */ Class class$org$eso$ohs$dfs$FindingChart;

    public FindingChart(FindingChart findingChart) {
        this.fcName = findingChart.getFcName();
        this.obsRun = findingChart.getObsRun();
        this.checkSum = findingChart.getCheckSum();
        this.fcType = findingChart.getFcType();
        this.fcNotes = findingChart.getFcNotes();
    }

    public FindingChart() {
    }

    public FindingChart(ObservingRun observingRun, byte[] byArray, String string, String string2) throws IOException {
        this.fcName = string;
        this.fcData = byArray;
        this.destDirectory = string2;
        this.obsRun = observingRun;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        this.checkSum = cRC32.getValue();
    }

    public void writeFindingChart(long l) throws IOException {
        File file = new File(this.destDirectory + File.separator + l + "." + this.fcType);
        if (!file.exists()) {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(this.fcData);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        this.setFcData(null);
    }

    public String getFcName() {
        if (this.fcName == null) {
            return "";
        }
        return this.fcName;
    }

    public String getFcType() {
        if (this.fcType == null) {
            return "";
        }
        return this.fcType;
    }

    public void setFcData(byte[] byArray) {
        this.fcData = byArray;
    }

    public void setFcName(String string) {
        this.fcName = string;
    }

    public void setFcType(String string) {
        this.fcType = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ID \n" + this.getId());
        stringBuffer.append("FC Name \n" + this.getFcName());
        stringBuffer.append("CheckSum \n" + this.checkSum);
        return stringBuffer.toString();
    }

    public long getCheckSum() {
        return this.checkSum;
    }

    public void setCheckSum(long l) {
        this.checkSum = l;
    }

    public byte[] getFcDataLocal(String string) throws IOException {
        if (this.fcData == null || this.fcData.length <= 0) {
            return FindingChartCache.getFindingChartData(this.getCheckSum(), this.getFileName(string));
        }
        return this.fcData;
    }

    public String getFileName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(File.separator);
        stringBuffer.append(this.getCheckSum());
        stringBuffer.append(".");
        stringBuffer.append(this.fcType);
        return stringBuffer.toString();
    }

    public byte[] getFcData() {
        return this.fcData;
    }

    public ObservingRun getObsRun() {
        return this.obsRun;
    }

    public void setObsRun(ObservingRun observingRun) {
        this.obsRun = observingRun;
    }

    public void postProecess() {
    }

    public String getFcNotes() {
        if (this.fcNotes == null) {
            return "";
        }
        return this.fcNotes;
    }

    public void setFcNotes(String string) {
        this.fcNotes = string;
    }

    public boolean equals(FindingChart findingChart) {
        return this.getCheckSum() == findingChart.getCheckSum() && this.getFcName().compareTo(findingChart.getFcName()) == 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

