/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.dfs;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eso.ohs.core.docview.datatrans.AdaptorFactory;
import org.eso.ohs.core.docview.datatrans.ObjectAdaptor;
import org.eso.ohs.core.utilities.Convert;
import org.eso.ohs.core.utilities.ReflectionException;
import org.eso.ohs.core.utilities.TextUtils;
import org.eso.ohs.dfs.BusinessObject;
import org.eso.ohs.dfs.BusinessVisitor;
import org.eso.ohs.dfs.CalibrationBlock;
import org.eso.ohs.dfs.ConstraintSet;
import org.eso.ohs.dfs.EphemerisFile;
import org.eso.ohs.dfs.FindingChart;
import org.eso.ohs.dfs.ObservationDescription;
import org.eso.ohs.dfs.ObservingRun;
import org.eso.ohs.dfs.Target;
import org.eso.ohs.dfs.TimeInterval;
import org.eso.ohs.instruments.Instrument;
import org.eso.ohs.instruments.InstrumentConstraintConfig;
import org.eso.ohs.instruments.InstrumentList;
import org.eso.ohs.instruments.Parameter;
import org.eso.ohs.instruments.TemplateSignature;
import org.eso.ohs.instruments.TemplateSignatureFactory;

public class ObservationBlock
extends CalibrationBlock {
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$dfs$ObservationBlock == null ? (class$org$eso$ohs$dfs$ObservationBlock = ObservationBlock.class$("org.eso.ohs.dfs.ObservationBlock")) : class$org$eso$ohs$dfs$ObservationBlock));
    static final long serialVersionUID = -3964774802755871193L;
    private transient Target target_;
    private transient ConstraintSet constraintSet_;
    private TimeInterval[] timeIntervals_;
    private TimeInterval[] stIntervals_;
    private TemplateSignature templateSignature_;
    private String calibrationRequirements_;
    private String obsGrade_ = "";
    private FindingChart[] findingCharts;
    private EphemerisFile ephemerisFile;
    static /* synthetic */ Class class$org$eso$ohs$dfs$ObservationBlock;
    static /* synthetic */ Class class$org$eso$ohs$dfs$Target;

    ObservationBlock() {
    }

    public String getType() {
        return "O";
    }

    public void setType(String string) {
    }

    public void setTimeIntervals(TimeInterval[] timeIntervalArray) {
        this.timeIntervals_ = timeIntervalArray;
        this.firePropertyChangeEvent();
    }

    public TimeInterval[] getTimeIntervals() {
        if (this.timeIntervals_ == null) {
            return new TimeInterval[0];
        }
        return this.timeIntervals_;
    }

    public void setTarget(Target target) {
        if (this.target_ != null) {
            this.target_.removePropertyChangeListener(this.eventRedirector_);
        }
        this.target_ = target;
        if (this.target_ != null) {
            this.target_.addPropertyChangeListener(this.eventRedirector_);
        }
        this.firePropertyChangeEvent();
    }

    public TemplateSignature firstTS() {
        TemplateSignature templateSignature = this.getTemplateSignature();
        if (templateSignature != null) {
            return templateSignature;
        }
        return null;
    }

    public Target getTarget() {
        return this.target_;
    }

    public void setCalibrationRequirements(String string) {
        this.calibrationRequirements_ = string;
        this.firePropertyChangeEvent();
    }

    public String getCalibrationRequirements() {
        if (this.calibrationRequirements_ == null) {
            return "";
        }
        return this.calibrationRequirements_;
    }

    public void setObsGrade(String string) {
        this.obsGrade_ = string;
        this.firePropertyChangeEvent();
    }

    public String getObsGrade() {
        if (this.obsGrade_ == null) {
            return "";
        }
        return this.obsGrade_;
    }

    public void setConstraintSet(ConstraintSet constraintSet) {
        if (this.constraintSet_ != null) {
            this.constraintSet_.removePropertyChangeListener(this.eventRedirector_);
        }
        this.constraintSet_ = constraintSet;
        if (this.constraintSet_ != null) {
            this.constraintSet_.addPropertyChangeListener(this.eventRedirector_);
        }
        this.constraintSet_ = constraintSet;
        this.firePropertyChangeEvent();
    }

    public ConstraintSet getConstraintSet() {
        return this.constraintSet_;
    }

    public void setTemplateSignature(TemplateSignature templateSignature) {
        this.templateSignature_ = templateSignature;
        this.firePropertyChangeEvent(this.templateEvent_);
    }

    public TemplateSignature getTemplateSignature() {
        return this.templateSignature_;
    }

    public String toOBD(boolean bl, boolean bl2, long l, String string) {
        TemplateSignature[] templateSignatureArray;
        String string2 = this.getOBDHeader(string);
        string2 = bl ? this.getOBDHeader(string) + this.getOBDBody(l) : this.getOBDBody(l);
        if (this.getTarget() != null) {
            templateSignatureArray = this.getTarget().getName();
            templateSignatureArray = templateSignatureArray.replace(' ', '-').replace('\t', '-');
            string2 = string2 + "\nOBS.TARG.NAME  \"" + (String)templateSignatureArray + "\"";
        }
        string2 = string2 + "\n";
        string2 = string2 + "\n";
        if (this.getTemplateSignature() != null) {
            string2 = string2 + this.toParameterFormat(this.templateSignature_, 1, bl2);
        }
        if (this.getOd() != null) {
            templateSignatureArray = this.getOd().getSignatures();
            int n = 0;
            while (n < templateSignatureArray.length) {
                string2 = string2 + this.toParameterFormat(templateSignatureArray[n], n + 2, bl2);
                ++n;
            }
        }
        return string2;
    }

    public String getOBDParameterValue(Parameter parameter, boolean bl) {
        String string = null;
        if (this.target_ != null) {
            if (parameter.samePrefix("TEL.TARG.ALPHA") || parameter.samePrefix("TEL.TARG.RA")) {
                string = Convert.convertToXXMMSS(this.target_.getRA());
            } else if (parameter.samePrefix("TEL.TARG.DELTA") || parameter.samePrefix("TEL.TARG.DEC")) {
                string = Convert.convertToXXMMSS(this.target_.getDeclination());
            } else if (parameter.samePrefix("TEL.TARG.EQUINOX")) {
                string = this.target_.getEquinox();
                if (string.length() > 0 && Character.isLetter(string.charAt(0))) {
                    string = string.substring(1);
                }
            } else if (parameter.samePrefix("TEL.TARG.EPOCH")) {
                string = String.valueOf(this.target_.getEpoch());
            } else if (parameter.samePrefix("TEL.TARG.PROPRA") || parameter.samePrefix("TEL.TARG.PMA")) {
                string = String.valueOf(this.target_.getPropRA());
            } else if (parameter.samePrefix("TEL.TARG.PROPDEC") || parameter.samePrefix("TEL.TARG.PMD")) {
                string = String.valueOf(this.target_.getProperDeclination());
            } else if (parameter.samePrefix("TEL.TARG.COLOR")) {
                string = String.valueOf(this.target_.getColor());
            } else if (parameter.samePrefix("TEL.TARG.MAG")) {
                string = String.valueOf(this.target_.getMag());
            } else if (parameter.samePrefix("TEL.TARG.NAME")) {
                string = this.target_.getName();
            }
        }
        string = string == null ? (bl ? parameter.toDisplayOBDParameterString() : parameter.toOBDParameterString()) : (bl ? parameter.toDisplayOBDParameterString(string) : parameter.toOBDParameterString(string));
        return string;
    }

    private static int getKeywordIndex(String string) {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        while (n4 < string.length()) {
            if (Character.isDigit(string.charAt(n4))) {
                n2 = n4;
            }
            ++n4;
        }
        String string2 = string.substring(n2, n2 + 1);
        try {
            n = new Integer(string2);
        }
        catch (NumberFormatException numberFormatException) {}
        return n;
    }

    public String toParameterFormat(TemplateSignature templateSignature, int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getOBDTemplateHeader(templateSignature, n));
        Parameter[] parameterArray = templateSignature.getParamList();
        String string = TextUtils.currentISODateTime();
        int n2 = 0;
        while (n2 < parameterArray.length) {
            if (!parameterArray[n2].isFixed()) {
                if (parameterArray[n2].getParameterName().indexOf("INS.ADM") != -1 && this.getOd().getInstrument().equals("VIMOS")) {
                    stringBuffer.append(this.getVIMOSADMParameterValue(parameterArray[n2], bl, string));
                } else {
                    stringBuffer.append(this.getOBDParameterValue(parameterArray[n2], bl));
                }
            }
            ++n2;
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static String getDisplayName() {
        return "ObsBlock";
    }

    public static String getSuffix() {
        return "ob";
    }

    public BusinessObject[] getBusObjChildren() {
        Vector<BusinessObject> vector = new Vector<BusinessObject>();
        if (this.getTarget() != null) {
            vector.addElement(this.getTarget());
        }
        if (this.getOd() != null) {
            vector.addElement(this.getOd());
        }
        if (this.getConstraintSet() != null) {
            vector.addElement(this.getConstraintSet());
        }
        Object[] objectArray = new BusinessObject[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public BusinessObject deepCopy() {
        ObservationBlock observationBlock = null;
        ObservationDescription observationDescription = null;
        ConstraintSet constraintSet = null;
        Target target = null;
        observationBlock = (ObservationBlock)this.copy();
        if (this.getOd() != null) {
            observationDescription = (ObservationDescription)this.getOd().deepCopy();
            observationBlock.setOd(observationDescription);
        }
        if (this.getTarget() != null) {
            target = (Target)this.getTarget().deepCopy();
            observationBlock.setTarget(target);
        }
        if (this.getConstraintSet() != null) {
            constraintSet = (ConstraintSet)this.getConstraintSet().deepCopy();
            observationBlock.setConstraintSet(constraintSet);
        }
        return observationBlock;
    }

    public void copyProperty(String string, BusinessObject businessObject) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ObservationBlock observationBlock = (ObservationBlock)businessObject;
        if (string.equals("TemplateSignature")) {
            if (this.getTemplateSignature() != null) {
                observationBlock.setTemplateSignature(new TemplateSignature(this.getTemplateSignature()));
            } else {
                observationBlock.setTemplateSignature(null);
            }
            return;
        }
        if (string.equals("TimeIntervals")) {
            TimeInterval[] timeIntervalArray = this.getTimeIntervals();
            if (timeIntervalArray != null) {
                TimeInterval[] timeIntervalArray2 = new TimeInterval[timeIntervalArray.length];
                int n = 0;
                while (n < timeIntervalArray2.length) {
                    timeIntervalArray2[n] = new TimeInterval(timeIntervalArray[n]);
                    ++n;
                }
                observationBlock.setTimeIntervals(timeIntervalArray2);
            } else {
                observationBlock.setTimeIntervals(new TimeInterval[0]);
            }
            return;
        }
        if (string.equals("FindingCharts")) {
            FindingChart[] findingChartArray = this.getFindingCharts();
            if (findingChartArray != null) {
                FindingChart[] findingChartArray2 = new FindingChart[findingChartArray.length];
                FindingChart[] findingChartArray3 = ((ObservationBlock)businessObject).getFindingCharts();
                int n = 0;
                while (n < findingChartArray2.length) {
                    findingChartArray2[n] = new FindingChart(findingChartArray[n]);
                    ++n;
                }
                observationBlock.setFindingCharts(findingChartArray2);
            } else {
                observationBlock.setFindingCharts(new FindingChart[0]);
            }
            return;
        }
        super.copyProperty(string, businessObject);
    }

    public String toReport(long l) {
        int n;
        int n2;
        String[] stringArray;
        String string = this.target_.getEquinox();
        ObjectAdaptor objectAdaptor = AdaptorFactory.getAdaptor(class$org$eso$ohs$dfs$Target == null ? (class$org$eso$ohs$dfs$Target = ObservationBlock.class$("org.eso.ohs.dfs.Target")) : class$org$eso$ohs$dfs$Target, "RA");
        ObjectAdaptor objectAdaptor2 = AdaptorFactory.getAdaptor(class$org$eso$ohs$dfs$Target == null ? (class$org$eso$ohs$dfs$Target = ObservationBlock.class$("org.eso.ohs.dfs.Target")) : class$org$eso$ohs$dfs$Target, "Declination");
        String string2 = objectAdaptor.fromMetaLevelObject(new Integer(this.target_.getRA()));
        String string3 = objectAdaptor2.fromMetaLevelObject(new Integer(this.target_.getDeclination()));
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getDbaseId() != 0L) {
            if (this.getId() < 0L) {
                stringBuffer.append(this.getName() + " (OB Id=" + l + ") ");
            } else {
                stringBuffer.append(this.getName() + " (OB Id=" + this.getDbaseId() + ") ");
            }
        } else {
            stringBuffer.append(this.getName());
            stringBuffer.append(" ");
        }
        stringBuffer.append(this.getObsRun().getName() + "\n");
        if (this.calibrationRequirements_ != null && this.calibrationRequirements_.length() > 0) {
            stringBuffer.append("Cal Req.  : ");
            stringArray = TextUtils.splitString(this.calibrationRequirements_, 60);
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (n3 != 0) {
                    stringBuffer.append("            ");
                }
                stringBuffer.append(stringArray[n3] + "\n");
                ++n3;
            }
        }
        if ((stringArray = this.getUserComments()) != null && stringArray.length() > 0) {
            stringBuffer.append("User Com. : ");
            String[] stringArray2 = TextUtils.splitString((String)stringArray, 60);
            int n4 = 0;
            while (n4 < stringArray2.length) {
                if (n4 != 0) {
                    stringBuffer.append("            ");
                }
                stringBuffer.append(stringArray2[n4] + "\n");
                ++n4;
            }
        }
        stringBuffer.append("\n");
        stringBuffer.append("Target    : " + this.target_.getName() + "," + " RA: " + string2 + ", " + "Dec: " + string3 + ", " + "Eq: " + string + "\n");
        String string4 = this.getTarget().getUserComments();
        if (string4 != null && string4.length() > 0) {
            stringBuffer.append("User Com. : ");
            String[] stringArray3 = TextUtils.splitString(string4, 60);
            n2 = 0;
            while (n2 < stringArray3.length) {
                if (n2 != 0) {
                    stringBuffer.append("            ");
                }
                stringBuffer.append(stringArray3[n2] + "\n");
                ++n2;
            }
        }
        stringBuffer.append("\n");
        stringBuffer.append("ObsDesc: " + this.getOd().getName() + "\n");
        stringBuffer.append("\n");
        if (this.templateSignature_ != null) {
            stringBuffer.append(this.templateSignature_.toReportString());
            stringBuffer.append("\n");
        }
        TemplateSignature[] templateSignatureArray = this.getOd().getSignatures();
        n2 = 0;
        while (n2 < templateSignatureArray.length) {
            stringBuffer.append(templateSignatureArray[n2].toReportString());
            stringBuffer.append("\n");
            ++n2;
        }
        stringBuffer.append(this.getConstraintSet().toReportString(this.getOd().getInstrument(), this.fetchIPVersionFromOd()));
        if (this.timeIntervals_ != null && this.timeIntervals_.length > 0) {
            stringBuffer.append("\n");
            stringBuffer.append("Time Intervals : ");
            n = 0;
            while (n < this.timeIntervals_.length) {
                if (n != 0) {
                    stringBuffer.append("                 ");
                }
                stringBuffer.append(this.timeIntervals_[n].toReportString() + "\n");
                ++n;
            }
        }
        if (this.stIntervals_ != null && this.stIntervals_.length > 0) {
            stringBuffer.append("\n");
            stringBuffer.append("Sidereal Time Intervals : ");
            n = 0;
            while (n < this.stIntervals_.length) {
                if (n != 0) {
                    stringBuffer.append("                          ");
                }
                stringBuffer.append(this.stIntervals_[n].toReportStringSidereal() + "\n");
                ++n;
            }
        }
        if (this.findingCharts != null && this.findingCharts.length > 0) {
            stringBuffer.append("\n");
            stringBuffer.append("FindingCharts : ");
            n = 0;
            while (n < this.findingCharts.length) {
                if (n != 0) {
                    stringBuffer.append("                ");
                }
                stringBuffer.append(this.findingCharts[n].getFcName() + "\n");
                ++n;
            }
        }
        stringBuffer.append("\n=====================================================\n");
        return stringBuffer.toString();
    }

    public String verify() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.verify());
        if (this.getTarget() == null) {
            stringBuffer.append("\n Target not defined.");
        } else {
            stringBuffer.append(this.getTarget().verify());
        }
        if (this.getConstraintSet() == null) {
            if ("S".equalsIgnoreCase(this.getObsRun().getObsMode())) {
                stringBuffer.append("\n Constraint Set not defined.");
            }
        } else {
            stringBuffer.append(this.getConstraintSet().verify());
        }
        stringBuffer.append(this.verifyBO());
        return stringBuffer.toString();
    }

    public String verifyBO() {
        int n;
        Object object;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.timeIntervals_ != null && this.timeIntervals_.length > 0) {
            n2 = 0;
            while (n2 < this.timeIntervals_.length) {
                object = this.timeIntervals_[n2].verify();
                if (object != null && ((String)object).length() > 0) {
                    n = n2 + 1;
                    stringBuffer.append("\n Time interval " + n + " is invalid.");
                }
                ++n2;
            }
        }
        if (this.getTemplateSignature() == null) {
            stringBuffer.append("\n Acquisition Template not defined.");
        } else {
            n2 = 0;
            object = this.getTemplateSignature().verify();
            n = 0;
            while (n < ((String[])object).length) {
                if (!object[n].equals("OK")) {
                    ++n2;
                }
                ++n;
            }
            if (n2 > 0) {
                stringBuffer.append("\n");
                if (n2 == 1) {
                    stringBuffer.append(" There is 1 error");
                } else {
                    stringBuffer.append(" There are " + n2 + " errors");
                }
                stringBuffer.append(" in the acquisition template.");
            }
        }
        return stringBuffer.toString();
    }

    public void convertIPVersion(float f) {
        if (this.templateSignature_ != null) {
            this.templateSignature_.setVersion(f);
        }
        super.convertIPVersion(f);
    }

    public void refreshTemplates(boolean bl) throws IOException {
        this.refreshTemplates(bl, false);
    }

    public void refreshTemplates(boolean bl, boolean bl2) throws IOException {
        if (this.templateSignature_ != null && !TemplateSignatureFactory.refreshTemplate(this.templateSignature_, bl2)) {
            this.setTemplateSignature(null);
        }
        super.refreshTemplates(bl, bl2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.templateSignature_ != null && !TemplateSignatureFactory.refreshTemplate(this.templateSignature_)) {
            if (this.templateSignature_.getInstrument() == null) {
                throw new IOException("Object could not be loaded as IP " + this.templateSignature_.getInstrumentName() + " v" + this.templateSignature_.getVersion() + " was not found.");
            }
            this.setTemplateSignature(null);
        }
    }

    public Object accept(BusinessVisitor businessVisitor, Object object) {
        return businessVisitor.visit(this, object);
    }

    public FindingChart[] getFindingCharts() {
        if (this.findingCharts == null) {
            return new FindingChart[0];
        }
        return this.findingCharts;
    }

    public void setFindingCharts(FindingChart[] findingChartArray) {
        this.findingCharts = findingChartArray;
        ObservingRun observingRun = this.getObsRun();
        this.firePropertyChangeEvent(this.findingChartEvent);
    }

    public boolean hasFindingChartName(String string) {
        FindingChart[] findingChartArray = this.getFindingCharts();
        int n = 0;
        while (n < findingChartArray.length) {
            stdlog_.debug((Object)("FC Name " + findingChartArray[n].getFcName()));
            if (findingChartArray[n].getFcName().equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean hasFindingChartChecksum(long l) {
        FindingChart[] findingChartArray = this.getFindingCharts();
        int n = 0;
        while (n < findingChartArray.length) {
            if (findingChartArray[n].getCheckSum() == l) {
                stdlog_.debug((Object)"!!!!!!!!!!!!!!! Returning true");
                return true;
            }
            ++n;
        }
        return false;
    }

    public void postProecess() {
        FindingChart[] findingChartArray = this.getFindingCharts();
        int n = 0;
        while (n < findingChartArray.length) {
            findingChartArray[n].setObsRun(this.getObsRun());
            ++n;
        }
    }

    public void replaceFindingChartsByName(FindingChart findingChart) {
        FindingChart[] findingChartArray = this.getFindingCharts();
        int n = 0;
        while (n < findingChartArray.length) {
            if (findingChartArray[n].getFcName() == findingChart.getFcName()) {
                findingChartArray[n] = findingChart;
            }
            ++n;
        }
    }

    public TimeInterval[] getSTTimeIntervals() {
        if (this.stIntervals_ == null) {
            return new TimeInterval[0];
        }
        return this.stIntervals_;
    }

    public void setSTTimeIntervals(TimeInterval[] timeIntervalArray) {
        this.stIntervals_ = timeIntervalArray;
        this.firePropertyChangeEvent();
    }

    public EphemerisFile getEphemerisFile() {
        return this.ephemerisFile;
    }

    public void setEphemerisFile(EphemerisFile ephemerisFile) {
        this.ephemerisFile = ephemerisFile;
        this.firePropertyChangeEvent();
    }

    public boolean hasEphemerisFile() {
        return this.ephemerisFile != null && this.ephemerisFile.hasEphemerisFile();
    }

    public boolean equals(ObservationBlock observationBlock) throws ReflectionException {
        TimeInterval timeInterval;
        if (!super.equals(observationBlock)) {
            return false;
        }
        if (this.getCalibrationRequirements().compareTo(observationBlock.getCalibrationRequirements()) != 0) {
            return false;
        }
        if (!this.getTarget().equals(observationBlock.getTarget())) {
            return false;
        }
        if (!this.getTemplateSignature().equals(observationBlock.getTemplateSignature())) {
            return false;
        }
        if (!this.getEphemerisFile().equals(observationBlock.getEphemerisFile())) {
            return false;
        }
        Instrument instrument = InstrumentList.getInstance().getInstrument(this.getOd().getInstrument(), this.getOd().getIPVersion());
        InstrumentConstraintConfig[] instrumentConstraintConfigArray = instrument.getCsConfList();
        ConstraintSet constraintSet = this.getConstraintSet();
        String[] stringArray = new String[instrumentConstraintConfigArray.length];
        int n = 0;
        while (n < instrumentConstraintConfigArray.length) {
            String string;
            stringArray[n] = string = instrumentConstraintConfigArray[n].getName();
            ++n;
        }
        if (!this.getConstraintSet().equals(observationBlock.getConstraintSet(), stringArray)) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.timeIntervals_.length) {
            TimeInterval timeInterval2 = this.timeIntervals_[n2];
            timeInterval = observationBlock.timeIntervals_[n2];
            if (!timeInterval2.equals(timeInterval)) {
                return false;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.stIntervals_.length) {
            timeInterval = this.stIntervals_[n3];
            TimeInterval timeInterval3 = observationBlock.stIntervals_[n3];
            if (!timeInterval.equals(timeInterval3)) {
                return false;
            }
            ++n3;
        }
        if (this.findingCharts.length == observationBlock.getFindingCharts().length) {
            int n4 = 0;
            while (n4 < this.findingCharts.length) {
                boolean bl = false;
                FindingChart findingChart = this.findingCharts[n4];
                int n5 = 0;
                while (n5 < observationBlock.getFindingCharts().length) {
                    FindingChart findingChart2 = observationBlock.getFindingCharts()[n5];
                    if (findingChart.equals(findingChart2)) {
                        bl = true;
                    }
                    ++n5;
                }
                if (!bl) {
                    return false;
                }
                ++n4;
            }
        } else {
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

