/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.dfs;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eso.ohs.dfs.BusinessObject;
import org.eso.ohs.dfs.BusinessVisitor;
import org.eso.ohs.instruments.InstrumentList;
import org.eso.ohs.instruments.TemplateSignature;
import org.eso.ohs.instruments.TemplateSignatureFactory;

public class ObservationDescription
extends BusinessObject {
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$dfs$ObservationDescription == null ? (class$org$eso$ohs$dfs$ObservationDescription = ObservationDescription.class$("org.eso.ohs.dfs.ObservationDescription")) : class$org$eso$ohs$dfs$ObservationDescription));
    static final long serialVersionUID = -1929856469897387244L;
    private String userComments_;
    private String mode_;
    private String instrument_;
    private float ipVersion_ = -1.0f;
    private Vector templSigVec_ = new Vector();
    static /* synthetic */ Class class$org$eso$ohs$dfs$ObservationDescription;

    ObservationDescription() {
    }

    public void setUserComments(String string) {
        this.userComments_ = string;
        this.firePropertyChangeEvent();
    }

    public String getUserComments() {
        if (this.userComments_ == null) {
            return "";
        }
        return this.userComments_;
    }

    public void setMode(String string) {
        this.mode_ = string;
        this.firePropertyChangeEvent();
    }

    public String getMode() {
        if (this.mode_ == null) {
            return "";
        }
        return this.mode_;
    }

    public String getInstrument() {
        if (this.instrument_ == null) {
            return "";
        }
        return this.instrument_;
    }

    public void setInstrument(String string) {
        this.instrument_ = string;
        this.firePropertyChangeEvent();
    }

    public void setInstrument(String string, float f) {
        stdlog_.debug((Object)("MIPS OD: setInstrument:" + string + " v" + f));
        this.instrument_ = string;
        this.ipVersion_ = f;
        this.firePropertyChangeEvent();
    }

    public void setIPVersion(float f) {
        stdlog_.debug((Object)("MIPS OD: setIPVersion: v" + f));
        this.ipVersion_ = f;
        this.firePropertyChangeEvent();
    }

    public float getIPVersion() {
        stdlog_.debug((Object)("MIPS  OD: getIPVersion:" + this.ipVersion_));
        return this.ipVersion_;
    }

    public void setSignatures(TemplateSignature[] templateSignatureArray) {
        this.templSigVec_.removeAllElements();
        int n = 0;
        while (n < templateSignatureArray.length) {
            this.templSigVec_.addElement(templateSignatureArray[n]);
            ++n;
        }
        stdlog_.debug((Object)("Initialising TemplateSigVec_ " + this.templSigVec_.size()));
        this.firePropertyChangeEvent(this.templateEvent_);
    }

    public void appendSignature(TemplateSignature templateSignature) {
        this.templSigVec_.addElement(templateSignature);
        this.firePropertyChangeEvent(this.templateEvent_);
    }

    public void insertSignature(TemplateSignature templateSignature, int n) {
        this.templSigVec_.insertElementAt(templateSignature, n);
        this.firePropertyChangeEvent(this.templateEvent_);
    }

    public void deleteSignature(TemplateSignature templateSignature) {
        this.templSigVec_.removeElement(templateSignature);
        this.firePropertyChangeEvent(this.templateEvent_);
    }

    public void removeAllSignatures() {
        this.templSigVec_.removeAllElements();
        this.firePropertyChangeEvent(this.templateEvent_);
    }

    public TemplateSignature[] getSignatures() {
        int n = this.templSigVec_.size();
        Object[] objectArray = new TemplateSignature[n];
        this.templSigVec_.copyInto(objectArray);
        return objectArray;
    }

    public static String getDisplayName() {
        return "ObsDesc";
    }

    public static String getSuffix() {
        return "od";
    }

    public void copyProperty(String string, BusinessObject businessObject) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ObservationDescription observationDescription = (ObservationDescription)businessObject;
        if (string.equals("Signatures")) {
            TemplateSignature[] templateSignatureArray = this.getSignatures();
            TemplateSignature[] templateSignatureArray2 = new TemplateSignature[templateSignatureArray.length];
            observationDescription.templSigVec_ = new Vector();
            int n = 0;
            while (n < templateSignatureArray.length) {
                templateSignatureArray2[n] = new TemplateSignature(templateSignatureArray[n]);
                ++n;
            }
            observationDescription.setSignatures(templateSignatureArray2);
            return;
        }
        super.copyProperty(string, businessObject);
    }

    public String verify() {
        StringBuffer stringBuffer = new StringBuffer();
        TemplateSignature[] templateSignatureArray = this.getSignatures();
        int n = 0;
        if (templateSignatureArray.length == 0) {
            return "\n There are no Template Signatures in the Observation Description.";
        }
        int n2 = 0;
        while (n2 < templateSignatureArray.length) {
            String[] stringArray = templateSignatureArray[n2].verify();
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (!stringArray[n3].equals("OK")) {
                    ++n;
                }
                ++n3;
            }
            ++n2;
        }
        if (n > 0) {
            stringBuffer.append("\n");
            if (n == 1) {
                stringBuffer.append(" There is 1 error");
            } else {
                stringBuffer.append(" There are " + n + " errors");
            }
            stringBuffer.append(" in the Observation Description.");
        }
        return stringBuffer.toString();
    }

    public String verifyBO() {
        return this.verify();
    }

    public void convertIPVersion(float f) {
        int n = 0;
        while (n < this.templSigVec_.size()) {
            TemplateSignature templateSignature = (TemplateSignature)this.templSigVec_.elementAt(n);
            templateSignature.setVersion(f);
            ++n;
        }
        this.setIPVersion(f);
    }

    public void refreshTemplates(boolean bl) throws IOException {
        this.refreshTemplates(bl, false);
    }

    public void refreshTemplates(boolean bl, boolean bl2) throws IOException {
        int n = this.templSigVec_.size() - 1;
        while (n >= 0) {
            TemplateSignature templateSignature = (TemplateSignature)this.templSigVec_.elementAt(n);
            if (!TemplateSignatureFactory.refreshTemplate(templateSignature, bl2)) {
                this.templSigVec_.removeElementAt(n);
            }
            --n;
        }
        if (bl) {
            this.firePropertyChangeEvent();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        TemplateSignature templateSignature = null;
        if (!this.templSigVec_.isEmpty()) {
            templateSignature = (TemplateSignature)this.templSigVec_.elementAt(0);
        } else {
            stdlog_.debug((Object)"CLASS ObservationDescription - readObject: No Template");
        }
        if (this.instrument_ == null && templateSignature != null) {
            this.instrument_ = templateSignature.getInstrumentName();
        }
        if (InstrumentList.getInstance().getInstrument(this.getInstrument(), this.getIPVersion()) == null) {
            throw new IOException("Object could not be loaded as IP " + this.getInstrument() + " v" + this.getIPVersion() + " was not found.");
        }
        this.refreshTemplates(false);
    }

    public String paramString() {
        return super.paramString() + ",instrument=" + this.instrument_ + ", version=" + this.ipVersion_ + ",mode=" + this.mode_;
    }

    public Object accept(BusinessVisitor businessVisitor, Object object) {
        return businessVisitor.visit(this, object);
    }

    public void postProecess() {
    }

    public boolean equals(ObservationDescription observationDescription) {
        if (this.instrument_.compareTo(observationDescription.getInstrument()) != 0) {
            return false;
        }
        if (this.userComments_.compareTo(observationDescription.getUserComments()) != 0) {
            return false;
        }
        Vector vector = this.templSigVec_;
        Vector vector2 = observationDescription.templSigVec_;
        if (vector.size() != vector2.size()) {
            return false;
        }
        Iterator iterator = vector2.iterator();
        Iterator iterator2 = vector.iterator();
        while (iterator2.hasNext()) {
            TemplateSignature templateSignature;
            TemplateSignature templateSignature2 = (TemplateSignature)iterator2.next();
            if (templateSignature2.equals(templateSignature = (TemplateSignature)iterator.next())) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

