/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.dfs;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.eso.ohs.dfs.BusinessObject;
import org.eso.ohs.dfs.BusinessVisitor;
import org.eso.ohs.dfs.Readme;
import org.eso.ohs.instruments.Instrument;
import org.eso.ohs.instruments.InstrumentList;
import org.eso.ohs.instruments.ReadmeAttribute;
import org.eso.ohs.instruments.ReadmeAttributesFactory;

public class ObservingRun
extends BusinessObject {
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$dfs$ObservingRun == null ? (class$org$eso$ohs$dfs$ObservingRun = ObservingRun.class$("org.eso.ohs.dfs.ObservingRun")) : class$org$eso$ohs$dfs$ObservingRun));
    static final long serialVersionUID = -7826695820902491018L;
    public static final String TYPE_OBSERVING = "observing";
    public static final String TYPE_LARGE = "large";
    public static final String TYPE_DDT = "ddt";
    public static final String TYPE_ENGINEERING = "engineering";
    public static final String OBSMODE_STANDARD = "S";
    public static final String OBSMODE_VISITOR = "V";
    public static final String OBSMODE_ENGINEERING = "E";
    private String[] instrumentList_;
    private String mode_;
    private float decimalHours_;
    private String instCode_;
    private String piName_;
    private int gto_;
    private float ipversion_ = -1.0f;
    private int period_;
    private int rank_;
    private String rankClass_;
    private String telescope_;
    private String title_;
    private String userName_;
    private long runId_;
    private int userId_;
    private long programmeId_;
    private String progId_;
    private String runDescription_;
    private Readme readme;
    private float decimalNights;
    public static final Integer TOO_INT = new Integer(3);
    public static final Integer DDT_INT = new Integer(2);
    public static final Integer GTO_INT = new Integer(1);
    public static final Integer NORMAL_INT = new Integer(0);
    static /* synthetic */ Class class$org$eso$ohs$dfs$ObservingRun;

    public boolean isServiceMode() {
        return this.getObsMode().equalsIgnoreCase(OBSMODE_STANDARD);
    }

    public String getType() {
        String string = this.getName();
        if (string.charAt(0) == ' ') {
            int n;
            int n2 = string.indexOf(45) + 1;
            String string2 = string.substring(n2, n = string.indexOf(40));
            int n3 = new Integer(string2);
            if (n3 > 9000) {
                return TYPE_ENGINEERING;
            }
            return TYPE_OBSERVING;
        }
        if (string.charAt(0) == '1') {
            return TYPE_LARGE;
        }
        if (string.charAt(0) == '2') {
            return TYPE_DDT;
        }
        return null;
    }

    public String getObsMode() {
        return this.mode_;
    }

    public void setObsMode(String string) {
        this.mode_ = string;
    }

    public String[] getInstrumentList() {
        return this.instrumentList_;
    }

    public void setInstrumentList(String[] stringArray) {
        this.instrumentList_ = stringArray;
    }

    public String getInstCode() {
        return this.instCode_;
    }

    public void setInstCode(String string) {
        this.instCode_ = string;
    }

    public float getIPVersion() {
        return this.ipversion_;
    }

    public void setIPVersion(float f) {
        this.ipversion_ = f;
    }

    public int getPeriod() {
        return this.period_;
    }

    public void setPeriod(int n) {
        this.period_ = n;
    }

    public int getRank() {
        return this.rank_;
    }

    public void setRank(int n) {
        this.rank_ = n;
    }

    public String getRankClass() {
        return this.rankClass_;
    }

    public void setRankClass(String string) {
        this.rankClass_ = string;
    }

    public long getRunId() {
        return this.runId_;
    }

    public void setRunId(long l) {
        this.runId_ = l;
    }

    public long getProgrammeId() {
        return this.programmeId_;
    }

    public void setProgrammeId(long l) {
        this.programmeId_ = l;
    }

    public String getProgId() {
        return this.progId_;
    }

    public void setProgId(String string) {
        this.progId_ = string;
    }

    public String getRunDescription() {
        return this.runDescription_;
    }

    public void setRunDescription(String string) {
        this.runDescription_ = string;
    }

    public String getTelescope() {
        return this.telescope_;
    }

    public void setTelescope(String string) {
        this.telescope_ = string;
    }

    public String getTitle() {
        return this.title_;
    }

    public void setTitle(String string) {
        this.title_ = string;
    }

    public int getUserId() {
        return this.userId_;
    }

    public void setUserId(int n) {
        this.userId_ = n;
    }

    public String getUserName() {
        return this.userName_;
    }

    public void setFirstName(String string) {
        this.userName_ = string;
        this.firePropertyChangeEvent();
    }

    public void setPIName(String string) {
        this.piName_ = string;
        this.firePropertyChangeEvent();
    }

    public String getPIName() {
        return this.piName_;
    }

    public static String getDisplayName() {
        return "Observing Run";
    }

    public static String getSuffix() {
        return "or";
    }

    public Object accept(BusinessVisitor businessVisitor, Object object) {
        return businessVisitor.visit(this, object);
    }

    public void postProecess() {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.readme != null) {
            ReadmeAttribute[] readmeAttributeArray = this.readme.getRedmeAttributes();
            stdlog_.debug((Object)("Readme " + this.readme.getIpVersion()));
            if (readmeAttributeArray != null) {
                Instrument instrument = InstrumentList.getInstance().getInstrument(this.getInstCode(), this.readme.getIpVersion());
                readmeAttributeArray = ReadmeAttributesFactory.refreshReadmeAttributes(instrument, readmeAttributeArray);
                this.readme.setRedmeAttributes(readmeAttributeArray);
            }
        }
    }

    public Readme getReadme() {
        return this.readme;
    }

    public void setReadme(Readme readme) {
        this.readme = readme;
        this.firePropertyChangeEvent();
    }

    public int getGto() {
        return this.gto_;
    }

    public void setGto(int n) {
        this.gto_ = n;
        this.firePropertyChangeEvent();
    }

    public String getProgType() {
        switch (this.gto_) {
            case 0: {
                return "NORMAL";
            }
            case 1: {
                return "GTO";
            }
            case 2: {
                return "DDT";
            }
            case 3: {
                return "TOO";
            }
            case 4: {
                return "LARGE";
            }
        }
        return "UNKOWN";
    }

    public void copyProperty(String string, BusinessObject businessObject) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (string.equals("Readme")) {
            return;
        }
        super.copyProperty(string, businessObject);
    }

    public float getDecimalNights() {
        return this.decimalNights;
    }

    public void setDecimalNights(float f) {
        this.decimalNights = f;
        this.firePropertyChangeEvent();
    }

    public float getDecimalHours() {
        return this.decimalHours_;
    }

    public void setDecimalHours(float f) {
        this.decimalHours_ = f;
        this.firePropertyChangeEvent();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

