/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.dfs;

import java.beans.PropertyChangeEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import org.eso.ohs.dfs.BusinessObject;
import org.eso.ohs.dfs.BusinessVisitor;
import org.eso.ohs.dfs.QueueItem;

public class Queue
extends BusinessObject {
    public static final String ITEMLIST = "itemlist";
    public static final String EXECUTION_SEQUENCE = "executionSequence";
    public static final String TELESCOPE = "telescope";
    public static final String DURATION = "duration";
    public static final String START_TIME = "startTime";
    public static final String DESCRIPTION = "description";
    public static final String NAME = "name";
    public static final String QI_LIST_SIZE = "QIListSize";
    public static long OFFSET = 99000L;
    public static long TIMEOFFSET = 16200L;
    private String description = "";
    private long startTime;
    private long duration;
    private String telescope = "UT1";
    private QueueItem[] queueItems_ = new QueueItem[0];
    private boolean update = false;
    private int size = 0;

    public Queue() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 18, 0, 0);
        this.startTime = calendar.getTime().getTime() / 1000L;
        this.duration = 86400L;
    }

    public void setName(String string) {
        boolean bl = !this.getName().equals(string);
        super.setName(string);
        if (bl) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, NAME, null, null);
            this.update = true;
            this.firePropertyChangeEvent(propertyChangeEvent);
        }
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, QI_LIST_SIZE, null, null);
        this.firePropertyChangeEvent(propertyChangeEvent);
    }

    public void setDescription(String string) {
        if (!this.description.equals(string)) {
            this.description = string;
            this.setUpdate(true);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setStartTime(long l) {
        boolean bl = this.startTime != l;
        this.startTime = l;
        if (bl) {
            this.setUpdate(true);
        }
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setDuration(long l) {
        boolean bl = this.duration != l;
        this.duration = l;
        if (bl) {
            this.setUpdate(true);
        }
    }

    public long getDuration() {
        return this.duration;
    }

    public void setTelescope(String string) {
        boolean bl = !this.telescope.equals(string);
        this.telescope = string;
        if (bl) {
            this.setUpdate(true);
        }
    }

    public String getTelescope() {
        return this.telescope;
    }

    public static String getSuffix() {
        return "queue";
    }

    public Object accept(BusinessVisitor businessVisitor, Object object) {
        return businessVisitor.visit(this, object);
    }

    public boolean isUpdate() {
        return this.update;
    }

    public void setUpdate(boolean bl) {
        this.setUpdate(bl, null);
    }

    public void setUpdateAndFire(boolean bl) {
        this.update = bl;
        this.firePropertyChangeEvent();
    }

    public void setUpdate(boolean bl, PropertyChangeEvent propertyChangeEvent) {
        boolean bl2;
        boolean bl3 = bl2 = this.update != bl;
        if (bl2) {
            this.update = bl;
            if (propertyChangeEvent == null) {
                this.firePropertyChangeEvent();
            } else {
                this.firePropertyChangeEvent(propertyChangeEvent);
            }
        }
    }

    public long[] getAllOBIds() {
        Vector<Long> vector = new Vector<Long>();
        int n = 0;
        while (n < this.queueItems_.length) {
            vector.addElement(new Long(this.queueItems_[n].getObId()));
            ++n;
        }
        long[] lArray = new long[vector.size()];
        int n2 = 0;
        while (n2 < vector.size()) {
            lArray[n2] = (Long)vector.elementAt(n2);
            ++n2;
        }
        return lArray;
    }

    public long[] getAllUniqueOBIds() {
        Vector<Long> vector = new Vector<Long>();
        int n = 0;
        while (n < this.queueItems_.length) {
            if (this.queueItems_[n].getType().equals("O")) {
                vector.addElement(new Long(this.queueItems_[n].getObId()));
            } else {
                vector.addElement(new Long(this.queueItems_[n].getObId()));
            }
            ++n;
        }
        long[] lArray = new long[vector.size()];
        int n2 = 0;
        while (n2 < vector.size()) {
            lArray[n2] = (Long)vector.elementAt(n2);
            ++n2;
        }
        return lArray;
    }

    public void sortQueueItems(long[] lArray) {
        int n;
        Vector<QueueItem> vector = new Vector<QueueItem>();
        Object var3_3 = null;
        int n2 = 0;
        long l = lArray[0];
        int n3 = 0;
        while (n3 < this.queueItems_.length) {
            n = 0;
            int n4 = 0;
            while (n4 < lArray.length) {
                if (this.queueItems_[n3].getObId() == lArray[n4]) {
                    n = 1;
                    if (n3 <= n2) {
                        n2 = n3;
                    }
                }
                ++n4;
            }
            if (n == 0) {
                vector.addElement(this.queueItems_[n3]);
            }
            ++n3;
        }
        n = lArray.length - 1;
        while (n >= 0) {
            QueueItem queueItem = this.getQueueItemFromObId(lArray[n]);
            vector.insertElementAt(queueItem, n2);
            --n;
        }
        Object[] objectArray = new QueueItem[vector.size()];
        vector.copyInto(objectArray);
        this.setQueueList((QueueItem[])objectArray);
    }

    public void moveUpQueueItems(long[] lArray, long l) {
        int n;
        Vector<QueueItem> vector = new Vector<QueueItem>();
        Object var5_4 = null;
        int n2 = -1;
        long l2 = l;
        int n3 = 0;
        while (n3 < this.queueItems_.length) {
            n = 0;
            int n4 = 0;
            while (n4 < lArray.length) {
                if (this.queueItems_[n3].getObId() == lArray[n4]) {
                    n = 1;
                }
                ++n4;
            }
            if (n == 0) {
                vector.addElement(this.queueItems_[n3]);
            }
            if (l2 == this.queueItems_[n3].getObId()) {
                n2 = n3;
            }
            ++n3;
        }
        n = lArray.length - 1;
        while (n >= 0) {
            QueueItem queueItem = this.getQueueItemFromObId(lArray[n]);
            vector.insertElementAt(queueItem, n2);
            --n;
        }
        Object[] objectArray = new QueueItem[vector.size()];
        vector.copyInto(objectArray);
        this.setQueueList((QueueItem[])objectArray);
    }

    public void moveDownQueueItems(long[] lArray, long l) {
        int n;
        Vector<QueueItem> vector = new Vector<QueueItem>();
        Object var5_4 = null;
        int n2 = -1;
        long l2 = l;
        int n3 = 0;
        while (n3 < this.queueItems_.length) {
            n = 0;
            int n4 = 0;
            while (n4 < lArray.length) {
                if (this.queueItems_[n3].getObId() == lArray[n4]) {
                    n = 1;
                }
                ++n4;
            }
            if (n == 0) {
                vector.addElement(this.queueItems_[n3]);
            }
            if (l2 == this.queueItems_[n3].getObId()) {
                n2 = n3;
            }
            ++n3;
        }
        n = 0;
        while (n < lArray.length) {
            QueueItem queueItem = this.getQueueItemFromObId(lArray[n]);
            vector.insertElementAt(queueItem, n2 - lArray.length + n + 1);
            ++n;
        }
        Object[] objectArray = new QueueItem[vector.size()];
        vector.copyInto(objectArray);
        this.setQueueList((QueueItem[])objectArray);
    }

    public QueueItem getQueueItemFromObId(long l) {
        int n = 0;
        while (n < this.queueItems_.length) {
            if (l == this.queueItems_[n].getObId()) {
                return this.queueItems_[n];
            }
            ++n;
        }
        return null;
    }

    public void setQueueList(QueueItem[] queueItemArray) {
        this.queueItems_ = queueItemArray;
        this.update = true;
        boolean bl = true;
        if (this.queueItems_ != null) {
            this.setSize(this.queueItems_.length);
        } else {
            this.setSize(0);
        }
        if (bl) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, ITEMLIST, null, null);
            this.firePropertyChangeEvent(propertyChangeEvent);
        }
    }

    public QueueItem[] getQueueList() {
        return this.queueItems_;
    }

    public void setQueueSequenceList(QueueItem[] queueItemArray) {
        this.queueItems_ = queueItemArray;
    }

    public boolean inQueueItems(long l) {
        int n = 0;
        while (n < this.queueItems_.length) {
            if (this.queueItems_[n].getObId() == l) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void removeQueueItems(long[] lArray) {
        Vector<QueueItem> vector = new Vector<QueueItem>();
        int n = 0;
        while (n < this.queueItems_.length) {
            boolean bl = false;
            int n2 = 0;
            while (n2 < lArray.length) {
                if (this.queueItems_[n].getObId() == lArray[n2]) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                vector.addElement(this.queueItems_[n]);
            }
            ++n;
        }
        Object[] objectArray = new QueueItem[vector.size()];
        vector.copyInto(objectArray);
        this.setQueueList((QueueItem[])objectArray);
    }

    public QueueItem[] appendQueueItems(long[] lArray, QueueItem[] queueItemArray, String[] stringArray) {
        Vector<QueueItem> vector = new Vector<QueueItem>();
        int n = 0;
        while (n < queueItemArray.length) {
            vector.addElement(queueItemArray[n]);
            ++n;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < lArray.length) {
            boolean bl = false;
            int n4 = 0;
            while (n4 < queueItemArray.length) {
                System.out.println("!!!!!!!!!!!! Append Queue Items" + queueItemArray[n4].getObId());
                if (queueItemArray[n4].getObId() == lArray[n3]) {
                    bl = true;
                    n2 = queueItemArray.length + n2;
                    ++n2;
                    break;
                }
                ++n4;
            }
            if (!bl) {
                QueueItem queueItem = new QueueItem(lArray[n3], this.getId(), n2, stringArray[n3]);
                vector.addElement(queueItem);
            }
            ++n3;
        }
        Object[] objectArray = new QueueItem[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void appendQueueItems(long[] lArray, String[] stringArray) {
        this.setQueueList(this.appendQueueItems(lArray, this.queueItems_, stringArray));
    }

    public QueueItem[] getQueueSequenceList() {
        return this.queueItems_;
    }

    public QueueItem[] getExecList() {
        return this.queueItems_;
    }

    public void fireNameEvent() {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, NAME, null, null);
        this.firePropertyChangeEvent(propertyChangeEvent);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.queueItems_.length) {
            stringBuffer.append(this.queueItems_[n].toString());
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public void postProecess() {
    }
}

