/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.dfs;

import gnu.regexp.RE;
import gnu.regexp.REException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eso.ohs.core.utilities.Convert;
import org.eso.ohs.core.utilities.OHSConfig;
import org.eso.ohs.core.utilities.PafFile;
import org.eso.ohs.core.utilities.Paramfile;
import org.eso.ohs.dfs.BusinessObject;
import org.eso.ohs.dfs.BusinessVisitor;
import org.eso.ohs.instruments.ParamFileParameter;

public class Target
extends BusinessObject {
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$dfs$Target == null ? (class$org$eso$ohs$dfs$Target = Target.class$("org.eso.ohs.dfs.Target")) : class$org$eso$ohs$dfs$Target));
    protected static final int MAX_MILLISECS_RA = 86400000;
    protected static final int MIN_MILLISECS_RA = 0;
    protected static final int MAX_MILLISECS_DEC = 324000000;
    protected static final int MIN_MILLISECS_DEC = -324000000;
    protected static final float MAX_PROP_RA = 99999.99f;
    protected static final float MIN_PROP_RA = -99999.99f;
    protected static final float MAX_PROP_DEC = 99999.99f;
    protected static final float MIN_PROP_DEC = -99999.99f;
    protected static final float MAX_DIFF_RA = 99999.99f;
    protected static final float MIN_DIFF_RA = -99999.99f;
    protected static final float MAX_DIFF_DEC = 99999.99f;
    protected static final float MIN_DIFF_DEC = -99999.99f;
    protected static final int MIN_EQUINOX = 4;
    static final long serialVersionUID = -7526074509242805287L;
    public static String[] objectClassValues_ = new String[]{"Unknown"};
    public static String[] objectClassTooltips_ = new String[0];
    private int ra_;
    private int dec_;
    private float epoch_ = 2000.0f;
    private transient PafFile paramPaf_ = null;
    private String equinox_ = "2000";
    private float propRA_;
    private float propDec_;
    private float diffRA_;
    private float diffDec_;
    private String objectClass_;
    private float mag_;
    private float color_;
    private String userComments_ = "";
    static /* synthetic */ Class class$org$eso$ohs$dfs$Target;

    Target() {
    }

    public void setRA(int n) {
        this.ra_ = n;
        this.firePropertyChangeEvent();
    }

    public int getRA() {
        return this.ra_;
    }

    public void setDeclination(int n) {
        this.dec_ = n;
        this.firePropertyChangeEvent();
    }

    public int getDeclination() {
        return this.dec_;
    }

    public void setEpoch(float f) {
        this.epoch_ = f;
        this.firePropertyChangeEvent();
    }

    public float getEpoch() {
        return this.epoch_;
    }

    public void setEquinox(String string) {
        this.equinox_ = string;
        this.firePropertyChangeEvent();
    }

    public String getEquinox() {
        return this.equinox_;
    }

    public void setProperDeclination(float f) {
        this.propDec_ = (float)Math.round(f * 100.0f) / 100.0f;
        this.firePropertyChangeEvent();
    }

    public float getProperDeclination() {
        return this.propDec_;
    }

    public void setPropRA(float f) {
        this.propRA_ = (float)Math.round(f * 100.0f) / 100.0f;
        this.firePropertyChangeEvent();
    }

    public float getPropRA() {
        return this.propRA_;
    }

    public void setDiffRA(float f) {
        this.diffRA_ = (float)Math.round(f * 100.0f) / 100.0f;
        this.firePropertyChangeEvent();
    }

    public float getDiffRA() {
        return this.diffRA_;
    }

    public void setDiffDec(float f) {
        this.diffDec_ = (float)Math.round(f * 100.0f) / 100.0f;
        this.firePropertyChangeEvent();
    }

    public float getDiffDec() {
        return this.diffDec_;
    }

    public void setUserComments(String string) {
        this.userComments_ = string;
        this.firePropertyChangeEvent();
    }

    public String getUserComments() {
        if (this.userComments_ == null) {
            return "";
        }
        return this.userComments_;
    }

    public void setMag(float f) {
        this.mag_ = f;
        this.firePropertyChangeEvent();
    }

    public float getMag() {
        return this.mag_;
    }

    public void setColor(float f) {
        this.color_ = f;
        this.firePropertyChangeEvent();
    }

    public float getColor() {
        return this.color_;
    }

    public static void setObjectClassValues(String[] stringArray) {
        objectClassValues_ = stringArray;
    }

    public static String[] getObjectClassValues() {
        return objectClassValues_;
    }

    public static void setObjectClassTooltips(String[] stringArray) {
        objectClassTooltips_ = stringArray;
    }

    public static String[] getObjectClassTooltips() {
        return objectClassTooltips_;
    }

    public void setObjectClass(String string) {
        String[] stringArray = Target.getObjectClassValues();
        String string2 = stringArray[0];
        stdlog_.debug((Object)("setObjectClass: newValue: '" + string + "'"));
        if (string != null) {
            int n = 1;
            while (n < stringArray.length) {
                if (stringArray[n].trim().equals(string.trim())) {
                    string2 = stringArray[n];
                    break;
                }
                ++n;
            }
        }
        this.objectClass_ = string2;
        this.firePropertyChangeEvent();
    }

    public String getObjectClass() {
        return this.objectClass_;
    }

    public static String getDisplayName() {
        return "Target";
    }

    public static String getSuffix() {
        return "tp";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.ra_ > 86400000) {
            this.ra_ = 86400000;
        }
        if (this.ra_ < 0) {
            this.ra_ = 0;
        }
        if (this.dec_ > 324000000) {
            this.dec_ = 324000000;
        }
        if (this.dec_ < -324000000) {
            this.dec_ = -324000000;
        }
        if (this.propRA_ > 99999.99f) {
            this.propRA_ = 99999.99f;
        }
        if (this.propRA_ < -99999.99f) {
            this.propRA_ = -99999.99f;
        }
        if (this.propDec_ > 99999.99f) {
            this.propDec_ = 99999.99f;
        }
        if (this.propDec_ < -99999.99f) {
            this.propDec_ = -99999.99f;
        }
        if (this.diffRA_ > 99999.99f) {
            this.diffRA_ = 99999.99f;
        }
        if (this.diffRA_ < -99999.99f) {
            this.diffRA_ = -99999.99f;
        }
        if (this.diffDec_ > 99999.99f) {
            this.diffDec_ = 99999.99f;
        }
        if (this.diffDec_ < -99999.99f) {
            this.diffDec_ = -99999.99f;
        }
    }

    public String verify() {
        RE rE = null;
        Object var2_2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        String string = "(([BJ])?\\d{0,2}\\d{0,2}(\\.\\d{0,2})?)?";
        try {
            rE = new RE((Object)string);
        }
        catch (REException rEException) {
            stdlog_.debug((Object)("CLASS Target - verify(equinox): Autsch!!!!! " + rEException.getMessage()));
        }
        if (!rE.isMatch((Object)this.equinox_) || this.equinox_.length() < 4) {
            stringBuffer.append("The equinox must be at a minimum a\nfour digit whole number with theoptional leading letter B or J.\nAn optional decimal point with a maximum of two digits is also allowed.\n");
        }
        if (!Convert.isValidRA(this.ra_)) {
            stringBuffer.append("The value of Right Ascension is out of range.\n");
        }
        if (!Convert.isValidDec(this.dec_)) {
            stringBuffer.append("The value of Declination is out of range.\n");
        }
        if (this.propRA_ > 99999.99f || this.propRA_ < -99999.99f) {
            stringBuffer.append("The value of Proper Motion RA is out of range.\nIt must be between -99999.99 and 99999.99.\n");
        }
        if (this.propDec_ > 99999.99f || this.propDec_ < -99999.99f) {
            stringBuffer.append("The value of Proper Motion DEC is out of range.\nIt must be between 99999.99 and -99999.99.\n");
        }
        if (this.diffRA_ > 99999.99f || this.diffRA_ < -99999.99f) {
            stringBuffer.append("The value of Diff RA is out of range.\nIt must  be between-99999.99 and 99999.99.\n");
        }
        if (this.diffDec_ > 99999.99f || this.diffDec_ < -99999.99f) {
            stringBuffer.append("The value of Diff DEC is out of range.\nIt must  be between-99999.99and 99999.99.\n");
        }
        return stringBuffer.toString();
    }

    public String verifyBO() {
        return this.verify();
    }

    public Object accept(BusinessVisitor businessVisitor, Object object) {
        return businessVisitor.visit(this, object);
    }

    public void updateFromParamFileParameter(ParamFileParameter paramFileParameter) throws IllegalArgumentException {
        if (!paramFileParameter.getValue().equals("NODEFAULT")) {
            Paramfile paramfile = paramFileParameter.getParamfile();
            this.updateFromParamfile(paramfile);
        }
    }

    public void updateFromParamfile(Paramfile paramfile) throws IllegalArgumentException {
        int n;
        int n2;
        IllegalArgumentException illegalArgumentException = null;
        this.suspendPropertyChangeEvents();
        String string = OHSConfig.getInstance().evalPropertyFromParamfile("TARGET.RA.PARAM", paramfile).trim();
        if (string.length() > 0) {
            n2 = 0;
            n = 0;
            try {
                n = Convert.HHMMSSToMilliarcsec(string);
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                n2 = 1;
                illegalArgumentException = illegalArgumentException2;
            }
            if (n2 == 0) {
                this.setRA(n);
            }
        }
        if ((string = OHSConfig.getInstance().evalPropertyFromParamfile("TARGET.DEC.PARAM", paramfile).trim()).length() > 0) {
            n2 = 0;
            n = 0;
            try {
                n = Convert.DDMMSSToMilliarcsec(string);
            }
            catch (IllegalArgumentException illegalArgumentException3) {
                n2 = 1;
                illegalArgumentException = illegalArgumentException3;
            }
            if (n2 == 0) {
                this.setDeclination(n);
            }
        }
        if ((string = OHSConfig.getInstance().evalPropertyFromParamfile("TARGET.EPOCH.PARAM", paramfile).trim()).length() > 0) {
            n2 = 6;
            if (string.length() > n2) {
                string = string.substring(0, n2 - 1);
            }
            Float f = new Float(string);
            float f2 = f.floatValue();
            this.setEpoch(f2);
        }
        if ((string = OHSConfig.getInstance().evalPropertyFromParamfile("TARGET.EQUINOX.PARAM", paramfile).trim()).length() > 0) {
            n2 = 8;
            if (string.length() > n2) {
                string = string.substring(0, n2 - 1);
            }
            this.setEquinox(string);
        }
        if ((string = OHSConfig.getInstance().evalPropertyFromParamfile("TARGET.PROPRA.PARAM", paramfile).trim()).length() > 0) {
            Float f = new Float(string);
            float f3 = f.floatValue();
            this.setPropRA(f3);
        }
        if ((string = OHSConfig.getInstance().evalPropertyFromParamfile("TARGET.PROPDEC.PARAM", paramfile).trim()).length() > 0) {
            Float f = new Float(string);
            float f4 = f.floatValue();
            this.setProperDeclination(f4);
        }
        if ((string = OHSConfig.getInstance().evalPropertyFromParamfile("TARGET.COLOR.PARAM", paramfile).trim()).length() > 0) {
            Float f = new Float(string);
            float f5 = f.floatValue();
            this.setColor(f5);
        }
        if ((string = OHSConfig.getInstance().evalPropertyFromParamfile("TARGET.MAG.PARAM", paramfile).trim()).length() > 0) {
            Float f = new Float(string);
            float f6 = f.floatValue();
            this.setMag(f6);
        }
        if ((string = OHSConfig.getInstance().evalPropertyFromParamfile("TARGET.NAME.PARAM", paramfile).trim()).length() > 0) {
            this.setName(string);
        }
        this.resumePropertyChangeEvents();
        this.firePropertyChangeEvent();
        if (illegalArgumentException != null) {
            throw illegalArgumentException;
        }
    }

    public static void initialiseBusinessObjects(File file) throws IOException {
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        BufferedReader bufferedReader = null;
        String string = null;
        String string2 = null;
        try {
            String string3;
            bufferedReader = new BufferedReader(new FileReader(file));
            while ((string3 = bufferedReader.readLine()) != null) {
                int n = string3.indexOf(58);
                if (n < 0 || (string3 = string3.substring(n + 1)).trim().length() == 0 || string3.length() <= 20) continue;
                int n2 = string3.indexOf(34);
                int n3 = string3.lastIndexOf(34);
                if (n2 < 0 || n3 < 0) continue;
                string = string3.substring(0, 20);
                string2 = string3.substring(n2 + 1, n3);
                vector.addElement(string);
                vector2.addElement(string2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bufferedReader != null) {
            bufferedReader.close();
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        Target.setObjectClassValues((String[])objectArray);
        Object[] objectArray2 = new String[vector2.size()];
        vector2.copyInto(objectArray2);
        Target.setObjectClassTooltips((String[])objectArray2);
    }

    public void postProecess() {
    }

    public boolean equals(Target target) {
        boolean bl = true;
        if (this.getDiffDec() != target.getDiffDec()) {
            bl = false;
        } else if (this.getDiffRA() != target.getDiffRA()) {
            bl = false;
        } else if (this.getEpoch() != target.getEpoch()) {
            bl = false;
        } else if (this.getEquinox().compareTo(target.getEquinox()) != 0) {
            bl = false;
        } else if (this.getProperDeclination() != target.getProperDeclination()) {
            bl = false;
        } else if (this.getPropRA() != target.getPropRA()) {
            bl = false;
        } else if (this.getRA() != target.getRA()) {
            bl = false;
        } else if (this.getUserComments().compareTo(target.getUserComments()) != 0) {
            bl = false;
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

