/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.instruments;

import org.eso.ohs.instruments.InstrumentConstraintMetaData;

public class InstrumentConstraintConfig {
    private String label;
    private String dbColumn;
    private String pafKeyword = "None";
    private InstrumentConstraintMetaData metaData = new InstrumentConstraintMetaData();
    private String name;
    private String fkColumn;
    private String fkTable;
    private String toolTip;
    private boolean property = false;
    private boolean compulsory = false;
    private String superType = "text";

    public String getDbColumn() {
        return this.dbColumn;
    }

    public void setDbColumn(String string) {
        this.dbColumn = string;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public InstrumentConstraintMetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(InstrumentConstraintMetaData instrumentConstraintMetaData) {
        this.metaData = instrumentConstraintMetaData;
    }

    public String getPafKeyword() {
        return this.pafKeyword;
    }

    public void setPafKeyword(String string) {
        this.pafKeyword = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PAF KEYWORD" + this.getPafKeyword());
        stringBuffer.append(" LABEL " + this.getLabel());
        stringBuffer.append("Db Column " + this.getDbColumn() + "\n");
        stringBuffer.append("Meta Info" + this.getMetaData().toString() + "\n");
        return stringBuffer.toString();
    }

    public String getBaseType() {
        return this.metaData.getBaseType();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getFkColumn() {
        return this.fkColumn;
    }

    public String getFkTable() {
        return this.fkTable;
    }

    public void setFkColumn(String string) {
        this.fkColumn = string;
    }

    public void setFkTable(String string) {
        this.fkTable = string;
    }

    public boolean hasFCConstraint() {
        return this.fkColumn != null && this.fkColumn.length() > 0 && this.fkTable != null && this.fkTable.length() > 0;
    }

    public String getSuperType() {
        int n = this.metaData.getMaxLength();
        if (this.superType.equals("emailAddressType")) {
            return "emailAddressType";
        }
        if (this.superType.equals("ThreeStateBooleanType")) {
            return "ThreeStateBooleanType";
        }
        if (this.superType.equals("FourStateBooleanType")) {
            return "FourStateBooleanType";
        }
        if (this.getBaseType().equals("integer")) {
            return "integer";
        }
        if (this.getBaseType().equals("float")) {
            return "float";
        }
        if (this.superType.equals("multilist")) {
            return "multilist";
        }
        if (this.getBaseType().equals("string") && this.getMetaData().getAllowedValues().length > 0) {
            return "keywordlist";
        }
        if (this.getBaseType().equals("string") && n > 120) {
            return "largetext";
        }
        if (this.getBaseType().equals("string") && n <= 120 && n > 0) {
            return "normaltext";
        }
        return this.superType;
    }

    public void setSuperType(String string) {
        this.superType = string;
    }

    public boolean isProperty() {
        return this.property;
    }

    public void setProperty(boolean bl) {
        this.property = bl;
    }

    public boolean isCompulsory() {
        return this.compulsory;
    }

    public void setCompulsory(boolean bl) {
        this.compulsory = bl;
    }

    public String getToolTip() {
        if (this.toolTip == null) {
            return "";
        }
        return this.toolTip;
    }

    public void setToolTip(String string) {
        this.toolTip = string;
    }
}

