/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.instruments;

import java.io.IOException;
import java.io.StringReader;
import org.apache.log4j.Logger;
import org.eso.ohs.core.utilities.PafData;
import org.eso.ohs.core.utilities.PafFile;
import org.eso.ohs.instruments.Instrument;

public class MaskInstrument
extends Instrument {
    private String dummyAdpData_ = "PAF.HDR.START\nPAF.TYPE \"paramfile\" ;\nPAF.ID \"3277996668361\" ;\nPAF.NAME \"ThisIsADummyAdm.adm\" ;\nPAF.DESC \"ADM:\" ;\nPAF.CRTE.NAME \"gbr2adm.awk\" ;\nPAF.CRTE.DAYTIM \"2001-08-01T14:19:21.000\" ;\nPAF.LCHG.NAME \" ;\" ;\nPAF.LCHG.DAYTIM \" ;\" ;\nPAF.CHCK.NAME \" ;\" ;\nPAF.CHCK.DAYTIM\" ;\" ;\nPAF.CHCK.CHECKSUM \"00000\" ;\nPAF.HDR.END\nTPL.FILE.DIRNAME \"$INS_ROOT/$INS_USER/ADF\" ;\n";
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$instruments$MaskInstrument == null ? (class$org$eso$ohs$instruments$MaskInstrument = MaskInstrument.class$("org.eso.ohs.instruments.MaskInstrument")) : class$org$eso$ohs$instruments$MaskInstrument));
    private int cabinetSize_ = 15;
    private int cabinetCount_ = 4;
    private double TEMP_COEFF = 2.0E-5;
    static /* synthetic */ Class class$org$eso$ohs$instruments$MaskInstrument;

    public MaskInstrument(String string, String string2) throws IOException, IllegalArgumentException {
        super(string, string2);
        this.initMaskData();
    }

    public boolean hasMasks() {
        return this.cabinetCount_ != -1 && this.cabinetSize_ != -1;
    }

    public String getDummyAdm() {
        return this.dummyAdpData_;
    }

    public String getDummyNaid() {
        PafFile pafFile = null;
        try {
            pafFile = new PafFile(new StringReader(this.dummyAdpData_));
        }
        catch (IOException iOException) {
            stdlog_.error((Object)iOException);
        }
        return pafFile.getPafIdentifier();
    }

    public void setCabinetSize(int n) {
        this.cabinetSize_ = n;
    }

    public void setCabinetCount(int n) {
        this.cabinetCount_ = n;
    }

    public int getCabinetCount() {
        return this.cabinetCount_;
    }

    public int getCabinetSize() {
        return this.cabinetSize_;
    }

    public double getTempCoeff() {
        return this.TEMP_COEFF;
    }

    public int getMaxMaskCount() {
        return this.cabinetCount_ * this.cabinetSize_;
    }

    protected void initMaskData() {
        stdlog_.debug((Object)"Sifetting identifier List for VIMOS");
        PafData[] pafDataArray = this.pafFile_.getIdentifierList();
        int n = 0;
        while (n < pafDataArray.length) {
            String string = pafDataArray[n].getIdentifier();
            String string2 = pafDataArray[n].getValue();
            if (string.equals("CABINET.COUNT")) {
                this.setCabinetCount(new Integer(string2));
            }
            if (string.equals("CABINET.SIZE")) {
                this.setCabinetSize(new Integer(pafDataArray[n].getValue()));
            }
            if (string.equals("DUMMY.ADM")) {
                this.dummyAdpData_ = new String(pafDataArray[n].getValue());
            }
            if (string.equals("TEMP.COEFF")) {
                this.TEMP_COEFF = new Double(pafDataArray[n].getValue());
            }
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

