/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.instruments;

import org.eso.ohs.instruments.InstrumentConstraintConfig;
import org.eso.ohs.instruments.ReadmeAttribute;

public class ReadmeBooleanType
extends ReadmeAttribute {
    private static final long serialVersionUID = -4378250031958139901L;
    public static final String DB_TYPE = "B";

    public ReadmeBooleanType(InstrumentConstraintConfig instrumentConstraintConfig) {
        super(instrumentConstraintConfig);
    }

    public String getDisplayValue() {
        if (this.getValue().equals("false")) {
            return "NO";
        }
        return "YES";
    }

    public Object getRawValue() {
        if (this.getValue().equals("false")) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public boolean isCompulsory() {
        InstrumentConstraintConfig instrumentConstraintConfig = this.getReadmeConfig();
        String string = this.getValue();
        return !instrumentConstraintConfig.isCompulsory() || this.hasValue();
    }

    public String verify() {
        String string = this.getValue();
        if (!this.isCompulsory()) {
            return "Not Defined";
        }
        if (string.equals("false") || string.equals("true")) {
            return "OK";
        }
        return "INVALID";
    }

    public String getToolTipText() {
        return "Select/Deselect";
    }

    public static String getDBType() {
        return DB_TYPE;
    }
}

