/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.instruments;

import gnu.regexp.RE;
import gnu.regexp.REException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import org.eso.ohs.instruments.Instrument;
import org.eso.ohs.instruments.TemplateSignatureMetaData;
import org.eso.ohs.instruments.ZipUtilsException;

public class ZipUtils {
    public static final String cvsID_ = "$Id: ZipUtils.java,v 1.20 2004/04/08 12:09:52 tcanavan Exp $";
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$instruments$ZipUtils == null ? (class$org$eso$ohs$instruments$ZipUtils = ZipUtils.class$("org.eso.ohs.instruments.ZipUtils")) : class$org$eso$ohs$instruments$ZipUtils));
    private static final String sep = File.separator;
    private static String baseTmpDir_;
    private File tmpDirL1_;
    private File rootDir_;
    private String zipFile_;
    private String dir1_;
    private Instrument instrument_;
    private int numTSFs_;
    private int numWarnings_;
    private int numCritical_;
    private int numInvalidTemplateNames_;
    private String report_;
    private String reportHead_;
    private boolean makeReport_;
    private boolean dirStructureOk_;
    private boolean dir1NameOk_;
    static /* synthetic */ Class class$org$eso$ohs$instruments$ZipUtils;

    public ZipUtils(String string) {
        this.zipFile_ = string;
        this.numWarnings_ = 0;
        this.numCritical_ = 0;
        this.numInvalidTemplateNames_ = 0;
        this.dirStructureOk_ = true;
        this.dir1NameOk_ = true;
        int n = this.zipFile_.lastIndexOf(sep) + 1;
        int n2 = this.zipFile_.lastIndexOf("-");
        this.dir1_ = this.zipFile_.substring(n, n2);
    }

    public int verifyIP(boolean bl) throws ZipUtilsException {
        this.reportHead_ = "\nVerify Instrument Package\n\nFilename: " + this.zipFile_;
        this.report_ = "\n\n\n";
        this.makeReport_ = bl;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(this.zipFile_);
        }
        catch (IOException iOException) {
            stdlog_.error((Object)("Zip file error: " + iOException.getMessage()));
            String string = "Error Verfying IP\nInvalid Zip File";
            throw new ZipUtilsException(string);
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        ZipEntry zipEntry = this.basicChecks(enumeration);
        this.handleDefaultISF(zipFile, zipEntry);
        enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry2 = enumeration.nextElement();
            if (!zipEntry2.getName().endsWith(".tsf")) continue;
            this.verifyTSF(zipFile, zipEntry2);
        }
        this.removeTmpDirs();
        return this.numWarnings_;
    }

    public String getReport() {
        String string = "\n\nNumber of TSF Files:        " + this.numTSFs_ + "\n" + "Files with Warnings:        " + this.numWarnings_ + "\n" + "Files with Critical Errors: " + this.numCritical_;
        return this.reportHead_ + string + this.report_;
    }

    public static void extract(InputStream inputStream, String string, String string2, boolean bl) throws IOException {
        if (!bl) {
            String string3 = string + sep + string2;
            ZipUtils.writeFileFromStream(inputStream, string3);
            inputStream.close();
        } else {
            ZipEntry zipEntry;
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string4 = zipEntry.getName();
                if (zipEntry.isDirectory()) {
                    ZipUtils.makeDirs(string + sep + string4);
                } else {
                    int n = string4.lastIndexOf(sep);
                    String string5 = n == -1 ? "" : string4.substring(0, n);
                    ZipUtils.makeDirs(string + sep + string5);
                    String string6 = string + sep + string4;
                    ZipUtils.writeFileFromStream(zipInputStream, string6);
                }
                zipInputStream.closeEntry();
            }
            zipInputStream.close();
        }
    }

    public static File removeSummaryIDX(File file) throws ZipUtilsException {
        File file2 = null;
        try {
            ZipFile zipFile = new ZipFile(file);
            boolean bl = false;
            file2 = File.createTempFile("ipacman", "zip");
            ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                int n;
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.getName().endsWith("summary.idx")) {
                    bl = true;
                    continue;
                }
                if (zipEntry.isDirectory()) continue;
                zipOutputStream.putNextEntry(zipEntry);
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                byte[] byArray = new byte[1024];
                while ((n = bufferedInputStream.read(byArray, 0, 1024)) != -1) {
                    zipOutputStream.write(byArray, 0, n);
                }
                bufferedInputStream.close();
                zipOutputStream.closeEntry();
            }
            zipOutputStream.close();
            if (bl) {
                return file2;
            }
            file2.delete();
            return file;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ZipUtilsException(fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            stdlog_.error((Object)iOException.getMessage());
            if (file2 != null && file2.exists()) {
                file2.delete();
            }
            throw new ZipUtilsException(iOException.getMessage());
        }
    }

    private static void writeFileFromStream(InputStream inputStream, String string) throws IOException {
        int n;
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        int n2 = 0;
        while ((n = bufferedInputStream.read()) != -1) {
            bufferedOutputStream.write(n);
            ++n2;
        }
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    private static void makeDirs(String string) {
        File file = new File(string);
        if (file.exists()) {
            return;
        }
        string = file.getAbsolutePath();
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, sep);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = string2 + sep + stringTokenizer.nextToken();
            File file2 = new File(string3);
            if (!file2.exists()) {
                file2.mkdir();
            }
            string2 = string3;
        }
    }

    public ZipEntry basicChecks(Enumeration enumeration) throws ZipUtilsException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        this.numTSFs_ = 0;
        ZipEntry zipEntry = null;
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry2 = (ZipEntry)enumeration.nextElement();
            ++n3;
            String string = zipEntry2.getName();
            stdlog_.debug((Object)("filename=" + string));
            boolean bl = true;
            if (zipEntry2.isDirectory()) {
                ++n;
                bl = false;
            } else if (string.endsWith(".tsf")) {
                ++this.numTSFs_;
            } else if (string.endsWith(sep + "default.isf")) {
                zipEntry = zipEntry2;
                ++n2;
                if (this.dir1NameOk_ && !string.equals(this.dir1_ + sep + "default.isf")) {
                    this.err("default.isf must be in directory " + this.dir1_);
                }
            } else if (string.endsWith("summary.idx")) {
                this.err("Instrument Package contains 'summary.idx'\nPlease remove it to insert the IP in the database");
            } else {
                ++n4;
                bl = false;
            }
            if (!bl) continue;
            this.checkDirStructure(string);
        }
        stdlog_.debug((Object)("entries in Zip     = " + n3));
        stdlog_.debug((Object)("directories in Zip = " + n));
        stdlog_.debug((Object)("isf files in Zip   = " + n2));
        stdlog_.debug((Object)("tsf files in Zip   = " + this.numTSFs_));
        stdlog_.debug((Object)("other files in Zip = " + n4));
        if (n2 < 1) {
            this.makeReport_ = false;
            this.err("default.isf not present in zip file");
        } else if (n2 > 1) {
            this.makeReport_ = false;
            this.err("More than 1 default.isf found in zip file");
        } else if (this.numTSFs_ == 0) {
            this.err("No tsf's present in zip file");
        }
        return zipEntry;
    }

    private void handleDefaultISF(ZipFile zipFile, ZipEntry zipEntry) throws ZipUtilsException {
        String string = zipEntry.getName();
        this.makeTmpDir(string);
        String string2 = this.writeZipEntryToFile(zipFile, zipEntry);
        String string3 = string2.substring(0, string2.lastIndexOf(sep));
        try {
            this.instrument_ = new Instrument(string3, string2);
            String string4 = this.instrument_.getVersion();
            float f = this.instrument_.getVersionNumber();
            stdlog_.debug((Object)("instrument_=" + this.instrument_.getInstrumentName()));
            stdlog_.debug((Object)("versionS=" + string4));
            stdlog_.debug((Object)("versionF=" + f));
            String string5 = this.dir1_.substring(this.dir1_.lastIndexOf("-") + 1);
            float f2 = Float.valueOf(string5).floatValue();
            stdlog_.debug((Object)("dir1_=" + this.dir1_));
            stdlog_.debug((Object)("verS=" + string5));
            stdlog_.debug((Object)("verF=" + f2));
            if (string4 == null) {
                this.err("Version number missing in default.isf file");
            } else {
                RE rE = new RE((Object)"^(0|[1-9][0-9]{0,3})\\.[0-9]{2}$");
                if (!rE.isMatch((Object)string4)) {
                    this.err("Illegal version number in default.isf file (" + string4 + ")\n" + "Version number in default.isf should be " + string5);
                }
                if (!string5.equals(string4)) {
                    this.err("Version number error:\nThe version number in the default.isf file (" + string4 + ") and\n" + "the version number of the first level directory (" + string5 + ")\n" + "should be exactly the same");
                }
            }
        }
        catch (IOException iOException) {
            this.deleteFile(string2);
            this.err("default.isf error: " + iOException.getMessage());
        }
        catch (REException rEException) {
            stdlog_.error((Object)("RegExp error: " + rEException.getMessage()));
            this.err("An error occurred while checking version number in default.isf");
        }
        this.deleteFile(string2);
        this.report_ = this.report_ + this.instrument_.toEngString() + "\n\n\n";
    }

    private void verifyTSF(ZipFile zipFile, ZipEntry zipEntry) throws ZipUtilsException {
        block6: {
            String string = zipEntry.getName();
            String string2 = this.writeZipEntryToFile(zipFile, zipEntry);
            try {
                TemplateSignatureMetaData templateSignatureMetaData = new TemplateSignatureMetaData(string2, this.instrument_);
                this.deleteFile(string2);
                this.report_ = this.report_ + templateSignatureMetaData.toEngString() + "\n";
                if (templateSignatureMetaData.getWarningStatus()) {
                    ++this.numWarnings_;
                }
                if (templateSignatureMetaData.getCriticalStatus()) {
                    ++this.numCritical_;
                    if (!this.makeReport_) {
                        this.err("Critical status: " + string);
                    }
                }
                if (templateSignatureMetaData.isValidTemplateName()) break block6;
                ++this.numInvalidTemplateNames_;
                if (!this.makeReport_) {
                    this.err("Invalid template name: " + string);
                }
            }
            catch (IOException iOException) {
                this.err("File IO error: " + iOException.getMessage());
            }
        }
    }

    public void makeTmpDir(String string) {
        this.tmpDirL1_ = ZipUtils.makeNewTmpDir();
        String string2 = string.substring(0, string.indexOf(sep));
        String string3 = this.tmpDirL1_ + sep + string2;
        this.rootDir_ = new File(string3);
        this.rootDir_.mkdir();
    }

    public static File makeNewTmpDir() {
        String string;
        File file;
        int n = 0;
        while ((file = new File(string = baseTmpDir_ + "IPacMan" + n++)).exists()) {
        }
        file.mkdir();
        return file;
    }

    private int checkDirStructure(String string) throws ZipUtilsException {
        int n = string.indexOf(sep);
        if (this.dirStructureOk_ && n != string.lastIndexOf(sep)) {
            this.dirStructureOk_ = false;
            this.err("Illegal directory structure in zip file");
        }
        if (this.dir1NameOk_ && !string.startsWith(this.dir1_ + sep)) {
            stdlog_.error((Object)("dir1_=" + this.dir1_));
            stdlog_.error((Object)("file=" + string));
            this.dir1NameOk_ = false;
            this.err("Illegal name for first level directory: " + string.substring(0, n) + "\nFirst level directory should be called: " + this.dir1_ + "\nfor all 'tsf' and 'isf' files in this Instrument Package");
        }
        return n;
    }

    public String writeZipEntryToFile(ZipFile zipFile, ZipEntry zipEntry) throws ZipUtilsException {
        String string = this.tmpDirL1_ + sep + zipEntry.getName();
        try {
            int n;
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            int n2 = 0;
            while ((n = bufferedInputStream.read()) != -1) {
                bufferedWriter.write(n);
                ++n2;
            }
            bufferedInputStream.close();
            bufferedWriter.close();
            stdlog_.debug((Object)("wrote " + n2 + " bytes to " + string));
        }
        catch (IOException iOException) {
            this.deleteFile(string);
            this.err("File IO error: " + iOException.getMessage());
        }
        return string;
    }

    public void deleteFile(String string) {
        File file = new File(string);
        if (file.exists()) {
            if (!file.delete()) {
                stdlog_.error((Object)("file IO error: can't delete " + string));
            }
        } else {
            stdlog_.debug((Object)("can't delete: file doesn't exist: " + string));
        }
    }

    public void removeTmpDirs() {
        this.delTree(this.tmpDirL1_);
    }

    private void delTree(File file) {
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            stdlog_.debug((Object)("deleting directory: " + file.toString()));
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                this.delTree(fileArray[n]);
                ++n;
            }
            file.delete();
        } else if (file.exists()) {
            file.delete();
        }
    }

    private void err(String string) throws ZipUtilsException {
        stdlog_.error((Object)string);
        this.report_ = this.report_ + string + "\n\n\n";
        if (!this.makeReport_) {
            this.removeTmpDirs();
            throw new ZipUtilsException(string);
        }
    }

    private static void err1(String string) throws ZipUtilsException {
        stdlog_.error((Object)string);
        throw new ZipUtilsException(string);
    }

    public static void setTmpDir(String string) throws ZipUtilsException {
        File file;
        if (string == null || string.trim().equals("")) {
            ZipUtils.err1("Folder name was not given");
        }
        if (!(string = string.trim()).endsWith(sep)) {
            string = string + sep;
        }
        if (!(file = new File(string)).exists()) {
            ZipUtils.err1("Temp folder [" + string + "] does not exist");
        }
        String string2 = string + "IPacMan-temp-test-dir";
        stdlog_.debug((Object)("creating & deleting directory: " + string2));
        File file2 = new File(string2);
        if (file2.mkdir() && file2.delete()) {
            stdlog_.debug((Object)(string2 + " created & deleted ok"));
        } else {
            stdlog_.error((Object)("failed to create and delete " + string2));
            ZipUtils.err1("Could not create files in temp folder " + string);
        }
        baseTmpDir_ = string;
        stdlog_.debug((Object)("baseTmpDir_=[" + baseTmpDir_ + "]"));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

