/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.persistence;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eso.ohs.apps.OHSApplication;
import org.eso.ohs.core.utilities.DefaultGTreeModel;
import org.eso.ohs.core.utilities.DefaultGTreePath;
import org.eso.ohs.core.utilities.Encrypt;
import org.eso.ohs.core.utilities.GTreeNode;
import org.eso.ohs.core.utilities.OHSConfig;
import org.eso.ohs.core.utilities.ObjConfig;
import org.eso.ohs.core.utilities.PafFile;

public class AppConfig
extends OHSConfig {
    protected static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$persistence$AppConfig == null ? (class$org$eso$ohs$persistence$AppConfig = AppConfig.class$("org.eso.ohs.persistence.AppConfig")) : class$org$eso$ohs$persistence$AppConfig));
    static /* synthetic */ Class class$org$eso$ohs$persistence$AppConfig;
    static /* synthetic */ Class class$org$eso$ohs$dfs$ObservationBlock;
    static /* synthetic */ Class class$org$eso$ohs$dfs$CalibrationBlock;

    public void setStandardOHSKeys(String string) {
        this.setStandardOHSKeys(string, System.getProperty("user.home"), false);
    }

    public void setStandardOHSKeys(String string, boolean bl) {
        this.setStandardOHSKeys(string, System.getProperty("user.home"), bl);
    }

    public void setStandardOHSKeys(String string, String string2) {
        this.setStandardOHSKeys(string, string2, false);
    }

    public void setStandardOHSKeys(String string, String string2, boolean bl) {
        this.setValue("DIR.CONFIG", string);
        this.setValue("DIR.HOME", string2);
        this.setValue("DIR.BASE", System.getProperty("user.dir"));
        this.setValue("APPSERVER.START", bl);
        this.setValue("INSTRUMENTS.FOLDER", new File("instruments").getAbsolutePath());
        this.setValue("IMPEX.FOLDER", new File("impex").getAbsolutePath());
        this.setValue("FC.FOLDER", new File(System.getProperty("user.dir")).getAbsolutePath());
        this.setValue("CACHE.FOLDER", new File("cache").getAbsolutePath());
        this.setValue("DUMP.DIRECTORY", new File(System.getProperty("user.dir")).getAbsolutePath());
        this.setValue("PARAMFILE.FOLDER", new File(System.getProperty("user.dir")).getAbsolutePath());
        this.setValue("PAF.DIRECTORY", new File(System.getProperty("user.home")).getAbsolutePath());
        this.setValue("APPSERVER.LOG", new File("logs/appserver.log").getAbsolutePath());
        this.setValue("PERSISTENCE.NAME.LEN", 32);
        this.setValue("PERSISTENCE.TEXT.LEN", 240);
        this.setValue("ENGINEERINGMODE.CLONING", false);
        this.setValue("FC.NOTES.ENABLED", false);
        this.setValue("FC.SCALED.ENABLED", false);
        this.setValue("INSTRUMENTS.IPVERSIONING.STARTPERIOD", "71");
        this.setValue("INSTRUMENTS.IPVERSIONING", "y");
        this.setValue("MAX.FINDING.CHARTS", "4");
        this.setValue("MAX.FINDING.CHARTSSIZE", "1000000");
    }

    public static AppConfig getAppConfig() {
        OHSConfig oHSConfig = OHSConfig.getInstance();
        AppConfig appConfig = null;
        if (oHSConfig instanceof AppConfig) {
            appConfig = (AppConfig)oHSConfig;
        }
        return appConfig;
    }

    public static void setAppConfig(AppConfig appConfig) {
        OHSConfig.setInstance(appConfig);
    }

    public void setVersion(String string) {
        if (string != null) {
            this.setValue("VERSION", string);
        }
    }

    public String getVersion() {
        return this.getValue("VERSION");
    }

    public int getPersistenceMaxNameLength() {
        return this.getInteger("PERSISTENCE.NAME.LEN");
    }

    public int getPersistenceMaxTextLength() {
        return this.getInteger("PERSISTENCE.TEXT.LEN");
    }

    public void setSuperUserEntitled(boolean bl) {
        this.setValue("USER.SUPERUSER.ENTITLED", bl);
    }

    public boolean isSuperUserEntitled() {
        return this.getBoolean("USER.SUPERUSER.ENTITLED");
    }

    public boolean isIPVersioningEnabled() {
        return this.getBoolean("INSTRUMENTS.IPVERSIONING");
    }

    public boolean isIPVersioningSingleIPMode() {
        return this.getBoolean("INSTRUMENTS.IPVERSIONING.SINGLEIPMODE");
    }

    public int getIPVersionStartPeriod() {
        return this.getInteger("INSTRUMENTS.IPVERSIONING.STARTPERIOD");
    }

    public int getMaxFindingCharts() {
        int n = -1;
        try {
            n = this.getInteger("MAX.FINDING.CHARTS");
        }
        catch (NumberFormatException numberFormatException) {
            n = 4;
        }
        return n;
    }

    public int getMaxFindingChartSize() {
        return this.getInteger("MAX.FINDING.CHARTSSIZE");
    }

    public String getIPVersionIPCache() {
        return this.prependBase("INSTRUMENTS.IPVERSIONING.IPCACHE.FOLDER");
    }

    public boolean getIPVersioningAutodownloadIPEnabled() {
        return this.getBoolean("INSTRUMENTS.IPVERSIONING.IPCACHE.AUTODOWNLOAD");
    }

    public void setCcsActive(boolean bl) {
        this.setValue("CCS.ACTIVE", bl);
    }

    public boolean isCcsActive() {
        return this.getBoolean("CCS.ACTIVE");
    }

    public void setEngModeClone(boolean bl) {
        this.setValue("ENGINEERINGMODE.CLONING", bl);
    }

    public boolean isCloneModeId() {
        return this.getBoolean("ENGINEERINGMODE.CLONING");
    }

    public boolean shouldUseAppServer() {
        return this.getValue("P2PP.SERVER.URL").length() > 0;
    }

    public String getAppServerUrl() {
        return this.getValue("P2PP.SERVER.URL");
    }

    public boolean getCCSEnabled() {
        return this.getBoolean("CCS.CONNECTION.ENABLED");
    }

    public boolean getFCNotesEnabled() {
        return this.getBoolean("FC.NOTES.ENABLED");
    }

    public boolean getUSGNotesEnabled() {
        return this.getBoolean("USD.ENABLED");
    }

    public boolean isFCScaled() {
        return this.getBoolean("FC.SCALED.ENABLED");
    }

    public String getCCSServer() {
        return this.getValue("CCS.OHS.SERVER.NAME");
    }

    public String getDbUserName() {
        return this.getUserName("");
    }

    public String getDbPassword() {
        return this.getPassword("");
    }

    public String getDbServer() {
        return this.getServer("");
    }

    public String getUrl(String string) {
        return this.getUrl("", string);
    }

    public String getDbName(String string) {
        return this.getDbName("", string);
    }

    public Class[] getDisplayedObjectTypes() {
        return new Class[]{class$org$eso$ohs$dfs$ObservationBlock == null ? (class$org$eso$ohs$dfs$ObservationBlock = AppConfig.class$("org.eso.ohs.dfs.ObservationBlock")) : class$org$eso$ohs$dfs$ObservationBlock, class$org$eso$ohs$dfs$CalibrationBlock == null ? (class$org$eso$ohs$dfs$CalibrationBlock = AppConfig.class$("org.eso.ohs.dfs.CalibrationBlock")) : class$org$eso$ohs$dfs$CalibrationBlock};
    }

    public boolean hasConnectInfo() {
        return this.hasConnectInfo("");
    }

    public void putObjCfg(ObjConfig objConfig) {
        Hashtable hashtable = this.getObjCfg();
        if (hashtable == null) {
            throw new IllegalArgumentException("ObjCfg at PERSISTENCE.OBJCFG not found");
        }
        hashtable.put(objConfig.key, objConfig);
    }

    public Hashtable getObjCfg() {
        Hashtable hashtable = (Hashtable)this.get("PERSISTENCE.OBJCFG");
        if (hashtable == null) {
            hashtable = new Hashtable();
            this.set("PERSISTENCE.OBJCFG", hashtable);
        }
        return hashtable;
    }

    public ObjConfig getObjCfg(Class clazz) {
        ObjConfig objConfig;
        Hashtable hashtable = this.getObjCfg();
        if (hashtable != null && (objConfig = (ObjConfig)hashtable.get(clazz)) != null) {
            return objConfig;
        }
        throw new IllegalArgumentException("getObjCfg: " + clazz);
    }

    public String[] folderColumnNames(Class clazz) {
        return this.getObjCfg((Class)clazz).columnNames;
    }

    public String[] folderColumnProperties(Class clazz) {
        return this.getObjCfg((Class)clazz).propertyNames;
    }

    public boolean isEditableProperty(Class clazz, String string) {
        String[] stringArray = this.getObjCfg((Class)clazz).editableProperties;
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals(string)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public boolean hasDbCfg() {
        String string = new String(OHSApplication.getShortName() + "-db.cf").toLowerCase();
        return new File(this.getConfigDir() + File.separator + string).exists();
    }

    public boolean dbCfgCanRead() {
        String string = new String(OHSApplication.getShortName() + "-db.cf").toLowerCase();
        return new File(this.getConfigDir() + File.separator + string).canRead();
    }

    public boolean getStartAppServer() {
        return this.getBoolean("APPSERVER.START");
    }

    public String getOptionDir() {
        return this.prependBase("OPTIONS.FOLDER");
    }

    public String getInstrumDir() {
        return this.prependBase("INSTRUMENTS.FOLDER");
    }

    public String getExpDir() {
        return this.prependBase("IMPEX.FOLDER");
    }

    public String getFcDir() {
        return this.prependBase("FC.FOLDER");
    }

    public String getSmtpName() {
        return this.getValue("MAIL.SMTP.HOST");
    }

    public String getP2PPSubmit() {
        return this.getValue("P2PP.SUBMIT");
    }

    public String getCacheDir() {
        return this.prependBase("CACHE.FOLDER");
    }

    public String getDumpDir() {
        return this.prependBase("DUMP.DIRECTORY");
    }

    public String getPafDirectory() {
        return this.prependBase("PAF.DIRECTORY");
    }

    public String getAppServerName() {
        return this.getValue("APPSERVER.NAME");
    }

    public String getAppServerPort() {
        return this.getValue("APPSERVER.PORT");
    }

    public String getAppServerHttpProxyHost() {
        return this.getValue("APPSERVER.HTTPPROXYHOST");
    }

    public String getAppServerHttpProxyPort() {
        return this.getValue("APPSERVER.HTTPPROXYPORT");
    }

    public String getAppServerDataPort() {
        return this.getValue("APPSERVER.DATAPORT");
    }

    public String getAppServerLog() {
        return this.prependBase("APPSERVER.LOG");
    }

    public String getParameterDir() {
        return this.prependBase("PARAMFILE.FOLDER");
    }

    public String getPropertyValue(String string) {
        stdlog_.info((Object)("apps.AppConfig  VALUE for: " + string + " :: " + this.getValue(string)));
        stdlog_.info((Object)("apps.AppConfig  TREE:\n" + this.toString()));
        return this.getValue(string);
    }

    public boolean isOperationsModeId(int n) {
        return n <= 10;
    }

    public boolean isEngineeringModeId(int n) {
        return n > 50000;
    }

    public boolean isVisitorModeId(int n) {
        return !this.isOperationsModeId(n) && !this.isEngineeringModeId(n) && this.isCcsActive();
    }

    public boolean isStandardModeId(int n) {
        return !this.isOperationsModeId(n) && !this.isEngineeringModeId(n) && !this.isCcsActive();
    }

    public void setHomeDir(String string) {
        this.setValue("DIR.HOME", string);
    }

    public void setupDbDirectConfig(String string, File file) throws IOException {
        Object object;
        if (file != null) {
            this.setValue(string + ".CFGFILE", file.getName());
            object = new PafFile(file.getAbsolutePath());
            if (((PafFile)object).compileError()) {
                throw new IOException("File " + file.getName() + " : " + ((PafFile)object).getCompileErrorMsg());
            }
            this.addPafData((PafFile)object, string);
        }
        if (((String)(object = this.getValue(string + ".ENCRYPTED.DATABASE.USERID"))).length() > 0 && AppConfig.decrypt((String)object) == null) {
            throw new IOException("Encrypted key ENCRYPTED.DATABASE.USERID  in config file " + file.getName() + " is corrupted. ");
        }
        String string2 = this.getValue(string + ".ENCRYPTED.DATABASE.USERID");
        if (string2.length() > 0 && AppConfig.decrypt(string2) == null) {
            throw new IOException("Encrypted key ENCRYPTED.DATABASE.USERID  in config file " + file.getName() + " is corrupted. ");
        }
    }

    private static String decrypt(String string) {
        String string2 = null;
        try {
            string2 = Encrypt.deCrypt(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string2 = null;
        }
        return string2;
    }

    protected String getUserName(String string) {
        String string2 = "DATABASE.USERID";
        String string3 = this.getValue(string + ".ENCRYPTED." + string2);
        string3 = string3.length() > 0 ? AppConfig.decrypt(string3) : null;
        if (string3 == null && (string3 = this.getValue(string + "." + string2)).length() == 0) {
            string3 = null;
        }
        return string3;
    }

    protected String getPassword(String string) {
        String string2 = "DATABASE.PASSWORD";
        String string3 = this.getValue(string + ".ENCRYPTED." + string2);
        string3 = string3.length() > 0 ? AppConfig.decrypt(string3) : null;
        if (string3 == null && (string3 = this.getValue(string + "." + string2)).length() == 0) {
            string3 = null;
        }
        return string3;
    }

    protected String getUrl(String string, String string2) {
        String string3 = this.getDbName(string2);
        if (string3 != null && string3.length() > 0) {
            String string4 = this.getServer(string);
            string3 = "jdbc:sybase:Tds:" + string4 + "/" + string3;
        } else {
            string3 = null;
        }
        return string3;
    }

    protected String getDbName(String string, String string2) {
        string2 = "DATABASE." + string2.toUpperCase();
        String string3 = this.getValue(string + "." + string2);
        if (string3.length() == 0) {
            string3 = AppConfig.decrypt(this.getValue(string + ".ENCRYPTED." + string2));
        }
        if (string3 != null && string3.length() > 0) {
            string3 = this.getValue(string + "." + string3);
        }
        return string3;
    }

    protected String getServer(String string) {
        String string2 = this.getValue(string + ".DATABASE.SERVER");
        if (string2.length() == 0) {
            string2 = null;
        }
        return string2;
    }

    public boolean hasConnectInfo(String string) {
        if (!(this.shouldUseAppServer() || this.getUserName(string) != null && this.getPassword(string) != null)) {
            return false;
        }
        GTreeNode gTreeNode = this.getNode(string + ".DATABASE");
        Enumeration enumeration = gTreeNode.getChildren();
        while (enumeration.hasMoreElements()) {
            GTreeNode gTreeNode2 = (GTreeNode)enumeration.nextElement();
            if (gTreeNode2.getName().equals("SERVER") || this.getUrl(gTreeNode2.getName()) != null) continue;
            return false;
        }
        return gTreeNode != null && gTreeNode.getChildCount() >= 2;
    }

    public void processOverrides() {
        OHSConfig oHSConfig = this.getSubConfig("USER.OVERRIDE");
        if (oHSConfig != null) {
            this.processOverrides(oHSConfig.getTree().getRoot(), (DefaultGTreeModel)oHSConfig.getTree());
        }
    }

    private void processOverrides(GTreeNode gTreeNode, DefaultGTreeModel defaultGTreeModel) {
        if (gTreeNode.isLeaf()) {
            if (!gTreeNode.getName().equals("FOLDER")) {
                GTreeNode[] gTreeNodeArray = defaultGTreeModel.getPathToRoot(gTreeNode);
                GTreeNode[] gTreeNodeArray2 = new GTreeNode[gTreeNodeArray.length - 1];
                System.arraycopy(gTreeNodeArray, 1, gTreeNodeArray2, 0, gTreeNodeArray2.length);
                DefaultGTreePath defaultGTreePath = new DefaultGTreePath(gTreeNodeArray2);
                this.setValue(this.tree_, defaultGTreePath, (Object)gTreeNode.getValue());
            }
        } else {
            Enumeration enumeration = gTreeNode.getChildren();
            while (enumeration.hasMoreElements()) {
                this.processOverrides((GTreeNode)enumeration.nextElement(), defaultGTreeModel);
            }
        }
    }

    public Vector getInstrumentsWithVMCheckInOk() {
        String string;
        String string2;
        Vector<String> vector = new Vector<String>();
        int n = 1;
        while ((string2 = this.getValue(string = "INSTRUMENTS.VMCHECKINOK." + n)).length() > 0) {
            vector.addElement(string2);
            ++n;
        }
        return vector;
    }

    public Vector getInstrumentsWithST() {
        String string;
        String string2;
        Vector<String> vector = new Vector<String>();
        int n = 1;
        while ((string2 = this.getValue(string = "INSTRUMENTS.SIDEREALTIME." + n)).length() > 0) {
            vector.addElement(string2);
            ++n;
        }
        return vector;
    }

    public Vector getAllowNoCheckSum() {
        String string;
        String string2;
        Vector<String> vector = new Vector<String>();
        int n = 1;
        while ((string2 = this.getValue(string = "CHECKSUM.DISABLED." + n)).length() > 0) {
            vector.addElement(string2);
            ++n;
        }
        return vector;
    }

    public boolean canCheckInVMOBs(String string) {
        boolean bl = false;
        if (string == null || string.length() == 0) {
            return false;
        }
        Vector vector = this.getInstrumentsWithVMCheckInOk();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string.equalsIgnoreCase(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean hasSTTime(String string) {
        boolean bl = false;
        if (string == null || string.length() == 0) {
            return false;
        }
        Vector vector = this.getInstrumentsWithST();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string.equalsIgnoreCase(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

