/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.persistence;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.eso.ohs.core.utilities.ObjectIOException;
import org.eso.ohs.dfs.BusinessObject;
import org.eso.ohs.dfs.FindingChart;
import org.eso.ohs.dfs.ObservingRun;
import org.eso.ohs.dfs.Readme;
import org.eso.ohs.dfs.Summary;
import org.eso.ohs.instruments.TemplateVersionInfo;
import org.eso.ohs.persistence.Config;
import org.eso.ohs.persistence.DirectoryNode;
import org.eso.ohs.persistence.Media;
import org.eso.ohs.persistence.ObjectNotFoundException;
import org.eso.ohs.persistence.StorageManager;

public class LocalDirMgr
implements StorageManager {
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$persistence$LocalDirMgr == null ? (class$org$eso$ohs$persistence$LocalDirMgr = LocalDirMgr.class$("org.eso.ohs.persistence.LocalDirMgr")) : class$org$eso$ohs$persistence$LocalDirMgr));
    public static final String DIRNAME_SUFFIX = "dir";
    public static final String NEWFILE_SUFFIX = "new";
    public static final String OLDFILE_SUFFIX = "old";
    final long creationTime_ = System.currentTimeMillis() / 10000L;
    private File localStoreRoot_;
    protected String subtreeDir_;
    private File subtreeDirFile_;
    private DirectoryNode rootNode_;
    private int idCounter = 0;
    private static boolean notify_mkdir_pop_up = false;
    private int userId_;
    static /* synthetic */ Class class$org$eso$ohs$persistence$LocalDirMgr;

    public LocalDirMgr(String string, int n) throws ObjectIOException {
        this.localStoreRoot_ = new File(string);
        if (!this.localStoreRoot_.exists()) {
            notify_mkdir_pop_up = true;
            this.localStoreRoot_.mkdirs();
        }
        this.setUserId(n);
    }

    public static boolean cacheDirsCreated() {
        return notify_mkdir_pop_up;
    }

    public void setUserId(int n) throws ObjectIOException {
        if (n == this.userId_ && this.subtreeDirFile_ != null) {
            return;
        }
        this.userId_ = n;
        this.subtreeDirFile_ = new File(this.localStoreRoot_, this.userId_ + ".dir");
        this.rootNode_ = new DirectoryNode(-1L);
        this.subtreeDir_ = this.subtreeDirFile_.getAbsolutePath();
        if (!Config.getCfg().isOperationsModeId(this.userId_)) {
            if (!this.subtreeDirFile_.exists()) {
                this.subtreeDirFile_.mkdirs();
            }
            if (!this.subtreeDirFile_.exists() || !this.subtreeDirFile_.isDirectory()) {
                throw new ObjectIOException("Cannot create local cache directory:\n" + this.subtreeDir_);
            }
            if (!this.subtreeDirFile_.canWrite()) {
                throw new ObjectIOException("Cannot write to local cache directory:\n" + this.subtreeDir_);
            }
        }
        this.initialise();
    }

    public int getUserId() {
        return this.userId_;
    }

    public DirectoryNode getRoot() {
        return this.rootNode_;
    }

    public String[] verifyTemplateSignatures(TemplateVersionInfo[] templateVersionInfoArray) {
        return new String[0];
    }

    public Media getMedia() {
        return Media.LOCAL;
    }

    public synchronized long getNewId(Class clazz, long l) {
        Config config = Config.getCfg();
        if (l != 0L) {
            return config.tableToUniqueId(config.uniqueToTableId(l), clazz);
        }
        long l2 = -(10L * this.creationTime_ + (long)(++this.idCounter));
        return config.tableToUniqueId(l2, clazz);
    }

    public boolean loginUser(String string) {
        return true;
    }

    public DirectoryNode find(long l, Class clazz) throws ObjectNotFoundException {
        Long l2 = new Long(l);
        Enumeration enumeration = this.getRoot().nodes();
        while (enumeration.hasMoreElements()) {
            DirectoryNode directoryNode = (DirectoryNode)enumeration.nextElement();
            File file = new Filename(directoryNode, l, clazz).getFile();
            if (!file.exists()) continue;
            return directoryNode;
        }
        if (l < 0L) {
            throw new ObjectNotFoundException("no such object: 0");
        }
        throw new ObjectNotFoundException("no such object: " + l);
    }

    public String locateRunPath(long l, Class clazz) throws ObjectNotFoundException {
        Long l2 = new Long(l);
        Enumeration enumeration = this.getRoot().nodes();
        while (enumeration.hasMoreElements()) {
            DirectoryNode directoryNode = (DirectoryNode)enumeration.nextElement();
            File file = new Filename(directoryNode, l, clazz).getFile();
            if (!file.exists()) continue;
            return file.getParentFile().getAbsolutePath();
        }
        if (l < 0L) {
            throw new ObjectNotFoundException("no such object: 0");
        }
        throw new ObjectNotFoundException("no such object: " + l);
    }

    public StorageManager.UnpackedStorableObject read(DirectoryNode directoryNode, long l, Class clazz) throws ObjectIOException {
        File file = new Filename(directoryNode, l, clazz).getFile();
        ObjectInputStream objectInputStream = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file.getAbsolutePath());
            objectInputStream = new ObjectInputStream(new BufferedInputStream(fileInputStream));
            StorageManager.UnpackedStorableObject unpackedStorableObject = (StorageManager.UnpackedStorableObject)objectInputStream.readObject();
            return unpackedStorableObject;
        }
        catch (IOException iOException) {
            throw new ObjectIOException(iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ObjectIOException(classNotFoundException);
        }
        finally {
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new ObjectIOException(iOException);
            }
        }
    }

    public void write(DirectoryNode directoryNode, long l, Class clazz, StorageManager.UnpackedStorableObject unpackedStorableObject) throws ObjectIOException {
        File file = new Filename(directoryNode, l, clazz).getFile();
        Filename filename = new Filename(directoryNode, l, clazz);
        Filename filename2 = new Filename(directoryNode, l, clazz);
        ObjectOutputStream objectOutputStream = null;
        filename.setBackupVersion(true);
        File file2 = filename.getFile();
        filename2.setNewVersion(true);
        File file3 = filename2.getFile();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file3.getAbsolutePath());
            objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(fileOutputStream));
            objectOutputStream.writeObject(unpackedStorableObject);
            objectOutputStream.close();
            objectOutputStream = null;
            file2.delete();
            file.renameTo(file2);
            file3.renameTo(file);
            file2.delete();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new ObjectIOException(iOException);
        }
        finally {
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new ObjectIOException(iOException);
            }
        }
    }

    public void update(DirectoryNode directoryNode, long l, Class clazz, StorageManager.UnpackedStorableObject unpackedStorableObject) throws ObjectIOException {
        this.write(directoryNode, l, clazz, unpackedStorableObject);
    }

    public void delete(DirectoryNode directoryNode, long l, Class clazz) {
        File file = new Filename(directoryNode, l, clazz).getFile();
        file.delete();
    }

    public void move(long l, Class clazz, DirectoryNode directoryNode, DirectoryNode directoryNode2) throws ObjectIOException {
        File file;
        File file2 = new Filename(directoryNode, l, clazz).getFile();
        if (!file2.renameTo(file = new Filename(directoryNode2, l, clazz).getFile())) {
            throw new ObjectIOException("Cannot move object");
        }
    }

    public void initialise() throws ObjectIOException {
        this.buildDirectoryTree();
        this.recoverLocalStorage();
    }

    private void buildDirectoryTree() {
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(LocalDirMgr.DIRNAME_SUFFIX);
            }
        };
        Stack<Serializable> stack = new Stack<Serializable>();
        stack.push(this.subtreeDirFile_);
        stack.push(this.getRoot());
        while (!stack.isEmpty()) {
            DirectoryNode directoryNode = (DirectoryNode)stack.pop();
            File file = (File)stack.pop();
            String[] stringArray = file.list(filenameFilter);
            if (stringArray == null) continue;
            int n = 0;
            while (n < stringArray.length) {
                long l = new Filename(directoryNode, stringArray[n]).getId();
                if (!directoryNode.hasSubdir(l)) {
                    directoryNode.mkdir(l);
                }
                DirectoryNode directoryNode2 = directoryNode.getDirectory(l);
                stack.push(new Filename(directoryNode2).getFile());
                stack.push(directoryNode2);
                ++n;
            }
        }
    }

    private void recoverLocalStorage() throws ObjectIOException {
        Enumeration enumeration = this.getRoot().nodes();
        while (enumeration.hasMoreElements()) {
            DirectoryNode directoryNode = (DirectoryNode)enumeration.nextElement();
            File file = new Filename(directoryNode).getFile();
            String[] stringArray = file.list();
            this.debug("Recovering:" + file);
            if (stringArray == null) continue;
            int n = 0;
            while (n < stringArray.length) {
                block9: {
                    Filename filename;
                    String string = stringArray[n];
                    try {
                        filename = new Filename(directoryNode, stringArray[n]);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        break block9;
                    }
                    this.debug("Checking:" + string);
                    String string2 = filename.getSuffix();
                    if (string2.equals(OLDFILE_SUFFIX)) {
                        Filename filename2 = new Filename(filename);
                        Filename filename3 = new Filename(filename);
                        filename2.setBackupVersion(false);
                        filename3.setBackupVersion(false);
                        filename3.setNewVersion(true);
                        File file2 = filename.getFile();
                        File file3 = filename2.getFile();
                        this.debug("node:" + directoryNode);
                        this.debug("fname:" + string);
                        this.debug("base:" + filename2);
                        this.debug("base file:" + filename2.getFile());
                        this.debug("old:" + filename);
                        this.debug("old file:" + filename.getFile());
                        this.debug("new:" + filename3);
                        this.debug("new file:" + filename3.getFile());
                        if (file3.exists()) {
                            this.debug("base file exists:" + file3);
                            this.checkOk(file2.delete(), "deleting");
                        } else {
                            File file4 = filename3.getFile();
                            if (file4.exists()) {
                                this.debug("installing new file:" + file4);
                                this.checkOk(file4.renameTo(file3), "renaming");
                                this.checkOk(file2.delete(), "deleting");
                            } else {
                                this.debug("reverting to oldf:" + file2);
                                this.checkOk(file2.renameTo(file3), "renaming");
                            }
                        }
                    }
                }
                ++n;
            }
        }
    }

    private void checkOk(boolean bl, String string) throws ObjectIOException {
        if (!bl) {
            throw new ObjectIOException("recovering: error while " + string);
        }
    }

    public boolean createDirectory(DirectoryNode directoryNode, long l) {
        if (directoryNode.mkdir(l)) {
            DirectoryNode directoryNode2 = directoryNode.getDirectory(l);
            File file = new Filename(directoryNode2).getFile();
            if (file.mkdir()) {
                return true;
            }
            directoryNode.rmdir(l);
        }
        return false;
    }

    public boolean moveDirectory(DirectoryNode directoryNode, DirectoryNode directoryNode2) throws ObjectIOException, ObjectNotFoundException {
        File file = new Filename(directoryNode).getFile();
        File file2 = new Filename(directoryNode2, new Filename(directoryNode).getFilename()).getFile();
        if (!file.exists()) {
            throw new ObjectNotFoundException("Not found: " + file.getAbsolutePath());
        }
        if (file.renameTo(file2)) {
            directoryNode.moveDirectory(directoryNode2);
            return true;
        }
        return false;
    }

    public boolean deleteDirectory(DirectoryNode directoryNode) {
        File file = new Filename(directoryNode).getFile();
        return file.delete() && directoryNode.getParent().rmdir(directoryNode.getId());
    }

    public Summary[] listObjects(DirectoryNode directoryNode) {
        Object object;
        File file = new Filename(directoryNode).getFile();
        String[] stringArray = file.list();
        Config config = Config.getCfg();
        int n = 0;
        if (stringArray == null) {
            return new Summary[0];
        }
        Summary[] summaryArray = new Summary[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            try {
                object = new Filename(directoryNode, stringArray[n2]);
                Class clazz = config.getClassForFileSuffix(((Filename)object).getSuffix());
                if (clazz != null && config.isUserLevel(clazz)) {
                    Summary summary;
                    summaryArray[n] = summary = new Summary();
                    summary.setId(((Filename)object).getId());
                    summary.setObjectClass(clazz);
                    ++n;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++n2;
        }
        object = new Summary[n];
        System.arraycopy(summaryArray, 0, object, 0, n);
        return object;
    }

    public boolean verifyObject(StorageManager.MultiObjSpec[] multiObjSpecArray) throws ObjectIOException {
        throw new ObjectIOException("verifyObject: Not implemented for local storage");
    }

    public byte[] downloadInstrumentPackage(String string, float f) throws ObjectIOException {
        throw new ObjectIOException("downloadInstrumentPackage: not implemented for local storage.");
    }

    public FindingChart[] populateFindingCharts(long l) throws ObjectIOException {
        throw new ObjectIOException("populateFindingCharts: not implemented for local storage.");
    }

    public void checkInReadme(ObservingRun observingRun) throws ObjectIOException {
        throw new ObjectIOException("checkInReadme: not implemented for local storage.");
    }

    public String checkOutReadme(ObservingRun observingRun) throws ObjectIOException {
        throw new ObjectIOException("checkOutReadme: not implemented for local storage.");
    }

    public void checkIn(StorageManager.MultiObjSpec[] multiObjSpecArray) throws ObjectIOException {
        throw new ObjectIOException("CheckIn: Not implemented for local storage");
    }

    public void checkOut(StorageManager.IdType[] idTypeArray) throws ObjectNotFoundException, ObjectIOException {
        throw new ObjectIOException("CheckOut: Not implemented for local storage");
    }

    public void multiStore(StorageManager.MultiObjSpec[] multiObjSpecArray) throws ObjectIOException {
        int n = 0;
        while (n < multiObjSpecArray.length) {
            StorageManager.MultiObjSpec multiObjSpec = multiObjSpecArray[n];
            if (multiObjSpec.isNew()) {
                this.write(multiObjSpec.dir, multiObjSpec.obj.getObject().getId(), multiObjSpec.getCls(), multiObjSpec.obj);
            } else {
                this.update(multiObjSpec.dir, multiObjSpec.obj.getObject().getId(), multiObjSpec.getCls(), multiObjSpec.obj);
            }
            ++n;
        }
    }

    private void debug(String string) {
    }

    public String toString() {
        return "LocalDirMgr[subtreeDir=" + this.subtreeDir_ + ",rootNode=" + this.getRoot() + "]";
    }

    public void usdSubmit(ObservingRun observingRun) throws ObjectIOException {
        throw new ObjectIOException("usdSubmit: not implemented for local storage.");
    }

    public Readme populateReadmeFile(ObservingRun observingRun) throws ObjectIOException {
        throw new ObjectIOException("populateReadmeFile is not implemented for local storage");
    }

    public void setReadmeFileStatus(String string, long l) throws ObjectIOException {
        throw new ObjectIOException("Not implemented for local storage");
    }

    public Readme populateReadmeFileReplicate(ObservingRun observingRun) throws ObjectIOException {
        throw new ObjectIOException("Not implemented for local storage");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class Filename {
        private long id_;
        private String suffix_;
        private DirectoryNode parent_;
        private boolean isNewVersion_;
        private boolean isBackupVersion_;

        public Filename(Filename filename) {
            this.id_ = filename.id_;
            this.suffix_ = filename.suffix_;
            this.parent_ = filename.parent_;
            this.isNewVersion_ = filename.isNewVersion_;
            this.isBackupVersion_ = filename.isBackupVersion_;
        }

        public Filename(DirectoryNode directoryNode, long l, Class clazz) {
            this.parent_ = directoryNode;
            this.id_ = l;
            this.suffix_ = BusinessObject.getSuffix(clazz);
        }

        public Filename(DirectoryNode directoryNode) {
            this.parent_ = directoryNode.getParent();
            this.id_ = directoryNode.getId();
            this.suffix_ = LocalDirMgr.DIRNAME_SUFFIX;
        }

        public Filename(DirectoryNode directoryNode, String string) {
            this.parent_ = directoryNode;
            int n = string.charAt(0) == 'L' ? -1 : 1;
            LocalDirMgr.this.debug("orig filename = " + string);
            this.suffix_ = this.getSuffixOf(string);
            if (this.suffix_.equals(LocalDirMgr.OLDFILE_SUFFIX)) {
                this.isBackupVersion_ = true;
                LocalDirMgr.this.debug("in OLD case, filename becomes: " + string);
                string = this.withoutSuffix(string);
                this.suffix_ = this.getSuffixOf(string);
            } else if (this.suffix_.equals(LocalDirMgr.NEWFILE_SUFFIX)) {
                this.isNewVersion_ = true;
                string = this.withoutSuffix(string);
                LocalDirMgr.this.debug("in NEW case, filename becomes: " + string);
                this.suffix_ = this.getSuffixOf(string);
            }
            String string2 = this.withoutSuffix(string);
            LocalDirMgr.this.debug("prefix = " + string2);
            LocalDirMgr.this.debug("suffix = " + this.suffix_);
            LocalDirMgr.this.debug("filename = " + string);
            this.id_ = (long)n * new Long(string2.substring(1));
        }

        public DirectoryNode getParent() {
            return this.parent_;
        }

        public long getId() {
            return this.id_;
        }

        public String getSuffix() {
            if (this.isNewVersion_) {
                return LocalDirMgr.NEWFILE_SUFFIX;
            }
            if (this.isBackupVersion_) {
                return LocalDirMgr.OLDFILE_SUFFIX;
            }
            return this.suffix_;
        }

        public File getFile() {
            if (this.parent_ == null) {
                return new File(LocalDirMgr.this.subtreeDir_);
            }
            Stack<String> stack = new Stack<String>();
            StringBuffer stringBuffer = new StringBuffer();
            DirectoryNode directoryNode = this.parent_;
            while (directoryNode.getParent() != null) {
                stack.push(this.makeFilename(directoryNode.getId(), LocalDirMgr.DIRNAME_SUFFIX));
                directoryNode = directoryNode.getParent();
            }
            stringBuffer.append(LocalDirMgr.this.subtreeDir_);
            while (!stack.isEmpty()) {
                stringBuffer.append(File.separator);
                stringBuffer.append(stack.pop());
            }
            return new File(stringBuffer.toString(), this.getFilename());
        }

        public String getFilename() {
            if (this.parent_ == null) {
                throw new IllegalArgumentException("Cannot get name of root");
            }
            String string = this.makeFilename(this.id_, this.suffix_);
            if (this.isNewVersion_) {
                string = string + ".new";
            } else if (this.isBackupVersion_) {
                string = string + ".old";
            }
            return string;
        }

        public void setBackupVersion(boolean bl) {
            this.isBackupVersion_ = bl;
        }

        public boolean getBackupVersion() {
            return this.isBackupVersion_;
        }

        public void setNewVersion(boolean bl) {
            this.isNewVersion_ = bl;
        }

        public boolean getNewVersion() {
            return this.isNewVersion_;
        }

        public String getBaseName() {
            if (this.parent_ == null) {
                throw new IllegalArgumentException("Cannot get name of root");
            }
            return this.makeFilename(this.id_, this.suffix_);
        }

        private String getSuffixOf(String string) {
            int n = string.lastIndexOf(46);
            return n >= 0 ? string.substring(n + 1) : "";
        }

        private String withoutSuffix(String string) {
            int n = string.lastIndexOf(46);
            return n >= 0 ? string.substring(0, n) : string;
        }

        private String makeFilename(long l, String string) {
            return (l < 0L ? "L" : "G") + Math.abs(l) + "." + string;
        }

        public String toString() {
            String string = "id=" + this.id_ + ", suffix=" + this.suffix_ + ", parent=" + this.parent_;
            if (this.isNewVersion_) {
                string = string + ",isNew";
            }
            if (this.isBackupVersion_) {
                string = string + ",isBackup";
            }
            return "Filename[" + string + "]";
        }
    }
}

