/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.persistence;

import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import org.eso.ohs.core.utilities.ObjectIOException;
import org.eso.ohs.dfs.BusinessObject;
import org.eso.ohs.dfs.FindingChart;
import org.eso.ohs.dfs.ObservingRun;
import org.eso.ohs.dfs.Readme;
import org.eso.ohs.dfs.StorableObject;
import org.eso.ohs.persistence.DirectoryNode;
import org.eso.ohs.persistence.LocalDirMgr;
import org.eso.ohs.persistence.Media;
import org.eso.ohs.persistence.ObjectManager;
import org.eso.ohs.persistence.ObjectNotFoundException;
import org.eso.ohs.persistence.StorageManager;

public abstract class OHSPersistence
extends ObjectManager {
    private final String rcsid = "$Id: OHSPersistence.java,v 1.15 2005/01/14 13:57:00 tcanavan Exp $";
    protected int userId_ = -1;

    public void setUserId(int n) throws ObjectIOException {
        Enumeration enumeration = this.mediaMgr_.keys();
        this.userId_ = n;
        while (enumeration.hasMoreElements()) {
            Media media = (Media)enumeration.nextElement();
            ((StorageManager)this.mediaMgr_.get(media)).setUserId(n);
        }
    }

    public int getUserId() {
        return this.userId_;
    }

    public BusinessObject copy(Media media, DirectoryNode directoryNode, BusinessObject businessObject) throws ObjectIOException {
        return this.copy(media, directoryNode, businessObject, 0L);
    }

    public BusinessObject copy(Media media, DirectoryNode directoryNode, BusinessObject businessObject, long l) throws ObjectIOException {
        BusinessObject businessObject2 = businessObject.copy();
        this.register(media, directoryNode, businessObject2, l);
        return businessObject2;
    }

    public void recursiveDelete(BusinessObject businessObject) throws ObjectIOException, ObjectNotFoundException {
        BusinessObject[] businessObjectArray = this.allDescendantsOf(businessObject);
        int n = 0;
        while (n < businessObjectArray.length) {
            BusinessObject businessObject2 = businessObjectArray[n];
            ObjectManager.RegistryEntry registryEntry = this.registry_.lookup(businessObject2.getId());
            this.deleteBusObj(registryEntry.getMedia(), businessObject2.getId(), businessObject2.getClass());
            ++n;
        }
    }

    protected BusinessObject[] allDescendantsOf(BusinessObject businessObject) {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        Stack<BusinessObject> stack = new Stack<BusinessObject>();
        stack.push(businessObject);
        while (!stack.isEmpty()) {
            object = (BusinessObject)stack.pop();
            BusinessObject[] businessObjectArray = ((BusinessObject)object).getBusObjChildren();
            vector.addElement(object);
            int n = 0;
            while (n < businessObjectArray.length) {
                stack.push(businessObjectArray[n]);
                ++n;
            }
        }
        object = new BusinessObject[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    protected void setDbaseIds(BusinessObject businessObject, BusinessObject businessObject2) {
        businessObject.setDbaseId(businessObject2.getId());
        BusinessObject[] businessObjectArray = businessObject2.getBusObjChildren();
        BusinessObject[] businessObjectArray2 = businessObject2.getBusObjChildren();
        int n = 0;
        while (n < businessObjectArray.length) {
            this.setDbaseIds(businessObjectArray2[n], businessObjectArray[n]);
            ++n;
        }
    }

    public Media getMediaFor(long l) throws IllegalArgumentException {
        ObjectManager.RegistryEntry registryEntry = this.registry_.lookup(l);
        if (registryEntry == null) {
            throw new IllegalArgumentException("Object not in Registry: " + l);
        }
        return registryEntry.getMedia();
    }

    public Media getMediaFor(StorableObject storableObject) throws IllegalArgumentException {
        ObjectManager.RegistryEntry registryEntry = this.registry_.lookup(storableObject.getId());
        if (registryEntry == null) {
            throw new IllegalArgumentException("Object not in Registry: " + storableObject);
        }
        return registryEntry.getMedia();
    }

    public boolean authenticateUser(Media media, String string) throws ObjectIOException {
        StorageManager storageManager = this.getStorageManager(media);
        return storageManager.loginUser(string);
    }

    public String getRootFolderPath(ObservingRun observingRun) throws IllegalArgumentException, ObjectNotFoundException {
        ObjectManager.RegistryEntry registryEntry = this.registry_.lookup(observingRun.getId());
        if (registryEntry == null) {
            throw new IllegalArgumentException("Object not in Registry: " + observingRun);
        }
        LocalDirMgr localDirMgr = (LocalDirMgr)this.getStorageManager(Media.LOCAL);
        String string = localDirMgr.locateRunPath(observingRun.getId(), observingRun.getClass());
        return string;
    }

    public FindingChart[] populateFindingCharts(Media media, long l) throws ObjectIOException {
        return this.getStorageManager(media).populateFindingCharts(l);
    }

    public Readme populateReadmeFile(Media media, ObservingRun observingRun) throws ObjectIOException {
        return this.getStorageManager(media).populateReadmeFile(observingRun);
    }

    public Readme populateReadmeFileReplicate(Media media, ObservingRun observingRun) throws ObjectIOException {
        return this.getStorageManager(media).populateReadmeFileReplicate(observingRun);
    }

    public void setReadmeFileStatus(Media media, String string, long l) throws ObjectIOException {
        this.getStorageManager(media).setReadmeFileStatus(string, l);
    }
}

