/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.tds.DoneToken;
import com.sybase.jdbc2.tds.Dumpable;
import com.sybase.jdbc2.tds.TdsInputStream;
import com.sybase.jdbc2.tds.TdsOutputStream;
import com.sybase.jdbc2.utils.DumpFilter;
import com.sybase.jdbc2.utils.DumpInfo;
import com.sybase.jdbc2.utils.HexConverts;
import java.io.IOException;

public class SrvDoneToken
extends DoneToken
implements Dumpable {
    public static final int TDS_NOT_IN_TRAN = 0;
    public static final int TDS_TRAN_SUCCEED = 1;
    public static final int TDS_TRAN_PROGRESS = 2;
    public static final int TDS_STMT_ABORT = 3;
    public static final int TDS_TRAN_ABORT = 4;
    protected static final String[] TRANSTATE_NAMES = new String[]{"TDS_NOT_IN_TRAN", "TDS_TRAN_SUCCEED", "TDS_TRAN_PROGRESS", "TDS_STMT_ABORT", "TDS_TRAN_ABORT"};

    public SrvDoneToken(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    public SrvDoneToken(TdsInputStream tdsInputStream) throws IOException {
        super(tdsInputStream);
    }

    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        DumpInfo dumpInfo = null;
        if (dumpFilter.includesToken(this.getTokenType())) {
            dumpInfo = dumpFilter.getDumpInfo();
            String string = null;
            switch (this.getTokenType()) {
                case 253: {
                    string = "DONE";
                    break;
                }
                case 255: {
                    string = "DONEINPROC";
                    break;
                }
                case 254: {
                    string = "DONEPROC";
                    break;
                }
            }
            if (dumpFilter.includesDetail(0)) {
                dumpInfo.addInfo("Token", 1, String.valueOf(string) + " Token (0x" + HexConverts.hexConvert(this.getTokenType(), 1) + "); fixed length.");
            } else {
                dumpInfo.addInfo("Token", 1, String.valueOf(string) + " Token");
            }
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Length", 0, 8L);
            }
            if (dumpFilter.includesDetail(3)) {
                String[] stringArray = new String[]{"DONE_FINAL", "DONE_MORE", "DONE_ERROR", "DONE_INXACT", "DONE_PROC", "DONE_COUNT", "DONE_ATTN", "DONE_EVENT"};
                dumpInfo.addBitfield("Status", 2, this._status, stringArray);
                dumpInfo.addField("TranState", 2, this._tranState, TRANSTATE_NAMES);
                if ((this._status & 0x10) != 0) {
                    dumpInfo.addInt("Count", 4, this._count);
                } else {
                    dumpInfo.addInt("Count (unused)", 4, this._count);
                }
            }
        }
        return dumpInfo;
    }

    public boolean getFinal() {
        return (1 & this._status) <= 0;
    }

    public int getTokenType() {
        return 253;
    }

    public void send(TdsOutputStream tdsOutputStream) throws IOException {
        this.send(tdsOutputStream, 253);
    }

    protected void send(TdsOutputStream tdsOutputStream, int n) throws IOException {
        tdsOutputStream.writeByte(n);
        tdsOutputStream.writeShort(this._status);
        tdsOutputStream.writeShort(this._tranState);
        tdsOutputStream.writeInt(this._count);
    }
}

