/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.tds.DataFormat;
import com.sybase.jdbc2.tds.Dumpable;
import com.sybase.jdbc2.tds.ParamFormat2Token;
import com.sybase.jdbc2.tds.SrvDataFormat;
import com.sybase.jdbc2.tds.SrvFormatToken;
import com.sybase.jdbc2.tds.SrvParamDataFormat2;
import com.sybase.jdbc2.tds.TdsInputStream;
import com.sybase.jdbc2.tds.TdsOutputStream;
import com.sybase.jdbc2.utils.DumpFilter;
import com.sybase.jdbc2.utils.DumpInfo;
import com.sybase.jdbc2.utils.HexConverts;
import java.io.IOException;
import java.util.Vector;

public class SrvParamFormat2Token
extends ParamFormat2Token
implements SrvFormatToken,
Dumpable {
    protected Vector _dataformats = new Vector();
    private long _len;

    public SrvParamFormat2Token() {
    }

    public SrvParamFormat2Token(TdsInputStream tdsInputStream) throws IOException {
        this._len = this.readLength(tdsInputStream);
        this._numParams = tdsInputStream.readShort();
        this.addDataFormats(tdsInputStream, this._numParams);
    }

    public void addDataFormats(TdsInputStream tdsInputStream, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            this._dataformats.addElement(this.dataFormatFactory(tdsInputStream));
            ++n2;
        }
    }

    public void addFormat(DataFormat dataFormat) {
        this._dataformats.addElement(dataFormat);
    }

    protected DataFormat dataFormatFactory(TdsInputStream tdsInputStream) throws IOException {
        return new SrvParamDataFormat2(tdsInputStream);
    }

    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        DumpInfo dumpInfo = null;
        if (dumpFilter.includesToken(32)) {
            dumpInfo = dumpFilter.getDumpInfo();
            if (dumpFilter.includesDetail(0)) {
                dumpInfo.addInfo("Token", 1, "PARAMFMT2 Token (0x" + HexConverts.hexConvert(32, 1) + "); variable length.");
            } else {
                dumpInfo.addInfo("Token", 1, "PARAMFMT2 Token");
            }
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Length", 4, this._len);
            }
            dumpInfo.addInt("Number of Params", 2, this._numParams);
            int n = 0;
            while (n < this.getFormatCount()) {
                dumpInfo.addInfo("TDSFmt", 0, "Param " + (n + 1));
                SrvParamDataFormat2 srvParamDataFormat2 = (SrvParamDataFormat2)this.formatAt(n);
                dumpInfo.addInfo(srvParamDataFormat2.dump(dumpFilter));
                ++n;
            }
        }
        return dumpInfo;
    }

    public DataFormat formatAt(int n) {
        return (SrvParamDataFormat2)this._dataformats.elementAt(n);
    }

    public int getByteLength(int n) {
        SrvParamDataFormat2 srvParamDataFormat2 = (SrvParamDataFormat2)this.formatAt(n);
        return DataFormat.lengthSize(srvParamDataFormat2._datatype);
    }

    public int getFormatCount() {
        return this._dataformats.size();
    }

    public long getLength() {
        long l = 2L;
        int n = 0;
        while (n < this._dataformats.size()) {
            SrvDataFormat srvDataFormat = (SrvDataFormat)this._dataformats.elementAt(n);
            l += (long)srvDataFormat.length();
            ++n;
        }
        return l;
    }

    public int getTokenType() {
        return 32;
    }

    public void sendFormat(TdsOutputStream tdsOutputStream) throws IOException {
        int n = 0;
        while (n < this._dataformats.size()) {
            SrvParamDataFormat2 srvParamDataFormat2 = (SrvParamDataFormat2)this._dataformats.elementAt(n);
            srvParamDataFormat2.send(tdsOutputStream);
            ++n;
        }
    }
}

