/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.tds.DataFormat;
import com.sybase.jdbc2.tds.Dumpable;
import com.sybase.jdbc2.tds.RowDataFormat2;
import com.sybase.jdbc2.tds.TdsInputStream;
import com.sybase.jdbc2.utils.DumpFilter;
import com.sybase.jdbc2.utils.DumpInfo;
import java.io.IOException;

public class SrvRowDataFormat2
extends RowDataFormat2
implements Dumpable {
    protected SrvRowDataFormat2() {
    }

    public SrvRowDataFormat2(TdsInputStream tdsInputStream) throws IOException {
        super(tdsInputStream);
    }

    public SrvRowDataFormat2(String string, int n, int n2, int n3, int n4, int n5, Object object) {
        this(string, n, n2, n3, object);
        this._precision = n4;
        this._scale = n5;
    }

    public SrvRowDataFormat2(String string, int n, int n2, int n3, Object object) {
        this._name = string;
        if (this._name != null) {
            this._nameLen = string.length();
        } else {
            this._name = "";
            this._nameLen = 0;
        }
        this._status = n2;
        this._usertype = 0;
        switch (n) {
            case 9217: {
                this._datatype = 36;
                this._blobType = 1;
                if (object != null) {
                    this._className = object.getClass().getName();
                    this._classIdLen = this._className.length();
                    break;
                }
                this._classIdLen = 0;
                break;
            }
            case 9219: {
                this._datatype = 36;
                this._blobType = 3;
                this._classIdLen = 0;
                break;
            }
            case 9220: {
                this._datatype = 36;
                this._blobType = 4;
                this._classIdLen = 0;
                break;
            }
            default: {
                this._datatype = n;
            }
        }
        this._length = n3;
        this._precision = 0;
        this._scale = 0;
        this._locale = null;
        this._localeLen = 0;
    }

    public SrvRowDataFormat2(String string, String string2, String string3, String string4, String string5, int n, int n2, int n3, int n4, int n5, Object object) {
        this(string5, n, n2, n3, n4, n5, object);
        this._labelName = string;
        if (this._labelName != null) {
            this._labelLen = string.length();
        } else {
            this._labelName = this._name;
            this._labelLen = this._nameLen;
        }
        this._catalogName = string2;
        if (this._catalogName != null) {
            this._catalogLen = string2.length();
        } else {
            this._catalogName = "";
            this._catalogLen = 0;
        }
        this._schemaName = string3;
        if (this._schemaName != null) {
            this._schemaLen = string3.length();
        } else {
            this._schemaName = "";
            this._schemaLen = 0;
        }
        this._tableName = string4;
        if (this._tableName != null) {
            this._tableLen = string4.length();
        } else {
            this._tableName = "";
            this._tableLen = 0;
        }
    }

    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        DumpInfo dumpInfo = dumpFilter.getDumpInfo();
        if (dumpFilter.includesDetail(3) || dumpFilter.includesDetail(7)) {
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Column Label Length", 1, this._labelLen);
            }
            if (this._labelLen > 0) {
                dumpInfo.addText("Column Label", this._labelLen, this._labelName);
            }
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Catalog Name Length", 1, this._catalogLen);
            }
            if (this._catalogLen > 0) {
                dumpInfo.addText("Catalog", this._catalogLen, this._catalogName);
            }
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Schema Length", 1, this._schemaLen);
            }
            if (this._schemaLen > 0) {
                dumpInfo.addText("Scehma", this._schemaLen, this._schemaName);
            }
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Table Name Length", 1, this._tableLen);
            }
            if (this._tableLen > 0) {
                dumpInfo.addText("Table Name", this._tableLen, this._tableName);
            }
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Column Name Length", 1, this._nameLen);
            }
            if (this._nameLen > 0) {
                dumpInfo.addText("Column Name", this._nameLen, this._name);
            }
            String[] stringArray = new String[]{"<unrecognized>", "ROW_HIDDEN", "ROW_KEY", "ROW_VERSION", "ROW_NODATA", "ROW_UPDATABLE", "ROW_NULLALLOWED", "ROW_IDENTITY ", "ROW_PADCHAR"};
            dumpInfo.addBitfield("Status", 4, this._status, stringArray);
            dumpInfo.addHex("User Type", 4, this._usertype);
            dumpInfo.addInfo("Data Type", 1, DataFormat.getDataTypeString(this._datatype));
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Length", DataFormat.lengthSize(this._datatype), this._length);
            }
            if (this._datatype == 106 || this._datatype == 108) {
                dumpInfo.addHex("Precision", 1, this._precision);
                dumpInfo.addHex("Scale", 1, this._scale);
            }
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Locale Length", 1, this._localeLen);
            }
            if (this._localeLen > 0) {
                dumpInfo.addText("Locale", this._localeLen, this._locale);
            }
        }
        return dumpInfo;
    }

    public int getTokenType() {
        return -1;
    }
}

