/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.tds.DataFormat;
import com.sybase.jdbc2.tds.Dumpable;
import com.sybase.jdbc2.tds.RowFormatToken;
import com.sybase.jdbc2.tds.SrvDataFormat;
import com.sybase.jdbc2.tds.SrvFormatToken;
import com.sybase.jdbc2.tds.TdsInputStream;
import com.sybase.jdbc2.tds.TdsOutputStream;
import com.sybase.jdbc2.utils.DumpFilter;
import com.sybase.jdbc2.utils.DumpInfo;
import com.sybase.jdbc2.utils.HexConverts;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;

public class SrvRowFormatToken
extends RowFormatToken
implements SrvFormatToken,
Dumpable {
    protected Vector _dataformats = new Vector();
    protected int _len;

    public SrvRowFormatToken() throws SQLException {
    }

    public SrvRowFormatToken(TdsInputStream tdsInputStream) throws IOException, SQLException {
        this._len = (int)this.readLength(tdsInputStream);
        this._numColumns = tdsInputStream.readShort();
        this.addDataFormats(tdsInputStream, this._numColumns);
    }

    public void addDataFormats(TdsInputStream tdsInputStream, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            this._dataformats.addElement(this.dataFormatFactory(tdsInputStream));
            ++n2;
        }
    }

    public void addFormat(DataFormat dataFormat) {
        this._dataformats.addElement(dataFormat);
    }

    protected DataFormat dataFormatFactory(TdsInputStream tdsInputStream) throws IOException {
        return new SrvDataFormat(tdsInputStream);
    }

    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        DumpInfo dumpInfo = null;
        if (dumpFilter.includesToken(238)) {
            dumpInfo = dumpFilter.getDumpInfo();
            if (dumpFilter.includesDetail(0)) {
                dumpInfo.addInfo("Token", 1, "ROWFMT Token (0x" + HexConverts.hexConvert(238, 1) + ");");
            } else {
                dumpInfo.addInfo("Token", 1, "ROWFMT Token");
            }
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Length", 2, this._len);
            }
            dumpInfo.addInt("Number of Columns", 2, this._numColumns);
            int n = 0;
            while (n < this.getFormatCount()) {
                dumpInfo.addInfo("TDSFmt", 0, "Column " + (n + 1));
                DataFormat dataFormat = this.formatAt(n);
                dumpInfo.addInfo(((SrvDataFormat)dataFormat).dump(dumpFilter));
                ++n;
            }
        }
        return dumpInfo;
    }

    public DataFormat formatAt(int n) {
        return (SrvDataFormat)this.getDataFormat(n);
    }

    public int getByteLength(int n) {
        DataFormat dataFormat = this.formatAt(n);
        return DataFormat.lengthSize(dataFormat._datatype);
    }

    protected DataFormat getDataFormat(int n) {
        return (SrvDataFormat)this._dataformats.elementAt(n);
    }

    public int getFormatCount() {
        return this._dataformats.size();
    }

    public long getLength() {
        int n = 2;
        int n2 = 0;
        while (n2 < this._dataformats.size()) {
            SrvDataFormat srvDataFormat = (SrvDataFormat)this._dataformats.elementAt(n2);
            n += srvDataFormat.length();
            ++n2;
        }
        return n;
    }

    public int getTokenType() {
        return 238;
    }

    public boolean hasKeyColumns() {
        boolean bl = false;
        int n = 0;
        while (n < this._dataformats.size()) {
            SrvDataFormat srvDataFormat = (SrvDataFormat)this._dataformats.elementAt(n);
            if ((srvDataFormat._status & 2) != 0) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    protected void send(TdsOutputStream tdsOutputStream) throws IOException {
        tdsOutputStream.writeByte(238);
        tdsOutputStream.writeShort((int)this.getLength());
        tdsOutputStream.writeShort(this._dataformats.size());
        int n = 0;
        while (n < this._dataformats.size()) {
            SrvDataFormat srvDataFormat = (SrvDataFormat)this._dataformats.elementAt(n);
            srvDataFormat.send(tdsOutputStream);
            ++n;
        }
    }

    public void sendFormat(TdsOutputStream tdsOutputStream) throws IOException {
        int n = 0;
        while (n < this._dataformats.size()) {
            SrvDataFormat srvDataFormat = (SrvDataFormat)this._dataformats.elementAt(n);
            srvDataFormat.send(tdsOutputStream);
            ++n;
        }
    }
}

