/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.tds.DataFormat;
import com.sybase.jdbc2.tds.SrvCapabilityToken;
import com.sybase.jdbc2.tds.SrvFormatToken;
import com.sybase.jdbc2.tds.SrvRowDataFormat2;
import com.sybase.jdbc2.tds.SrvSQLTypeFormatter;
import com.sybase.jdbc2.tds.SrvTypeException;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class SrvSQLTypeFormatter2
extends SrvSQLTypeFormatter {
    public SrvSQLTypeFormatter2(SrvFormatToken srvFormatToken, SrvCapabilityToken srvCapabilityToken) {
        super(srvFormatToken, srvCapabilityToken);
    }

    public DataFormat[] buildDataFormat(ResultSet resultSet) throws IOException {
        DataFormat[] dataFormatArray = null;
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            if (n == 0) {
                throw new SrvTypeException("Cannot format result set with  0 columns");
            }
            dataFormatArray = new SrvRowDataFormat2[n];
            int n2 = 1;
            while (n2 <= n) {
                int n3;
                Object v = SrvSQLTypeFormatter._formatmap.get(new Integer(resultSetMetaData.getColumnType(n2)));
                if (v == null) {
                    throw new SrvTypeException("Cannot map JDBC type " + resultSetMetaData.getColumnTypeName(n2) + " to TDS type");
                }
                int[] nArray = (int[])v;
                if (this._cap.handlesDataType(nArray[1])) {
                    n3 = 0;
                    if (resultSetMetaData.isNullable(n2) == 1) {
                        n3 |= 0x20;
                    }
                    if (resultSetMetaData.isWritable(n2)) {
                        n3 |= 0x10;
                    }
                } else {
                    throw new SrvTypeException("Not handling client literal  conversion for JDBC types " + resultSetMetaData.getColumnTypeName(n2));
                }
                String string = resultSetMetaData.getColumnLabel(n2);
                String string2 = resultSetMetaData.getCatalogName(n2);
                String string3 = resultSetMetaData.getSchemaName(n2);
                String string4 = resultSetMetaData.getTableName(n2);
                dataFormatArray[n2 - 1] = new SrvRowDataFormat2(string, string2, string3, string4, resultSetMetaData.getColumnName(n2), nArray[1], n3, nArray[2], resultSetMetaData.getPrecision(n2), resultSetMetaData.getScale(n2), null);
                ++n2;
            }
        }
        catch (SQLException sQLException) {
            throw new SrvTypeException("SQL to TDS conversion error: " + sQLException);
        }
        return dataFormatArray;
    }
}

