/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.tds.Iana;
import com.sybase.jdbc2.tds.ParamFormatToken;
import com.sybase.jdbc2.tds.Slurp;
import com.sybase.jdbc2.tds.SrvAttentionException;
import com.sybase.jdbc2.tds.SrvBulkException;
import com.sybase.jdbc2.tds.SrvCapabilityToken;
import com.sybase.jdbc2.tds.SrvDataInputStream;
import com.sybase.jdbc2.tds.SrvDataOutputStream;
import com.sybase.jdbc2.tds.SrvDbrpcToken;
import com.sybase.jdbc2.tds.SrvDoneProcToken;
import com.sybase.jdbc2.tds.SrvDoneToken;
import com.sybase.jdbc2.tds.SrvDumpInputStream;
import com.sybase.jdbc2.tds.SrvDumpOutputStream;
import com.sybase.jdbc2.tds.SrvEedToken;
import com.sybase.jdbc2.tds.SrvEventListener;
import com.sybase.jdbc2.tds.SrvEventToken;
import com.sybase.jdbc2.tds.SrvFormatToken;
import com.sybase.jdbc2.tds.SrvJavaTypeFormatter;
import com.sybase.jdbc2.tds.SrvLanguageToken;
import com.sybase.jdbc2.tds.SrvLoginToken;
import com.sybase.jdbc2.tds.SrvLogoutToken;
import com.sybase.jdbc2.tds.SrvParamFormat2Token;
import com.sybase.jdbc2.tds.SrvParamFormatToken;
import com.sybase.jdbc2.tds.SrvParamsToken;
import com.sybase.jdbc2.tds.SrvProtocolException;
import com.sybase.jdbc2.tds.SrvRequestListener;
import com.sybase.jdbc2.tds.SrvTypeException;
import com.sybase.jdbc2.tds.SrvUnknownPacketException;
import com.sybase.jdbc2.tds.Token;
import com.sybase.jdbc2.utils.Debug;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;

public class SrvSession
implements Runnable {
    private OutputStream _rawOut = null;
    private SrvDataInputStream _tdsin = null;
    private SrvDataOutputStream _tdsout = null;
    private SrvDataOutputStream _asyncNotif = null;
    private Vector _listeners = new Vector();
    protected Vector _events = new Vector();
    private SrvCapabilityToken _cap = null;
    private SrvLoginToken _login = null;
    private boolean _running = false;
    private String _encoding = System.getProperty("file.encoding");
    protected boolean _encodingChanged = false;
    private Hashtable _sessionData = new Hashtable();

    public SrvSession(InputStream inputStream, OutputStream outputStream, boolean bl, boolean bl2) throws IOException {
        try {
            this._rawOut = bl2 ? new SrvDumpOutputStream(outputStream) : outputStream;
            this._tdsout = new SrvDataOutputStream(this._rawOut);
            this._tdsin = bl ? new SrvDataInputStream(new SrvDumpInputStream(inputStream)) : new SrvDataInputStream(inputStream);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public void addSrvRequestListener(SrvRequestListener srvRequestListener) {
        this._listeners.addElement(srvRequestListener);
    }

    public synchronized void close() {
        try {
            this._running = false;
            if (this._tdsout != null) {
                this._tdsout.flush();
                this._tdsout.close();
                this._tdsout = null;
            }
            if (this._tdsin != null) {
                this._tdsin.flush();
                this._tdsin.close();
                this._tdsin = null;
            }
        }
        catch (Exception exception) {}
        try {
            while (true) {
                SrvEventListener srvEventListener = (SrvEventListener)this._events.elementAt(0);
                srvEventListener.close();
                this._events.removeElementAt(0);
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    protected void fireEvent(Object object, Object object2) {
        int n = 0;
        while (n < this._listeners.size()) {
            SrvRequestListener srvRequestListener = (SrvRequestListener)this._listeners.elementAt(n);
            if (object == null) {
                srvRequestListener.attention(this);
            } else if (object instanceof SrvLoginToken) {
                srvRequestListener.connect(this, (SrvLoginToken)object);
            } else if (object instanceof SrvLanguageToken) {
                srvRequestListener.language(this, (SrvLanguageToken)object);
            } else if (object instanceof SrvDbrpcToken) {
                srvRequestListener.rpc(this, (SrvDbrpcToken)object);
            } else if (object instanceof EOFException) {
                srvRequestListener.disconnect(this, null);
            } else if (object instanceof SrvLogoutToken) {
                srvRequestListener.disconnect(this, (SrvLogoutToken)object);
            } else if (object instanceof SrvBulkException) {
                srvRequestListener.bulk(this, this._tdsin);
            } else if (object instanceof IOException) {
                srvRequestListener.error(this, (IOException)object);
            } else {
                Debug.assert(false, "Invalid request token " + object.getClass().getName() + ", hence can't fire event");
                srvRequestListener.error(this, new SrvProtocolException("Invalid request token " + object.getClass().getName() + ", hence can't fire event"));
            }
            ++n;
        }
    }

    protected synchronized SrvDataOutputStream getAsyncOut() throws IOException {
        if (this._asyncNotif == null) {
            try {
                this._asyncNotif = new SrvDataOutputStream(this._rawOut);
                this._asyncNotif.setBigEndian(this._tdsout.getBigEndian());
                this._asyncNotif.setPacketSize(this._tdsout.getPacketSize());
                this._asyncNotif.setEncoding(this._tdsout.getCharset());
                this._asyncNotif.setNotify();
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
        }
        return this._asyncNotif;
    }

    protected String getCharset() {
        return Iana.lookupIana("java", this._encoding);
    }

    public SrvCapabilityToken getClientCapability() {
        return this._cap;
    }

    public SrvLoginToken getLogin() {
        return this._login;
    }

    public Object getSessionData(Object object) {
        return this._sessionData.get(object);
    }

    public boolean isWidetableEnabled() {
        return this.getClientCapability()._reqCaps.get(59) & (this.getClientCapability()._respCaps.get(45) ^ true);
    }

    public void login() throws IOException {
        Object object;
        this._login = new SrvLoginToken(this._tdsin);
        this._tdsin.setBigEndian(this._login.getBigEndian());
        this._tdsout.setBigEndian(this._login.getBigEndian());
        if (this._login.getCharset() == null || this._login.getCharset().equals("")) {
            this._encodingChanged = true;
            this._login._charset = Iana.lookupIana("java", this._encoding);
            if (this._login._charset.equals("UnsupportedCharset")) {
                this._login._charset = "iso_1";
            }
        }
        boolean bl = false;
        try {
            object = Iana.lookupIana(this._login.getCharset());
            this._tdsin.setEncoding((String)object);
            this._tdsout.setEncoding((String)object);
            this._encoding = object;
        }
        catch (Exception exception) {
            this._encodingChanged = true;
            try {
                this._tdsin.setEncoding(this._encoding);
                this._tdsout.setEncoding(this._encoding);
            }
            catch (Exception exception2) {
                throw new IOException("Problems negotiating PDU protocol: " + exception2);
            }
            bl = true;
        }
        try {
            this._cap = (SrvCapabilityToken)this.receive();
            this._cap.setDefaultServerCapabilities();
        }
        catch (ClassCastException classCastException) {
            throw new SrvProtocolException("Did not get SrvCapabilityToken for connection request");
        }
        this._tdsin.setPacketSize(this._login.getPacketSize());
        this._tdsout.setPacketSize(this._login.getPacketSize());
        if (bl) {
            object = new SrvEedToken(2409, 0, 0, "01ZZZ", 0, " Cannot find the requested character set in Syscharsets:  name = '" + this._login.getCharset() + "'. No conversions will be done.", "Unknown", null, 0);
            this.send((Token)object);
        }
        this.fireEvent(this._login, null);
    }

    public Token receive() throws IOException, SrvAttentionException, SrvBulkException {
        int n = 0;
        try {
            n = this._tdsin.readUnsignedByte();
        }
        catch (SrvAttentionException srvAttentionException) {
            this._tdsin.flush();
            throw srvAttentionException;
        }
        Token token = null;
        switch (n) {
            case 33: {
                token = new SrvLanguageToken(this._tdsin);
                break;
            }
            case 113: {
                token = new SrvLogoutToken(this._tdsin);
                break;
            }
            case 226: {
                try {
                    token = new SrvCapabilityToken(this._tdsin);
                }
                catch (SQLException sQLException) {
                    ErrorMessage.raiseIOException(sQLException.getSQLState());
                }
                break;
            }
            case 230: {
                token = new SrvDbrpcToken(this._tdsin);
                break;
            }
            case 236: {
                token = new SrvParamFormatToken(this._tdsin);
                break;
            }
            case 32: {
                token = new SrvParamFormat2Token(this._tdsin);
                break;
            }
            case 215: {
                token = new SrvParamsToken(this._tdsin);
                break;
            }
            default: {
                Slurp slurp = new Slurp(this._tdsin, n);
                throw new SrvUnknownPacketException("Received unknown or unhandled TDS token type: 0x" + Integer.toHexString(n));
            }
        }
        return token;
    }

    public void removeSrvRequestListener(SrvRequestListener srvRequestListener) {
        this._listeners.removeElement(srvRequestListener);
    }

    public void run() {
        try {
            this.login();
        }
        catch (IOException iOException) {
            this.fireEvent(iOException, null);
            return;
        }
        this._running = true;
        while (this._running) {
            try {
                this.fireEvent(this.receive(), null);
            }
            catch (SrvAttentionException srvAttentionException) {
                this.fireEvent(null, null);
            }
            catch (SrvBulkException srvBulkException) {
                this.fireEvent(srvBulkException, null);
                try {
                    while (this._tdsin.read() != -1) {
                    }
                    this._tdsin.bulkDone();
                }
                catch (IOException iOException) {
                    this.fireEvent(iOException, null);
                }
            }
            catch (SocketException socketException) {
                this._listeners.removeElement(this);
                this.close();
                break;
            }
            catch (IOException iOException) {
                this.fireEvent(iOException, null);
            }
            Thread.yield();
        }
    }

    public void send(SrvDataOutputStream srvDataOutputStream, Token token) throws IOException {
        token.send(srvDataOutputStream);
        if (token instanceof SrvDoneToken && ((SrvDoneToken)token).getFinal()) {
            srvDataOutputStream.flush(true);
        }
    }

    public void send(Token token) throws IOException {
        this.send(this._tdsout, token);
    }

    public void sendAttention() throws IOException {
        this._tdsout.setAttention();
        this._tdsout.flush(true);
    }

    public void sendDone(int n, boolean bl, boolean bl2, boolean bl3) throws IOException {
        this.sendDone(this._tdsout, n, bl, bl2, bl3, false);
    }

    private void sendDone(SrvDataOutputStream srvDataOutputStream, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException {
        int n2 = 0;
        if (bl) {
            n2 |= 2;
        }
        if (bl4) {
            n2 |= 0x40;
        }
        n2 = bl2 ? (n2 |= 0) : (n2 |= 1);
        if (n >= 0) {
            n2 |= 0x10;
        } else {
            n = 0;
        }
        if (bl3) {
            this.send(srvDataOutputStream, new SrvDoneProcToken(n2, 0, n));
        } else {
            this.send(srvDataOutputStream, new SrvDoneToken(n2, 0, n));
        }
    }

    public void sendNotify(String string, Object[] objectArray) throws IOException, SrvTypeException {
        SrvDataOutputStream srvDataOutputStream;
        SrvDataOutputStream srvDataOutputStream2 = srvDataOutputStream = this.getAsyncOut();
        synchronized (srvDataOutputStream2) {
            this.send(srvDataOutputStream, new SrvEventToken(string));
            if (objectArray != null && objectArray.length > 0) {
                this.sendParams(srvDataOutputStream, null, objectArray, 0);
            }
            this.sendDone(srvDataOutputStream, 0, false, true, false, true);
        }
    }

    private void sendParams(SrvDataOutputStream srvDataOutputStream, Object[] objectArray, Object[] objectArray2, int n) throws IOException {
        if (objectArray != null && objectArray.length != objectArray2.length) {
            throw new SrvTypeException("Number of names do not match number of data elements in results send");
        }
        ParamFormatToken paramFormatToken = null;
        Object[] objectArray3 = null;
        objectArray3 = objectArray != null ? objectArray : objectArray2;
        if (objectArray3.length * 136 > 65535 && this.isWidetableEnabled()) {
            paramFormatToken = new SrvParamFormat2Token();
        }
        if (paramFormatToken == null) {
            paramFormatToken = new SrvParamFormatToken();
        }
        SrvJavaTypeFormatter srvJavaTypeFormatter = new SrvJavaTypeFormatter((SrvFormatToken)((Object)paramFormatToken), this.getClientCapability());
        int n2 = 0;
        while (n2 < objectArray3.length) {
            int n3 = 0;
            if (objectArray3[n2] instanceof String) {
                n3 = ((String)objectArray3[n2]).length();
            }
            srvJavaTypeFormatter.addFormat(objectArray3[n2], null, n, n3);
            ++n2;
        }
        this.send(srvDataOutputStream, paramFormatToken);
        SrvParamsToken srvParamsToken = new SrvParamsToken();
        srvJavaTypeFormatter.convertData(srvParamsToken, objectArray3);
        this.send(srvDataOutputStream, srvParamsToken);
    }

    public void sendParams(Object[] objectArray, Object[] objectArray2, int n) throws IOException {
        this.sendParams(this._tdsout, objectArray, objectArray2, n);
    }

    public void setSessionData(Object object, Object object2) {
        this._sessionData.put(object, object2);
    }
}

