/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import org.exolab.castor.types.OperationNotSupportedException;
import org.exolab.castor.types.TimePeriod;

public class Century
extends TimePeriod {
    private static final boolean DEBUG = false;
    private static final String YEAR_FORMAT = "yyyy";

    public Century() {
        super("P100Y");
        int temp = SimpleTimeZone.getDefault().getRawOffset();
        if (temp < 0) {
            temp = -temp;
            try {
                this.setZoneNegative();
            }
            catch (OperationNotSupportedException e) {
                // empty catch block
            }
        }
        try {
            short zhour = (short)(temp / 3600000);
            short zmin = (short)((temp %= 3600000) / 60000);
            super.setZone(zhour, zmin);
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            // empty catch block
        }
    }

    public void setYear(short year) throws OperationNotSupportedException {
        String err = "In a Century : the year field must not be changed";
        throw new OperationNotSupportedException(err);
    }

    public void setMonth(short month) throws OperationNotSupportedException {
        String err = "In a Century : the month field must not be changed";
        throw new OperationNotSupportedException(err);
    }

    public void setDay(short day) throws OperationNotSupportedException {
        String err = "In a Century : the day field must not be changed";
        throw new OperationNotSupportedException(err);
    }

    public void setHour(short hour) throws OperationNotSupportedException {
        String err = "In a Century : the hour field must not be changed";
        throw new OperationNotSupportedException(err);
    }

    public void setMinute(short minute) throws OperationNotSupportedException {
        String err = "In a Century : the minute field must not be changed";
        throw new OperationNotSupportedException(err);
    }

    public void setSecond(short second, short millsecond) throws OperationNotSupportedException {
        String err = "In a Century : the second field must not be changed";
        throw new OperationNotSupportedException(err);
    }

    public void setZone(short hour, short minute) throws OperationNotSupportedException {
        String err = "In a Century : the time zone field must not be changed";
        throw new OperationNotSupportedException(err);
    }

    public void setZoneNegative() throws OperationNotSupportedException {
        String err = "In a Century : the time zone field must not be changed";
        throw new OperationNotSupportedException(err);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(String.valueOf(this.getCentury()));
        if (result.length() == 1) {
            result.insert(0, 0);
        }
        if (this.isNegative()) {
            result.insert(0, "-");
        }
        return result.toString();
    }

    public static Object parse(String str) throws ParseException {
        return Century.parseCentury(str);
    }

    public static Century parseCentury(String str) throws ParseException {
        Century result = new Century();
        if (str.startsWith("-")) {
            result.setNegative();
            str = str.substring(1);
        }
        if (str.length() != 2) {
            throw new ParseException(str + ": Bad XML Schema Century type format (CC)", 0);
        }
        result.setCentury(Short.parseShort(str));
        return result;
    }

    public Date toDate() throws ParseException {
        Date date = null;
        SimpleDateFormat df = new SimpleDateFormat(YEAR_FORMAT);
        SimpleTimeZone timeZone = new SimpleTimeZone(0, "UTC");
        if (!this.isUTC()) {
            int offset = 0;
            offset = (this.getZoneMinute() + this.getZoneHour() * 60) * 60 * 1000;
            offset = this.isZoneNegative() ? -offset : offset;
            timeZone.setRawOffset(offset);
            timeZone.setID(SimpleTimeZone.getAvailableIDs(offset)[0]);
        }
        df.setTimeZone(timeZone);
        date = df.parse(this.toString());
        return date;
    }
}

