/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.DynamicClassLoader;
import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.LoaderConnection;
import com.sybase.jdbc2.jdbc.Protocol;
import com.sybase.jdbc2.jdbc.SybConnection;
import com.sybase.jdbc2.jdbc.SybDebug;
import com.sybase.jdbc2.jdbc.SybKey;
import com.sybase.jdbc2.jdbc.SybProperty;
import com.sybase.jdbc2.jdbc.SybUrlManager;
import com.sybase.jdbc2.jdbc.SybUrlProvider;
import com.sybase.jdbcx.Debug;
import com.sybase.jdbcx.SybMessageHandler;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class SybDriver
implements com.sybase.jdbcx.SybDriver {
    protected static final int HIGHEST_JCONNECT_VERSION = 6;
    public static final int DEFAULT_DRIVER_VERSION = 5;
    protected int _version = 5;
    private transient SybMessageHandler _msgHandler;
    static /* synthetic */ Class class$java$sql$DriverManager;

    static {
        SybDriver sybDriver = new SybDriver();
    }

    public SybDriver() {
        this.registerWithDriverManager();
    }

    public boolean acceptsURL(String string) throws SQLException {
        SybUrlManager sybUrlManager;
        SybUrlProvider sybUrlProvider;
        int n = string.indexOf(47);
        if (n != -1) {
            string = string.substring(0, n);
        }
        if ((sybUrlProvider = (sybUrlManager = new SybUrlManager(string, null, null)).getUrlProvider()) == null) {
            return false;
        }
        Protocol protocol = sybUrlProvider.getProtocol();
        return protocol != null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected final Connection connect(SybUrlProvider sybUrlProvider) throws SQLException {
        return this.connect(null, sybUrlProvider);
    }

    protected final SybConnection connect(String string, SybUrlProvider sybUrlProvider) throws SQLException {
        SQLWarning sQLWarning;
        SybConnection sybConnection = this.createConnection(string, sybUrlProvider);
        if (this._msgHandler != null) {
            sybConnection.setSybMessageHandler(this._msgHandler);
        }
        if ((sQLWarning = sybUrlProvider.getSybProperty().getWarnings()) != null) {
            sybConnection.handleSQLE(sQLWarning);
        }
        return sybConnection;
    }

    public final Connection connect(String string, Properties properties) throws SQLException {
        SQLWarning sQLWarning;
        SybProperty sybProperty = new SybProperty(properties, this._version);
        SybUrlManager sybUrlManager = new SybUrlManager(string, properties, sybProperty);
        SybUrlProvider sybUrlProvider = sybUrlManager.getUrlProvider();
        if (sybUrlProvider == null) {
            return null;
        }
        SybConnection sybConnection = new SybConnection(sybUrlProvider, string);
        if (this._msgHandler != null) {
            sybConnection.setSybMessageHandler(this._msgHandler);
        }
        if ((sQLWarning = sybProperty.getWarnings()) != null) {
            sybConnection.handleSQLE(sQLWarning);
        }
        return sybConnection;
    }

    protected SybConnection createConnection(String string, SybUrlProvider sybUrlProvider) throws SQLException {
        Protocol protocol;
        SybConnection sybConnection = null;
        if (sybUrlProvider != null && (protocol = sybUrlProvider.getProtocol()) != null) {
            sybConnection = new SybConnection(sybUrlProvider, string);
        }
        return sybConnection;
    }

    private static StringBuffer escapeSpecialCharacters(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        char c = '\u0000';
        int n2 = 0;
        while (n2 < n) {
            c = string.charAt(n2);
            if (c == '\\' || c == ',') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
            ++n2;
        }
        return stringBuffer;
    }

    public com.sybase.jdbcx.DynamicClassLoader getClassLoader(String string, Properties properties) {
        LoaderConnection loaderConnection = new LoaderConnection(this, string, properties);
        DynamicClassLoader dynamicClassLoader = new DynamicClassLoader(loaderConnection);
        return dynamicClassLoader;
    }

    public final Debug getDebug() {
        return new SybDebug();
    }

    public int getMajorVersion() {
        return 5;
    }

    public SybMessageHandler getMessageHandler() {
        return this.getSybMessageHandler();
    }

    public int getMinorVersion() {
        return 5;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        int n;
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[43];
        SybProperty sybProperty = new SybProperty(properties, this._version);
        if (string != null && (n = string.indexOf(63)) > 0 && n++ < string.length()) {
            sybProperty.parsePropertyString(string.substring(n));
        }
        n = 0;
        while (n < 43) {
            driverPropertyInfoArray[n] = new DriverPropertyInfo(SybProperty.PROPNAME[n], sybProperty._propValue[n] == null ? null : sybProperty._propValue[n].toString());
            driverPropertyInfoArray[n].required = false;
            driverPropertyInfoArray[n].description = SybProperty.DESCRIPTION[n];
            ++n;
        }
        driverPropertyInfoArray[3].required = true;
        driverPropertyInfoArray[4].required = true;
        driverPropertyInfoArray[11].value = "";
        driverPropertyInfoArray[10].value = String.valueOf(driverPropertyInfoArray[10].value) + "\n\nConfidential property of Sybase, Inc.\nCopyright 1997-2001\nSybase, Inc.  All rights reserved.\nUnpublished rights reserved under U.S. copyright laws.\nThis software contains confidential and trade secret information of Sybase,\nInc.  Use, duplication or disclosure of the software and documentation by\nthe U.S. Government is subject to restrictions set forth in a license\nagreement between the Government and Sybase, Inc. or other written\nagreement specifying the Government's rights to use the software and any\napplicable FAR provisions, for example, FAR 52.227-19.\n\nSybase, Inc. 6475 Christie Avenue, Emeryville, CA 94608, USA\n";
        return driverPropertyInfoArray;
    }

    public SybMessageHandler getSybMessageHandler() {
        return this._msgHandler;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    protected void registerWithDriverManager() {
        try {
            Class clazz = class$java$sql$DriverManager != null ? class$java$sql$DriverManager : (class$java$sql$DriverManager = SybDriver.class$("java.sql.DriverManager"));
            synchronized (clazz) {
                DriverManager.registerDriver(this);
                Enumeration<Driver> enumeration = DriverManager.getDrivers();
                while (enumeration.hasMoreElements()) {
                    Driver driver = enumeration.nextElement();
                    if (!(driver instanceof com.sybase.jdbcx.SybDriver) || driver == this) continue;
                    DriverManager.deregisterDriver(driver);
                }
            }
        }
        catch (SQLException sQLException) {}
    }

    public final void setKey(SybKey sybKey) throws SQLException {
    }

    public void setMessageHandler(SybMessageHandler sybMessageHandler) {
        this.setSybMessageHandler(sybMessageHandler);
    }

    public final void setRemotePassword(String string, String string2, Properties properties) {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = SybProperty.PROPNAME[9];
        String string4 = properties.getProperty(string3);
        if (string4 != null) {
            stringBuffer.append(string4);
        }
        stringBuffer.append(',');
        if (string != null) {
            stringBuffer.append((Object)SybDriver.escapeSpecialCharacters(string));
        }
        stringBuffer.append(',');
        if (string2 != null) {
            stringBuffer.append((Object)SybDriver.escapeSpecialCharacters(string2));
        }
        ((Hashtable)properties).put(string3, stringBuffer.toString());
    }

    public void setSybMessageHandler(SybMessageHandler sybMessageHandler) {
        this._msgHandler = sybMessageHandler;
    }

    public void setVersion(int n) throws SQLException {
        switch (n) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this._version = n;
                return;
            }
            case 0: {
                this._version = 6;
                return;
            }
        }
        ErrorMessage.raiseError("JZ0D6", String.valueOf(n));
    }
}

