/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import java.io.IOException;
import org.apache.xerces.impl.validation.XMLGrammarPoolImpl;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSDeclarationPool;
import org.apache.xerces.impl.xs.XSGrammarBucket;
import org.apache.xerces.impl.xs.models.CMBuilder;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.parsers.StandardParserConfiguration;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.SynchronizedSymbolTable;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLInputSource;

public class XMLGrammarCachingConfiguration
extends StandardParserConfiguration {
    public static final int BIG_PRIME = 2039;
    protected static final SynchronizedSymbolTable fStaticSymbolTable = new SynchronizedSymbolTable(2039);
    protected static final XMLGrammarPoolImpl fStaticGrammarPool = new XMLGrammarPoolImpl();
    protected static final String SCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    String XMLNS = this.fSymbolTable.addSymbol("xmlns");
    String URI_XSI = this.fSymbolTable.addSymbol("http://www.w3.org/2001/XMLSchema-instance");
    String XSI_SCHEMALOCATION = this.fSymbolTable.addSymbol("schemaLocation");
    String XSI_NONAMESPACESCHEMALOCATION = this.fSymbolTable.addSymbol("noNamespaceSchemaLocation");
    String XSI_TYPE = this.fSymbolTable.addSymbol("type");
    String XSI_NIL = this.fSymbolTable.addSymbol("nil");
    String URI_SCHEMAFORSCHEMA = this.fSymbolTable.addSymbol("http://www.w3.org/2001/XMLSchema");
    protected XSDHandler fSchemaHandler;
    protected XSGrammarBucket fXSGrammarBucket;
    protected SubstitutionGroupHandler fSubGroupHandler;
    protected CMBuilder fCMBuilder;

    public XMLGrammarCachingConfiguration() {
        this(fStaticSymbolTable, fStaticGrammarPool, null);
    }

    public XMLGrammarCachingConfiguration(SymbolTable symbolTable) {
        this(symbolTable, fStaticGrammarPool, null);
    }

    public XMLGrammarCachingConfiguration(SymbolTable symbolTable, XMLGrammarPool grammarPool) {
        this(symbolTable, grammarPool, null);
    }

    public XMLGrammarCachingConfiguration(SymbolTable symbolTable, XMLGrammarPool grammarPool, XMLComponentManager parentSettings) {
        super(symbolTable, grammarPool, parentSettings);
    }

    public boolean lockGrammarPool() {
        return this.fGrammarPool instanceof XMLGrammarPoolImpl;
    }

    public Grammar parseGrammar(String type, String uri) throws XNIException, IOException {
        XMLInputSource source = new XMLInputSource(null, uri, null);
        return this.parseGrammar(type, source);
    }

    public Grammar parseGrammar(String type, XMLInputSource is) throws XNIException, IOException {
        if (!type.equals("XSD")) {
            return null;
        }
        if (this.fSchemaHandler == null) {
            this.fXSGrammarBucket = new XSGrammarBucket();
            this.fSubGroupHandler = new SubstitutionGroupHandler(this.fXSGrammarBucket);
            this.fSchemaHandler = new XSDHandler(this.fXSGrammarBucket);
            this.fCMBuilder = new CMBuilder(new XSDeclarationPool());
        }
        String externalSchemas = (String)this.getProperty("http://apache.org/xml/properties/schema/external-schemaLocation");
        String noNamespaceExternalSchemas = (String)this.getProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation");
        this.fXSGrammarBucket.reset();
        SchemaGrammar[] grammars = (SchemaGrammar[])this.fGrammarPool.retrieveInitialGrammarSet("XSD");
        int i = 0;
        while (i < grammars.length) {
            this.fXSGrammarBucket.putGrammar(grammars[i]);
            ++i;
        }
        this.fSubGroupHandler.reset();
        this.fSchemaHandler.reset(this.fErrorReporter, this.fEntityManager, this.fSymbolTable, externalSchemas, noNamespaceExternalSchemas, this.fGrammarPool);
        SchemaGrammar grammar = this.fSchemaHandler.parseSchema(null, is, (short)3);
        if (this.getFeature(SCHEMA_FULL_CHECKING)) {
            XSConstraints.fullSchemaChecking(this.fXSGrammarBucket, this.fSubGroupHandler, this.fCMBuilder, this.fErrorReporter);
        }
        this.fGrammarPool.cacheGrammars("XSD", new Grammar[]{grammar});
        return grammar;
    }

    protected void checkFeature(String featureId) throws XMLConfigurationException {
        super.checkFeature(featureId);
    }

    protected void checkProperty(String propertyId) throws XMLConfigurationException {
        super.checkProperty(propertyId);
    }
}

