/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

public class XSParticleDecl {
    public static final short PARTICLE_EMPTY = 0;
    public static final short PARTICLE_ELEMENT = 1;
    public static final short PARTICLE_WILDCARD = 2;
    public static final short PARTICLE_CHOICE = 3;
    public static final short PARTICLE_SEQUENCE = 4;
    public static final short PARTICLE_ALL = 5;
    public static final short PARTICLE_ZERO_OR_ONE = 6;
    public static final short PARTICLE_ZERO_OR_MORE = 7;
    public static final short PARTICLE_ONE_OR_MORE = 8;
    public short fType = 0;
    public Object fValue = null;
    public Object fOtherValue = null;
    public int fMinOccurs = 1;
    public int fMaxOccurs = 1;
    private String fDescription = null;

    public boolean emptiable() {
        return this.minEffectiveTotalRange() == 0;
    }

    public boolean isEmpty() {
        if (this.fType == 1 || this.fType == 2) {
            return false;
        }
        if (this.fType == 0) {
            return true;
        }
        boolean leftIsEmpty = this.fValue == null || ((XSParticleDecl)this.fValue).isEmpty();
        boolean rightIsEmpty = this.fOtherValue == null || ((XSParticleDecl)this.fOtherValue).isEmpty();
        return leftIsEmpty && rightIsEmpty;
    }

    public int minEffectiveTotalRange() {
        switch (this.fType) {
            case 4: 
            case 5: {
                return this.minEffectiveTotalRangeAllSeq();
            }
            case 3: {
                return this.minEffectiveTotalRangeChoice();
            }
        }
        return this.fMinOccurs;
    }

    private int minEffectiveTotalRangeAllSeq() {
        int fromLeft = ((XSParticleDecl)this.fValue).minEffectiveTotalRange();
        if (this.fOtherValue != null) {
            fromLeft += ((XSParticleDecl)this.fOtherValue).minEffectiveTotalRange();
        }
        return this.fMinOccurs * fromLeft;
    }

    private int minEffectiveTotalRangeChoice() {
        int fromRight;
        int fromLeft = ((XSParticleDecl)this.fValue).minEffectiveTotalRange();
        if (this.fOtherValue != null && (fromRight = ((XSParticleDecl)this.fOtherValue).minEffectiveTotalRange()) < fromLeft) {
            fromLeft = fromRight;
        }
        return this.fMinOccurs * fromLeft;
    }

    public int maxEffectiveTotalRange() {
        switch (this.fType) {
            case 4: 
            case 5: {
                return this.maxEffectiveTotalRangeAllSeq();
            }
            case 3: {
                return this.maxEffectiveTotalRangeChoice();
            }
        }
        return this.fMaxOccurs;
    }

    private int maxEffectiveTotalRangeAllSeq() {
        int fromLeft = ((XSParticleDecl)this.fValue).maxEffectiveTotalRange();
        if (fromLeft == -1) {
            return -1;
        }
        if (this.fOtherValue != null) {
            int fromRight = ((XSParticleDecl)this.fValue).maxEffectiveTotalRange();
            if (fromRight == -1) {
                return -1;
            }
            fromLeft += fromRight;
        }
        if (fromLeft != 0 && this.fMaxOccurs == -1) {
            return -1;
        }
        return this.fMaxOccurs * fromLeft;
    }

    private int maxEffectiveTotalRangeChoice() {
        int fromLeft = ((XSParticleDecl)this.fValue).maxEffectiveTotalRange();
        if (fromLeft == -1) {
            return -1;
        }
        if (this.fOtherValue != null) {
            int fromRight = ((XSParticleDecl)this.fValue).maxEffectiveTotalRange();
            if (fromRight == -1) {
                return -1;
            }
            if (fromRight < fromLeft) {
                fromLeft = fromRight;
            }
        }
        if (fromLeft != 0 && this.fMaxOccurs == -1) {
            return -1;
        }
        return this.fMaxOccurs * fromLeft;
    }

    public String toString() {
        if (this.fDescription == null) {
            StringBuffer buffer = new StringBuffer();
            this.appendParticle(buffer);
            if (!(this.fMinOccurs == 0 && this.fMaxOccurs == 0 || this.fMinOccurs == 1 && this.fMaxOccurs == 1)) {
                buffer.append("{" + this.fMinOccurs);
                if (this.fMaxOccurs == -1) {
                    buffer.append("-UNBOUNDED");
                } else if (this.fMinOccurs != this.fMaxOccurs) {
                    buffer.append("-" + this.fMaxOccurs);
                }
                buffer.append("}");
            }
            this.fDescription = buffer.toString();
        }
        return this.fDescription;
    }

    void appendParticle(StringBuffer fBuffer) {
        switch (this.fType) {
            case 0: {
                fBuffer.append("EMPTY");
                break;
            }
            case 1: 
            case 2: {
                fBuffer.append('(');
                fBuffer.append(this.fValue.toString());
                fBuffer.append(')');
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                if (this.fOtherValue == null) {
                    fBuffer.append(this.fValue.toString());
                    break;
                }
                if (this.fType == 5) {
                    fBuffer.append("all(");
                } else {
                    fBuffer.append('(');
                }
                fBuffer.append(this.fValue.toString());
                if (this.fType == 3) {
                    fBuffer.append('|');
                } else {
                    fBuffer.append(',');
                }
                fBuffer.append(this.fOtherValue.toString());
                fBuffer.append(')');
            }
        }
    }
}

