/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.models;

import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XMLSchemaException;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.xni.QName;

public class XSAllCM
implements XSCMValidator {
    private static final short STATE_START = 0;
    private static final short STATE_VALID = 1;
    private XSElementDecl[] fAllElements = new XSElementDecl[10];
    private boolean[] fIsOptionalElement = new boolean[10];
    private boolean fHasOptionalContent = false;
    private int fNumElements = 0;
    private int fNumRequired = 0;

    public XSAllCM(boolean hasOptionalContent) {
        this.fHasOptionalContent = hasOptionalContent;
    }

    public void addElement(XSElementDecl element, boolean isOptional) {
        if (this.fNumElements >= this.fAllElements.length) {
            XSElementDecl[] newAllElements = new XSElementDecl[2 * this.fAllElements.length];
            boolean[] newIsOptionalElements = new boolean[2 * this.fIsOptionalElement.length];
            System.arraycopy(this.fAllElements, 0, newAllElements, 0, this.fAllElements.length);
            System.arraycopy(this.fIsOptionalElement, 0, newIsOptionalElements, 0, this.fIsOptionalElement.length);
            this.fAllElements = newAllElements;
            this.fIsOptionalElement = newIsOptionalElements;
        }
        this.fAllElements[this.fNumElements] = element;
        this.fIsOptionalElement[this.fNumElements] = isOptional;
        ++this.fNumElements;
        if (!isOptional) {
            ++this.fNumRequired;
        }
    }

    public int[] startContentModel() {
        int[] state = new int[this.fNumElements + 1];
        int i = 0;
        while (i <= this.fNumElements) {
            state[i] = 0;
            ++i;
        }
        return state;
    }

    public Object oneTransition(QName elementName, int[] currentState, SubstitutionGroupHandler subGroupHandler) {
        XSElementDecl matchingDecl = null;
        int i = 0;
        while (i < this.fNumElements) {
            matchingDecl = subGroupHandler.getMatchingElemDecl(elementName, this.fAllElements[i]);
            if (matchingDecl != null) {
                if (currentState[i + 1] == 0) {
                    currentState[i + 1] = 1;
                } else if (currentState[i + 1] == 1) {
                    currentState[i + 1] = -1;
                    currentState[0] = -1;
                } else if (currentState[i + 1] == -1) {
                    currentState[i + 1] = -2;
                    currentState[0] = -2;
                }
                if (currentState[0] == 0) {
                    currentState[0] = 1;
                }
                return matchingDecl;
            }
            ++i;
        }
        if (currentState[0] == -1) {
            currentState[0] = -2;
        } else if (currentState[0] == 0 || currentState[0] == 1) {
            currentState[0] = -1;
        }
        return null;
    }

    public boolean endContentModel(int[] currentState) {
        int state = currentState[0];
        if (state == -1 || state == -2) {
            return false;
        }
        if (this.fHasOptionalContent && this.fNumElements == 0) {
            return true;
        }
        int numRequiredSeen = 0;
        int i = 0;
        while (i < this.fNumElements) {
            if (!this.fIsOptionalElement[i] && currentState[i + 1] != 0) {
                ++numRequiredSeen;
            }
            ++i;
        }
        return this.fNumRequired == numRequiredSeen;
    }

    public boolean checkUniqueParticleAttribution(SubstitutionGroupHandler subGroupHandler) throws XMLSchemaException {
        int i = 0;
        while (i < this.fNumElements) {
            int j = i + 1;
            while (j < this.fNumElements) {
                if (XSConstraints.overlapUPA(this.fAllElements[i], this.fAllElements[j], subGroupHandler)) {
                    throw new XMLSchemaException("cos-nonambig", new Object[]{this.fAllElements[i].toString(), this.fAllElements[j].toString()});
                }
                ++j;
            }
            ++i;
        }
        return false;
    }
}

