/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.core.dbb.server;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eso.ohs.core.dbb.sql.DbbSqlTable;
import org.eso.ohs.core.utilities.ConnectionPool;

public class DbbSession {
    private static final String rcsid = "$Id: DbbSession.java,v 1.3 2004/04/08 12:09:51 tcanavan Exp $";
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$core$dbb$server$DbbSession == null ? (class$org$eso$ohs$core$dbb$server$DbbSession = DbbSession.class$("org.eso.ohs.core.dbb.server.DbbSession")) : class$org$eso$ohs$core$dbb$server$DbbSession));
    private String url_ = null;
    private Hashtable connHashtable_ = new Hashtable();
    private Hashtable dbmdHashtable_ = new Hashtable();
    private String database_;
    private String owner_ = null;
    private String username_ = null;
    private String password_ = null;
    private Connection conn_ = null;
    static /* synthetic */ Class class$org$eso$ohs$core$dbb$server$DbbSession;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Object;

    public DbbSession(String string, String string2, String string3, String string4) {
        this.url_ = string;
        this.username_ = string3;
        this.password_ = string4;
        this.database_ = string2;
    }

    public String getDefaultDatabase() {
        return this.database_;
    }

    public String getDefaultOwner() {
        return this.owner_;
    }

    public Connection getCurrentConnection() {
        return this.conn_;
    }

    public void releaseCurrentConnection() {
        if (this.conn_ != null) {
            ConnectionPool.getPool().releaseConnection(this.conn_);
        }
        this.conn_ = null;
    }

    public void setAccount(String string, String string2) {
        this.username_ = string;
        this.password_ = string2;
        this.releaseCurrentConnection();
    }

    public DatabaseMetaData getDatabaseMetadata(String string) throws SQLException {
        DatabaseMetaData databaseMetaData;
        if (string == null || string.equals("")) {
            string = this.database_;
        }
        if ((databaseMetaData = (DatabaseMetaData)this.dbmdHashtable_.get(string)) == null) {
            this.conn_ = ConnectionPool.getPool().acquireConnection(this.url_, this.username_, this.password_);
            databaseMetaData = this.conn_.getMetaData();
            this.dbmdHashtable_.put(string, databaseMetaData);
            ConnectionPool.getPool().releaseConnection(this.conn_);
            this.conn_ = null;
        }
        return databaseMetaData;
    }

    public DatabaseMetaData getDatabaseMetadata() throws SQLException {
        return this.getDatabaseMetadata(this.database_);
    }

    public Class getColumnDataType(DbbSqlTable dbbSqlTable, String string) throws SQLException {
        int n = -1;
        ResultSet resultSet = null;
        dbbSqlTable.completeTable(this);
        DatabaseMetaData databaseMetaData = this.getDatabaseMetadata(dbbSqlTable.getDatabase());
        resultSet = databaseMetaData.getColumns(dbbSqlTable.getDatabase(), dbbSqlTable.getOwner(), dbbSqlTable.getTable(), string);
        while (resultSet.next()) {
            n = resultSet.getInt(5);
        }
        Class clazz = DbbSession.getDataTypeClass(n);
        return clazz;
    }

    public ResultSet execSql(String string, String string2, boolean bl) throws SQLException {
        Object var4_4 = null;
        Statement statement = null;
        ResultSet resultSet = null;
        SQLException sQLException = null;
        this.conn_ = ConnectionPool.getPool().acquireConnection(this.url_, this.username_, this.password_);
        statement = this.conn_.createStatement();
        try {
            resultSet = statement.executeQuery(string2);
        }
        catch (SQLException sQLException2) {
            sQLException2.printStackTrace();
            sQLException = sQLException2;
        }
        ConnectionPool.getPool().releaseConnection(this.conn_);
        this.conn_ = null;
        if (sQLException != null) {
            throw new SQLException(sQLException.getMessage());
        }
        return resultSet;
    }

    public ResultSet execSql(String string, String string2) throws SQLException {
        return this.execSql(string, string2, false);
    }

    public ResultSet execSql(String string, boolean bl) throws SQLException {
        return this.execSql(this.database_, string, bl);
    }

    public ResultSet execSql(String string) throws SQLException {
        return this.execSql(this.database_, string, false);
    }

    public void execUpdateSql(String string) throws SQLException {
        Object var2_2 = null;
        Statement statement = null;
        this.conn_ = ConnectionPool.getPool().acquireConnection(this.url_, this.username_, this.password_);
        statement = this.conn_.createStatement();
        statement.executeUpdate(string);
        ConnectionPool.getPool().releaseConnection(this.conn_);
        this.conn_ = null;
    }

    public static Class getDataTypeClass(int n) {
        switch (n) {
            case -1: 
            case 1: 
            case 12: {
                return class$java$lang$String == null ? (class$java$lang$String = DbbSession.class$("java.lang.String")) : class$java$lang$String;
            }
            case 2: 
            case 3: {
                return class$java$lang$Long == null ? (class$java$lang$Long = DbbSession.class$("java.lang.Long")) : class$java$lang$Long;
            }
            case -7: {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = DbbSession.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            case -6: 
            case 4: 
            case 5: {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = DbbSession.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            case -5: {
                return class$java$lang$Long == null ? (class$java$lang$Long = DbbSession.class$("java.lang.Long")) : class$java$lang$Long;
            }
            case 7: {
                return class$java$lang$Float == null ? (class$java$lang$Float = DbbSession.class$("java.lang.Float")) : class$java$lang$Float;
            }
            case 8: {
                return class$java$lang$Double == null ? (class$java$lang$Double = DbbSession.class$("java.lang.Double")) : class$java$lang$Double;
            }
            case -4: 
            case -3: 
            case -2: {
                return class$java$lang$Object == null ? (class$java$lang$Object = DbbSession.class$("java.lang.Object")) : class$java$lang$Object;
            }
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = DbbSession.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public static void dumpRs(String string, ResultSet resultSet) {
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            stdlog_.debug((Object)string);
            StringBuffer stringBuffer = new StringBuffer();
            while (resultSet.next()) {
                int n2 = 1;
                while (n2 <= n) {
                    stringBuffer.append("   ");
                    stringBuffer.append(resultSet.getString(n2));
                    stringBuffer.append("  ");
                    ++n2;
                }
            }
            stdlog_.debug((Object)stringBuffer.toString());
        }
        catch (SQLException sQLException) {
            stdlog_.warn((Object)"", (Throwable)sQLException);
        }
    }

    public String[] getTables(String string) throws SQLException {
        String[] stringArray = new String[]{"TABLE"};
        Object[] objectArray = null;
        int n = 0;
        Vector<String> vector = new Vector<String>();
        ResultSet resultSet = this.getDatabaseMetadata(string).getTables(null, null, null, stringArray);
        while (resultSet.next()) {
            String string2 = resultSet.getString(3);
            vector.addElement(string2);
        }
        resultSet.close();
        this.releaseCurrentConnection();
        n = vector.size();
        objectArray = new String[n];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static void main(String[] stringArray) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

