/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.core.utilities;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.eso.ohs.core.utilities.TextUtils;

public class Convert {
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$core$utilities$Convert == null ? (class$org$eso$ohs$core$utilities$Convert = Convert.class$("org.eso.ohs.core.utilities.Convert")) : class$org$eso$ohs$core$utilities$Convert));
    public static final String ST_TIME_FORMAT = "HH:mm";
    public static final int SEC_PER_MINUTE = 60;
    public static final int SEC_PER_HOUR = 3600;
    public static final int SEC_PER_DAY = 86400;
    public static final int MILLISECS_PER_SEC = 1000;
    public static final int MILLISECS_PER_MINUTE = 60000;
    public static final int MILLISECS_PER_UNIT = 3600000;
    public static final int DECIMAL_PLACES_ACCURACY = 3;
    public static final int MAX_MILLISECS_RA = 86400000;
    public static final int MAX_MILLISECS_DEC = 324000000;
    public static final int EXECTIME_MAX = 86399;
    public static final int EXECTIME_ERR = -86399;
    public static final String EXECTIME_ERR_STRING = "-23:59:59.000";
    public static final long TIME_MAX = 0x80000000L;
    public static final long ENDTIME_MAX = Integer.MAX_VALUE;
    public static final String ISO_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String DURATION_FORMAT = "d'T'HH:mm:ss";
    static /* synthetic */ Class class$org$eso$ohs$core$utilities$Convert;

    public static long getCurrentTime() {
        return System.currentTimeMillis() / 1000L;
    }

    public static int convertHHMMTOSeconds(String string) throws NumberFormatException {
        int n = 0;
        String[] stringArray = string.split(":");
        if (stringArray == null || stringArray.length != 2) {
            throw new NumberFormatException("Invalid format should be hh:mm not " + string);
        }
        if (stringArray[0].length() > 2 || stringArray[1].length() > 2) {
            throw new NumberFormatException("Invalid format should be hh:mm not " + string);
        }
        try {
            int n2 = Integer.valueOf(stringArray[0]);
            int n3 = Integer.valueOf(stringArray[1]);
            n = n2 * 3600 + n3 * 60;
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            stdlog_.debug((Object)("HH MM " + string));
            throw new NumberFormatException("Invalid format should be hh:mm not " + string);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NumberFormatException("Invalid format should be hh:mm not " + string);
        }
    }

    public static int HHMMSSToMilliarcsec(String string) throws IllegalArgumentException {
        return Convert.stringToMilliarcsec(string, true, false);
    }

    public static int HHMMSSToSec(String string) throws IllegalArgumentException {
        int n = Convert.stringToMilliarcsec(string, false, true);
        return n / 1000;
    }

    public static int DDMMSSToMilliarcsec(String string) throws IllegalArgumentException {
        return Convert.stringToMilliarcsec(string, false, false);
    }

    public static int DDMMSSToMilliarcsec(String string, boolean bl) throws IllegalArgumentException {
        return Convert.stringToMilliarcsec(string, false, bl);
    }

    private static int stringToMilliarcsec(String string, boolean bl, boolean bl2) throws IllegalArgumentException {
        if (string.startsWith("+")) {
            string = string.substring(1);
        }
        if (string.indexOf(58) == -1) {
            return Convert.stringToMilliarcsecNoColons(string, bl, bl2);
        }
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " :");
        try {
            int n2;
            String string2 = stringTokenizer.nextToken();
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 1;
            if (stringTokenizer.hasMoreTokens()) {
                n3 = new Integer(stringTokenizer.nextToken());
                if (stringTokenizer.hasMoreTokens()) {
                    n4 = new Integer(stringTokenizer.nextToken(": ,."));
                    if (stringTokenizer.hasMoreTokens()) {
                        String string3 = stringTokenizer.nextToken(".,");
                        int n7 = 1;
                        while (n7 <= 3) {
                            string3 = string3 + "0";
                            ++n7;
                        }
                        string3 = string3.substring(0, 3);
                        n5 = new Integer(string3);
                    }
                }
            }
            if (string2.startsWith("-")) {
                n6 = -1;
                n2 = -new Integer(string2).intValue();
            } else {
                n2 = new Integer(string2);
            }
            if (!bl2) {
                if (bl) {
                    Convert.checkBoundsHHMMSS(n6, n2, n3, n4, n5);
                } else {
                    Convert.checkBoundsDDMMSS(n6, n2, n3, n4, n5);
                }
            }
            n = n6 * (n2 * 3600000 + n3 * 60000 + n4 * 1000 + n5);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(numberFormatException.getMessage());
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalArgumentException(noSuchElementException.getMessage());
        }
        return n;
    }

    private static int stringToMilliarcsecNoColons(String string, boolean bl, boolean bl2) throws IllegalArgumentException {
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        String string2 = null;
        String string3 = "000";
        int n4 = 0;
        int n5 = 0;
        string = string.trim();
        n4 = string.indexOf(46);
        n5 = string.length();
        n2 = n4 == -1 ? n5 : n4;
        n3 = string.startsWith("-") ? 1 : 0;
        string2 = string.substring(n3, n2).trim();
        if (n2 < n5) {
            string3 = string.substring(n2 + 1, n5) + "000";
            string2 = TextUtils.padded("000000", 6, string2);
        } else {
            if (string2.length() == 1) {
                string2 = "0" + string2;
            }
            string2 = TextUtils.rightpadded("000000", 6, string2);
        }
        string3 = string3.substring(0, 3);
        if (string2.length() > 6) {
            throw new IllegalArgumentException("String too long: \"" + string + "\"");
        }
        String string4 = string2.substring(0, 2);
        String string5 = string2.substring(2, 4);
        String string6 = string2.substring(4, 6);
        try {
            int n6 = n3 == 1 ? -1 : 1;
            int n7 = new Integer(string4);
            int n8 = new Integer(string5);
            int n9 = new Integer(string6);
            int n10 = new Integer(string3);
            if (!bl2) {
                if (bl) {
                    Convert.checkBoundsHHMMSS(n6, n7, n8, n9, n10);
                } else {
                    Convert.checkBoundsDDMMSS(n6, n7, n8, n9, n10);
                }
            }
            n = n6 * (n7 * 3600000 + n8 * 60000 + n9 * 1000 + n10);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(numberFormatException.getMessage());
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalArgumentException(noSuchElementException.getMessage());
        }
        return n;
    }

    public static String milliarcsecToHHMMSS(int n) throws IllegalArgumentException {
        return Convert.milliarcsecToString(n, true, false);
    }

    public static String secToHHMMSS(int n) throws IllegalArgumentException {
        long l = (long)n * 1000L;
        return Convert.milliarcsecToString(l, false, true);
    }

    public static String milliarcsecToDDMMSS(int n) throws IllegalArgumentException {
        return Convert.milliarcsecToString(n, false, false);
    }

    private static String milliarcsecToString(long l, boolean bl, boolean bl2) throws IllegalArgumentException {
        if (!bl2) {
            if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                throw new IllegalArgumentException("Integer value out of bounds: " + l);
            }
            if (bl) {
                if (!Convert.isValidRA((int)l)) {
                    throw new IllegalArgumentException("Invalid RA value: " + l);
                }
            } else if (!Convert.isValidDec((int)l)) {
                throw new IllegalArgumentException("Invalid DEC value: " + l);
            }
        }
        char c = ' ';
        if (l < 0L) {
            c = '-';
            l = -l;
        }
        long l2 = l / 3600000L;
        long l3 = (l -= l2 * 3600000L) / 60000L;
        return c + TextUtils.zeroPadded(2, l2) + ":" + TextUtils.zeroPadded(2, l3) + ":" + TextUtils.zeroPadded(2, (l -= l3 * 60000L) / 1000L) + "." + TextUtils.zeroPadded(3, l % 1000L);
    }

    public static boolean isValidRA(int n) {
        return n >= 0 && n < 86400000;
    }

    public static boolean isValidDec(int n) {
        return n > -324000000 && n <= 324000000;
    }

    public static String convertToXXMMSS(int n) {
        String string = "";
        if (n < 0) {
            string = "-";
            n = -n;
        }
        int n2 = n % 1000;
        int n3 = (n /= 1000) % 60;
        int n4 = (n /= 60) % 60;
        int n5 = n /= 60;
        return string + TextUtils.zeroPadded(2, n5) + TextUtils.zeroPadded(2, n4) + TextUtils.zeroPadded(2, n3) + "." + TextUtils.zeroPadded(3, n2);
    }

    private static void checkBoundsHHMMSS(int n, int n2, int n3, int n4, int n5) throws IllegalArgumentException {
        if (n < 0 || n2 >= 24 || n3 >= 60 || n4 >= 60 || n5 >= 1000) {
            throw new IllegalArgumentException("Illegal HHMMSS value: " + Convert.valuesToString(n, n2, n3, n4, n5));
        }
    }

    private static void checkBoundsDDMMSS(int n, int n2, int n3, int n4, int n5) throws IllegalArgumentException {
        if (n2 > 90 || n3 >= 60 || n4 >= 60 || n5 >= 1000) {
            throw new IllegalArgumentException("Illegal DDMMSS value: " + Convert.valuesToString(n, n2, n3, n4, n5));
        }
        if (n2 == 90 && (n3 > 0 || n4 > 0 || n5 > 0)) {
            throw new IllegalArgumentException("Illegal DDMMSS value: " + Convert.valuesToString(n, n2, n3, n4, n5));
        }
    }

    private static String valuesToString(int n, int n2, int n3, int n4, int n5) {
        String string = null;
        string = n < 0 ? "-" : "";
        string = string + n2 + ":" + n3 + ":" + n4 + "." + n5;
        return string;
    }

    public static double round(double d, int n) {
        double d2 = 1.0;
        int n2 = 1;
        while (n2 <= n) {
            d2 *= 10.0;
            ++n2;
        }
        double d3 = d * d2;
        d3 = d3 >= 0.0 ? (d3 += 0.5) : (d3 -= 0.5);
        int n3 = (int)d3;
        d3 = (double)n3 / d2;
        return d3;
    }

    public static long ISOdateToLong(String string) throws ParseException {
        String string2 = Convert.completeISODateString(string);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(ISO_DATE_FORMAT);
        Date date = simpleDateFormat.parse(string2);
        return date.getTime() / 1000L;
    }

    public static String longToISODate(long l) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(ISO_DATE_FORMAT);
        return simpleDateFormat.format(new Date(l * 1000L));
    }

    public static String longToHHSS(long l) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(ST_TIME_FORMAT);
        return simpleDateFormat.format(new Date(l * 1000L));
    }

    public static String completeISODateString(String string) throws ParseException {
        String string2 = TextUtils.currentISODateTime();
        int n = string2.indexOf(84);
        string2 = string2.substring(0, n + 1) + "00:00:00";
        return Convert.completeISODateString(string, string2);
    }

    public static String completeISODateString(String string, String string2) throws ParseException {
        String[] stringArray = Convert.parseISODate(string);
        String[] stringArray2 = Convert.parseISODate(string2);
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = null;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].length() == 0) {
                stringArray[n] = stringArray2[n];
            }
            ++n;
        }
        stringBuffer.append(TextUtils.zeroPadded(4, stringArray[0]));
        stringBuffer.append('-');
        stringBuffer.append(TextUtils.zeroPadded(2, stringArray[1]));
        stringBuffer.append('-');
        stringBuffer.append(TextUtils.zeroPadded(2, stringArray[2]));
        stringBuffer.append('T');
        stringBuffer.append(TextUtils.zeroPadded(2, stringArray[3]));
        stringBuffer.append(':');
        stringBuffer.append(TextUtils.zeroPadded(2, stringArray[4]));
        stringBuffer.append(':');
        stringBuffer.append(TextUtils.zeroPadded(2, stringArray[5]));
        string3 = stringBuffer.toString();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(ISO_DATE_FORMAT);
        simpleDateFormat.setLenient(false);
        Date date = simpleDateFormat.parse(string3);
        if (date == null) {
            throw new ParseException(string3, 0);
        }
        try {
            int n2 = Integer.parseInt(stringArray[0]);
            if (n2 < 1970 || n2 > 2037) {
                throw new ParseException(string3, 0);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return string3;
    }

    private static String[] parseISODate(String string) throws ParseException {
        String[] stringArray = new String[6];
        String string2 = null;
        String string3 = "";
        String string4 = "";
        int n = (string = string.trim()).indexOf(84);
        if (n == -1) {
            string3 = string;
        } else {
            string3 = string.substring(0, n);
            string4 = string.substring(n + 1);
        }
        string2 = string3;
        int n2 = 2;
        while (n2 >= 0) {
            n = string2.lastIndexOf(45);
            if (n == -1) {
                stringArray[n2] = string2;
                string2 = "";
            } else {
                stringArray[n2] = string2.substring(n + 1);
                string2 = string2.substring(0, n);
            }
            --n2;
        }
        string2 = string4;
        int n3 = 3;
        while (n3 <= 5) {
            n = string2.indexOf(58);
            if (n == -1) {
                stringArray[n3] = string2;
                string2 = "";
            } else {
                stringArray[n3] = string2.substring(0, n);
                string2 = string2.substring(n + 1);
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < stringArray.length) {
            int n5 = 0;
            while (n5 < stringArray[n4].length()) {
                char c = stringArray[n4].charAt(n5);
                if (!Character.isDigit(c) && c != '.') {
                    throw new ParseException(stringArray[n4], n5);
                }
                ++n5;
            }
            ++n4;
        }
        return stringArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

