/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.core.utilities;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eso.ohs.core.utilities.PafData;
import org.eso.ohs.core.utilities.TextUtils;

public class PafFile {
    private final String[] mandatoryPafKeywords_ = new String[]{"PAF.HDR.START", "PAF.TYPE", "PAF.ID", "PAF.NAME", "PAF.DESC", "PAF.CRTE.NAME", "PAF.CRTE.DAYTIM", "PAF.LCHG.NAME", "PAF.LCHG.DAYTIM", "PAF.CHCK.NAME", "PAF.CHCK.DAYTIM", "PAF.CHCK.CHECKSUM", "PAF.HDR.END"};
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$core$utilities$PafFile == null ? (class$org$eso$ohs$core$utilities$PafFile = PafFile.class$("org.eso.ohs.core.utilities.PafFile")) : class$org$eso$ohs$core$utilities$PafFile));
    private int numQuotes_;
    private StreamTokenizer pafToken_;
    private String pafName_;
    private String pafDescription_;
    private String pafIdentifier_;
    private String pafType_;
    private String version_;
    private boolean importFile = false;
    private PafData[] identifierList_ = null;
    private LineNumberReader fReader_;
    private PrintWriter out_;
    private Vector pafLinesMissing_ = new Vector();
    private Vector idList_ = new Vector();
    private String compileErrorMsg_ = null;
    private String shortFilename_;
    private Hashtable uniqueKeywords_ = new Hashtable();
    static /* synthetic */ Class class$org$eso$ohs$core$utilities$PafFile;

    public PafFile(String string, boolean bl, boolean bl2) throws IOException, FileNotFoundException {
        this.importFile = bl2;
        if (string != null) {
            this.initialise(string);
        }
    }

    public PafFile(String string) throws IOException, FileNotFoundException {
        if (string != null) {
            this.initialise(string);
        }
    }

    public PafFile(PafFile pafFile) {
        this.identifierList_ = pafFile.getIdentifierList();
        this.uniqueKeywords_ = pafFile.getUniqueKeywordList();
        this.initPafHeaderValues();
        this.initPafLinesMissing();
    }

    public String toFileString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.identifierList_.length) {
            if (this.identifierList_[n].hasValue()) {
                stringBuffer.append(this.identifierList_[n].getIdentifier() + " " + "\"" + this.identifierList_[n].getValue() + "\"" + "\n");
            } else {
                stringBuffer.append(this.identifierList_[n].getIdentifier() + " \"\"\n");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void setKeywordValue(String string, String string2) {
        int n = 0;
        while (n < this.identifierList_.length) {
            if (this.identifierList_[n].getIdentifier().equals(string)) {
                this.identifierList_[n].setValue(string2);
                return;
            }
            ++n;
        }
    }

    public Hashtable getUniqueKeywordList() {
        return this.uniqueKeywords_;
    }

    public String getValueForKeyword(String string) {
        return (String)this.uniqueKeywords_.get(string);
    }

    public boolean keyExists(String string) {
        return this.uniqueKeywords_.containsKey(string);
    }

    public PafFile(String string, boolean bl) throws IOException {
        if (bl) {
            File file = new File(string);
            File file2 = new File(file.getParent());
            if (!file2.canWrite()) {
                throw new IOException("Error no rights to write this file in directory " + file2.getName());
            }
            this.out_ = new PrintWriter(new BufferedWriter(new FileWriter(string)));
        } else {
            this.initialise(string);
        }
    }

    public PafFile(Reader reader) throws IOException {
        this.fReader_ = new LineNumberReader(reader);
        this.init();
    }

    public void initialise(String string) throws IOException, FileNotFoundException {
        File file = new File(string);
        this.shortFilename_ = file.getName();
        if (!file.exists()) {
            throw new FileNotFoundException("File does not exist: " + string);
        }
        if (!file.canRead()) {
            throw new IOException("Permission denied - can't open file for read: " + string);
        }
        this.fReader_ = new LineNumberReader(new FileReader(string));
        this.init();
    }

    private void init() throws IOException {
        if (this.importFile) {
            this.initImportIdentifierList();
        } else {
            this.initIdentifierList();
        }
        if (!this.compileError() && this.identifierList_ != null) {
            this.initPafHeaderValues();
            this.initPafLinesMissing();
        }
        this.fReader_.close();
    }

    public String getCompileErrorMsg() {
        return this.compileErrorMsg_;
    }

    public boolean compileError() {
        return this.compileErrorMsg_ != null && this.compileErrorMsg_.length() > 0;
    }

    public boolean isPafFile() {
        if (this.identifierList_ == null) {
            return false;
        }
        int n = 0;
        while (n < this.mandatoryPafKeywords_.length) {
            boolean bl = false;
            int n2 = 0;
            while (n2 < this.identifierList_.length) {
                if (this.identifierList_[n2].getIdentifier().equals(this.mandatoryPafKeywords_[n])) {
                    bl = true;
                    if (!this.identifierList_[n2].getIdentifier().equals("PAF.NAME") || this.identifierList_[n2].hasValue()) break;
                    bl = false;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String getShortFilename() {
        return this.shortFilename_;
    }

    public void writeLine(String string) throws NullPointerException {
        this.out_.println(string);
    }

    public void closeWriter() throws NullPointerException {
        this.out_.close();
    }

    private void initPafHeaderValues() {
        int n = this.identifierList_.length;
        int n2 = 0;
        while (n2 < n) {
            PafData pafData = this.identifierList_[n2];
            String string = pafData.getIdentifier();
            if (string.equals("PAF.NAME")) {
                this.pafName_ = pafData.getValue();
            }
            if (string.equals("PAF.DESC")) {
                this.pafDescription_ = pafData.getValue();
            }
            if (string.equals("PAF.ID")) {
                this.pafIdentifier_ = pafData.getValue();
            }
            if (string.equals("PAF.TYPE")) {
                this.pafType_ = pafData.getValue();
            }
            if (string.equals("PAF.VERSION")) {
                this.version_ = pafData.getValue();
            }
            ++n2;
        }
    }

    private void initPafLinesMissing() {
        boolean bl = false;
        int n = 0;
        while (n < this.mandatoryPafKeywords_.length) {
            bl = false;
            int n2 = 0;
            while (n2 < this.identifierList_.length) {
                if (this.identifierList_[n2].getIdentifier().equals(this.mandatoryPafKeywords_[n])) {
                    bl = true;
                }
                ++n2;
            }
            if (!bl) {
                this.pafLinesMissing_.addElement(this.mandatoryPafKeywords_[n]);
            }
            ++n;
        }
    }

    public Vector getIdVector() {
        return this.idList_;
    }

    public String[] getPafLinesMissing() {
        Object[] objectArray = new String[this.pafLinesMissing_.size()];
        this.pafLinesMissing_.copyInto(objectArray);
        return objectArray;
    }

    public String readLine(String string) {
        int n = 0;
        while (n < this.identifierList_.length) {
            if (this.identifierList_[n].getIdentifier().equals(string)) {
                return this.identifierList_[n].getValue();
            }
            ++n;
        }
        return null;
    }

    public String[] readKeywordValues(String string) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < this.identifierList_.length) {
            if (this.identifierList_[n].getIdentifier().equals(string)) {
                vector.addElement(this.identifierList_[n].getValue());
            }
            ++n;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public int getLineNumber(String string) {
        int n = 0;
        while (n < this.identifierList_.length) {
            if (this.identifierList_[n].getIdentifier().equals(string)) {
                return this.identifierList_[n].getLineNumber();
            }
            ++n;
        }
        return -1;
    }

    public String getPafName() {
        return this.pafName_;
    }

    public String getVersion() {
        return this.version_;
    }

    public String getPafDescription() {
        return this.pafDescription_;
    }

    public String getPafIdentifier() {
        return this.pafIdentifier_;
    }

    public String getPafType() {
        return this.pafType_;
    }

    public PafData[] getIdentifierList() {
        return this.identifierList_;
    }

    public void setPafName(String string) {
        this.pafName_ = string;
    }

    public void setVersion(String string) {
        this.version_ = string;
    }

    public void setPafDescription(String string) {
        this.pafDescription_ = string;
    }

    public void setPafIdentifier(String string) {
        this.pafIdentifier_ = string;
    }

    public void setPafType(String string) {
        this.pafType_ = string;
    }

    private void initIdentifierList() {
        Object var1_1 = null;
        String string = "";
        this.idList_ = new Vector();
        try {
            String string2;
            while ((string2 = this.fReader_.readLine()) != null) {
                string2 = string2.trim();
                int n = this.fReader_.getLineNumber();
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                if (string2.startsWith("#") || string2.startsWith(";") || stringTokenizer.countTokens() <= 0) continue;
                String string3 = stringTokenizer.nextToken();
                int n2 = string2.indexOf(34);
                string = "";
                if (n2 != -1) {
                    char c;
                    ++this.numQuotes_;
                    int n3 = -1;
                    int n4 = ++n2;
                    boolean bl = false;
                    while (n4 < string2.length()) {
                        if (bl) {
                            bl = false;
                            ++n4;
                            continue;
                        }
                        c = string2.charAt(n4);
                        if (c == '\\') {
                            bl = true;
                        } else if (c == '\"') {
                            n3 = n4;
                            break;
                        }
                        ++n4;
                    }
                    c = '\u0000';
                    if (n3 > n2) {
                        ++this.numQuotes_;
                        string = string2.substring(n2, n3).trim();
                        string = TextUtils.revertEscapedString(string);
                        c = '\u0001';
                    } else if (n2 == n3) {
                        string = "";
                        c = '\u0001';
                    } else {
                        if (string2.length() - 1 > n2) {
                            string = string2.substring(n2, string2.length());
                        }
                        c = '\u0000';
                    }
                    while (c == '\u0000' && this.fReader_.ready()) {
                        String string4 = this.fReader_.readLine().trim();
                        n3 = -1;
                        n3 = string4.indexOf(34);
                        int n5 = string4.indexOf(59);
                        if (n3 != -1 || n5 != -1) {
                            ++this.numQuotes_;
                            int n6 = string4.lastIndexOf(35);
                            if (n6 != -1 && n6 > n3 && n6 > n5) {
                                string4 = string4.substring(0, n6);
                            }
                            if (n3 == (string4 = string4.trim()).length() - 1) {
                                c = '\u0001';
                                string = string + " " + string4.substring(0, n3).trim();
                            } else if (n3 == -1 && n5 == string4.length() - 1) {
                                c = '\u0001';
                                string = string + " " + string4.substring(0, n5).trim();
                            }
                            if (n3 == string4.length() - 2 && n5 == string4.length() - 1) {
                                c = '\u0001';
                                string = string + " " + string4.substring(0, n3).trim();
                                continue;
                            }
                            if (n3 == -1 || n3 == string4.length() - 1) continue;
                            this.compileErrorMsg_ = "Id " + string3 + " has  no terminating quote at line number " + "(" + n + ")";
                            return;
                        }
                        string = string + " " + string4;
                    }
                    if (c == '\u0000') {
                        this.compileErrorMsg_ = "Id " + string3 + "  has  no terminating quote at line number" + "(" + n + ")";
                        return;
                    }
                } else if (string3.indexOf(59) != -1) {
                    string3 = string3.substring(0, string3.indexOf(59));
                }
                PafData pafData = new PafData();
                pafData.setIdentifier(string3);
                pafData.setValue(string);
                pafData.setLineNumber(n);
                this.uniqueKeywords_.put(string3, string);
                this.idList_.addElement(pafData);
            }
            this.identifierList_ = new PafData[this.idList_.size()];
            this.idList_.copyInto(this.identifierList_);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void initImportIdentifierList() {
        Object var1_1 = null;
        String string = "";
        this.idList_ = new Vector();
        try {
            String string2;
            while ((string2 = this.fReader_.readLine()) != null) {
                string2 = string2.trim();
                int n = this.fReader_.getLineNumber();
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                if (string2.startsWith("#") || string2.startsWith(";") || stringTokenizer.countTokens() <= 0) continue;
                String string3 = stringTokenizer.nextToken();
                int n2 = string2.indexOf(34);
                string = "";
                if (n2 != -1) {
                    ++this.numQuotes_;
                    int n3 = -1;
                    int n4 = ++n2;
                    boolean bl = false;
                    n3 = this.getEndQuote(string2, n4);
                    boolean bl2 = false;
                    if (n3 > n2) {
                        ++this.numQuotes_;
                        string = string2.substring(n2, n3).trim();
                        string = TextUtils.revertEscapedString(string);
                        bl2 = true;
                    } else if (n2 == n3) {
                        string = "";
                        bl2 = true;
                    } else {
                        if (string2.length() - 1 >= n2) {
                            string = TextUtils.revertEscapedString(string2.substring(n2, string2.length()));
                        }
                        bl2 = false;
                    }
                    while (!bl2 && this.fReader_.ready()) {
                        String string4 = this.fReader_.readLine().trim();
                        int n5 = 0;
                        n3 = this.getEndQuote(string4, n5);
                        int n6 = string4.indexOf(59);
                        if (n3 != -1 || n6 != -1) {
                            ++this.numQuotes_;
                            int n7 = string4.lastIndexOf(35);
                            if (n7 != -1 && n7 > n3 && n7 > n6) {
                                string4 = string4.substring(0, n7);
                            }
                            if (n3 == (string4 = string4.trim()).length() - 1) {
                                bl2 = true;
                                string = string + "\n" + TextUtils.revertEscapedString(string4.substring(0, n3)).trim();
                            } else if (n3 == -1 && n6 == string4.length() - 1) {
                                bl2 = true;
                                string = string + "\n" + TextUtils.revertEscapedString(string4.substring(0, n6).trim());
                            }
                            if (n3 == string4.length() - 2 && n6 == string4.length() - 1) {
                                System.out.println("Found " + string);
                                bl2 = true;
                                string = string + "\n" + TextUtils.revertEscapedString(string4.substring(0, n3).trim());
                                continue;
                            }
                            if (n3 == -1 || n3 == string4.length() - 1) continue;
                            System.out.println("Compile issue " + string);
                            this.compileErrorMsg_ = "Id " + string3 + " has  no terminating quote at line number " + "(" + n + ")";
                            return;
                        }
                        System.out.println("Adding new line");
                        string = string + "\n" + TextUtils.revertEscapedString(string4);
                    }
                    if (!bl2) {
                        this.compileErrorMsg_ = "Id " + string3 + "  has  no terminating quote at line number" + "(" + n + ")";
                        return;
                    }
                } else if (string3.indexOf(59) != -1) {
                    string3 = string3.substring(0, string3.indexOf(59));
                }
                PafData pafData = new PafData();
                pafData.setIdentifier(string3);
                pafData.setValue(string);
                pafData.setLineNumber(n);
                this.uniqueKeywords_.put(string3, string);
                this.idList_.addElement(pafData);
            }
            this.identifierList_ = new PafData[this.idList_.size()];
            this.idList_.copyInto(this.identifierList_);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private int getEndQuote(String string, int n) {
        int n2 = n;
        boolean bl = false;
        boolean bl2 = false;
        while (n2 < string.length()) {
            if (bl2) {
                bl2 = false;
                ++n2;
                continue;
            }
            char c = string.charAt(n2);
            if (c == '\\') {
                bl2 = true;
            } else if (c == '\"') {
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            return -1;
        }
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Paf Name=");
        stringBuffer.append(this.pafName_);
        stringBuffer.append("\n");
        stringBuffer.append("Paf Description=");
        stringBuffer.append(this.pafDescription_);
        stringBuffer.append("\n");
        stringBuffer.append("Paf Identifier=");
        stringBuffer.append(this.pafIdentifier_);
        stringBuffer.append("\n");
        stringBuffer.append("Paf Type=");
        stringBuffer.append(this.pafType_);
        stringBuffer.append("\n");
        stringBuffer.append("Paf Version=");
        stringBuffer.append(this.version_);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println("Missing paf file to test!");
            System.out.println("command <path to PAF file>");
            System.exit(1);
        }
        PafFile.report(stringArray[0]);
    }

    public static void report(String string) {
        PafFile pafFile = null;
        try {
            pafFile = new PafFile(string);
        }
        catch (Exception exception) {
            System.out.println("Error reading paf file: " + exception.toString());
        }
        System.out.println(pafFile.reportToString());
    }

    public void report() {
        stdlog_.debug((Object)this.reportToString());
    }

    public String reportToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Compile Error: " + this.compileError() + "\n");
        stringBuffer.append("Compile Msg  : " + this.getCompileErrorMsg() + "\n");
        stringBuffer.append("Is PAF File  : " + this.isPafFile() + "\n");
        stringBuffer.append("=================toString()=================\n");
        stringBuffer.append(this.toString() + "\n");
        stringBuffer.append("=================Identifier List============\n");
        PafData[] pafDataArray = this.getIdentifierList();
        int n = 0;
        while (n < pafDataArray.length) {
            PafData pafData = pafDataArray[n];
            stringBuffer.append("" + n + "\t<" + pafData.getIdentifier() + ">\t\t<" + pafData.getValue() + ">" + "\n");
            ++n;
        }
        stringBuffer.append("============================================\n");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

