/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.core.utilities.rmi;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.AlreadyBoundException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UnicastRemoteObject;
import java.rmi.server.Unreferenced;
import org.eso.ohs.core.utilities.Logger;
import org.eso.ohs.core.utilities.rmi.OHSServerControl;

public class OHSServer
extends UnicastRemoteObject
implements OHSServerControl,
Unreferenced {
    private static final String rcsid = "$Id: OHSServer.java,v 1.5 2004/03/17 09:25:29 ddorigo Exp $";
    private int rmiPort_;
    private String rmiName_;
    private String rmiURL_;
    private Logger logger_ = null;
    protected static Registry registry_ = null;

    public OHSServer(String string, int n, Logger logger) throws IOException, AlreadyBoundException, NotBoundException {
        this.rmiPort_ = n;
        this.rmiName_ = string;
        this.rmiURL_ = OHSServer.computeURL(string, n);
        this.logger_ = logger == null ? new Logger() : logger;
        this.log("Logging started port: " + n);
        if (registry_ == null) {
            registry_ = this.getRegistry(n);
        }
        this.log("Created local RMI registry on port " + n);
        this.bind();
        this.log("Bound as " + this.getURL());
        this.log("Server started");
    }

    protected Registry getRegistry(int n) throws RemoteException {
        return LocateRegistry.createRegistry(n);
    }

    public void bind() throws RemoteException, AlreadyBoundException, MalformedURLException, NotBoundException {
        Naming.bind(this.rmiURL_, this);
    }

    public void rebind() throws RemoteException, AlreadyBoundException, MalformedURLException, NotBoundException {
        Naming.rebind(this.rmiURL_, this);
    }

    public void unbind() throws RemoteException, AlreadyBoundException, MalformedURLException, NotBoundException {
        Naming.unbind(this.rmiURL_);
    }

    public String getName() {
        return this.rmiName_;
    }

    public int getPort() {
        return this.rmiPort_;
    }

    public String getURL() {
        return this.rmiURL_;
    }

    public static String computeURL(String string, int n) {
        String string2 = "localhost";
        String string3 = null;
        try {
            string2 = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        string3 = "rmi://" + string2 + ":" + n + "/" + string;
        return string3;
    }

    public String getClientHostName() {
        String string = "<unknown hostname>";
        InetAddress inetAddress = null;
        try {
            string = RemoteServer.getClientHost();
            inetAddress = InetAddress.getByName(string);
            string = inetAddress.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (ServerNotActiveException serverNotActiveException) {}
        return string;
    }

    public Logger getLogger() {
        return this.logger_;
    }

    public void setLogger(Logger logger) {
        if (this.logger_ != null) {
            this.logger_.close();
        }
        this.logger_ = logger;
    }

    public void setLogger(String string) throws IOException {
        if (this.logger_ != null) {
            this.logger_.close();
        }
        this.logger_ = new Logger(string);
    }

    public void log(String string) {
        if (this.logger_ != null) {
            this.logger_.log(string, false);
        }
    }

    public void log(String string, Exception exception) {
        if (this.logger_ != null) {
            this.logger_.logException(string, exception);
        }
    }

    public void exit(int n) throws ServerNotActiveException {
        this.log("Terminated by " + this.getClientHostName());
        try {
            this.unbind();
        }
        catch (Exception exception) {
            this.logger_.logException("Trying to unbind", exception);
        }
        this.log("Exiting (" + n + ")");
        System.exit(n);
    }

    public void exit() throws ServerNotActiveException {
        this.exit(0);
    }

    public void ping() throws ServerNotActiveException {
        this.log("Pinged by " + this.getClientHostName());
    }

    public void unreferenced() {
        this.log("No clients are connected");
    }

    public static void main(String[] stringArray) {
        String string = "Usage: ...OHSServer server-name server-port";
        if (stringArray.length < 2) {
            System.out.println(string);
            System.exit(1);
        }
        String string2 = stringArray[0];
        try {
            Integer n = new Integer(stringArray[1]);
            int n2 = n;
            OHSServer oHSServer = new OHSServer(string2, n2, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

